/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.Freerouting;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.Unit;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.scoring.BoardStatistics;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.SegmentedButtons;
import app.freerouting.interactive.DragMenuState;
import app.freerouting.interactive.InteractiveActionThread;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.RouteMenuState;
import app.freerouting.interactive.SelectMenuState;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.RoutingJobScheduler;
import app.freerouting.management.SessionManager;
import app.freerouting.management.TextManager;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.management.gson.GsonProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;

class BoardToolbar
extends JPanel {
    private final float ICON_FONT_SIZE = 26.0f;
    private final SegmentedButtons modeSelectionPanel;
    private final JButton settings_button;
    private final JButton toolbar_autoroute_button;
    private final JButton cancel_button;
    private final JButton toolbar_undo_button;
    private final JButton toolbar_redo_button;
    private final JButton toolbar_incompletes_button;
    private final JButton toolbar_violation_button;
    private final JButton toolbar_display_region_button;
    private final JButton toolbar_display_all_button;
    private final SegmentedButtons unitSelectionPanel;
    private final JButton delete_all_tracks_button;
    private final BoardFrame board_frame;

    BoardToolbar(BoardFrame p_board_frame, boolean p_disable_select_mode) {
        this.board_frame = p_board_frame;
        TextManager tm = new TextManager(this.getClass(), p_board_frame.get_locale());
        this.setLayout(new BorderLayout());
        JToolBar left_toolbar = new JToolBar();
        left_toolbar.setMaximumSize(new Dimension(1200, 30));
        this.modeSelectionPanel = !p_disable_select_mode ? new SegmentedButtons(tm, "Mode", "select_button", "route_button", "drag_button") : new SegmentedButtons(tm, "Mode", "route_button", "drag_button");
        this.modeSelectionPanel.addValueChangedEventListener(value -> {
            switch (value) {
                case "select_button": {
                    this.board_frame.board_panel.board_handling.set_select_menu_state();
                    break;
                }
                case "route_button": {
                    this.board_frame.board_panel.board_handling.set_route_menu_state();
                    break;
                }
                case "drag_button": {
                    this.board_frame.board_panel.board_handling.set_drag_menu_state();
                }
            }
        });
        this.modeSelectionPanel.addValueChangedEventListener(value -> FRAnalytics.buttonClicked("modeSelectionPanel", value));
        left_toolbar.add((Component)this.modeSelectionPanel, "Center");
        this.add((Component)left_toolbar, "West");
        JToolBar middle_toolbar = new JToolBar();
        this.settings_button = new JButton();
        tm.setText(this.settings_button, "settings_button", new String[0]);
        this.settings_button.addActionListener(actionEvent -> this.board_frame.autoroute_parameter_window.setVisible(true));
        this.settings_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("settings_button", this.settings_button.getText()));
        middle_toolbar.add(this.settings_button);
        this.toolbar_autoroute_button = new JButton();
        tm.setText(this.toolbar_autoroute_button, "autoroute_button", new String[0]);
        this.toolbar_autoroute_button.setDefaultCapable(true);
        Font currentFont = this.toolbar_autoroute_button.getFont();
        Font boldFont = new Font(currentFont.getFontName(), 1, currentFont.getSize());
        this.toolbar_autoroute_button.setFont(boldFont);
        this.toolbar_autoroute_button.setBorder(BorderFactory.createBevelBorder(0));
        this.toolbar_autoroute_button.setBorder(BorderFactory.createCompoundBorder(this.toolbar_autoroute_button.getBorder(), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.toolbar_autoroute_button.setCursor(new Cursor(12));
        this.toolbar_autoroute_button.addActionListener(actionEvent -> {
            RoutingJob[] routingJobs = RoutingJobScheduler.getInstance().listJobs(SessionManager.getInstance().getGuiSession().id.toString());
            if (routingJobs.length == 0) {
                FRLogger.warn("No routing job found for the current session");
                return;
            }
            RoutingJob guiRoutingJob = Arrays.stream(routingJobs).findFirst().get();
            guiRoutingJob.routerSettings = Freerouting.globalSettings.routerSettings.clone();
            InteractiveActionThread thread = this.board_frame.board_panel.board_handling.start_autorouter_and_route_optimizer(guiRoutingJob);
            if (thread != null && this.board_frame.board_panel.board_handling.autorouter_listener != null) {
                thread.addListener(this.board_frame.board_panel.board_handling.autorouter_listener);
            }
        });
        this.toolbar_autoroute_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("toolbar_autoroute_button", GsonProvider.GSON.toJson(Freerouting.globalSettings)));
        middle_toolbar.add(this.toolbar_autoroute_button);
        this.cancel_button = new JButton();
        tm.setText(this.cancel_button, "cancel_button", new String[0]);
        this.cancel_button.addActionListener(actionEvent -> this.board_frame.board_panel.board_handling.stop_autorouter_and_route_optimizer());
        this.cancel_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("cancel_button", this.cancel_button.getText()));
        this.cancel_button.setEnabled(false);
        middle_toolbar.add(this.cancel_button);
        this.delete_all_tracks_button = new JButton();
        tm.setText(this.delete_all_tracks_button, "delete_all_tracks_button", new String[0]);
        this.delete_all_tracks_button.addActionListener(actionEvent -> {
            RoutingBoard board = this.board_frame.board_panel.board_handling.get_routing_board();
            board.delete_all_tracks_and_vias();
            this.board_frame.board_panel.board_handling.replaceRoutingBoard(board);
            board = this.board_frame.board_panel.board_handling.get_routing_board().deepCopy();
            this.board_frame.board_panel.board_handling.replaceRoutingBoard(board);
            this.board_frame.board_panel.board_handling.create_ratsnest();
            this.board_frame.board_panel.board_handling.repaint();
            BoardStatistics boardStatistics = board.get_statistics();
            this.board_frame.screen_messages.set_board_score(boardStatistics.getNormalizedScore(Freerouting.globalSettings.routerSettings.scoring), boardStatistics.connections.incompleteCount, boardStatistics.clearanceViolations.totalCount);
        });
        this.delete_all_tracks_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("delete_all_tracks_button", this.delete_all_tracks_button.getText()));
        middle_toolbar.add(this.delete_all_tracks_button);
        JLabel separator_2 = new JLabel();
        separator_2.setMaximumSize(new Dimension(10, 10));
        separator_2.setPreferredSize(new Dimension(10, 10));
        separator_2.setRequestFocusEnabled(false);
        middle_toolbar.add(separator_2);
        this.toolbar_undo_button = new JButton();
        tm.setText(this.toolbar_undo_button, "undo_button", new String[0]);
        this.toolbar_undo_button.addActionListener(actionEvent -> {
            this.board_frame.board_panel.board_handling.cancel_state();
            this.board_frame.board_panel.board_handling.undo();
            this.board_frame.refresh_windows();
        });
        this.toolbar_undo_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("toolbar_undo_button", this.toolbar_undo_button.getText()));
        middle_toolbar.add(this.toolbar_undo_button);
        this.toolbar_redo_button = new JButton();
        tm.setText(this.toolbar_redo_button, "redo_button", new String[0]);
        this.toolbar_redo_button.addActionListener(actionEvent -> this.board_frame.board_panel.board_handling.redo());
        this.toolbar_redo_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("toolbar_redo_button", this.toolbar_redo_button.getText()));
        middle_toolbar.add(this.toolbar_redo_button);
        JLabel separator_1 = new JLabel();
        separator_1.setMaximumSize(new Dimension(10, 10));
        separator_1.setPreferredSize(new Dimension(10, 10));
        middle_toolbar.add(separator_1);
        this.toolbar_incompletes_button = new JButton();
        tm.setText(this.toolbar_incompletes_button, "incompletes_button", new String[0]);
        this.toolbar_incompletes_button.addActionListener(actionEvent -> this.board_frame.board_panel.board_handling.toggle_ratsnest());
        this.toolbar_incompletes_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("toolbar_incompletes_button", this.toolbar_incompletes_button.getText()));
        middle_toolbar.add(this.toolbar_incompletes_button);
        this.toolbar_violation_button = new JButton();
        tm.setText(this.toolbar_violation_button, "violations_button", new String[0]);
        this.toolbar_violation_button.addActionListener(actionEvent -> this.board_frame.board_panel.board_handling.toggle_clearance_violations());
        this.toolbar_violation_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("toolbar_violation_button", this.toolbar_violation_button.getText()));
        middle_toolbar.add(this.toolbar_violation_button);
        JLabel separator_3 = new JLabel();
        separator_3.setMaximumSize(new Dimension(10, 10));
        separator_3.setPreferredSize(new Dimension(10, 10));
        separator_3.setRequestFocusEnabled(false);
        middle_toolbar.add(separator_3);
        this.toolbar_display_region_button = new JButton();
        tm.setText(this.toolbar_display_region_button, "display_region_button", new String[0]);
        this.toolbar_display_region_button.addActionListener(actionEvent -> this.board_frame.board_panel.board_handling.zoom_region());
        this.toolbar_display_region_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("toolbar_display_region_button", this.toolbar_display_region_button.getText()));
        middle_toolbar.add(this.toolbar_display_region_button);
        this.toolbar_display_all_button = new JButton();
        tm.setText(this.toolbar_display_all_button, "display_all_button", new String[0]);
        this.toolbar_display_all_button.addActionListener(actionEvent -> this.board_frame.zoom_all());
        this.toolbar_display_all_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("toolbar_display_all_button", this.toolbar_display_all_button.getText()));
        middle_toolbar.add(this.toolbar_display_all_button);
        this.add((Component)middle_toolbar, "Center");
        JToolBar right_toolbar = new JToolBar();
        right_toolbar.setAutoscrolls(true);
        this.unitSelectionPanel = new SegmentedButtons(tm, "Unit", "unit_mil", "unit_inch", "unit_mm", "unit_um");
        this.unitSelectionPanel.addValueChangedEventListener(value -> {
            switch (value) {
                case "unit_mil": {
                    this.board_frame.board_panel.board_handling.change_user_unit(Unit.MIL);
                    break;
                }
                case "unit_inch": {
                    this.board_frame.board_panel.board_handling.change_user_unit(Unit.INCH);
                    break;
                }
                case "unit_mm": {
                    this.board_frame.board_panel.board_handling.change_user_unit(Unit.MM);
                    break;
                }
                case "unit_um": {
                    this.board_frame.board_panel.board_handling.change_user_unit(Unit.UM);
                }
            }
            this.board_frame.refresh_windows();
        });
        this.unitSelectionPanel.addValueChangedEventListener(value -> FRAnalytics.buttonClicked("unitSelectionPanel", value));
        right_toolbar.add(this.unitSelectionPanel);
        this.add((Component)right_toolbar, "East");
        BoardToolbar.changeToolbarFontSize(middle_toolbar, 26.0f);
        this.board_frame.addBoardLoadedEventListener(board -> {
            if (board == null || board.components.count() == 0) {
                this.setEnabled(false);
            }
            this.board_frame.board_panel.board_handling.addReadOnlyEventListener(isBoardReadOnly -> {
                this.setEnabled(isBoardReadOnly == false);
                this.cancel_button.setEnabled((boolean)isBoardReadOnly);
            });
        });
    }

    private static void changeToolbarFontSize(JToolBar toolBar, float newSize) {
        for (Component comp : toolBar.getComponents()) {
            Font font = comp.getFont();
            Font newFont = font.deriveFont(newSize);
            comp.setFont(newFont);
            if (!(comp instanceof Container)) continue;
            Container container = (Container)comp;
            BoardToolbar.updateContainerFont(container, newFont);
        }
    }

    private static void updateContainerFont(Container container, Font font) {
        for (Component child : container.getComponents()) {
            child.setFont(font);
            if (!(child instanceof Container)) continue;
            Container container1 = (Container)child;
            BoardToolbar.updateContainerFont(container1, font);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.modeSelectionPanel.setEnabled(enabled);
        this.settings_button.setEnabled(enabled);
        this.toolbar_autoroute_button.setEnabled(enabled);
        this.cancel_button.setEnabled(!enabled);
        this.toolbar_undo_button.setEnabled(enabled);
        this.toolbar_redo_button.setEnabled(enabled);
        this.toolbar_incompletes_button.setEnabled(enabled);
        this.toolbar_violation_button.setEnabled(enabled);
        this.toolbar_display_region_button.setEnabled(enabled);
        this.toolbar_display_all_button.setEnabled(enabled);
        this.unitSelectionPanel.setEnabled(enabled);
        this.delete_all_tracks_button.setEnabled(enabled);
    }

    void setModeSelectionPanelValue(InteractiveState interactive_state) {
        if (interactive_state instanceof RouteMenuState) {
            this.modeSelectionPanel.setSelectedValue("route_button");
        } else if (interactive_state instanceof DragMenuState) {
            this.modeSelectionPanel.setSelectedValue("drag_button");
        } else if (interactive_state instanceof SelectMenuState) {
            this.modeSelectionPanel.setSelectedValue("select_button");
        }
    }

    public void setUnitSelectionPanelValue(Unit unit) {
        switch (unit) {
            case MIL: {
                this.unitSelectionPanel.setSelectedValue("unit_mil");
                break;
            }
            case INCH: {
                this.unitSelectionPanel.setSelectedValue("unit_inch");
                break;
            }
            case MM: {
                this.unitSelectionPanel.setSelectedValue("unit_mm");
                break;
            }
            case UM: {
                this.unitSelectionPanel.setSelectedValue("unit_um");
            }
        }
    }
}

