/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.Freerouting;
import app.freerouting.core.RoutingJob;
import app.freerouting.gui.BoardFrame;
import app.freerouting.management.TextManager;
import app.freerouting.management.analytics.FRAnalytics;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class BoardMenuFile
extends JMenu {
    public final JMenuItem file_save_as_menuitem;
    private final TextManager tm;
    private final List<Consumer<File>> openEventListeners = new ArrayList<Consumer<File>>();
    private final List<Consumer<File>> saveAsEventListeners = new ArrayList<Consumer<File>>();

    public BoardMenuFile(BoardFrame board_frame, boolean p_disable_feature_macros) {
        this.tm = new TextManager(this.getClass(), board_frame.get_locale());
        this.setText(this.tm.getText("file", new String[0]));
        JMenuItem file_open_menuitem = new JMenuItem();
        file_open_menuitem.setText(this.tm.getText("open", new String[0]));
        file_open_menuitem.setToolTipText(this.tm.getText("open_tooltip", new String[0]));
        file_open_menuitem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        file_open_menuitem.addActionListener(actionEvent -> {
            File selected_file = RoutingJob.showOpenDialog(Freerouting.globalSettings.guiSettings.inputDirectory, board_frame);
            this.openEventListeners.forEach(listener -> listener.accept(selected_file));
        });
        file_open_menuitem.addActionListener(actionEvent -> FRAnalytics.buttonClicked("file_open_menuitem", file_open_menuitem.getText()));
        this.add(file_open_menuitem);
        this.file_save_as_menuitem = new JMenuItem();
        this.file_save_as_menuitem.setText(this.tm.getText("save_as", new String[0]));
        this.file_save_as_menuitem.setToolTipText(this.tm.getText("save_as_tooltip", new String[0]));
        this.file_save_as_menuitem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.file_save_as_menuitem.addActionListener(actionEvent -> {
            File selected_file = board_frame.showSaveAsDialog(Freerouting.globalSettings.guiSettings.inputDirectory, board_frame.routingJob.output);
            this.saveAsEventListeners.forEach(listener -> listener.accept(selected_file));
        });
        this.file_save_as_menuitem.addActionListener(actionEvent -> FRAnalytics.buttonClicked("file_save_as_menuitem", this.file_save_as_menuitem.getText()));
        this.add(this.file_save_as_menuitem);
        if (!p_disable_feature_macros) {
            JMenuItem file_write_logfile_menuitem = new JMenuItem();
            file_write_logfile_menuitem.setText(this.tm.getText("generate_logfile", new String[0]));
            file_write_logfile_menuitem.setToolTipText(this.tm.getText("generate_logfile_tooltip", new String[0]));
            file_write_logfile_menuitem.addActionListener(actionEvent -> this.write_logfile_action(board_frame));
            file_write_logfile_menuitem.addActionListener(actionEvent -> FRAnalytics.buttonClicked("file_write_logfile_menuitem", file_write_logfile_menuitem.getText()));
            this.add(file_write_logfile_menuitem);
            JMenuItem file_replay_logfile_menuitem = new JMenuItem();
            file_replay_logfile_menuitem.setText(this.tm.getText("replay_logfile", new String[0]));
            file_replay_logfile_menuitem.setToolTipText(this.tm.getText("replay_logfile_tooltip", new String[0]));
            file_replay_logfile_menuitem.addActionListener(actionEvent -> this.read_logfile_action(board_frame));
            file_replay_logfile_menuitem.addActionListener(actionEvent -> FRAnalytics.buttonClicked("file_replay_logfile_menuitem", file_replay_logfile_menuitem.getText()));
            this.add(file_replay_logfile_menuitem);
        }
        JMenuItem file_exit_menuitem = new JMenuItem();
        file_exit_menuitem.setText(this.tm.getText("exit", new String[0]));
        file_exit_menuitem.setToolTipText(this.tm.getText("exit_tooltip", new String[0]));
        file_exit_menuitem.setAccelerator(KeyStroke.getKeyStroke(115, 512));
        file_exit_menuitem.addActionListener(actionEvent -> board_frame.dispose());
        file_exit_menuitem.addActionListener(actionEvent -> FRAnalytics.buttonClicked("file_exit_menuitem", file_exit_menuitem.getText()));
        this.add(file_exit_menuitem);
    }

    private void write_logfile_action(BoardFrame board_frame) {
        JFileChooser file_chooser = new JFileChooser();
        File logfile_dir = new File(board_frame.routingJob.input.getDirectoryPath());
        file_chooser.setMinimumSize(new Dimension(500, 250));
        file_chooser.setCurrentDirectory(logfile_dir);
        file_chooser.setFileFilter(BoardFrame.logfile_filter);
        file_chooser.showOpenDialog(this);
        File filename = file_chooser.getSelectedFile();
        if (filename == null) {
            board_frame.screen_messages.set_status_message(this.tm.getText("message_8", new String[0]));
        } else {
            board_frame.screen_messages.set_status_message(this.tm.getText("message_9", new String[0]));
            board_frame.board_panel.board_handling.start_logfile(filename);
        }
    }

    private void read_logfile_action(BoardFrame board_frame) {
        JFileChooser file_chooser = new JFileChooser();
        File logfile_dir = new File(board_frame.routingJob.input.getDirectoryPath());
        file_chooser.setMinimumSize(new Dimension(500, 250));
        file_chooser.setCurrentDirectory(logfile_dir);
        file_chooser.setFileFilter(BoardFrame.logfile_filter);
        file_chooser.showOpenDialog(this);
        File filename = file_chooser.getSelectedFile();
        if (filename == null) {
            board_frame.screen_messages.set_status_message(this.tm.getText("message_10", new String[0]));
        } else {
            FileInputStream input_stream;
            try {
                input_stream = new FileInputStream(filename);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            board_frame.read_logfile(input_stream);
        }
    }

    public void addOpenEventListener(Consumer<File> listener) {
        this.openEventListeners.add(listener);
    }

    public void addSaveAsEventListener(Consumer<File> listener) {
        this.saveAsEventListeners.add(listener);
    }
}

