/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardMenuDisplay;
import app.freerouting.gui.BoardMenuFile;
import app.freerouting.gui.BoardMenuHelp;
import app.freerouting.gui.BoardMenuInfo;
import app.freerouting.gui.BoardMenuOther;
import app.freerouting.gui.BoardMenuParameter;
import app.freerouting.gui.BoardMenuRules;
import app.freerouting.gui.WindowUserSettings;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.settings.FeatureFlagsSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JMenuBar;

public class BoardMenuBar
extends JMenuBar {
    private final BoardFrame boardFrame;
    public BoardMenuFile fileMenu;
    public BoardMenuDisplay appereanceMenu;
    public BoardMenuParameter settingsMenu;
    public BoardMenuRules rulesMenu;
    public BoardMenuInfo infoMenu;

    public BoardMenuBar(BoardFrame boardFrame, FeatureFlagsSettings featureFlags) {
        this.boardFrame = boardFrame;
        this.fileMenu = new BoardMenuFile(boardFrame, !featureFlags.macros);
        this.add(this.fileMenu);
        this.appereanceMenu = BoardMenuDisplay.get_instance(boardFrame);
        this.add(this.appereanceMenu);
        this.settingsMenu = BoardMenuParameter.get_instance(boardFrame);
        this.add(this.settingsMenu);
        this.rulesMenu = BoardMenuRules.get_instance(boardFrame);
        this.add(this.rulesMenu);
        this.infoMenu = BoardMenuInfo.get_instance(boardFrame);
        this.add(this.infoMenu);
        if (featureFlags.otherMenu) {
            BoardMenuOther other_menu = BoardMenuOther.get_instance(boardFrame);
            this.add(other_menu);
        }
        BoardMenuHelp help_menu = new BoardMenuHelp(boardFrame);
        this.add(help_menu);
        JButton profileButton = new JButton("User Settings");
        profileButton.setBorderPainted(false);
        profileButton.addActionListener(new ActionListener(this){
            final /* synthetic */ BoardMenuBar this$0;
            {
                BoardMenuBar boardMenuBar = this$0;
                Objects.requireNonNull(boardMenuBar);
                this.this$0 = boardMenuBar;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.showProfileDialog();
            }
        });
        profileButton.addActionListener(actionEvent -> FRAnalytics.buttonClicked("profile_button", profileButton.getText()));
        this.add(Box.createHorizontalGlue());
        this.add(profileButton);
    }

    public void showProfileDialog() {
        WindowUserSettings.show(this.boardFrame);
    }
}

