/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.Freerouting;
import app.freerouting.board.BoardObserverAdaptor;
import app.freerouting.board.BoardObservers;
import app.freerouting.board.ItemIdentificationNumberGenerator;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.Unit;
import app.freerouting.core.BoardFileDetails;
import app.freerouting.core.RoutingJob;
import app.freerouting.datastructures.FileFilter;
import app.freerouting.designforms.specctra.DsnFile;
import app.freerouting.designforms.specctra.RulesFile;
import app.freerouting.gui.BoardMenuBar;
import app.freerouting.gui.BoardPanel;
import app.freerouting.gui.BoardPanelStatus;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.gui.BoardSubWindow;
import app.freerouting.gui.BoardTemporarySubWindow;
import app.freerouting.gui.BoardToolbar;
import app.freerouting.gui.BoardToolbarSelectedItem;
import app.freerouting.gui.ColorManager;
import app.freerouting.gui.FileFormat;
import app.freerouting.gui.GUIDefaultsFile;
import app.freerouting.gui.WindowAbout;
import app.freerouting.gui.WindowAssignNetClass;
import app.freerouting.gui.WindowAutorouteParameter;
import app.freerouting.gui.WindowBase;
import app.freerouting.gui.WindowClearanceMatrix;
import app.freerouting.gui.WindowClearanceViolations;
import app.freerouting.gui.WindowComponents;
import app.freerouting.gui.WindowDisplayMisc;
import app.freerouting.gui.WindowEditVias;
import app.freerouting.gui.WindowIncompletes;
import app.freerouting.gui.WindowLayerVisibility;
import app.freerouting.gui.WindowLengthViolations;
import app.freerouting.gui.WindowMessage;
import app.freerouting.gui.WindowMoveParameter;
import app.freerouting.gui.WindowNetClasses;
import app.freerouting.gui.WindowNets;
import app.freerouting.gui.WindowObjectListWithFilter;
import app.freerouting.gui.WindowObjectVisibility;
import app.freerouting.gui.WindowPackages;
import app.freerouting.gui.WindowPadstacks;
import app.freerouting.gui.WindowRouteParameter;
import app.freerouting.gui.WindowRouteStubs;
import app.freerouting.gui.WindowSelectParameter;
import app.freerouting.gui.WindowSnapshot;
import app.freerouting.gui.WindowUnconnectedRoute;
import app.freerouting.gui.WindowVia;
import app.freerouting.gui.WindowWelcome;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.ScreenMessages;
import app.freerouting.logger.FRLogger;
import app.freerouting.logger.LogEntries;
import app.freerouting.logger.LogEntry;
import app.freerouting.logger.LogEntryType;
import app.freerouting.management.RoutingJobScheduler;
import app.freerouting.management.SessionManager;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.settings.GlobalSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileNameExtensionFilter;

public class BoardFrame
extends WindowBase {
    static final int SUBWINDOW_COUNT = 24;
    static final String[] log_file_extensions = new String[]{"log"};
    static final String GUI_DEFAULTS_FILE_NAME = "gui_defaults.par";
    static final String GUI_DEFAULTS_FILE_BACKUP_NAME = "gui_defaults.par.bak";
    static final FileFilter logfile_filter = new FileFilter(log_file_extensions);
    public final RoutingJob routingJob;
    public final BoardMenuBar menubar;
    final JScrollPane scroll_pane;
    final ScreenMessages screen_messages;
    private final BoardToolbar toolbar_panel;
    private final JToolBar select_toolbar;
    private final BoardPanelStatus message_panel;
    private final Locale locale;
    private final List<Consumer<RoutingBoard>> boardLoadedEventListeners = new ArrayList<Consumer<RoutingBoard>>();
    private final List<Consumer<RoutingBoard>> boardSavedEventListeners = new ArrayList<Consumer<RoutingBoard>>();
    private final BoardObservers board_observers;
    private final String freerouting_version;
    BoardPanel board_panel;
    WindowAbout about_window;
    WindowRouteParameter route_parameter_window;
    WindowAutorouteParameter autoroute_parameter_window;
    WindowSelectParameter select_parameter_window;
    WindowMoveParameter move_parameter_window;
    WindowClearanceMatrix clearance_matrix_window;
    WindowVia via_window;
    WindowEditVias edit_vias_window;
    WindowNetClasses edit_net_rules_window;
    WindowAssignNetClass assign_net_classes_window;
    WindowPadstacks padstacks_window;
    WindowPackages packages_window;
    WindowIncompletes incompletes_window;
    WindowNets net_info_window;
    WindowClearanceViolations clearance_violations_window;
    WindowLengthViolations length_violations_window;
    WindowUnconnectedRoute unconnected_route_window;
    WindowRouteStubs route_stubs_window;
    WindowComponents components_window;
    WindowLayerVisibility layer_visibility_window;
    WindowObjectVisibility object_visibility_window;
    WindowDisplayMisc display_misc_window;
    WindowSnapshot snapshot_window;
    ColorManager color_manager;
    BoardSavableSubWindow[] permanent_subwindows = new BoardSavableSubWindow[24];
    Collection<BoardTemporarySubWindow> temporary_subwindows = new LinkedList<BoardTemporarySubWindow>();
    private LogEntries.LogEntryAddedListener log_entry_added_listener;
    private LocalDateTime intermediate_stage_file_last_saved_at;

    public BoardFrame(RoutingJob p_design, GlobalSettings globalSettings) {
        this(p_design, new BoardObserverAdaptor(), globalSettings);
    }

    BoardFrame(RoutingJob routingJob, BoardObservers boardObservers, GlobalSettings globalSettings) {
        super(800, 150);
        this.routingJob = routingJob;
        this.board_observers = boardObservers;
        this.locale = globalSettings.currentLocale;
        this.setLanguage(this.locale);
        this.freerouting_version = globalSettings.version;
        this.menubar = new BoardMenuBar(this, globalSettings.featureFlags);
        this.menubar.fileMenu.addOpenEventListener(selectedFile -> {
            if (selectedFile == null) {
                return;
            }
            try {
                routingJob.setInput((File)selectedFile);
                if (routingJob.input.format == FileFormat.UNKNOWN) {
                    FRLogger.warn("The input file format was not recognised.");
                    return;
                }
            }
            catch (Exception e) {
                FRLogger.error("There was an error while reading the input file.", e);
                return;
            }
            if (routingJob.input.getFile() != null) {
                String sessionId = SessionManager.getInstance().getGuiSession().id.toString();
                RoutingJobScheduler.getInstance().clearJobs(sessionId);
                RoutingJobScheduler.getInstance().enqueueJob(routingJob);
                String oldInputDirectory = globalSettings.guiSettings.inputDirectory;
                globalSettings.guiSettings.inputDirectory = this.routingJob.input.getDirectoryPath();
                if (!oldInputDirectory.equals(globalSettings.guiSettings.inputDirectory)) {
                    try {
                        GlobalSettings.saveAsJson(globalSettings);
                    }
                    catch (IOException e) {
                        FRLogger.error("Couldn't save the global settings to the configuration file", e);
                    }
                }
                try {
                    GlobalSettings.setDefaultValue("gui.input_directory", this.routingJob.input.getDirectoryPath());
                }
                catch (Exception e) {
                    FRLogger.error("Couldn't update the input directory in the configuration file", e);
                }
            }
            if (this.board_panel != null && this.board_panel.board_handling != null && routingJob.input.format != FileFormat.UNKNOWN) {
                switch (routingJob.input.format) {
                    case DSN: {
                        this.load(routingJob.input.getData(), true, null, routingJob);
                        FRAnalytics.buttonClicked("fileio_loaddsn", this.routingJob.getInputFileDetails());
                        break;
                    }
                    case FRB: {
                        this.load(routingJob.input.getData(), false, null, routingJob);
                        FRAnalytics.buttonClicked("fileio_loadfrb", this.routingJob.getInputFileDetails());
                        break;
                    }
                    default: {
                        FRLogger.warn("Loading the board failed, because the selected file format is not supported.");
                    }
                }
            }
        });
        this.menubar.fileMenu.addSaveAsEventListener(selectedFile -> {
            if (selectedFile == null) {
                return;
            }
            if (!routingJob.tryToSetOutputFile((File)selectedFile)) {
                return;
            }
            switch (routingJob.output.format) {
                case SES: {
                    boolean sesFileSaved = this.saveAsSpecctraSessionSes(this.routingJob.output.getFile(), this.routingJob.input.getFilename());
                    if (sesFileSaved && WindowMessage.confirm(this.tm.getText("confirm_rules_save", new String[0]), 1)) {
                        this.saveRulesAs(this.routingJob.getRulesFile(), this.routingJob.input.getFilename(), this.board_panel.board_handling);
                    }
                    FRAnalytics.buttonClicked("fileio_saveses", this.routingJob.getOutputFileDetails());
                    break;
                }
                case DSN: {
                    this.saveAsSpecctraDesignDsn(this.routingJob.output.getFile(), this.routingJob.input.getFilename(), false);
                    FRAnalytics.buttonClicked("fileio_savedsn", this.routingJob.getOutputFileDetails());
                    break;
                }
                case FRB: {
                    this.saveAsBinary(this.routingJob.output.getFile());
                    FRAnalytics.buttonClicked("fileio_savefrb", this.routingJob.getOutputFileDetails());
                    break;
                }
                case SCR: {
                    this.saveAsEagleScriptScr(this.routingJob.getEagleScriptFile(), this.routingJob.input.getFilename());
                    FRAnalytics.buttonClicked("fileio_savescr", "");
                    break;
                }
                default: {
                    FRLogger.warn("Saving the board failed, because the selected file format is not supported.");
                }
            }
        });
        this.setJMenuBar(this.menubar);
        this.toolbar_panel = new BoardToolbar(this, !globalSettings.featureFlags.selectMode);
        this.add((Component)this.toolbar_panel, "North");
        this.message_panel = new BoardPanelStatus(this.locale);
        this.add((Component)this.message_panel, "South");
        this.message_panel.addErrorOrWarningLabelClickedListener(() -> {
            LogEntries logEntries = FRLogger.getLogEntries();
            LogEntries filteredLogEntries = new LogEntries();
            for (LogEntry entry : logEntries.getEntries(null, null)) {
                if (entry.getType() != LogEntryType.Error && entry.getType() != LogEntryType.Warning && entry.getType() != LogEntryType.Info) continue;
                filteredLogEntries.add(entry.getType(), entry.getMessage(), entry.getTopic());
            }
            JTextArea textArea = new JTextArea(filteredLogEntries.getAsString());
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setPreferredSize(new Dimension(1000, 600));
            this.log_entry_added_listener = logEntry -> {
                LogEntryType type = logEntry.getType();
                if (type == LogEntryType.Error || type == LogEntryType.Warning || type == LogEntryType.Info) {
                    textArea.append(String.valueOf(logEntry) + "\n");
                }
            };
            logEntries.addLogEntryAddedListener(this.log_entry_added_listener);
            int messageType = filteredLogEntries.getErrorCount() > 0 ? 0 : 2;
            JOptionPane.showMessageDialog(null, scrollPane, this.tm.getText("logs_window_title", new String[0]), messageType);
        });
        this.select_toolbar = new BoardToolbarSelectedItem(this);
        this.screen_messages = new ScreenMessages(this.message_panel.errorLabel, this.message_panel.warningLabel, this.message_panel.statusMessage, this.message_panel.additionalMessage, this.message_panel.currentLayer, this.message_panel.currentBoardScore, this.message_panel.mousePosition, this.message_panel.unitLabel, this.locale);
        this.scroll_pane = new JScrollPane();
        this.scroll_pane.setPreferredSize(new Dimension(1150, 800));
        this.scroll_pane.setVerifyInputWhenFocusTarget(false);
        this.add((Component)this.scroll_pane, "Center");
        this.board_panel = new BoardPanel(this.screen_messages, this, globalSettings, routingJob);
        this.scroll_pane.setViewportView(this.board_panel);
        this.addWindowListener(new WindowStateListener(this));
        this.addBoardLoadedEventListener(board -> {
            boolean isBoardEmpty = board == null || board.components.count() == 0;
            this.menubar.fileMenu.file_save_as_menuitem.setEnabled(!isBoardEmpty);
            this.menubar.appereanceMenu.setEnabled(!isBoardEmpty);
            this.menubar.settingsMenu.setEnabled(!isBoardEmpty);
            this.menubar.rulesMenu.setEnabled(!isBoardEmpty);
            this.menubar.infoMenu.setEnabled(!isBoardEmpty);
            this.toolbar_panel.setEnabled(!isBoardEmpty);
        });
        this.updateTexts();
        this.pack();
    }

    @Override
    public void updateTexts() {
        if (this.routingJob == null || this.routingJob.output.getFile() == null) {
            this.setTitle(this.tm.getText("title", this.freerouting_version));
        } else {
            this.setTitle(this.routingJob.input.getFilename() + " - " + this.tm.getText("title", this.freerouting_version));
        }
    }

    void read_logfile(InputStream p_input_stream) {
        this.board_panel.board_handling.read_logfile(p_input_stream);
    }

    boolean load(InputStream inputStream, boolean isSpecctraDsn, JTextField p_message_field, RoutingJob routingJob) {
        Point viewport_position = null;
        DsnFile.ReadResult read_result = null;
        this.board_panel.reset_board_handling(routingJob);
        for (int i = 0; i < this.permanent_subwindows.length; ++i) {
            if (this.permanent_subwindows[i] == null) continue;
            this.permanent_subwindows[i].dispose();
            this.permanent_subwindows[i] = null;
        }
        if (isSpecctraDsn) {
            read_result = this.board_panel.board_handling.loadFromSpecctraDsn(inputStream, this.board_observers, new ItemIdentificationNumberGenerator());
            if (read_result == DsnFile.ReadResult.OK) {
                viewport_position = new Point(0, 0);
                this.initialize_windows();
                this.boardLoadedEventListeners.forEach(listener -> listener.accept(this.board_panel.board_handling.get_routing_board()));
            }
        } else {
            Rectangle frame_bounds;
            Point frame_location;
            ObjectInputStream object_stream;
            try {
                object_stream = new ObjectInputStream(inputStream);
            }
            catch (IOException iOException) {
                return false;
            }
            boolean read_ok = this.board_panel.board_handling.loadFromBinary(object_stream);
            if (!read_ok) {
                return false;
            }
            this.boardLoadedEventListeners.forEach(listener -> listener.accept(this.board_panel.board_handling.get_routing_board()));
            try {
                viewport_position = (Point)object_stream.readObject();
                frame_location = (Point)object_stream.readObject();
                frame_bounds = (Rectangle)object_stream.readObject();
            }
            catch (Exception exception) {
                return false;
            }
            this.setLocation(frame_location);
            this.setBounds(frame_bounds);
            this.allocate_permanent_subwindows();
            for (int i = 0; i < this.permanent_subwindows.length; ++i) {
                this.permanent_subwindows[i].read(object_stream);
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return this.update_gui(isSpecctraDsn, read_result, viewport_position, p_message_field);
    }

    private boolean update_gui(boolean isSpecctraDsn, DsnFile.ReadResult read_result, Point viewport_position, JTextField p_message_field) {
        if (isSpecctraDsn && read_result != DsnFile.ReadResult.OK) {
            if (p_message_field != null) {
                if (read_result == DsnFile.ReadResult.OUTLINE_MISSING) {
                    p_message_field.setText(this.tm.getText("error_7", new String[0]));
                } else {
                    p_message_field.setText(this.tm.getText("error_6", new String[0]));
                }
            }
            return false;
        }
        Dimension panel_size = this.board_panel.board_handling.graphics_context.get_panel_size();
        this.board_panel.setSize(panel_size);
        this.board_panel.setPreferredSize(panel_size);
        if (viewport_position != null) {
            this.board_panel.set_viewport_position(viewport_position);
        }
        this.board_panel.create_popup_menus();
        this.board_panel.init_colors();
        this.board_panel.board_handling.create_ratsnest();
        this.setToolbarModeSelectionPanelValue(this.board_panel.board_handling.get_interactive_state());
        this.setToolbarUnitSelectionPanelValue(this.board_panel.board_handling.coordinate_transform.user_unit);
        this.setVisible(true);
        if (isSpecctraDsn) {
            FileInputStream input_stream = null;
            File defaults_file = new File(this.routingJob.input.getAbsolutePath(), GUI_DEFAULTS_FILE_NAME);
            boolean defaults_file_found = true;
            try {
                input_stream = new FileInputStream(defaults_file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                defaults_file_found = false;
            }
            if (defaults_file_found) {
                boolean read_ok = GUIDefaultsFile.read(this, this.board_panel.board_handling, input_stream);
                if (!read_ok) {
                    this.screen_messages.set_status_message(this.tm.getText("error_1", new String[0]));
                }
                try {
                    ((InputStream)input_stream).close();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            this.zoom_all();
        }
        return true;
    }

    public boolean load_intermediate_stage_file() {
        try {
            FileInputStream input_stream = new FileInputStream(this.routingJob.snapshot.getFile());
            return this.load(input_stream, false, null, this.routingJob);
        }
        catch (IOException iOException) {
            this.screen_messages.set_status_message(this.tm.getText("error_2", new String[0]));
            return false;
        }
        catch (Exception exception) {
            this.screen_messages.set_status_message(this.tm.getText("error_3", new String[0]));
            return false;
        }
    }

    @Deprecated
    public boolean save_intermediate_stage_file() {
        if (this.intermediate_stage_file_last_saved_at != null && this.intermediate_stage_file_last_saved_at.plusSeconds(30L).isAfter(LocalDateTime.now())) {
            return false;
        }
        this.intermediate_stage_file_last_saved_at = LocalDateTime.now();
        return this.saveAsBinary(this.routingJob.snapshot);
    }

    public boolean delete_intermediate_stage_file() {
        return this.routingJob.snapshot.getFile().delete();
    }

    public boolean is_intermediate_stage_file_available() {
        return this.routingJob.snapshot.getFile() != null && this.routingJob.snapshot.getFile().exists() && this.routingJob.snapshot.getFile().canRead();
    }

    public LocalDateTime get_intermediate_stage_file_modification_time() {
        long lastModified = this.routingJob.snapshot.getFile().lastModified();
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(lastModified), ZoneId.systemDefault());
    }

    private boolean saveAsBinary(OutputStream outputStream) throws Exception {
        ObjectOutputStream objectStream = new ObjectOutputStream(outputStream);
        boolean save_ok = this.board_panel.board_handling.saveAsBinary(objectStream);
        if (!save_ok) {
            return false;
        }
        objectStream.writeObject(this.board_panel.get_viewport_position());
        objectStream.writeObject(this.getLocation());
        objectStream.writeObject(this.getBounds());
        for (int i = 0; i < this.permanent_subwindows.length; ++i) {
            this.permanent_subwindows[i].save(objectStream);
        }
        objectStream.flush();
        return true;
    }

    private boolean saveAsBinary(File outputFile) {
        FileOutputStream output_stream;
        if (outputFile == null) {
            return false;
        }
        try {
            FRLogger.info("Saving '" + outputFile.getPath() + "'...");
            output_stream = new FileOutputStream(outputFile);
            this.saveAsBinary(output_stream);
        }
        catch (IOException iOException) {
            this.screen_messages.set_status_message(this.tm.getText("message_binary_file_save_failed", outputFile.getPath()));
            return false;
        }
        catch (Exception exception) {
            this.screen_messages.set_status_message(this.tm.getText("message_binary_file_save_failed", outputFile.getPath()));
            return false;
        }
        try {
            ((OutputStream)output_stream).close();
        }
        catch (IOException iOException) {
            this.screen_messages.set_status_message(this.tm.getText("message_binary_file_save_failed", outputFile.getPath()));
            return false;
        }
        return true;
    }

    @Deprecated
    private boolean saveAsBinary(BoardFileDetails output) {
        if (output == null) {
            return false;
        }
        try {
            ByteArrayOutputStream output_stream = new ByteArrayOutputStream();
            this.saveAsBinary(output_stream);
            output.format = FileFormat.FRB;
            output.setData(output_stream.toByteArray());
            output_stream.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean saveAsSpecctraSessionSes(File outputFile, String designName) {
        FileOutputStream output_stream;
        if (outputFile == null) {
            return false;
        }
        FRLogger.info("Saving '" + outputFile.getPath() + "'...");
        try {
            output_stream = new FileOutputStream(outputFile);
        }
        catch (Exception exception) {
            output_stream = null;
        }
        if (!this.board_panel.board_handling.saveAsSpecctraSessionSes(output_stream, designName)) {
            this.screen_messages.set_status_message(this.tm.getText("message_specctra_ses_save_failed", outputFile.getPath()));
            return false;
        }
        this.screen_messages.set_status_message(this.tm.getText("message_specctra_ses_saved", outputFile.getPath()));
        return true;
    }

    public File showSaveAsDialog(String p_default_directory, BoardFileDetails output) {
        BoardFrame p_parent = this;
        File outputFile = output.getFile();
        String directoryName = outputFile == null ? p_default_directory : outputFile.getParent();
        JFileChooser fileChooser = new JFileChooser(directoryName);
        fileChooser.setMinimumSize(new Dimension(500, 250));
        FileNameExtensionFilter sesFilter = new FileNameExtensionFilter("SPECCTRA Session file (*.ses)", "ses");
        fileChooser.addChoosableFileFilter(sesFilter);
        FileNameExtensionFilter frbFilter = new FileNameExtensionFilter("Freerouting binary file (*.frb)", "frb");
        fileChooser.addChoosableFileFilter(frbFilter);
        FileNameExtensionFilter scrFilter = new FileNameExtensionFilter("Eagle Session Script file (*.scr)", "scr");
        fileChooser.addChoosableFileFilter(scrFilter);
        FileNameExtensionFilter dsnFilter = new FileNameExtensionFilter("SPECCTRA Design file (*.dsn)", "dsn");
        fileChooser.addChoosableFileFilter(dsnFilter);
        switch (output.format) {
            case SES: {
                fileChooser.setFileFilter(sesFilter);
                break;
            }
            case FRB: {
                fileChooser.setFileFilter(frbFilter);
                break;
            }
            case SCR: {
                fileChooser.setFileFilter(scrFilter);
                break;
            }
            case DSN: {
                fileChooser.setFileFilter(dsnFilter);
                break;
            }
            default: {
                fileChooser.setFileFilter(sesFilter);
            }
        }
        if (!output.getFilename().isEmpty()) {
            fileChooser.setSelectedFile(output.getFile());
        }
        fileChooser.showSaveDialog(p_parent);
        return fileChooser.getSelectedFile();
    }

    private boolean saveRulesAs(File rulesFile, String designName, GuiBoardManager p_board_handling) {
        FileOutputStream outputStream;
        FRLogger.info("Saving '" + rulesFile.getPath() + "'...");
        try {
            outputStream = new FileOutputStream(rulesFile);
        }
        catch (IOException e) {
            FRLogger.error("unable to create rules file", e);
            return false;
        }
        RulesFile.write(p_board_handling, outputStream, designName);
        return true;
    }

    public void saveAsEagleScriptScr(File outputFile, String design_name) {
        FileOutputStream output_stream;
        ByteArrayOutputStream sesOutputStream = new ByteArrayOutputStream();
        if (!this.board_panel.board_handling.saveAsSpecctraSessionSes(sesOutputStream, design_name)) {
            return;
        }
        ByteArrayInputStream sesInputStream = new ByteArrayInputStream(sesOutputStream.toByteArray());
        FRLogger.info("Saving '" + outputFile.getPath() + "'...");
        try {
            output_stream = new FileOutputStream(outputFile);
        }
        catch (Exception exception) {
            output_stream = null;
        }
        if (this.board_panel.board_handling.saveSpecctraSessionSesAsEagleScriptScr(sesInputStream, output_stream)) {
            this.screen_messages.set_status_message(this.tm.getText("message_eagle_saved", outputFile.getPath()));
        } else {
            this.screen_messages.set_status_message(this.tm.getText("message_eagle_save_failed", outputFile.getPath()));
        }
    }

    public boolean saveAsSpecctraDesignDsn(File outputFile, String designName, boolean compatibilityMode) {
        FileOutputStream output_stream;
        if (outputFile == null) {
            return false;
        }
        FRLogger.info("Saving '" + outputFile.getPath() + "'...");
        try {
            output_stream = new FileOutputStream(outputFile);
        }
        catch (Exception exception) {
            output_stream = null;
        }
        return this.board_panel.board_handling.saveAsSpecctraDesignDsn(output_stream, designName, compatibilityMode);
    }

    public void set_select_toolbar() {
        this.getContentPane().remove(this.toolbar_panel);
        this.getContentPane().add((Component)this.select_toolbar, "North");
        this.repaint();
    }

    public void set_menu_toolbar() {
        this.getContentPane().remove(this.select_toolbar);
        this.getContentPane().add((Component)this.toolbar_panel, "North");
        this.repaint();
    }

    Point absolute_panel_location() {
        int x = this.scroll_pane.getX();
        int y = this.scroll_pane.getY();
        for (Container curr_parent = this.scroll_pane.getParent(); curr_parent != null; curr_parent = curr_parent.getParent()) {
            x += curr_parent.getX();
            y += curr_parent.getY();
        }
        return new Point(x, y);
    }

    public void zoom_all() {
        this.board_panel.board_handling.adjust_design_bounds();
        Rectangle display_rect = this.board_panel.get_viewport_bounds();
        Rectangle design_bounds = this.board_panel.board_handling.graphics_context.get_design_bounds();
        double width_factor = display_rect.getWidth() / design_bounds.getWidth();
        double height_factor = display_rect.getHeight() / design_bounds.getHeight();
        double zoom_factor = Math.min(width_factor, height_factor);
        Point2D zoom_center = this.board_panel.board_handling.graphics_context.get_design_center();
        this.board_panel.zoom(zoom_factor, zoom_center);
        Point2D new_vieport_center = this.board_panel.board_handling.graphics_context.get_design_center();
        this.board_panel.set_viewport_center(new_vieport_center);
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.permanent_subwindows.length; ++i) {
            if (this.permanent_subwindows[i] == null) continue;
            this.permanent_subwindows[i].dispose();
            this.permanent_subwindows[i] = null;
        }
        for (BoardTemporarySubWindow curr_subwindow : this.temporary_subwindows) {
            if (curr_subwindow == null) continue;
            curr_subwindow.board_frame_disposed();
        }
        if (this.board_panel.board_handling != null) {
            this.board_panel.board_handling.dispose();
            this.board_panel.board_handling = null;
        }
        if (this.log_entry_added_listener != null) {
            FRLogger.getLogEntries().removeLogEntryAddedListener(this.log_entry_added_listener);
        }
        super.dispose();
    }

    private void allocate_permanent_subwindows() {
        this.color_manager = new ColorManager(this);
        this.permanent_subwindows[0] = this.color_manager;
        this.object_visibility_window = WindowObjectVisibility.get_instance(this);
        this.permanent_subwindows[1] = this.object_visibility_window;
        this.layer_visibility_window = WindowLayerVisibility.get_instance(this);
        this.permanent_subwindows[2] = this.layer_visibility_window;
        this.display_misc_window = new WindowDisplayMisc(this);
        this.permanent_subwindows[3] = this.display_misc_window;
        this.snapshot_window = new WindowSnapshot(this);
        this.permanent_subwindows[4] = this.snapshot_window;
        this.route_parameter_window = new WindowRouteParameter(this);
        this.permanent_subwindows[5] = this.route_parameter_window;
        this.select_parameter_window = new WindowSelectParameter(this);
        this.permanent_subwindows[6] = this.select_parameter_window;
        this.clearance_matrix_window = new WindowClearanceMatrix(this);
        this.permanent_subwindows[7] = this.clearance_matrix_window;
        this.padstacks_window = new WindowPadstacks(this);
        this.permanent_subwindows[8] = this.padstacks_window;
        this.packages_window = new WindowPackages(this);
        this.permanent_subwindows[9] = this.packages_window;
        this.components_window = new WindowComponents(this);
        this.permanent_subwindows[10] = this.components_window;
        this.incompletes_window = new WindowIncompletes(this);
        this.permanent_subwindows[11] = this.incompletes_window;
        this.clearance_violations_window = new WindowClearanceViolations(this);
        this.permanent_subwindows[12] = this.clearance_violations_window;
        this.net_info_window = new WindowNets(this);
        this.permanent_subwindows[13] = this.net_info_window;
        this.via_window = new WindowVia(this);
        this.permanent_subwindows[14] = this.via_window;
        this.edit_vias_window = new WindowEditVias(this);
        this.permanent_subwindows[15] = this.edit_vias_window;
        this.edit_net_rules_window = new WindowNetClasses(this);
        this.permanent_subwindows[16] = this.edit_net_rules_window;
        this.assign_net_classes_window = new WindowAssignNetClass(this);
        this.permanent_subwindows[17] = this.assign_net_classes_window;
        this.length_violations_window = new WindowLengthViolations(this);
        this.permanent_subwindows[18] = this.length_violations_window;
        this.about_window = new WindowAbout(this.locale, this.freerouting_version);
        this.permanent_subwindows[19] = this.about_window;
        this.move_parameter_window = new WindowMoveParameter(this);
        this.permanent_subwindows[20] = this.move_parameter_window;
        this.unconnected_route_window = new WindowUnconnectedRoute(this);
        this.permanent_subwindows[21] = this.unconnected_route_window;
        this.route_stubs_window = new WindowRouteStubs(this);
        this.permanent_subwindows[22] = this.route_stubs_window;
        this.autoroute_parameter_window = new WindowAutorouteParameter(this);
        this.permanent_subwindows[23] = this.autoroute_parameter_window;
    }

    private void initialize_windows() {
        this.allocate_permanent_subwindows();
        this.setLocation(120, 0);
        this.select_parameter_window.setLocation(0, 0);
        this.select_parameter_window.setVisible(true);
        this.route_parameter_window.setLocation(0, 100);
        this.autoroute_parameter_window.setLocation(0, 200);
        this.move_parameter_window.setLocation(0, 50);
        this.clearance_matrix_window.setLocation(0, 150);
        this.via_window.setLocation(50, 150);
        this.edit_vias_window.setLocation(100, 150);
        this.edit_net_rules_window.setLocation(100, 200);
        this.assign_net_classes_window.setLocation(100, 250);
        this.padstacks_window.setLocation(100, 30);
        this.packages_window.setLocation(200, 30);
        this.components_window.setLocation(300, 30);
        this.incompletes_window.setLocation(400, 30);
        this.clearance_violations_window.setLocation(500, 30);
        this.length_violations_window.setLocation(550, 30);
        this.net_info_window.setLocation(350, 30);
        this.unconnected_route_window.setLocation(650, 30);
        this.route_stubs_window.setLocation(600, 30);
        this.snapshot_window.setLocation(0, 250);
        this.layer_visibility_window.setLocation(0, 450);
        this.object_visibility_window.setLocation(0, 550);
        this.display_misc_window.setLocation(0, 350);
        this.color_manager.setLocation(0, 600);
        this.about_window.setLocation(200, 200);
    }

    public Locale get_locale() {
        return this.locale;
    }

    public void set_board_background(Color p_color) {
        this.board_panel.setBackground(p_color);
    }

    public void refresh_windows() {
        for (int i = 0; i < this.permanent_subwindows.length; ++i) {
            if (this.permanent_subwindows[i] == null) continue;
            this.permanent_subwindows[i].refresh();
        }
    }

    public void setToolbarModeSelectionPanelValue(InteractiveState interactiveState) {
        this.toolbar_panel.setModeSelectionPanelValue(interactiveState);
    }

    private void setToolbarUnitSelectionPanelValue(Unit unit) {
        this.toolbar_panel.setUnitSelectionPanelValue(unit);
    }

    public void goto_selected_snapshot() {
        if (this.snapshot_window != null) {
            this.snapshot_window.goto_selected();
        }
    }

    public void select_previous_snapshot() {
        if (this.snapshot_window != null) {
            this.snapshot_window.select_previous_item();
        }
    }

    public void select_next_snapshot() {
        if (this.snapshot_window != null) {
            this.snapshot_window.select_next_item();
        }
    }

    public SubwindowSelections get_snapshot_subwindow_selections() {
        SubwindowSelections result = new SubwindowSelections();
        result.incompletes_selection = this.incompletes_window.get_snapshot_info();
        result.packages_selection = this.packages_window.get_snapshot_info();
        result.nets_selection = this.net_info_window.get_snapshot_info();
        result.components_selection = this.components_window.get_snapshot_info();
        result.padstacks_selection = this.padstacks_window.get_snapshot_info();
        return result;
    }

    public void set_snapshot_subwindow_selections(SubwindowSelections p_filters) {
        this.incompletes_window.set_snapshot_info(p_filters.incompletes_selection);
        this.packages_window.set_snapshot_info(p_filters.packages_selection);
        this.net_info_window.set_snapshot_info(p_filters.nets_selection);
        this.components_window.set_snapshot_info(p_filters.components_selection);
        this.padstacks_window.set_snapshot_info(p_filters.padstacks_selection);
    }

    public void repaint_all() {
        this.repaint();
        for (int i = 0; i < this.permanent_subwindows.length; ++i) {
            this.permanent_subwindows[i].repaint();
        }
    }

    public void addBoardLoadedEventListener(Consumer<RoutingBoard> listener) {
        this.boardLoadedEventListeners.add(listener);
    }

    public void addReadOnlyEventListener(Consumer<RoutingBoard> listener) {
        this.boardSavedEventListeners.add(listener);
    }

    private class WindowStateListener
    extends WindowAdapter {
        final /* synthetic */ BoardFrame this$0;

        private WindowStateListener(BoardFrame boardFrame) {
            BoardFrame boardFrame2 = boardFrame;
            Objects.requireNonNull(boardFrame2);
            this.this$0 = boardFrame2;
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            this.this$0.setDefaultCloseOperation(2);
            boolean wasBoardChanged = this.this$0.board_panel.board_handling.isBoardChanged();
            if (wasBoardChanged) {
                Object[] options = new Object[]{this.this$0.tm.getText("confirm_exit_yes", new String[0]), this.this$0.tm.getText("confirm_exit_no", new String[0])};
                JOptionPane optionPane = new JOptionPane(this.this$0.tm.getText("confirm_cancel", new String[0]), 2, 0, null, options, options[1]);
                JDialog dialog = optionPane.createDialog(null, "Warning");
                dialog.setVisible(true);
                Object selectedValue = optionPane.getValue();
                if (selectedValue == null || selectedValue.equals(this.this$0.tm.getText("confirm_exit_no", new String[0]))) {
                    this.this$0.setDefaultCloseOperation(0);
                    FRAnalytics.buttonClicked("board_confirm_exit_dialog_no", this.this$0.tm.getText("confirm_cancel", new String[0]));
                    return;
                }
            }
            try {
                WindowWelcome.saveSettings();
            }
            catch (IOException e) {
                FRLogger.error("Error saving settings to the freerouting.json file.", e);
            }
            Freerouting.globalSettings.guiSettings.isRunning = false;
            Freerouting.globalSettings.apiServerSettings.isRunning = false;
        }

        @Override
        public void windowIconified(WindowEvent evt) {
            for (int i = 0; i < this.this$0.permanent_subwindows.length; ++i) {
                this.this$0.permanent_subwindows[i].parent_iconified();
            }
            for (BoardSubWindow boardSubWindow : this.this$0.temporary_subwindows) {
                if (boardSubWindow == null) continue;
                boardSubWindow.parent_iconified();
            }
        }

        @Override
        public void windowDeiconified(WindowEvent evt) {
            for (BoardSavableSubWindow permanentSubwindow : this.this$0.permanent_subwindows) {
                if (permanentSubwindow == null) continue;
                permanentSubwindow.parent_deiconified();
            }
            for (BoardSubWindow boardSubWindow : this.this$0.temporary_subwindows) {
                if (boardSubWindow == null) continue;
                boardSubWindow.parent_deiconified();
            }
        }
    }

    public static class SubwindowSelections
    implements Serializable {
        private WindowObjectListWithFilter.SnapshotInfo incompletes_selection;
        private WindowObjectListWithFilter.SnapshotInfo packages_selection;
        private WindowObjectListWithFilter.SnapshotInfo nets_selection;
        private WindowObjectListWithFilter.SnapshotInfo components_selection;
        private WindowObjectListWithFilter.SnapshotInfo padstacks_selection;
    }
}

