/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.geometry.planar.ConvexShape;
import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.FloatLine;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.LineSegment;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polygon;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.geometry.planar.PolylineShape;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.Simplex;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class TileShape
extends PolylineShape
implements ConvexShape,
Serializable {
    public static TileShape get_instance(Line[] p_line_arr) {
        Simplex result = Simplex.get_instance(p_line_arr);
        return result.simplify();
    }

    public static TileShape get_instance(Point[] p_convex_polygon) {
        Line[] line_arr = new Line[p_convex_polygon.length];
        for (int j = 0; j < line_arr.length - 1; ++j) {
            line_arr[j] = new Line(p_convex_polygon[j], p_convex_polygon[j + 1]);
        }
        line_arr[line_arr.length - 1] = new Line(p_convex_polygon[line_arr.length - 1], p_convex_polygon[0]);
        return TileShape.get_instance(line_arr);
    }

    public static TileShape get_instance(Line p_line) {
        Line[] lines = new Line[]{p_line};
        return Simplex.get_instance(lines);
    }

    public static IntOctagon get_instance(int p_lx, int p_ly, int p_rx, int p_uy, int p_ulx, int p_lrx, int p_llx, int p_urx) {
        IntOctagon oct = new IntOctagon(p_lx, p_ly, p_rx, p_uy, p_ulx, p_lrx, p_llx, p_urx);
        return oct.normalize();
    }

    public static IntOctagon get_instance(int p_lower_left_x, int p_lower_left_y, int p_upper_right_x, int p_upper_right_y) {
        IntBox box = new IntBox(p_lower_left_x, p_lower_left_y, p_upper_right_x, p_upper_right_y);
        return box.to_IntOctagon();
    }

    public static IntBox get_instance(Point p_point) {
        return p_point.surrounding_box();
    }

    public TileShape intersection_with_simplify(TileShape p_other) {
        TileShape result = this.intersection(p_other);
        return result.simplify();
    }

    public abstract TileShape simplify();

    public abstract boolean is_IntBox();

    public abstract boolean is_IntOctagon();

    public abstract TileShape intersection(TileShape var1);

    @Override
    public abstract Line border_line(int var1);

    public abstract int border_line_index(Line var1);

    public abstract Simplex to_Simplex();

    @Override
    public double area() {
        if (!this.is_bounded()) {
            return Double.MAX_VALUE;
        }
        if (this.dimension() < 2) {
            return 0.0;
        }
        double result = 0.0;
        int corner_count = this.border_line_count();
        FloatPoint prev_corner = this.corner_approx(corner_count - 2);
        FloatPoint curr_corner = this.corner_approx(corner_count - 1);
        for (int i = 0; i < corner_count; ++i) {
            FloatPoint next_corner = this.corner_approx(i);
            result += curr_corner.x * (next_corner.y - prev_corner.y);
            prev_corner = curr_corner;
            curr_corner = next_corner;
        }
        result = 0.5 * Math.abs(result);
        return result;
    }

    @Override
    public boolean is_outside(Point p_point) {
        int line_count = this.border_line_count();
        if (line_count == 0) {
            return true;
        }
        for (int i = 0; i < line_count; ++i) {
            if (this.border_line(i).side_of(p_point) != Side.ON_THE_LEFT) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Point p_point) {
        return !this.is_outside(p_point);
    }

    @Override
    public boolean contains_inside(Point p_point) {
        int line_count = this.border_line_count();
        if (line_count == 0) {
            return false;
        }
        for (int i = 0; i < line_count; ++i) {
            if (this.border_line(i).side_of(p_point) == Side.ON_THE_RIGHT) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(FloatPoint p_point) {
        return this.contains(p_point, 0.0);
    }

    public boolean contains(FloatPoint p_point, double p_tolerance) {
        int line_count = this.border_line_count();
        if (line_count == 0) {
            return false;
        }
        for (int i = 0; i < line_count; ++i) {
            if (this.border_line(i).side_of(p_point, p_tolerance) == Side.ON_THE_RIGHT) continue;
            return false;
        }
        return true;
    }

    public Side side_of_border(FloatPoint p_point, double p_tolerance) {
        int line_count = this.border_line_count();
        if (line_count == 0) {
            return Side.COLLINEAR;
        }
        Side result = Side.ON_THE_RIGHT;
        for (int i = 0; i < line_count; ++i) {
            Side curr_side = this.border_line(i).side_of(p_point, p_tolerance);
            if (curr_side == Side.ON_THE_LEFT) {
                return Side.ON_THE_LEFT;
            }
            if (curr_side != Side.COLLINEAR) continue;
            result = curr_side;
        }
        return result;
    }

    public int contains_on_border_line_no(Point p_point) {
        int line_count = this.border_line_count();
        if (line_count == 0) {
            return -1;
        }
        int containing_line_no = -1;
        for (int i = 0; i < line_count; ++i) {
            Side side_of = this.border_line(i).side_of(p_point);
            if (side_of == Side.ON_THE_LEFT) {
                return -1;
            }
            if (side_of != Side.COLLINEAR) continue;
            containing_line_no = i;
        }
        return containing_line_no;
    }

    @Override
    public boolean contains_on_border(Point p_point) {
        return this.contains_on_border_line_no(p_point) >= 0;
    }

    public boolean contains_approx(TileShape p_other) {
        FloatPoint[] corners;
        for (FloatPoint curr_corner : corners = p_other.corner_approx_arr()) {
            if (this.contains(curr_corner)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(TileShape p_other) {
        for (int i = 0; i < p_other.border_line_count(); ++i) {
            if (this.contains(p_other.corner(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public double distance(FloatPoint p_point) {
        FloatPoint nearest_point = this.nearest_point_approx(p_point);
        return nearest_point.distance(p_point);
    }

    @Override
    public double border_distance(FloatPoint p_point) {
        FloatPoint nearest_point = this.nearest_border_point_approx(p_point);
        return nearest_point.distance(p_point);
    }

    @Override
    public double smallest_radius() {
        return this.border_distance(this.centre_of_gravity());
    }

    public Point nearest_point(Point p_from_point) {
        if (!this.is_outside(p_from_point)) {
            return p_from_point;
        }
        return this.nearest_border_point(p_from_point);
    }

    @Override
    public FloatPoint nearest_point_approx(FloatPoint p_from_point) {
        if (this.contains(p_from_point)) {
            return p_from_point;
        }
        return this.nearest_border_point_approx(p_from_point);
    }

    public Point nearest_border_point(Point p_from_point) {
        int line_count = this.border_line_count();
        if (line_count == 0) {
            return null;
        }
        FloatPoint from_point_f = p_from_point.to_float();
        if (line_count == 1) {
            return this.border_line(0).perpendicular_projection(p_from_point);
        }
        double min_dist = Double.MAX_VALUE;
        int min_dist_ind = 0;
        for (int i = 0; i < line_count; ++i) {
            FloatPoint curr_corner_f = this.corner_approx(i);
            double curr_dist = curr_corner_f.distance_square(from_point_f);
            if (!(curr_dist < min_dist)) continue;
            min_dist = curr_dist;
            min_dist_ind = i;
        }
        Point nearest_point = this.corner(min_dist_ind);
        int prev_ind = line_count - 2;
        int curr_ind = line_count - 1;
        int next_ind = 0;
        while (next_ind < line_count) {
            FloatPoint projection_f;
            double curr_dist;
            Point projection = this.border_line(curr_ind).perpendicular_projection(p_from_point);
            if (!(this.corner_is_bounded(curr_ind) && this.border_line(prev_ind).side_of(projection) != Side.ON_THE_RIGHT || this.corner_is_bounded(next_ind) && this.border_line(next_ind).side_of(projection) != Side.ON_THE_RIGHT || !((curr_dist = (projection_f = projection.to_float()).distance_square(from_point_f)) < min_dist))) {
                min_dist = curr_dist;
                nearest_point = projection;
            }
            prev_ind = curr_ind;
            curr_ind = next_ind++;
        }
        return nearest_point;
    }

    public FloatPoint nearest_border_point_approx(FloatPoint p_from_point) {
        FloatPoint[] nearest_points = this.nearest_border_points_approx(p_from_point, 1);
        if (nearest_points.length == 0) {
            return null;
        }
        return nearest_points[0];
    }

    public FloatPoint[] nearest_border_points_approx(FloatPoint p_from_point, int p_count) {
        if (p_count <= 0) {
            return new FloatPoint[0];
        }
        int line_count = this.border_line_count();
        int result_count = Math.min(p_count, line_count);
        if (line_count == 0) {
            return new FloatPoint[0];
        }
        if (line_count == 1) {
            FloatPoint[] result = new FloatPoint[]{p_from_point.projection_approx(this.border_line(0))};
            return result;
        }
        if (this.dimension() == 0) {
            FloatPoint[] result = new FloatPoint[]{this.corner_approx(0)};
            return result;
        }
        FloatPoint[] nearest_points = new FloatPoint[result_count];
        double[] min_dists = new double[result_count];
        Arrays.fill(min_dists, Double.MAX_VALUE);
        block0: for (int i = 0; i < line_count; ++i) {
            if (!this.corner_is_bounded(i)) continue;
            FloatPoint curr_corner = this.corner_approx(i);
            double curr_dist = curr_corner.distance_square(p_from_point);
            for (int j = 0; j < result_count; ++j) {
                if (!(curr_dist < min_dists[j])) continue;
                for (int k = j + 1; k < result_count; ++k) {
                    min_dists[k] = min_dists[k - 1];
                    nearest_points[k] = nearest_points[k - 1];
                }
                min_dists[j] = curr_dist;
                nearest_points[j] = curr_corner;
                continue block0;
            }
        }
        int prev_ind = line_count - 2;
        int curr_ind = line_count - 1;
        int next_ind = 0;
        while (next_ind < line_count) {
            FloatPoint projection = p_from_point.projection_approx(this.border_line(curr_ind));
            if (!(this.corner_is_bounded(curr_ind) && this.border_line(prev_ind).side_of(projection) != Side.ON_THE_RIGHT || this.corner_is_bounded(next_ind) && this.border_line(next_ind).side_of(projection) != Side.ON_THE_RIGHT)) {
                double curr_dist = projection.distance_square(p_from_point);
                for (int j = 0; j < result_count; ++j) {
                    if (!(curr_dist < min_dists[j])) continue;
                    for (int k = j + 1; k < result_count; ++k) {
                        min_dists[k] = min_dists[k - 1];
                        nearest_points[k] = nearest_points[k - 1];
                    }
                    min_dists[j] = curr_dist;
                    nearest_points[j] = projection;
                    break;
                }
            }
            prev_ind = curr_ind;
            curr_ind = next_ind++;
        }
        return nearest_points;
    }

    public int index_of_nearest_corner(Point p_from_point) {
        FloatPoint from_point_f = p_from_point.to_float();
        int result = 0;
        int corner_count = this.border_line_count();
        double min_dist = Double.MIN_VALUE;
        for (int i = 0; i < corner_count; ++i) {
            double curr_dist = this.corner_approx(i).distance(from_point_f);
            if (!(curr_dist < min_dist)) continue;
            min_dist = curr_dist;
            result = i;
        }
        return result;
    }

    public FloatLine diagonal_corner_segment() {
        if (this.is_empty()) {
            return null;
        }
        FloatPoint first_corner = this.corner_approx(0);
        FloatPoint last_corner = this.corner_approx(this.border_line_count() / 2);
        return new FloatLine(first_corner, last_corner);
    }

    public FloatPoint[] nearest_relative_outside_locations(TileShape p_shape, int p_count) {
        int line_count = this.border_line_count();
        if (p_count <= 0 || line_count < 3 || !this.intersects(p_shape)) {
            return new FloatPoint[0];
        }
        int result_count = Math.min(p_count, line_count);
        FloatPoint[] translate_coors = new FloatPoint[result_count];
        double[] min_dists = new double[result_count];
        Arrays.fill(min_dists, Double.MAX_VALUE);
        int curr_ind = line_count - 1;
        int other_line_count = p_shape.border_line_count();
        int next_ind = 0;
        while (next_ind < line_count) {
            double curr_max_dist = 0.0;
            FloatPoint curr_translate_coor = FloatPoint.ZERO;
            for (int corner_no = 0; corner_no < other_line_count; ++corner_no) {
                FloatPoint projection;
                double curr_dist;
                FloatPoint curr_corner = p_shape.corner_approx(corner_no);
                if (this.border_line(curr_ind).side_of(curr_corner) != Side.ON_THE_RIGHT || !((curr_dist = (projection = curr_corner.projection_approx(this.border_line(curr_ind))).distance_square(curr_corner)) > curr_max_dist)) continue;
                curr_max_dist = curr_dist;
                curr_translate_coor = projection.substract(curr_corner);
            }
            for (int j = 0; j < result_count; ++j) {
                if (!(curr_max_dist < min_dists[j])) continue;
                for (int k = j + 1; k < result_count; ++k) {
                    min_dists[k] = min_dists[k - 1];
                    translate_coors[k] = translate_coors[k - 1];
                }
                min_dists[j] = curr_max_dist;
                translate_coors[j] = curr_translate_coor;
                break;
            }
            curr_ind = next_ind++;
        }
        return translate_coors;
    }

    @Override
    public ConvexShape shrink(double p_offset) {
        ConvexShape result = this.offset(-p_offset);
        if (result.is_empty()) {
            IntBox centre_box = this.centre_of_gravity().bounding_box();
            result = this.intersection(centre_box);
        }
        return result;
    }

    public double length() {
        if (!this.is_bounded()) {
            return 2.147483647E9;
        }
        int dimension = this.dimension();
        if (dimension <= 0) {
            return 0.0;
        }
        if (dimension == 1) {
            return this.circumference() / 2.0;
        }
        double max_distance = -1.0;
        double max_distance_2 = -1.0;
        FloatPoint gravity_point = this.centre_of_gravity();
        for (int i = 0; i < this.border_line_count(); ++i) {
            double curr_distance = Math.abs(this.border_line(i).signed_distance(gravity_point));
            if (curr_distance > max_distance) {
                max_distance_2 = max_distance;
                max_distance = curr_distance;
                continue;
            }
            if (!(curr_distance > max_distance_2)) continue;
            max_distance_2 = curr_distance;
        }
        return max_distance + max_distance_2;
    }

    public int[] touching_sides(TileShape p_other) {
        int side_no_2 = -1;
        Direction dir2 = null;
        for (int i = 0; i < p_other.border_line_count(); ++i) {
            Direction curr_dir = p_other.border_line(i).direction();
            if (curr_dir.compareTo(Direction.LEFT) < 0) continue;
            side_no_2 = i;
            dir2 = curr_dir.opposite();
            break;
        }
        if (dir2 == null) {
            FRLogger.warn("touching_side : dir2 not found");
            return new int[0];
        }
        int side_no_1 = 0;
        Direction dir1 = this.border_line(0).direction();
        int max_ind = this.border_line_count() + p_other.border_line_count();
        for (int i = 0; i < max_ind; ++i) {
            int compare = dir2.compareTo(dir1);
            if (compare == 0 && this.border_line(side_no_1).is_equal_or_opposite(p_other.border_line(side_no_2))) {
                int[] result = new int[]{side_no_1, side_no_2};
                return result;
            }
            if (compare >= 0) {
                side_no_1 = (side_no_1 + 1) % this.border_line_count();
                dir1 = this.border_line(side_no_1).direction();
                continue;
            }
            side_no_2 = (side_no_2 + 1) % p_other.border_line_count();
            dir2 = p_other.border_line(side_no_2).direction().opposite();
        }
        return new int[0];
    }

    public double distance_to_the_left(Line p_line) {
        double result = 2.147483647E9;
        for (int i = 0; i < this.border_line_count(); ++i) {
            FloatPoint curr_corner = this.corner_approx(i);
            Side line_side = p_line.side_of(curr_corner, 1.0);
            if (line_side == Side.COLLINEAR) {
                line_side = p_line.side_of(this.corner(i));
            }
            if (line_side == Side.ON_THE_RIGHT) {
                result = -1.0;
                break;
            }
            result = Math.min(result, p_line.signed_distance(curr_corner));
        }
        return result;
    }

    public Side side_of(Line p_line) {
        boolean on_the_left = false;
        boolean on_the_right = false;
        for (int i = 0; i < this.border_line_count(); ++i) {
            Side curr_side = p_line.side_of(this.corner(i));
            if (curr_side == Side.ON_THE_LEFT) {
                on_the_right = true;
            } else if (curr_side == Side.ON_THE_RIGHT) {
                on_the_left = true;
            }
            if (!on_the_left || !on_the_right) continue;
            return Side.COLLINEAR;
        }
        Side result = on_the_left ? Side.ON_THE_LEFT : Side.ON_THE_RIGHT;
        return result;
    }

    @Override
    public TileShape turn_90_degree(int p_factor, IntPoint p_pole) {
        Line[] new_lines = new Line[this.border_line_count()];
        for (int i = 0; i < new_lines.length; ++i) {
            new_lines[i] = this.border_line(i).turn_90_degree(p_factor, p_pole);
        }
        return TileShape.get_instance(new_lines);
    }

    @Override
    public TileShape rotate_approx(double p_angle, FloatPoint p_pole) {
        TileShape result;
        if (p_angle == 0.0) {
            return this;
        }
        Point[] new_corners = new IntPoint[this.border_line_count()];
        for (int i = 0; i < new_corners.length; ++i) {
            new_corners[i] = this.corner_approx(i).rotate(p_angle, p_pole).round();
        }
        Polygon corner_polygon = new Polygon(new_corners);
        Point[] polygon_corners = corner_polygon.corner_array();
        if (polygon_corners.length >= 3) {
            result = TileShape.get_instance(polygon_corners);
        } else if (polygon_corners.length == 2) {
            Polyline curr_polyline = new Polyline(polygon_corners);
            LineSegment curr_segment = new LineSegment(curr_polyline, 0);
            result = curr_segment.to_simplex();
        } else {
            result = polygon_corners.length == 1 ? TileShape.get_instance(polygon_corners[0]) : Simplex.EMPTY;
        }
        return result;
    }

    @Override
    public TileShape mirror_vertical(IntPoint p_pole) {
        Line[] new_lines = new Line[this.border_line_count()];
        for (int i = 0; i < new_lines.length; ++i) {
            new_lines[i] = this.border_line(i).mirror_vertical(p_pole);
        }
        return TileShape.get_instance(new_lines);
    }

    @Override
    public TileShape mirror_horizontal(IntPoint p_pole) {
        Line[] new_lines = new Line[this.border_line_count()];
        for (int i = 0; i < new_lines.length; ++i) {
            new_lines[i] = this.border_line(i).mirror_horizontal(p_pole);
        }
        return TileShape.get_instance(new_lines);
    }

    public int intersecting_border_line_no(Point p_from_point, Direction p_direction) {
        if (!this.contains(p_from_point)) {
            return -1;
        }
        FloatPoint from_point = p_from_point.to_float();
        Line intersection_line = new Line(p_from_point, p_direction);
        FloatPoint second_line_point = intersection_line.b.to_float();
        int result = -1;
        double min_distance = 3.4028234663852886E38;
        for (int i = 0; i < this.border_line_count(); ++i) {
            boolean direction_ok;
            double curr_distance;
            Line curr_border_line = this.border_line(i);
            FloatPoint curr_intersection = curr_border_line.intersection_approx(intersection_line);
            if (curr_intersection.x >= 2.147483647E9 || !((curr_distance = curr_intersection.distance_square(from_point)) < min_distance)) continue;
            boolean bl = direction_ok = curr_border_line.side_of(second_line_point) == Side.ON_THE_LEFT || second_line_point.distance_square(curr_intersection) < curr_distance;
            if (!direction_ok) continue;
            result = i;
            min_distance = curr_distance;
        }
        return result;
    }

    public abstract TileShape[] cutout(TileShape var1);

    public int[][] entrance_points(Polyline p_polyline) {
        int[][] result = new int[2 * p_polyline.arr.length][2];
        int intersection_count = 0;
        int prev_intersection_line_no = -1;
        int prev_intersection_edge_no = -1;
        for (int line_no = 1; line_no < p_polyline.arr.length - 1; ++line_no) {
            LineSegment curr_line_seg = new LineSegment(p_polyline, line_no);
            int[] curr_intersections = curr_line_seg.border_intersections(this);
            for (int i = 0; i < curr_intersections.length; ++i) {
                int edge_no = curr_intersections[i];
                if (line_no == prev_intersection_line_no && edge_no == prev_intersection_edge_no) continue;
                result[intersection_count][0] = line_no;
                result[intersection_count][1] = edge_no;
                ++intersection_count;
                prev_intersection_line_no = line_no;
                prev_intersection_edge_no = edge_no;
            }
        }
        return (int[][])Arrays.copyOf(result, intersection_count);
    }

    @Override
    public Polyline[] cutout(Polyline p_polyline) {
        Polyline curr_piece;
        Line[] curr_lines;
        int curr_polyline_intersection_no;
        int[][] intersection_no = this.entrance_points(p_polyline);
        Point first_corner = p_polyline.first_corner();
        boolean first_corner_is_inside = this.contains_inside(first_corner);
        if (intersection_no.length == 0) {
            if (first_corner_is_inside) {
                return new Polyline[0];
            }
            Polyline[] result = new Polyline[]{p_polyline};
            return result;
        }
        LinkedList<Polyline> pieces = new LinkedList<Polyline>();
        int curr_intersection_no = 0;
        int[] curr_intersection_tuple = intersection_no[curr_intersection_no];
        Point first_intersection = p_polyline.arr[curr_intersection_tuple[0]].intersection(this.border_line(curr_intersection_tuple[1]));
        if (!first_corner_is_inside) {
            if (!first_corner.equals(first_intersection)) {
                curr_polyline_intersection_no = curr_intersection_tuple[0];
                curr_lines = new Line[curr_polyline_intersection_no + 2];
                System.arraycopy(p_polyline.arr, 0, curr_lines, 0, curr_polyline_intersection_no + 1);
                curr_lines[curr_polyline_intersection_no + 1] = this.border_line(curr_intersection_tuple[1]);
                curr_piece = new Polyline(curr_lines);
                if (!curr_piece.is_empty()) {
                    pieces.add(curr_piece);
                }
            }
            ++curr_intersection_no;
        }
        while (curr_intersection_no < intersection_no.length - 1) {
            curr_intersection_tuple = intersection_no[curr_intersection_no];
            int[] next_intersection_tuple = intersection_no[curr_intersection_no + 1];
            int curr_intersection_no_of_polyline = curr_intersection_tuple[0];
            int next_intersection_no_of_polyline = next_intersection_tuple[0];
            boolean insert_piece = false;
            for (int i = curr_intersection_no_of_polyline + 1; i < next_intersection_no_of_polyline; ++i) {
                if (!this.is_outside(p_polyline.corner(i))) continue;
                insert_piece = true;
                break;
            }
            if (insert_piece) {
                Line[] curr_lines2 = new Line[next_intersection_no_of_polyline - curr_intersection_no_of_polyline + 3];
                curr_lines2[0] = this.border_line(curr_intersection_tuple[1]);
                System.arraycopy(p_polyline.arr, curr_intersection_no_of_polyline, curr_lines2, 1, curr_lines2.length - 2);
                curr_lines2[curr_lines2.length - 1] = this.border_line(next_intersection_tuple[1]);
                Polyline curr_piece2 = new Polyline(curr_lines2);
                if (!curr_piece2.is_empty()) {
                    pieces.add(curr_piece2);
                }
            }
            curr_intersection_no += 2;
        }
        if (curr_intersection_no <= intersection_no.length - 1) {
            curr_intersection_tuple = intersection_no[curr_intersection_no];
            curr_polyline_intersection_no = curr_intersection_tuple[0];
            curr_lines = new Line[p_polyline.arr.length - curr_polyline_intersection_no + 1];
            curr_lines[0] = this.border_line(curr_intersection_tuple[1]);
            System.arraycopy(p_polyline.arr, curr_polyline_intersection_no, curr_lines, 1, curr_lines.length - 1);
            curr_piece = new Polyline(curr_lines);
            if (!curr_piece.is_empty()) {
                pieces.add(curr_piece);
            }
        }
        Polyline[] result = new Polyline[pieces.size()];
        Iterator it = pieces.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Polyline)it.next();
        }
        return result;
    }

    @Override
    public TileShape[] split_to_convex() {
        TileShape[] result = new TileShape[]{this};
        return result;
    }

    public TileShape[] divide_into_sections(double p_max_section_width) {
        if (this.is_empty()) {
            TileShape[] result = new TileShape[]{this};
            return result;
        }
        IntBox[] section_boxes = this.bounding_box().divide_into_sections(p_max_section_width);
        LinkedList<TileShape> section_list = new LinkedList<TileShape>();
        for (int i = 0; i < section_boxes.length; ++i) {
            TileShape curr_section = this.intersection_with_simplify(section_boxes[i]);
            if (curr_section.dimension() != 2) continue;
            section_list.add(curr_section);
        }
        TileShape[] result = new TileShape[section_list.size()];
        Iterator it = section_list.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (TileShape)it.next();
        }
        return result;
    }

    public boolean is_intersected_interior_by(LineSegment p_line_segment) {
        FloatPoint float_start_point = p_line_segment.start_point_approx();
        FloatPoint float_end_point = p_line_segment.end_point_approx();
        Side[] border_line_side_of_start_point_arr = new Side[this.border_line_count()];
        Side[] border_line_side_of_end_point_arr = new Side[border_line_side_of_start_point_arr.length];
        for (int i = 0; i < border_line_side_of_start_point_arr.length; ++i) {
            Side border_line_side_of_end_point;
            Line curr_border_line = this.border_line(i);
            Side border_line_side_of_start_point = curr_border_line.side_of(float_start_point, 1.0);
            if (border_line_side_of_start_point == Side.COLLINEAR) {
                border_line_side_of_start_point = curr_border_line.side_of(p_line_segment.start_point());
            }
            if ((border_line_side_of_end_point = curr_border_line.side_of(float_end_point, 1.0)) == Side.COLLINEAR) {
                border_line_side_of_end_point = curr_border_line.side_of(p_line_segment.end_point());
            }
            if (border_line_side_of_start_point != Side.ON_THE_RIGHT && border_line_side_of_end_point != Side.ON_THE_RIGHT) {
                return false;
            }
            border_line_side_of_start_point_arr[i] = border_line_side_of_start_point;
            border_line_side_of_end_point_arr[i] = border_line_side_of_end_point;
        }
        boolean start_point_is_inside = true;
        for (int i = 0; i < border_line_side_of_start_point_arr.length; ++i) {
            if (border_line_side_of_start_point_arr[i] == Side.ON_THE_RIGHT) continue;
            start_point_is_inside = false;
            break;
        }
        if (start_point_is_inside) {
            return true;
        }
        boolean end_point_is_inside = true;
        for (int i = 0; i < border_line_side_of_end_point_arr.length; ++i) {
            if (border_line_side_of_end_point_arr[i] == Side.ON_THE_RIGHT) continue;
            end_point_is_inside = false;
            break;
        }
        if (end_point_is_inside) {
            return true;
        }
        Line segment_line = p_line_segment.get_line();
        for (int i = 0; i < border_line_side_of_start_point_arr.length; ++i) {
            int next_corner_index;
            Side next_corner_side;
            Side border_line_side_of_start_point = border_line_side_of_start_point_arr[i];
            Side border_line_side_of_end_point = border_line_side_of_end_point_arr[i];
            if (border_line_side_of_start_point == border_line_side_of_end_point || border_line_side_of_start_point == Side.COLLINEAR && border_line_side_of_end_point == Side.ON_THE_LEFT || border_line_side_of_end_point == Side.COLLINEAR && border_line_side_of_start_point == Side.ON_THE_LEFT) continue;
            Side prev_corner_side = segment_line.side_of(this.corner_approx(i), 1.0);
            if (prev_corner_side == Side.COLLINEAR) {
                prev_corner_side = segment_line.side_of(this.corner(i));
            }
            if ((next_corner_side = segment_line.side_of(this.corner_approx(next_corner_index = i == border_line_side_of_start_point_arr.length - 1 ? 0 : i + 1), 1.0)) == Side.COLLINEAR) {
                next_corner_side = segment_line.side_of(this.corner(next_corner_index));
            }
            if ((prev_corner_side != Side.ON_THE_LEFT || next_corner_side != Side.ON_THE_RIGHT) && (prev_corner_side != Side.ON_THE_RIGHT || next_corner_side != Side.ON_THE_LEFT)) continue;
            return true;
        }
        return false;
    }

    abstract TileShape intersection(Simplex var1);

    abstract TileShape intersection(IntOctagon var1);

    abstract TileShape intersection(IntBox var1);

    abstract TileShape[] cutout_from(IntBox var1);

    abstract TileShape[] cutout_from(IntOctagon var1);

    abstract TileShape[] cutout_from(Simplex var1);
}

