/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.datastructures.BigIntAux;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.IntVector;
import app.freerouting.geometry.planar.Limits;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.RationalVector;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.Vector;
import java.io.Serializable;
import java.math.BigInteger;

public class RationalPoint
extends Point
implements Serializable {
    final BigInteger x;
    final BigInteger y;
    final BigInteger z;

    RationalPoint(BigInteger p_x, BigInteger p_y, BigInteger p_z) {
        this.x = p_x;
        this.y = p_y;
        this.z = p_z;
        if (p_z.signum() < 0) {
            throw new IllegalArgumentException("RationalPoint: p_z is expected to be >= 0");
        }
    }

    RationalPoint(IntPoint p_point) {
        this.x = BigInteger.valueOf(p_point.x);
        this.y = BigInteger.valueOf(p_point.y);
        this.z = BigInteger.ONE;
    }

    @Override
    public FloatPoint to_float() {
        double xd = this.x.doubleValue();
        double yd = this.y.doubleValue();
        double zd = this.z.doubleValue();
        if (zd == 0.0) {
            xd = 3.4028234663852886E38;
            yd = 3.4028234663852886E38;
        } else {
            xd /= zd;
            yd /= zd;
        }
        return new FloatPoint(xd, yd);
    }

    public final boolean equals(Object p_ob) {
        if (this == p_ob) {
            return true;
        }
        if (p_ob == null) {
            return false;
        }
        if (this.getClass() != p_ob.getClass()) {
            return false;
        }
        RationalPoint other = (RationalPoint)p_ob;
        BigInteger det = BigIntAux.determinant(this.x, other.x, this.z, other.z);
        if (det.signum() != 0) {
            return false;
        }
        det = BigIntAux.determinant(this.y, other.y, this.z, other.z);
        return det.signum() == 0;
    }

    @Override
    public boolean is_infinite() {
        return this.z.signum() == 0;
    }

    @Override
    public IntBox surrounding_box() {
        FloatPoint fp = this.to_float();
        int llx = (int)Math.floor(fp.x);
        int lly = (int)Math.floor(fp.y);
        int urx = (int)Math.ceil(fp.x);
        int ury = (int)Math.ceil(fp.y);
        return new IntBox(llx, lly, urx, ury);
    }

    @Override
    public IntOctagon surrounding_octagon() {
        FloatPoint fp = this.to_float();
        int lx = (int)Math.floor(fp.x);
        int ly = (int)Math.floor(fp.y);
        int rx = (int)Math.ceil(fp.x);
        int uy = (int)Math.ceil(fp.y);
        double tmp = fp.x - fp.y;
        int ulx = (int)Math.floor(tmp);
        int lrx = (int)Math.ceil(tmp);
        tmp = fp.x + fp.y;
        int llx = (int)Math.floor(tmp);
        int urx = (int)Math.ceil(tmp);
        return new IntOctagon(lx, ly, rx, uy, ulx, lrx, llx, urx);
    }

    @Override
    public boolean is_contained_in(IntBox p_box) {
        BigInteger tmp = BigInteger.valueOf(p_box.ll.x).multiply(this.z);
        if (this.x.compareTo(tmp) < 0) {
            return false;
        }
        tmp = BigInteger.valueOf(p_box.ll.y).multiply(this.z);
        if (this.y.compareTo(tmp) < 0) {
            return false;
        }
        tmp = BigInteger.valueOf(p_box.ur.x).multiply(this.z);
        if (this.x.compareTo(tmp) > 0) {
            return false;
        }
        tmp = BigInteger.valueOf(p_box.ur.y).multiply(this.z);
        return this.y.compareTo(tmp) <= 0;
    }

    @Override
    public Point translate_by(Vector p_vector) {
        if (p_vector.equals(Vector.ZERO)) {
            return this;
        }
        return p_vector.add_to(this);
    }

    @Override
    Point translate_by(IntVector p_vector) {
        RationalVector vector = new RationalVector(p_vector);
        return this.translate_by(vector);
    }

    @Override
    Point translate_by(RationalVector p_vector) {
        BigInteger[] v1 = new BigInteger[]{this.x, this.y, this.z};
        BigInteger[] v2 = new BigInteger[]{p_vector.x, p_vector.y, p_vector.z};
        BigInteger[] result = BigIntAux.add_rational_coordinates(v1, v2);
        return new RationalPoint(result[0], result[1], result[2]);
    }

    @Override
    public Vector difference_by(Point p_other) {
        Vector tmp = p_other.difference_by(this);
        return tmp.negate();
    }

    @Override
    Vector difference_by(IntPoint p_other) {
        RationalPoint other = new RationalPoint(p_other);
        return this.difference_by(other);
    }

    @Override
    Vector difference_by(RationalPoint p_other) {
        BigInteger[] v1 = new BigInteger[]{this.x, this.y, this.z};
        BigInteger[] v2 = new BigInteger[]{p_other.x.negate(), p_other.y.negate(), p_other.z};
        BigInteger[] result = BigIntAux.add_rational_coordinates(v1, v2);
        return new RationalVector(result[0], result[1], result[2]);
    }

    @Override
    public Side side_of(Point p_1, Point p_2) {
        Vector v1 = this.difference_by(p_1);
        Vector v2 = p_2.difference_by(p_1);
        return v1.side_of(v2);
    }

    @Override
    public Side side_of(Line p_line) {
        return this.side_of(p_line.a, p_line.b);
    }

    @Override
    public Point perpendicular_projection(Line p_line) {
        IntVector v = (IntVector)p_line.b.difference_by(p_line.a);
        BigInteger vxvx = BigInteger.valueOf((long)v.x * (long)v.x);
        BigInteger vyvy = BigInteger.valueOf((long)v.y * (long)v.y);
        BigInteger vxvy = BigInteger.valueOf((long)v.x * (long)v.y);
        BigInteger denominator = vxvx.add(vyvy);
        BigInteger det = BigInteger.valueOf(((IntPoint)p_line.a).determinant((IntPoint)p_line.b));
        BigInteger tmp1 = vxvx.multiply(this.x);
        BigInteger tmp2 = vxvy.multiply(this.y);
        tmp1 = tmp1.add(tmp2);
        tmp2 = det.multiply(BigInteger.valueOf(v.y));
        tmp2 = tmp2.multiply(this.z);
        BigInteger proj_x = tmp1.add(tmp2);
        tmp1 = vxvy.multiply(this.x);
        tmp2 = vyvy.multiply(this.y);
        tmp1 = tmp1.add(tmp2);
        tmp2 = det.multiply(BigInteger.valueOf(v.x));
        tmp2 = tmp2.multiply(this.z);
        BigInteger proj_y = tmp1.add(tmp2);
        int signum = denominator.signum();
        if (signum != 0) {
            if (signum < 0) {
                denominator = denominator.negate();
                proj_x = proj_x.negate();
                proj_y = proj_y.negate();
            }
            if (proj_x.mod(denominator).signum() == 0 && proj_y.mod(denominator).signum() == 0) {
                proj_x = proj_x.divide(denominator);
                proj_y = proj_y.divide(denominator);
                if (proj_x.abs().compareTo(Limits.CRIT_INT_BIG) <= 0 && proj_y.abs().compareTo(Limits.CRIT_INT_BIG) <= 0) {
                    return new IntPoint(proj_x.intValue(), proj_y.intValue());
                }
                denominator = BigInteger.ONE;
            }
        }
        return new RationalPoint(proj_x, proj_y, denominator);
    }

    @Override
    public int compare_x(Point p_other) {
        return -p_other.compare_x(this);
    }

    @Override
    public int compare_y(Point p_other) {
        return -p_other.compare_y(this);
    }

    @Override
    int compare_x(RationalPoint p_other) {
        BigInteger tmp1 = this.x.multiply(p_other.z);
        BigInteger tmp2 = p_other.x.multiply(this.z);
        return tmp1.compareTo(tmp2);
    }

    @Override
    int compare_y(RationalPoint p_other) {
        BigInteger tmp1 = this.y.multiply(p_other.z);
        BigInteger tmp2 = p_other.y.multiply(this.z);
        return tmp1.compareTo(tmp2);
    }

    @Override
    int compare_x(IntPoint p_other) {
        BigInteger tmp1 = this.z.multiply(BigInteger.valueOf(p_other.x));
        return this.x.compareTo(tmp1);
    }

    @Override
    int compare_y(IntPoint p_other) {
        BigInteger tmp1 = this.z.multiply(BigInteger.valueOf(p_other.y));
        return this.y.compareTo(tmp1);
    }
}

