/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.geometry.planar.Circle;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntDirection;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polygon;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.geometry.planar.PolylineShape;
import app.freerouting.geometry.planar.RegularTileShape;
import app.freerouting.geometry.planar.Shape;
import app.freerouting.geometry.planar.ShapeBoundingDirections;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.Simplex;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Random;

public class PolygonShape
extends PolylineShape {
    private static final int seed = 99;
    private static final Random random_generator = new Random(99L);
    public final Point[] corners;
    private transient IntBox precalculated_bounding_box;
    private transient IntOctagon precalculated_bounding_octagon;
    private transient TileShape[] precalculated_convex_pieces;

    public PolygonShape(Polygon p_polygon) {
        int i;
        Point[] curr_corners;
        int last_corner_no;
        Polygon curr_polygon = p_polygon;
        if (p_polygon.winding_number_after_closing() < 0) {
            curr_polygon = p_polygon.revert_corners();
        }
        if ((last_corner_no = (curr_corners = curr_polygon.corner_array()).length - 1) > 0 && curr_corners[0].equals(curr_corners[last_corner_no])) {
            --last_corner_no;
        }
        boolean last_point_collinear = false;
        if (last_corner_no >= 2) {
            boolean bl = last_point_collinear = curr_corners[last_corner_no].side_of(curr_corners[last_corner_no - 1], curr_corners[0]) == Side.COLLINEAR;
        }
        if (last_point_collinear) {
            --last_corner_no;
        }
        int first_corner_no = 0;
        boolean first_point_collinear = false;
        if (last_corner_no - first_corner_no >= 2) {
            boolean bl = first_point_collinear = curr_corners[0].side_of(curr_corners[1], curr_corners[last_corner_no]) == Side.COLLINEAR;
        }
        if (first_point_collinear) {
            ++first_corner_no;
        }
        int start_corner_no = first_corner_no;
        FloatPoint start_corner = curr_corners[start_corner_no].to_float();
        for (int i2 = start_corner_no + 1; i2 <= last_corner_no; ++i2) {
            FloatPoint curr_corner = curr_corners[i2].to_float();
            if (!(curr_corner.y < start_corner.y) && (curr_corner.y != start_corner.y || !(curr_corner.x < start_corner.x))) continue;
            start_corner_no = i2;
            start_corner = curr_corner;
        }
        int new_corner_count = last_corner_no - first_corner_no + 1;
        Point[] result = new Point[new_corner_count];
        int curr_corner_no = 0;
        for (i = start_corner_no; i <= last_corner_no; ++i) {
            result[curr_corner_no] = curr_corners[i];
            ++curr_corner_no;
        }
        for (i = first_corner_no; i < start_corner_no; ++i) {
            result[curr_corner_no] = curr_corners[i];
            ++curr_corner_no;
        }
        this.corners = result;
    }

    public PolygonShape(Point[] p_corner_arr) {
        this(new Polygon(p_corner_arr));
    }

    @Override
    public Point corner(int p_no) {
        if (p_no < 0 || p_no >= this.corners.length) {
            FRLogger.warn("PolygonShape.corner: p_no out of range");
            return null;
        }
        return this.corners[p_no];
    }

    @Override
    public int border_line_count() {
        return this.corners.length;
    }

    @Override
    public boolean corner_is_bounded(int p_no) {
        return true;
    }

    @Override
    public boolean intersects(Shape p_shape) {
        return p_shape.intersects(this);
    }

    @Override
    public boolean intersects(Circle p_circle) {
        TileShape[] convex_pieces = this.split_to_convex();
        for (int i = 0; i < convex_pieces.length; ++i) {
            if (!convex_pieces[i].intersects(p_circle)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(Simplex p_simplex) {
        TileShape[] convex_pieces = this.split_to_convex();
        for (int i = 0; i < convex_pieces.length; ++i) {
            if (!convex_pieces[i].intersects(p_simplex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(IntOctagon p_oct) {
        TileShape[] convex_pieces = this.split_to_convex();
        for (int i = 0; i < convex_pieces.length; ++i) {
            if (!convex_pieces[i].intersects(p_oct)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(IntBox p_box) {
        TileShape[] convex_pieces = this.split_to_convex();
        for (int i = 0; i < convex_pieces.length; ++i) {
            if (!convex_pieces[i].intersects(p_box)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Polyline[] cutout(Polyline p_polyline) {
        FRLogger.warn("PolygonShape.cutout not yet implemented");
        return null;
    }

    @Override
    public PolygonShape enlarge(double p_offset) {
        if (p_offset == 0.0) {
            return this;
        }
        FRLogger.warn("PolygonShape.enlarge not yet implemented");
        return null;
    }

    @Override
    public double border_distance(FloatPoint p_point) {
        FRLogger.warn("PolygonShape.border_distance not yet implemented");
        return 0.0;
    }

    @Override
    public double smallest_radius() {
        return this.border_distance(this.centre_of_gravity());
    }

    @Override
    public boolean contains(FloatPoint p_point) {
        TileShape[] convex_pieces = this.split_to_convex();
        for (int i = 0; i < convex_pieces.length; ++i) {
            if (!convex_pieces[i].contains(p_point)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains_inside(Point p_point) {
        if (this.contains_on_border(p_point)) {
            return false;
        }
        return !this.is_outside(p_point);
    }

    @Override
    public boolean is_outside(Point p_point) {
        TileShape[] convex_pieces = this.split_to_convex();
        for (int i = 0; i < convex_pieces.length; ++i) {
            if (convex_pieces[i].is_outside(p_point)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Point p_point) {
        return !this.is_outside(p_point);
    }

    @Override
    public boolean contains_on_border(Point p_point) {
        return false;
    }

    @Override
    public double distance(FloatPoint p_point) {
        FRLogger.warn("PolygonShape.distance not yet implemented");
        return 0.0;
    }

    @Override
    public PolygonShape translate_by(Vector p_vector) {
        if (p_vector.equals(Vector.ZERO)) {
            return this;
        }
        Point[] new_corners = new Point[this.corners.length];
        for (int i = 0; i < this.corners.length; ++i) {
            new_corners[i] = this.corners[i].translate_by(p_vector);
        }
        return new PolygonShape(new_corners);
    }

    @Override
    public RegularTileShape bounding_shape(ShapeBoundingDirections p_dirs) {
        return p_dirs.bounds(this);
    }

    @Override
    public IntBox bounding_box() {
        if (this.precalculated_bounding_box == null) {
            double llx = 2.147483647E9;
            double lly = 2.147483647E9;
            double urx = -2.147483648E9;
            double ury = -2.147483648E9;
            for (int i = 0; i < this.corners.length; ++i) {
                FloatPoint curr = this.corners[i].to_float();
                llx = Math.min(llx, curr.x);
                lly = Math.min(lly, curr.y);
                urx = Math.max(urx, curr.x);
                ury = Math.max(ury, curr.y);
            }
            IntPoint lower_left = new IntPoint((int)Math.floor(llx), (int)Math.floor(lly));
            IntPoint upper_right = new IntPoint((int)Math.ceil(urx), (int)Math.ceil(ury));
            this.precalculated_bounding_box = new IntBox(lower_left, upper_right);
        }
        return this.precalculated_bounding_box;
    }

    @Override
    public IntOctagon bounding_octagon() {
        if (this.precalculated_bounding_octagon == null) {
            double lx = 2.147483647E9;
            double ly = 2.147483647E9;
            double rx = -2.147483648E9;
            double uy = -2.147483648E9;
            double ulx = 2.147483647E9;
            double lrx = -2.147483648E9;
            double llx = 2.147483647E9;
            double urx = -2.147483648E9;
            for (int i = 0; i < this.corners.length; ++i) {
                FloatPoint curr = this.corners[i].to_float();
                lx = Math.min(lx, curr.x);
                ly = Math.min(ly, curr.y);
                rx = Math.max(rx, curr.x);
                uy = Math.max(uy, curr.y);
                double tmp = curr.x - curr.y;
                ulx = Math.min(ulx, tmp);
                lrx = Math.max(lrx, tmp);
                tmp = curr.x + curr.y;
                llx = Math.min(llx, tmp);
                urx = Math.max(urx, tmp);
            }
            this.precalculated_bounding_octagon = new IntOctagon((int)Math.floor(lx), (int)Math.floor(ly), (int)Math.ceil(rx), (int)Math.ceil(uy), (int)Math.floor(ulx), (int)Math.ceil(lrx), (int)Math.floor(llx), (int)Math.ceil(urx));
        }
        return this.precalculated_bounding_octagon;
    }

    public boolean is_convex() {
        if (this.corners.length <= 2) {
            return true;
        }
        Point prev_point = this.corners[this.corners.length - 1];
        Point curr_point = this.corners[0];
        Point next_point = this.corners[1];
        for (int ind = 0; ind < this.corners.length; ++ind) {
            if (next_point.side_of(prev_point, curr_point) == Side.ON_THE_RIGHT) {
                return false;
            }
            prev_point = curr_point;
            curr_point = next_point;
            next_point = ind == this.corners.length - 2 ? this.corners[0] : this.corners[ind + 2];
        }
        Line first_line = new Line(this.corners[this.corners.length - 1], this.corners[0]);
        Line curr_line = new Line(this.corners[0], this.corners[1]);
        IntDirection first_direction = (IntDirection)first_line.direction();
        IntDirection curr_direction = (IntDirection)curr_line.direction();
        double last_det = first_direction.determinant(curr_direction);
        for (int ind2 = 2; ind2 < this.corners.length; ++ind2) {
            curr_line = new Line(curr_line.b, this.corners[ind2]);
            curr_direction = (IntDirection)curr_line.direction();
            double curr_det = first_direction.determinant(curr_direction);
            if (last_det <= 0.0 && curr_det > 0.0) {
                return false;
            }
            last_det = curr_det;
        }
        return true;
    }

    public PolygonShape convex_hull() {
        if (this.corners.length <= 2) {
            return this;
        }
        Point prev_point = this.corners[this.corners.length - 1];
        Point curr_point = this.corners[0];
        for (int ind = 0; ind < this.corners.length; ++ind) {
            Point next_point = ind == this.corners.length - 1 ? this.corners[0] : this.corners[ind + 1];
            if (next_point.side_of(prev_point, curr_point) != Side.ON_THE_LEFT) {
                Point[] new_corners = new Point[this.corners.length - 1];
                System.arraycopy(this.corners, 0, new_corners, 0, ind);
                if (ind < new_corners.length) {
                    System.arraycopy(this.corners, ind + 1, new_corners, ind, new_corners.length - ind);
                }
                PolygonShape result = new PolygonShape(new_corners);
                return result.convex_hull();
            }
            prev_point = curr_point;
            curr_point = next_point;
        }
        return this;
    }

    @Override
    public TileShape bounding_tile() {
        PolygonShape hull = this.convex_hull();
        Line[] bounding_lines = new Line[hull.corners.length];
        for (int i = 0; i < bounding_lines.length - 1; ++i) {
            bounding_lines[i] = new Line(hull.corners[i], hull.corners[i + 1]);
        }
        bounding_lines[bounding_lines.length - 1] = new Line(hull.corners[hull.corners.length - 1], hull.corners[0]);
        return TileShape.get_instance(bounding_lines);
    }

    @Override
    public double area() {
        if (this.dimension() <= 2) {
            return 0.0;
        }
        double result = 0.0;
        FloatPoint prev_corner = this.corners[this.corners.length - 2].to_float();
        FloatPoint curr_corner = this.corners[this.corners.length - 1].to_float();
        for (int i = 0; i < this.corners.length; ++i) {
            FloatPoint next_corner = this.corners[i].to_float();
            result += curr_corner.x * (next_corner.y - prev_corner.y);
            prev_corner = curr_corner;
            curr_corner = next_corner;
        }
        result = 0.5 * Math.abs(result);
        return result;
    }

    @Override
    public int dimension() {
        if (this.corners.length == 0) {
            return -1;
        }
        if (this.corners.length == 1) {
            return 0;
        }
        if (this.corners.length == 2) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean is_bounded() {
        return true;
    }

    @Override
    public boolean is_empty() {
        return this.corners.length == 0;
    }

    @Override
    public Line border_line(int p_no) {
        if (p_no < 0 || p_no >= this.corners.length) {
            FRLogger.warn("PolygonShape.edge_line: p_no out of range");
            return null;
        }
        Point next_corner = p_no == this.corners.length - 1 ? this.corners[0] : this.corners[p_no + 1];
        return new Line(this.corners[p_no], next_corner);
    }

    @Override
    public FloatPoint nearest_point_approx(FloatPoint p_from_point) {
        double min_dist = Double.MAX_VALUE;
        FloatPoint result = null;
        TileShape[] convex_shapes = this.split_to_convex();
        for (int i = 0; i < convex_shapes.length; ++i) {
            FloatPoint curr_nearest_point = convex_shapes[i].nearest_point_approx(p_from_point);
            double curr_dist = curr_nearest_point.distance_square(p_from_point);
            if (!(curr_dist < min_dist)) continue;
            min_dist = curr_dist;
            result = curr_nearest_point;
        }
        return result;
    }

    @Override
    public PolygonShape turn_90_degree(int p_factor, IntPoint p_pole) {
        Point[] new_corners = new Point[this.corners.length];
        for (int i = 0; i < this.corners.length; ++i) {
            new_corners[i] = this.corners[i].turn_90_degree(p_factor, p_pole);
        }
        return new PolygonShape(new_corners);
    }

    @Override
    public PolygonShape rotate_approx(double p_angle, FloatPoint p_pole) {
        if (p_angle == 0.0) {
            return this;
        }
        Point[] new_corners = new Point[this.corners.length];
        for (int i = 0; i < this.corners.length; ++i) {
            new_corners[i] = this.corners[i].to_float().rotate(p_angle, p_pole).round();
        }
        return new PolygonShape(new_corners);
    }

    @Override
    public PolygonShape mirror_vertical(IntPoint p_pole) {
        Point[] new_corners = new Point[this.corners.length];
        for (int i = 0; i < this.corners.length; ++i) {
            new_corners[i] = this.corners[i].mirror_vertical(p_pole);
        }
        return new PolygonShape(new_corners);
    }

    @Override
    public PolygonShape mirror_horizontal(IntPoint p_pole) {
        Point[] new_corners = new Point[this.corners.length];
        for (int i = 0; i < this.corners.length; ++i) {
            new_corners[i] = this.corners[i].mirror_horizontal(p_pole);
        }
        return new PolygonShape(new_corners);
    }

    @Override
    public TileShape[] split_to_convex() {
        if (this.precalculated_convex_pieces == null) {
            random_generator.setSeed(99L);
            Collection<PolygonShape> convex_pieces = this.split_to_convex_recu();
            if (convex_pieces == null) {
                return null;
            }
            this.precalculated_convex_pieces = new TileShape[convex_pieces.size()];
            Iterator<PolygonShape> it = convex_pieces.iterator();
            for (int i = 0; i < this.precalculated_convex_pieces.length; ++i) {
                PolygonShape curr_piece = it.next();
                this.precalculated_convex_pieces[i] = TileShape.get_instance(curr_piece.corners);
            }
        }
        return this.precalculated_convex_pieces;
    }

    private Collection<PolygonShape> split_to_convex_recu() {
        int start_corner_no = random_generator.nextInt(this.corners.length);
        Point curr_corner = this.corners[start_corner_no];
        Point prev_corner = start_corner_no != 0 ? this.corners[start_corner_no - 1] : this.corners[this.corners.length - 1];
        int concave_corner_no = -1;
        for (int i = 0; i < this.corners.length; ++i) {
            Point next_corner = start_corner_no < this.corners.length - 1 ? this.corners[start_corner_no + 1] : this.corners[0];
            if (next_corner.side_of(prev_corner, curr_corner) == Side.ON_THE_RIGHT) {
                concave_corner_no = start_corner_no;
                break;
            }
            prev_corner = curr_corner;
            curr_corner = next_corner;
            start_corner_no = (start_corner_no + 1) % this.corners.length;
        }
        LinkedList<PolygonShape> result = new LinkedList<PolygonShape>();
        if (concave_corner_no < 0) {
            result.add(this);
            return result;
        }
        DivisionPoint d = new DivisionPoint(this, concave_corner_no);
        if (d.projection == null) {
            return null;
        }
        int corner_count = d.corner_no_after_projection - concave_corner_no;
        if (corner_count < 0) {
            corner_count += this.corners.length;
        }
        Point[] first_arr = new Point[++corner_count];
        int corner_ind = concave_corner_no;
        for (int i = 0; i < corner_count - 1; ++i) {
            first_arr[i] = this.corners[corner_ind];
            corner_ind = (corner_ind + 1) % this.corners.length;
        }
        first_arr[corner_count - 1] = d.projection.round();
        PolygonShape first_piece = new PolygonShape(first_arr);
        corner_count = concave_corner_no - d.corner_no_after_projection;
        if (corner_count < 0) {
            corner_count += this.corners.length;
        }
        Point[] last_arr = new Point[corner_count += 2];
        last_arr[0] = d.projection.round();
        corner_ind = d.corner_no_after_projection;
        for (int i = 1; i < corner_count; ++i) {
            last_arr[i] = this.corners[corner_ind];
            corner_ind = (corner_ind + 1) % this.corners.length;
        }
        PolygonShape last_piece = new PolygonShape(last_arr);
        Collection<PolygonShape> c1 = first_piece.split_to_convex_recu();
        if (c1 == null) {
            return null;
        }
        Collection<PolygonShape> c2 = last_piece.split_to_convex_recu();
        if (c2 == null) {
            return null;
        }
        result.addAll(c1);
        result.addAll(c2);
        return result;
    }

    private class DivisionPoint {
        final int corner_no_after_projection;
        final FloatPoint projection;

        DivisionPoint(PolygonShape polygonShape, int p_concave_corner_no) {
            Objects.requireNonNull(polygonShape);
            FloatPoint concave_corner = polygonShape.corners[p_concave_corner_no].to_float();
            FloatPoint before_concave_corner = p_concave_corner_no != 0 ? polygonShape.corners[p_concave_corner_no - 1].to_float() : polygonShape.corners[polygonShape.corners.length - 1].to_float();
            FloatPoint after_concave_corner = p_concave_corner_no == polygonShape.corners.length - 1 ? polygonShape.corners[0].to_float() : polygonShape.corners[p_concave_corner_no + 1].to_float();
            boolean search_right = before_concave_corner.y > concave_corner.y || concave_corner.y > after_concave_corner.y;
            boolean search_left = before_concave_corner.y < concave_corner.y || concave_corner.y < after_concave_corner.y;
            boolean search_up = before_concave_corner.x < concave_corner.x || concave_corner.x < after_concave_corner.x;
            boolean search_down = before_concave_corner.x > concave_corner.x || concave_corner.x > after_concave_corner.x;
            double min_projection_dist = 2.147483647E9;
            FloatPoint min_projection = null;
            int corner_no_after_min_projection = 0;
            int corner_no_after_curr_projection = (p_concave_corner_no + 2) % polygonShape.corners.length;
            Point corner_before_curr_projection = corner_no_after_curr_projection != 0 ? polygonShape.corners[corner_no_after_curr_projection - 1] : polygonShape.corners[polygonShape.corners.length - 1];
            FloatPoint corner_before_projection_approx = corner_before_curr_projection.to_float();
            int loop_end = polygonShape.corners.length - 2;
            for (int i = 0; i < loop_end; ++i) {
                boolean projection_ok;
                double curr_dist;
                Line curr_line;
                Point corner_after_curr_projection = polygonShape.corners[corner_no_after_curr_projection];
                FloatPoint corner_after_projection_approx = corner_after_curr_projection.to_float();
                if (corner_before_projection_approx.y != corner_after_projection_approx.y) {
                    double max_y;
                    double min_y;
                    if (corner_after_projection_approx.y > corner_before_projection_approx.y) {
                        min_y = corner_before_projection_approx.y;
                        max_y = corner_after_projection_approx.y;
                    } else {
                        min_y = corner_after_projection_approx.y;
                        max_y = corner_before_projection_approx.y;
                    }
                    if (concave_corner.y >= min_y && concave_corner.y <= max_y) {
                        curr_line = new Line(corner_before_curr_projection, corner_after_curr_projection);
                        double x_intersect = curr_line.function_in_y_value_approx(concave_corner.y);
                        curr_dist = Math.abs(x_intersect - concave_corner.x);
                        boolean bl = projection_ok = curr_dist < min_projection_dist && (search_right && x_intersect > concave_corner.x && concave_corner.y <= corner_after_projection_approx.y || search_left && x_intersect < concave_corner.x && concave_corner.y >= corner_after_projection_approx.y);
                        if (projection_ok) {
                            min_projection_dist = curr_dist;
                            corner_no_after_min_projection = corner_no_after_curr_projection;
                            min_projection = new FloatPoint(x_intersect, concave_corner.y);
                        }
                    }
                }
                if (corner_before_projection_approx.x != corner_after_projection_approx.x) {
                    double max_x;
                    double min_x;
                    if (corner_after_projection_approx.x > corner_before_projection_approx.x) {
                        min_x = corner_before_projection_approx.x;
                        max_x = corner_after_projection_approx.x;
                    } else {
                        min_x = corner_after_projection_approx.x;
                        max_x = corner_before_projection_approx.x;
                    }
                    if (concave_corner.x >= min_x && concave_corner.x <= max_x) {
                        curr_line = new Line(corner_before_curr_projection, corner_after_curr_projection);
                        double y_intersect = curr_line.function_value_approx(concave_corner.x);
                        curr_dist = Math.abs(y_intersect - concave_corner.y);
                        boolean bl = projection_ok = curr_dist < min_projection_dist && (search_up && y_intersect > concave_corner.y && concave_corner.x >= corner_after_projection_approx.x || search_down && y_intersect < concave_corner.y && concave_corner.x <= corner_after_projection_approx.x);
                        if (projection_ok) {
                            min_projection_dist = curr_dist;
                            corner_no_after_min_projection = corner_no_after_curr_projection;
                            min_projection = new FloatPoint(concave_corner.x, y_intersect);
                        }
                    }
                }
                corner_before_curr_projection = corner_after_curr_projection;
                corner_before_projection_approx = corner_after_projection_approx;
                if (corner_no_after_curr_projection == polygonShape.corners.length - 1) {
                    corner_no_after_curr_projection = 0;
                    continue;
                }
                ++corner_no_after_curr_projection;
            }
            if (min_projection_dist == 2.147483647E9) {
                FRLogger.warn("PolygonShape.DivisionPoint: projection not found");
            }
            this.projection = min_projection;
            this.corner_no_after_projection = corner_no_after_min_projection;
        }
    }
}

