/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.IntVector;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.RationalPoint;
import app.freerouting.geometry.planar.RationalVector;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.math.BigInteger;

public class IntPoint
extends Point
implements Serializable {
    public final int x;
    public final int y;

    public IntPoint(int p_x, int p_y) {
        if (Math.abs(p_x) > 0x2000000) {
            FRLogger.debug("IntPoint: p_x is out of range");
        }
        if (Math.abs(p_y) > 0x2000000) {
            FRLogger.debug("IntPoint: p_y is out of range");
        }
        this.x = p_x;
        this.y = p_y;
    }

    public final boolean equals(Object p_ob) {
        if (this == p_ob) {
            return true;
        }
        if (p_ob == null) {
            return false;
        }
        if (this.getClass() != p_ob.getClass()) {
            return false;
        }
        IntPoint other = (IntPoint)p_ob;
        return this.x == other.x && this.y == other.y;
    }

    @Override
    public boolean is_infinite() {
        return false;
    }

    @Override
    public IntBox surrounding_box() {
        return new IntBox(this, this);
    }

    @Override
    public IntOctagon surrounding_octagon() {
        int tmp_1 = this.x - this.y;
        int tmp_2 = this.x + this.y;
        return new IntOctagon(this.x, this.y, this.x, this.y, tmp_1, tmp_1, tmp_2, tmp_2);
    }

    @Override
    public boolean is_contained_in(IntBox p_box) {
        return this.x >= p_box.ll.x && this.y >= p_box.ll.y && this.x <= p_box.ur.x && this.y <= p_box.ur.y;
    }

    @Override
    public final Point translate_by(Vector p_vector) {
        if (p_vector.equals(Vector.ZERO)) {
            return this;
        }
        return p_vector.add_to(this);
    }

    @Override
    Point translate_by(IntVector p_vector) {
        return new IntPoint(this.x + p_vector.x, this.y + p_vector.y);
    }

    @Override
    Point translate_by(RationalVector p_vector) {
        return p_vector.add_to(this);
    }

    @Override
    public Vector difference_by(Point p_other) {
        Vector tmp = p_other.difference_by(this);
        return tmp.negate();
    }

    @Override
    Vector difference_by(RationalPoint p_other) {
        Vector tmp = p_other.difference_by(this);
        return tmp.negate();
    }

    @Override
    IntVector difference_by(IntPoint p_other) {
        return new IntVector(this.x - p_other.x, this.y - p_other.y);
    }

    @Override
    public Side side_of(Line p_line) {
        Vector v1 = this.difference_by(p_line.a);
        Vector v2 = p_line.b.difference_by(p_line.a);
        return v1.side_of(v2);
    }

    @Override
    public FloatPoint to_float() {
        return new FloatPoint(this.x, this.y);
    }

    public final long determinant(IntPoint p_other) {
        return (long)this.x * (long)p_other.y - (long)this.y * (long)p_other.x;
    }

    @Override
    public Point perpendicular_projection(Line p_line) {
        IntVector v = (IntVector)p_line.b.difference_by(p_line.a);
        BigInteger vxvx = BigInteger.valueOf((long)v.x * (long)v.x);
        BigInteger vyvy = BigInteger.valueOf((long)v.y * (long)v.y);
        BigInteger vxvy = BigInteger.valueOf((long)v.x * (long)v.y);
        BigInteger denominator = vxvx.add(vyvy);
        BigInteger det = BigInteger.valueOf(((IntPoint)p_line.a).determinant((IntPoint)p_line.b));
        BigInteger point_x = BigInteger.valueOf(this.x);
        BigInteger point_y = BigInteger.valueOf(this.y);
        BigInteger tmp1 = vxvx.multiply(point_x);
        BigInteger tmp2 = vxvy.multiply(point_y);
        tmp1 = tmp1.add(tmp2);
        tmp2 = det.multiply(BigInteger.valueOf(v.y));
        BigInteger proj_x = tmp1.add(tmp2);
        tmp1 = vxvy.multiply(point_x);
        tmp2 = vyvy.multiply(point_y);
        tmp1 = tmp1.add(tmp2);
        tmp2 = det.multiply(BigInteger.valueOf(v.x));
        BigInteger proj_y = tmp1.subtract(tmp2);
        int signum = denominator.signum();
        if (signum != 0) {
            if (signum < 0) {
                denominator = denominator.negate();
                proj_x = proj_x.negate();
                proj_y = proj_y.negate();
            }
            if (proj_x.mod(denominator).signum() == 0 && proj_y.mod(denominator).signum() == 0) {
                proj_x = proj_x.divide(denominator);
                proj_y = proj_y.divide(denominator);
                return new IntPoint(proj_x.intValue(), proj_y.intValue());
            }
        }
        return new RationalPoint(proj_x, proj_y, denominator);
    }

    public double signed_area(IntPoint p_1, IntPoint p_2) {
        IntVector d21 = p_2.difference_by(p_1);
        IntVector d01 = this.difference_by(p_1);
        return d21.determinant(d01);
    }

    public double distance_square(IntPoint p_to_point) {
        double dx = p_to_point.x - this.x;
        double dy = p_to_point.y - this.y;
        return dx * dx + dy * dy;
    }

    public double distance(IntPoint p_to_point) {
        return Math.sqrt(this.distance_square(p_to_point));
    }

    public IntPoint orthogonal_projection(IntPoint p_other) {
        int vertical_distance;
        int horizontal_distance = Math.abs(this.x - p_other.x);
        IntPoint result = horizontal_distance <= (vertical_distance = Math.abs(this.y - p_other.y)) ? new IntPoint(p_other.x, this.y) : new IntPoint(this.x, p_other.y);
        return result;
    }

    public IntPoint fortyfive_degree_projection(IntPoint p_other) {
        IntPoint result;
        int dx = this.x - p_other.x;
        int dy = this.y - p_other.y;
        double[] dist_arr = new double[4];
        dist_arr[0] = Math.abs(dx);
        dist_arr[1] = Math.abs(dy);
        double diagonal_1 = ((double)dy - (double)dx) / 2.0;
        double diagonal_2 = ((double)dy + (double)dx) / 2.0;
        dist_arr[2] = Math.abs(diagonal_1);
        dist_arr[3] = Math.abs(diagonal_2);
        double min_dist = dist_arr[0];
        for (int i = 1; i < 4; ++i) {
            if (!(dist_arr[i] < min_dist)) continue;
            min_dist = dist_arr[i];
        }
        if (min_dist == dist_arr[0]) {
            result = new IntPoint(p_other.x, this.y);
        } else if (min_dist == dist_arr[1]) {
            result = new IntPoint(this.x, p_other.y);
        } else if (min_dist == dist_arr[2]) {
            int diagonal_value = (int)diagonal_2;
            result = new IntPoint(p_other.x + diagonal_value, p_other.y + diagonal_value);
        } else {
            int diagonal_value = (int)diagonal_1;
            result = new IntPoint(p_other.x - diagonal_value, p_other.y + diagonal_value);
        }
        return result;
    }

    public IntPoint fortyfive_degree_corner(IntPoint p_to_point, boolean p_left_turn) {
        int dx = p_to_point.x - this.x;
        int dy = p_to_point.y - this.y;
        IntPoint result = dy > 0 && dy < dx ? (p_left_turn ? new IntPoint(p_to_point.x - dy, this.y) : new IntPoint(this.x + dy, p_to_point.y)) : (dx > 0 && dy > dx ? (p_left_turn ? new IntPoint(p_to_point.x, this.y + dx) : new IntPoint(this.x, p_to_point.y - dx)) : (dx < 0 && dy > -dx ? (p_left_turn ? new IntPoint(this.x, p_to_point.y + dx) : new IntPoint(p_to_point.x, this.y - dx)) : (dy > 0 && dy < -dx ? (p_left_turn ? new IntPoint(this.x - dy, p_to_point.y) : new IntPoint(p_to_point.x + dy, this.y)) : (dy < 0 && dy > dx ? (p_left_turn ? new IntPoint(p_to_point.x - dy, this.y) : new IntPoint(this.x + dy, p_to_point.y)) : (dx < 0 && dy < dx ? (p_left_turn ? new IntPoint(p_to_point.x, this.y + dx) : new IntPoint(this.x, p_to_point.y - dx)) : (dx > 0 && dy < -dx ? (p_left_turn ? new IntPoint(this.x, p_to_point.y + dx) : new IntPoint(p_to_point.x, this.y - dx)) : (dy < 0 && dy > -dx ? (p_left_turn ? new IntPoint(this.x - dy, p_to_point.y) : new IntPoint(p_to_point.x + dy, this.y)) : null)))))));
        return result;
    }

    public IntPoint ninety_degree_corner(IntPoint p_to_point, boolean p_left_turn) {
        int dx = p_to_point.x - this.x;
        int dy = p_to_point.y - this.y;
        IntPoint result = dx > 0 && dy > 0 || dx < 0 && dy < 0 ? (p_left_turn ? new IntPoint(p_to_point.x, this.y) : new IntPoint(this.x, p_to_point.y)) : (dx < 0 && dy > 0 || dx > 0 && dy < 0 ? (p_left_turn ? new IntPoint(this.x, p_to_point.y) : new IntPoint(p_to_point.x, this.y)) : null);
        return result;
    }

    @Override
    public int compare_x(Point p_other) {
        return -p_other.compare_x(this);
    }

    @Override
    public int compare_y(Point p_other) {
        return -p_other.compare_y(this);
    }

    @Override
    int compare_x(IntPoint p_other) {
        int result = this.x > p_other.x ? 1 : (this.x == p_other.x ? 0 : -1);
        return result;
    }

    @Override
    int compare_y(IntPoint p_other) {
        int result = this.y > p_other.y ? 1 : (this.y == p_other.y ? 0 : -1);
        return result;
    }

    @Override
    int compare_x(RationalPoint p_other) {
        return -p_other.compare_x(this);
    }

    @Override
    int compare_y(RationalPoint p_other) {
        return -p_other.compare_y(this);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

