/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.datastructures.Signum;
import app.freerouting.geometry.planar.BigIntDirection;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntDirection;
import app.freerouting.geometry.planar.IntVector;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.Vector;
import java.io.Serializable;

public abstract class Direction
implements Comparable<Direction>,
Serializable {
    public static final IntDirection NULL = new IntDirection(0, 0);
    public static final IntDirection RIGHT = new IntDirection(1, 0);
    public static final IntDirection RIGHT45 = new IntDirection(1, 1);
    public static final IntDirection UP = new IntDirection(0, 1);
    public static final IntDirection UP45 = new IntDirection(-1, 1);
    public static final IntDirection LEFT = new IntDirection(-1, 0);
    public static final IntDirection LEFT45 = new IntDirection(-1, -1);
    public static final IntDirection DOWN = new IntDirection(0, -1);
    public static final IntDirection DOWN45 = new IntDirection(1, -1);

    public static Direction get_instance(Vector p_vector) {
        return p_vector.to_normalized_direction();
    }

    public static Direction get_instance(Point p_from, Point p_to) {
        if (p_from.equals(p_to)) {
            return null;
        }
        return Direction.get_instance(p_to.difference_by(p_from));
    }

    public static Direction get_instance_approx(double p_angle) {
        double scale_factor = 10000.0;
        int x = (int)Math.round(Math.cos(p_angle) * 10000.0);
        int y = (int)Math.round(Math.sin(p_angle) * 10000.0);
        return Direction.get_instance(new IntVector(x, y));
    }

    public abstract Vector get_vector();

    public abstract boolean is_orthogonal();

    public abstract boolean is_diagonal();

    public boolean is_multiple_of_45_degree() {
        return this.is_orthogonal() || this.is_diagonal();
    }

    public abstract Direction turn_45_degree(int var1);

    public abstract Direction opposite();

    public final boolean equals(Direction p_other) {
        Vector other_vector;
        if (this == p_other) {
            return true;
        }
        if (p_other == null) {
            return false;
        }
        if (this.side_of(p_other) != Side.COLLINEAR) {
            return false;
        }
        Vector this_vector = this.get_vector();
        return this_vector.projection(other_vector = p_other.get_vector()) == Signum.POSITIVE;
    }

    public Side side_of(Direction p_other) {
        return this.get_vector().side_of(p_other.get_vector());
    }

    public Signum projection(Direction p_other) {
        return this.get_vector().projection(p_other.get_vector());
    }

    public Direction middle_approx(Direction p_other) {
        FloatPoint v1 = this.get_vector().to_float();
        FloatPoint v2 = p_other.get_vector().to_float();
        double length1 = v1.size();
        double length2 = v2.size();
        double x = v1.x / length1 + v2.x / length2;
        double y = v1.y / length1 + v2.y / length2;
        double scale_factor = 1000.0;
        IntVector vm = new IntVector((int)Math.round(x * 1000.0), (int)Math.round(y * 1000.0));
        return Direction.get_instance(vm);
    }

    public int compare_from(Direction p_1, Direction p_2) {
        int result = p_1.compareTo(this) >= 0 ? (p_2.compareTo(this) >= 0 ? p_1.compareTo(p_2) : -1) : (p_2.compareTo(this) >= 0 ? 1 : p_1.compareTo(p_2));
        return result;
    }

    public double angle_approx() {
        return this.get_vector().angle_approx();
    }

    @Override
    abstract int compareTo(IntDirection var1);

    @Override
    abstract int compareTo(BigIntDirection var1);

    public String toString() {
        if (this.compareTo(RIGHT) == 0) {
            return "RIGHT";
        }
        if (this.compareTo(RIGHT45) == 0) {
            return "UP-RIGHT";
        }
        if (this.compareTo(UP) == 0) {
            return "UP";
        }
        if (this.compareTo(UP45) == 0) {
            return "UP-LEFT";
        }
        if (this.compareTo(LEFT) == 0) {
            return "LEFT";
        }
        if (this.compareTo(LEFT45) == 0) {
            return "DOWN-LEFT";
        }
        if (this.compareTo(DOWN) == 0) {
            return "DOWN";
        }
        if (this.compareTo(DOWN45) == 0) {
            return "DOWN-RIGHT";
        }
        if (this.compareTo(NULL) == 0) {
            return "NULL";
        }
        return "UNKNOWN";
    }
}

