/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.geometry.planar.ConvexShape;
import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.IntVector;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.geometry.planar.RegularTileShape;
import app.freerouting.geometry.planar.Shape;
import app.freerouting.geometry.planar.ShapeBoundingDirections;
import app.freerouting.geometry.planar.Simplex;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;

public class Circle
implements ConvexShape,
Serializable {
    public final IntPoint center;
    public final int radius;

    public Circle(IntPoint p_center, int p_radius) {
        this.center = p_center;
        if (p_radius < 0) {
            FRLogger.warn("Circle: unexpected negative radius");
            this.radius = -p_radius;
        } else {
            this.radius = p_radius;
        }
    }

    @Override
    public boolean is_empty() {
        return false;
    }

    @Override
    public boolean is_bounded() {
        return true;
    }

    @Override
    public int dimension() {
        if (this.radius == 0) {
            return 0;
        }
        return 2;
    }

    @Override
    public double circumference() {
        return Math.PI * 2 * (double)this.radius;
    }

    @Override
    public double area() {
        return Math.PI * (double)this.radius * (double)this.radius;
    }

    @Override
    public FloatPoint centre_of_gravity() {
        return this.center.to_float();
    }

    @Override
    public boolean is_outside(Point p_point) {
        FloatPoint fp = p_point.to_float();
        return fp.distance_square(this.center.to_float()) > (double)this.radius * (double)this.radius;
    }

    @Override
    public boolean contains(Point p_point) {
        return !this.is_outside(p_point);
    }

    @Override
    public boolean contains_inside(Point p_point) {
        FloatPoint fp = p_point.to_float();
        return fp.distance_square(this.center.to_float()) < (double)this.radius * (double)this.radius;
    }

    @Override
    public boolean contains_on_border(Point p_point) {
        FloatPoint fp = p_point.to_float();
        return fp.distance_square(this.center.to_float()) == (double)this.radius * (double)this.radius;
    }

    @Override
    public boolean contains(FloatPoint p_point) {
        return p_point.distance_square(this.center.to_float()) <= (double)this.radius * (double)this.radius;
    }

    @Override
    public double distance(FloatPoint p_point) {
        double d = p_point.distance(this.center.to_float()) - (double)this.radius;
        return Math.max(d, 0.0);
    }

    @Override
    public double smallest_radius() {
        return this.radius;
    }

    @Override
    public IntBox bounding_box() {
        int llx = this.center.x - this.radius;
        int urx = this.center.x + this.radius;
        int lly = this.center.y - this.radius;
        int ury = this.center.y + this.radius;
        return new IntBox(llx, lly, urx, ury);
    }

    @Override
    public IntOctagon bounding_octagon() {
        int lx = this.center.x - this.radius;
        int rx = this.center.x + this.radius;
        int ly = this.center.y - this.radius;
        int uy = this.center.y + this.radius;
        double sqrt2_minus_1 = Math.sqrt(2.0) - 1.0;
        int ceil_corner_value = (int)Math.ceil(sqrt2_minus_1 * (double)this.radius);
        int floor_corner_value = (int)Math.floor(sqrt2_minus_1 * (double)this.radius);
        int ulx = lx - (this.center.y + floor_corner_value);
        int lrx = rx - (this.center.y - ceil_corner_value);
        int llx = lx + (this.center.y - floor_corner_value);
        int urx = rx + (this.center.y + ceil_corner_value);
        return new IntOctagon(lx, ly, rx, uy, ulx, lrx, llx, urx);
    }

    @Override
    public TileShape bounding_tile() {
        return this.bounding_octagon();
    }

    public TileShape bounding_tile(int p_max_segment_length) {
        int quadrant_division_count = this.radius / p_max_segment_length + 1;
        if (quadrant_division_count <= 2) {
            return this.bounding_octagon();
        }
        Line[] tangent_line_arr = new Line[quadrant_division_count * 4];
        for (int i = 0; i < quadrant_division_count; ++i) {
            Line curr_tangent;
            IntVector border_delta;
            if (i == 0) {
                border_delta = new IntVector(this.radius, 0);
            } else {
                double curr_angle = (double)i * Math.PI / (2.0 * (double)quadrant_division_count);
                int curr_x = (int)Math.ceil(Math.sin(curr_angle) * (double)this.radius);
                int curr_y = (int)Math.ceil(Math.cos(curr_angle) * (double)this.radius);
                border_delta = new IntVector(curr_x, curr_y);
            }
            Point curr_a = this.center.translate_by((Vector)border_delta);
            Point curr_b = curr_a.turn_90_degree(1, this.center);
            Direction curr_dir = Direction.get_instance(curr_b.difference_by(this.center));
            tangent_line_arr[quadrant_division_count + i] = curr_tangent = new Line(curr_a, curr_dir);
            tangent_line_arr[2 * quadrant_division_count + i] = curr_tangent.turn_90_degree(1, this.center);
            tangent_line_arr[3 * quadrant_division_count + i] = curr_tangent.turn_90_degree(2, this.center);
            tangent_line_arr[i] = curr_tangent.turn_90_degree(3, this.center);
        }
        return TileShape.get_instance(tangent_line_arr);
    }

    @Override
    public boolean is_contained_in(IntBox p_box) {
        if (p_box.ll.x > this.center.x - this.radius) {
            return false;
        }
        if (p_box.ll.y > this.center.y - this.radius) {
            return false;
        }
        if (p_box.ur.x < this.center.x + this.radius) {
            return false;
        }
        return p_box.ur.y >= this.center.y + this.radius;
    }

    @Override
    public Circle turn_90_degree(int p_factor, IntPoint p_pole) {
        IntPoint new_center = (IntPoint)this.center.turn_90_degree(p_factor, p_pole);
        return new Circle(new_center, this.radius);
    }

    @Override
    public Circle rotate_approx(double p_angle, FloatPoint p_pole) {
        IntPoint new_center = this.center.to_float().rotate(p_angle, p_pole).round();
        return new Circle(new_center, this.radius);
    }

    @Override
    public Circle mirror_vertical(IntPoint p_pole) {
        IntPoint new_center = (IntPoint)this.center.mirror_vertical(p_pole);
        return new Circle(new_center, this.radius);
    }

    @Override
    public Circle mirror_horizontal(IntPoint p_pole) {
        IntPoint new_center = (IntPoint)this.center.mirror_horizontal(p_pole);
        return new Circle(new_center, this.radius);
    }

    @Override
    public double max_width() {
        return 2 * this.radius;
    }

    @Override
    public double min_width() {
        return 2 * this.radius;
    }

    @Override
    public RegularTileShape bounding_shape(ShapeBoundingDirections p_dirs) {
        return p_dirs.bounds(this);
    }

    @Override
    public Circle offset(double p_offset) {
        double new_radius = (double)this.radius + p_offset;
        int r = (int)Math.round(new_radius);
        return new Circle(this.center, r);
    }

    @Override
    public Circle shrink(double p_offset) {
        double new_radius = (double)this.radius - p_offset;
        int r = Math.max((int)Math.round(new_radius), 1);
        return new Circle(this.center, r);
    }

    @Override
    public Circle translate_by(Vector p_vector) {
        if (p_vector.equals(Vector.ZERO)) {
            return this;
        }
        if (!(p_vector instanceof IntVector)) {
            FRLogger.warn("Circle.translate_by only implemented for IntVectors till now");
            return this;
        }
        IntPoint new_center = (IntPoint)this.center.translate_by(p_vector);
        return new Circle(new_center, this.radius);
    }

    @Override
    public FloatPoint nearest_point_approx(FloatPoint p_point) {
        FRLogger.warn("Circle.nearest_point_approx not yet implemented");
        return null;
    }

    @Override
    public double border_distance(FloatPoint p_point) {
        double d = p_point.distance(this.center.to_float()) - (double)this.radius;
        return Math.abs(d);
    }

    @Override
    public Circle enlarge(double p_offset) {
        if (p_offset == 0.0) {
            return this;
        }
        int new_radius = this.radius + (int)Math.round(p_offset);
        return new Circle(this.center, new_radius);
    }

    @Override
    public boolean intersects(Shape p_other) {
        return p_other.intersects(this);
    }

    @Override
    public Polyline[] cutout(Polyline p_polyline) {
        FRLogger.warn("Circle.cutout not yet implemented");
        return null;
    }

    @Override
    public boolean intersects(Circle p_other) {
        double d_square = this.radius + p_other.radius;
        d_square *= d_square;
        return this.center.distance_square(p_other.center) <= d_square;
    }

    @Override
    public boolean intersects(IntBox p_box) {
        return p_box.distance(this.center.to_float()) <= (double)this.radius;
    }

    @Override
    public boolean intersects(IntOctagon p_oct) {
        return p_oct.distance(this.center.to_float()) <= (double)this.radius;
    }

    @Override
    public boolean intersects(Simplex p_simplex) {
        return p_simplex.distance(this.center.to_float()) <= (double)this.radius;
    }

    @Override
    public TileShape[] split_to_convex() {
        TileShape[] result = new TileShape[]{this.bounding_tile()};
        return result;
    }

    @Override
    public Circle get_border() {
        return this;
    }

    @Override
    public Shape[] get_holes() {
        return new Shape[0];
    }

    @Override
    public FloatPoint[] corner_approx_arr() {
        return new FloatPoint[0];
    }

    public String toString() {
        return this.to_string(Locale.ENGLISH);
    }

    public String to_string(Locale p_locale) {
        Object result = "Circle: ";
        if (!this.center.equals(Point.ZERO)) {
            String center_string = "center " + String.valueOf(this.center);
            result = (String)result + center_string;
        }
        NumberFormat nf = NumberFormat.getInstance(p_locale);
        String radius_string = "radius " + nf.format(this.radius);
        result = (String)result + radius_string;
        return result;
    }
}

