/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.drc;

import app.freerouting.drc.DrcViolation;
import com.google.gson.annotations.SerializedName;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class DrcReport {
    @SerializedName(value="$schema")
    public final String $schema = "https://schemas.kicad.org/drc.v1.json";
    @SerializedName(value="coordinate_units")
    public final String coordinate_units;
    @SerializedName(value="date")
    public final String date;
    @SerializedName(value="kicad_version")
    public final String kicad_version = "N/A";
    @SerializedName(value="freerouting_version")
    public final String freerouting_version;
    @SerializedName(value="source")
    public final String source;
    @SerializedName(value="unconnected_items")
    public final List<DrcViolation> unconnected_items;
    @SerializedName(value="violations")
    public final List<DrcViolation> violations;
    @SerializedName(value="schematic_parity")
    public final List<Object> schematic_parity;

    public DrcReport(String coordinateUnits, String source, String version) {
        this.coordinate_units = coordinateUnits;
        this.source = source;
        this.freerouting_version = version;
        this.date = ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.violations = new ArrayList<DrcViolation>();
        this.unconnected_items = new ArrayList<DrcViolation>();
        this.schematic_parity = new ArrayList<Object>();
    }

    public void addViolation(DrcViolation violation) {
        this.violations.add(violation);
    }

    public void addUnconnectedItem(DrcViolation item) {
        this.unconnected_items.add(item);
    }
}

