/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.drc;

import app.freerouting.board.BasicBoard;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.Item;
import app.freerouting.board.Pin;
import app.freerouting.board.Trace;
import app.freerouting.board.Unit;
import app.freerouting.board.Via;
import app.freerouting.drc.ClearanceViolation;
import app.freerouting.drc.DrcPosition;
import app.freerouting.drc.DrcReport;
import app.freerouting.drc.DrcViolation;
import app.freerouting.drc.DrcViolationItem;
import app.freerouting.drc.UnconnectedItems;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.RatsNest;
import app.freerouting.management.gson.GsonProvider;
import app.freerouting.settings.DesignRulesCheckerSettings;
import java.util.ArrayList;
import java.util.Collection;

public class DesignRulesChecker {
    private final BasicBoard board;
    private final DesignRulesCheckerSettings drcSettings;

    public DesignRulesChecker(BasicBoard board, DesignRulesCheckerSettings drcSettings) {
        this.board = board;
        this.drcSettings = drcSettings;
    }

    public Collection<ClearanceViolation> getAllClearanceViolations() {
        ArrayList<ClearanceViolation> allViolations = new ArrayList<ClearanceViolation>();
        Collection<Item> items = this.board.get_items();
        for (Item item : items) {
            if (item == null) continue;
            Collection<ClearanceViolation> itemViolations = item.clearance_violations();
            allViolations.addAll(itemViolations);
        }
        return allViolations;
    }

    public Collection<UnconnectedItems> getAllUnconnectedItems() {
        ArrayList<UnconnectedItems> unconnectedItems = new ArrayList<UnconnectedItems>();
        RatsNest ratsnest = new RatsNest(this.board);
        for (RatsNest.AirLine airline : ratsnest.get_airlines()) {
            unconnectedItems.add(new UnconnectedItems(airline.from_item, airline.to_item));
        }
        return unconnectedItems;
    }

    public DrcReport generateReport(String sourceFile, String coordinateUnit) {
        DrcReport report = new DrcReport(coordinateUnit, sourceFile, "Freerouting 2.1.2-SNAPSHOT");
        Collection<ClearanceViolation> violations = this.getAllClearanceViolations();
        for (ClearanceViolation violation : violations) {
            DrcViolation drcViolation = this.convertToDrcViolation(violation, coordinateUnit);
            report.addViolation(drcViolation);
        }
        Collection<UnconnectedItems> unconnectedItems = this.getAllUnconnectedItems();
        for (UnconnectedItems unconnectedItem : unconnectedItems) {
            DrcViolation drcViolation = this.convertToDrcViolation(unconnectedItem, coordinateUnit);
            report.addUnconnectedItem(drcViolation);
        }
        return report;
    }

    private DrcViolation convertToDrcViolation(ClearanceViolation violation, String coordinateUnit) {
        ArrayList<DrcViolationItem> items = new ArrayList<DrcViolationItem>();
        double unitScale = this.getUnitScale(coordinateUnit);
        String firstItemDesc = this.getItemDescription(violation.first_item);
        String secondItemDesc = this.getItemDescription(violation.second_item);
        FloatPoint firstItemCenterOfGravity = violation.first_item.bounding_box().centre_of_gravity();
        DrcPosition firstItemPos = new DrcPosition(firstItemCenterOfGravity.x * unitScale, firstItemCenterOfGravity.y * unitScale);
        FloatPoint secondItemCenterOfGravity = violation.second_item.bounding_box().centre_of_gravity();
        DrcPosition secondItemPos = new DrcPosition(secondItemCenterOfGravity.x * unitScale, secondItemCenterOfGravity.y * unitScale);
        String firstUuid = String.valueOf(violation.first_item.get_id_no());
        String secondUuid = String.valueOf(violation.second_item.get_id_no());
        items.add(new DrcViolationItem(firstItemDesc, firstItemPos, firstUuid));
        items.add(new DrcViolationItem(secondItemDesc, secondItemPos, secondUuid));
        String description = "Clearance violation between %s and %s (expected: %.4f %s, actual: %.4f %s)".formatted(firstItemDesc, secondItemDesc, violation.expected_clearance * unitScale, coordinateUnit, violation.actual_clearance * unitScale, coordinateUnit);
        return new DrcViolation("clearance", description, "error", items);
    }

    private DrcViolation convertToDrcViolation(UnconnectedItems unconnectedItems, String coordinateUnit) {
        ArrayList<DrcViolationItem> items = new ArrayList<DrcViolationItem>();
        double unitScale = this.getUnitScale(coordinateUnit);
        String fromItemDesc = this.getItemDescription(unconnectedItems.first_item);
        String toItemDesc = this.getItemDescription(unconnectedItems.second_item);
        FloatPoint fromItemCenterOfGravity = unconnectedItems.first_item.bounding_box().centre_of_gravity();
        DrcPosition fromItemPos = new DrcPosition(fromItemCenterOfGravity.x * unitScale, fromItemCenterOfGravity.y * unitScale);
        FloatPoint toItemCenterOfGravity = unconnectedItems.second_item.bounding_box().centre_of_gravity();
        DrcPosition toItemPos = new DrcPosition(toItemCenterOfGravity.x * unitScale, toItemCenterOfGravity.y * unitScale);
        String fromUuid = String.valueOf(unconnectedItems.first_item.get_id_no());
        String toUuid = String.valueOf(unconnectedItems.second_item.get_id_no());
        items.add(new DrcViolationItem(fromItemDesc, fromItemPos, fromUuid));
        items.add(new DrcViolationItem(toItemDesc, toItemPos, toUuid));
        String description = "Unconnected items: %s and %s".formatted(fromItemDesc, toItemDesc);
        return new DrcViolation("unconnected", description, "warning", items);
    }

    private String getItemDescription(Item item) {
        StringBuilder desc = new StringBuilder();
        if (item instanceof Trace) {
            desc.append("Trace");
        } else if (item instanceof Via) {
            desc.append("Via");
        } else if (item instanceof Pin) {
            desc.append("Pin");
        } else if (item instanceof ConductionArea) {
            desc.append("Conduction Area");
        } else {
            desc.append(item.getClass().getSimpleName());
        }
        if (item.net_count() > 0) {
            String netName = this.board.rules.nets.get((int)item.get_net_no((int)0)).name;
            desc.append(" [").append(netName).append("]");
        }
        return desc.toString();
    }

    private double getUnitScale(String coordinateUnit) {
        Unit boardUnit = this.board.communication.unit;
        Unit targetUnit = "mm".equals(coordinateUnit) ? Unit.MM : ("mil".equals(coordinateUnit) ? Unit.MIL : ("inch".equals(coordinateUnit) ? Unit.INCH : ("um".equals(coordinateUnit) ? Unit.UM : boardUnit)));
        return Unit.scale(1.0, boardUnit, targetUnit);
    }

    public String generateReportJson(String sourceFile, String coordinateUnit) {
        DrcReport report = this.generateReport(sourceFile, coordinateUnit);
        return GsonProvider.GSON.toJson(report);
    }
}

