/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.drc;

import app.freerouting.board.Item;
import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.geometry.planar.ConvexShape;
import app.freerouting.management.TextManager;
import java.util.Locale;

public class ClearanceViolation
implements ObjectInfoPanel.Printable {
    public final Item first_item;
    public final Item second_item;
    public final ConvexShape shape;
    public final int layer;
    public final double expected_clearance;
    public final double actual_clearance;

    public ClearanceViolation(Item p_first_item, Item p_second_item, ConvexShape p_shape, int p_layer, double p_expected_clearance, double p_actual_clearance) {
        this.first_item = p_first_item;
        this.second_item = p_second_item;
        this.shape = p_shape;
        this.layer = p_layer;
        this.expected_clearance = p_expected_clearance;
        this.actual_clearance = p_actual_clearance;
    }

    @Override
    public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
        TextManager tm = new TextManager(this.getClass(), p_locale);
        p_window.append_bold(tm.getText("clearance_violation_2", new String[0]));
        p_window.append(" " + tm.getText("at", new String[0]) + " ");
        p_window.append(this.shape.centre_of_gravity());
        p_window.append(", " + tm.getText("width", new String[0]) + " ");
        p_window.append(2.0 * this.shape.smallest_radius());
        p_window.append(", " + tm.getText("layer", new String[0]) + " ");
        p_window.append(this.first_item.board.layer_structure.arr[this.layer].name);
        p_window.append(", " + tm.getText("between", new String[0]));
        p_window.newline();
        p_window.indent();
        this.first_item.print_info(p_window, p_locale);
        p_window.indent();
        this.second_item.print_info(p_window, p_locale);
        p_window.newline();
        p_window.indent();
        String clearance_violation_info_expected_clearance = tm.getText("clearance_violation_info_expected_clearance", new String[0]).formatted(this.expected_clearance / 10000.0, this.actual_clearance / 10000.0);
        p_window.append(clearance_violation_info_expected_clearance);
    }
}

