/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.designforms.specctra;

import app.freerouting.datastructures.IdentifierType;
import app.freerouting.datastructures.IndentFileWriter;
import app.freerouting.designforms.specctra.Circle;
import app.freerouting.designforms.specctra.CoordinateTransform;
import app.freerouting.designforms.specctra.DsnFile;
import app.freerouting.designforms.specctra.IJFlexScanner;
import app.freerouting.designforms.specctra.Keyword;
import app.freerouting.designforms.specctra.Layer;
import app.freerouting.designforms.specctra.LayerStructure;
import app.freerouting.designforms.specctra.Polygon;
import app.freerouting.designforms.specctra.PolygonPath;
import app.freerouting.designforms.specctra.PolylinePath;
import app.freerouting.designforms.specctra.Rectangle;
import app.freerouting.designforms.specctra.ScopeKeyword;
import app.freerouting.geometry.planar.Area;
import app.freerouting.geometry.planar.PolylineArea;
import app.freerouting.geometry.planar.PolylineShape;
import app.freerouting.logger.FRLogger;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class Shape {
    public final Layer layer;

    protected Shape(Layer p_layer) {
        this.layer = p_layer;
    }

    public static Shape read_scope(IJFlexScanner p_scanner, LayerStructure p_layer_structure) {
        Shape result = null;
        try {
            Object next_token = p_scanner.next_token();
            if (next_token == Keyword.OPEN_BRACKET) {
                next_token = p_scanner.next_token();
            }
            if (next_token == Keyword.RECTANGLE) {
                result = Shape.read_rectangle_scope(p_scanner, p_layer_structure);
            } else if (next_token == Keyword.POLYGON) {
                result = Shape.read_polygon_scope(p_scanner, p_layer_structure);
            } else if (next_token == Keyword.CIRCLE) {
                result = Shape.read_circle_scope(p_scanner, p_layer_structure);
            } else if (next_token == Keyword.POLYGON_PATH) {
                result = Shape.read_polygon_path_scope(p_scanner, p_layer_structure);
            } else {
                ScopeKeyword.skip_scope(p_scanner);
            }
        }
        catch (IOException e) {
            FRLogger.error("Shape.read_scope: IO error scanning file", e);
            return result;
        }
        return result;
    }

    private static Layer get_layer(LayerStructure p_layer_structure, String layer_name) {
        Layer layer;
        if (layer_name.equals(Keyword.PCB_SCOPE.get_name())) {
            layer = Layer.PCB;
        } else if (layer_name.equals(Keyword.SIGNAL.get_name())) {
            layer = Layer.SIGNAL;
        } else {
            if (p_layer_structure == null) {
                FRLogger.warn("Shape.read_circle_scope: p_layer_structure != null expected");
                return null;
            }
            int layer_no = p_layer_structure.get_no(layer_name);
            if (layer_no < 0 || layer_no >= p_layer_structure.arr.length) {
                FRLogger.warn("Shape.read_circle_scope: layer with name '" + layer_name + "' not found in layer structure.");
                return null;
            }
            layer = p_layer_structure.arr[layer_no];
        }
        return layer;
    }

    public static PolylinePath read_polyline_path_scope(IJFlexScanner p_scanner, LayerStructure p_layer_structure) {
        try {
            Object next_token;
            String layer_name = p_scanner.next_string();
            Layer layer = Shape.get_layer(p_layer_structure, layer_name);
            LinkedList<Object> corner_list = new LinkedList<Object>();
            while ((next_token = p_scanner.next_token()) != Keyword.CLOSED_BRACKET) {
                corner_list.add(next_token);
            }
            if (corner_list.size() < 5) {
                FRLogger.warn("PolylinePath.read_scope: to few numbers in scope at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            Iterator it = corner_list.iterator();
            double width = 0.0;
            Object next_object = it.next();
            if (next_object instanceof Double) {
                Double double1 = (Double)next_object;
                width = double1;
            } else if (next_object instanceof Integer) {
                Integer integer = (Integer)next_object;
                width = integer.intValue();
            } else {
                FRLogger.warn("PolylinePath.read_scope: number expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            double[] corner_arr = new double[corner_list.size() - 1];
            for (int i = 0; i < corner_arr.length; ++i) {
                next_object = it.next();
                if (next_object instanceof Double) {
                    Double double1 = (Double)next_object;
                    corner_arr[i] = double1;
                    continue;
                }
                if (next_object instanceof Integer) {
                    Integer integer = (Integer)next_object;
                    corner_arr[i] = integer.intValue();
                    continue;
                }
                FRLogger.warn("Shape.read_polygon_path_scope: number expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            return new PolylinePath(layer, width, corner_arr);
        }
        catch (IOException e) {
            FRLogger.error("PolylinePath.read_scope: IO error scanning file", e);
            return null;
        }
    }

    public static ReadAreaScopeResult read_area_scope(IJFlexScanner p_scanner, LayerStructure p_layer_structure, boolean p_skip_window_scopes) {
        Shape curr_shape;
        Object next_token;
        LinkedList<Shape> shape_list = new LinkedList<Shape>();
        String clearance_class_name = null;
        String area_name = null;
        boolean result_ok = true;
        try {
            next_token = p_scanner.next_token();
        }
        catch (IOException iOException) {
            FRLogger.warn("Shape.read_area_scope: IO error scanning file at '" + p_scanner.get_scope_identifier() + "'");
            return null;
        }
        if (next_token instanceof String) {
            String curr_name = (String)next_token;
            p_scanner.set_scope_identifier(curr_name);
            if (!curr_name.isEmpty()) {
                area_name = curr_name;
            }
        }
        if ((curr_shape = Shape.read_scope(p_scanner, p_layer_structure)) == null) {
            FRLogger.warn("Shape.read_area_scope: could not read shape at '" + p_scanner.get_scope_identifier() + "'");
            result_ok = false;
        }
        shape_list.add(curr_shape);
        next_token = null;
        while (true) {
            Object prev_token = next_token;
            try {
                next_token = p_scanner.next_token();
            }
            catch (IOException e) {
                FRLogger.error("Shape.read_area_scope: IO error scanning file", e);
                return null;
            }
            if (next_token == null) {
                FRLogger.warn("Shape.read_area_scope: unexpected end of file at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            if (next_token == Keyword.CLOSED_BRACKET) break;
            if (prev_token != Keyword.OPEN_BRACKET) continue;
            if (next_token == Keyword.WINDOW && !p_skip_window_scopes) {
                Shape hole_shape = Shape.read_scope(p_scanner, p_layer_structure);
                shape_list.add(hole_shape);
                try {
                    next_token = p_scanner.next_token();
                }
                catch (IOException e) {
                    FRLogger.error("Shape.read_area_scope: IO error scanning file", e);
                    return null;
                }
                if (next_token == Keyword.CLOSED_BRACKET) continue;
                FRLogger.warn("Shape.read_area_scope: closed bracket expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            if (next_token == Keyword.CLEARANCE_CLASS) {
                clearance_class_name = DsnFile.read_string_scope(p_scanner);
                continue;
            }
            ScopeKeyword.skip_scope(p_scanner);
        }
        if (!result_ok) {
            return null;
        }
        return new ReadAreaScopeResult(area_name, shape_list, clearance_class_name);
    }

    public static Rectangle read_rectangle_scope(IJFlexScanner p_scanner, LayerStructure p_layer_structure) {
        try {
            Object next_token;
            String layer_name = p_scanner.next_string();
            Layer rect_layer = Shape.get_layer(p_layer_structure, layer_name);
            if (rect_layer == null) {
                rect_layer = Shape.get_layer(p_layer_structure, Keyword.SIGNAL.get_name());
            }
            double[] rect_coor = new double[4];
            for (int i = 0; i < 4; ++i) {
                next_token = p_scanner.next_token();
                if (next_token instanceof Double) {
                    Double double1 = (Double)next_token;
                    rect_coor[i] = double1;
                    continue;
                }
                if (next_token instanceof Integer) {
                    Integer integer = (Integer)next_token;
                    rect_coor[i] = integer.intValue();
                    continue;
                }
                FRLogger.warn("Shape.read_rectangle_scope: number expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            next_token = p_scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                FRLogger.warn("Shape.read_rectangle_scope ) expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            if (rect_layer == null) {
                return null;
            }
            return new Rectangle(rect_layer, rect_coor);
        }
        catch (IOException e) {
            FRLogger.error("Shape.read_rectangle_scope: IO error scanning file", e);
            return null;
        }
    }

    public static Polygon read_polygon_scope(IJFlexScanner p_scanner, LayerStructure p_layer_structure) {
        try {
            Layer polygon_layer = null;
            boolean layer_ok = true;
            Object next_token = p_scanner.next_token();
            if (next_token == Keyword.PCB_SCOPE) {
                polygon_layer = Layer.PCB;
            } else if (next_token == Keyword.SIGNAL) {
                polygon_layer = Layer.SIGNAL;
            } else {
                if (p_layer_structure == null) {
                    FRLogger.warn("Shape.read_polygon_scope: only layer types pcb or signal expected at '" + p_scanner.get_scope_identifier() + "'");
                    return null;
                }
                if (!(next_token instanceof String)) {
                    FRLogger.warn("Shape.read_polygon_scope: layer name string expected at '" + p_scanner.get_scope_identifier() + "'");
                    return null;
                }
                int layer_no = p_layer_structure.get_no((String)next_token);
                if (layer_no < 0 || layer_no >= p_layer_structure.arr.length) {
                    FRLogger.warn("Shape.read_polygon_scope: layer name '" + String.valueOf(next_token) + "' not found in layer structure  at '" + p_scanner.get_scope_identifier() + "'");
                    layer_ok = false;
                } else {
                    polygon_layer = p_layer_structure.arr[layer_no];
                }
            }
            next_token = p_scanner.next_token();
            LinkedList<Object> coor_list = new LinkedList<Object>();
            while (true) {
                if ((next_token = p_scanner.next_token()) == null) {
                    FRLogger.warn("Shape.read_polygon_scope: unexpected end of file at '" + p_scanner.get_scope_identifier() + "'");
                    return null;
                }
                if (next_token == Keyword.OPEN_BRACKET) {
                    ScopeKeyword.skip_scope(p_scanner);
                    next_token = p_scanner.next_token();
                }
                if (next_token == Keyword.CLOSED_BRACKET) break;
                coor_list.add(next_token);
            }
            if (!layer_ok) {
                return null;
            }
            double[] coor_arr = new double[coor_list.size()];
            Iterator it = coor_list.iterator();
            for (int i = 0; i < coor_arr.length; ++i) {
                Object next_object = it.next();
                if (next_object instanceof Double) {
                    Double double1 = (Double)next_object;
                    coor_arr[i] = double1;
                    continue;
                }
                if (next_object instanceof Integer) {
                    Integer integer = (Integer)next_object;
                    coor_arr[i] = integer.intValue();
                    continue;
                }
                FRLogger.warn("Shape.read_polygon_scope: number expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            return new Polygon(polygon_layer, coor_arr);
        }
        catch (IOException e) {
            FRLogger.error("Rectangle.read_scope: IO error scanning file", e);
            return null;
        }
    }

    public static Circle read_circle_scope(IJFlexScanner p_scanner, LayerStructure p_layer_structure) {
        try {
            Object next_token;
            String layer_name = p_scanner.next_string();
            Layer circle_layer = Shape.get_layer(p_layer_structure, layer_name);
            if (circle_layer == null) {
                FRLogger.warn("Circle.read_circle_scope: layer with name '" + layer_name + "' not found in layer structure at '" + p_scanner.get_scope_identifier() + "'");
            }
            double[] circle_coor = new double[3];
            int curr_index = 0;
            while ((next_token = p_scanner.next_token()) != Keyword.CLOSED_BRACKET) {
                if (curr_index > 2) {
                    FRLogger.warn("Shape.read_circle_scope: closed bracket expected at '" + p_scanner.get_scope_identifier() + "'");
                    return null;
                }
                if (next_token instanceof Double) {
                    Double double1 = (Double)next_token;
                    circle_coor[curr_index] = double1;
                } else if (next_token instanceof Integer) {
                    Integer integer = (Integer)next_token;
                    circle_coor[curr_index] = integer.intValue();
                } else {
                    FRLogger.warn("Shape.read_circle_scope: number expected at '" + p_scanner.get_scope_identifier() + "'");
                    return null;
                }
                ++curr_index;
            }
            if (circle_layer == null) {
                return null;
            }
            return new Circle(circle_layer, circle_coor);
        }
        catch (IOException e) {
            FRLogger.error("Shape.read_rectangle_scope: IO error scanning file", e);
            return null;
        }
    }

    public static PolygonPath read_polygon_path_scope(IJFlexScanner p_scanner, LayerStructure p_layer_structure) {
        try {
            String layer_name = p_scanner.next_string();
            Layer layer = Shape.get_layer(p_layer_structure, layer_name);
            LinkedList<Object> corner_list = new LinkedList<Object>();
            while (true) {
                Object next_token;
                if ((next_token = p_scanner.next_token()) == Keyword.OPEN_BRACKET) {
                    ScopeKeyword.skip_scope(p_scanner);
                    next_token = p_scanner.next_token();
                }
                if (next_token == Keyword.CLOSED_BRACKET) break;
                corner_list.add(next_token);
            }
            if (corner_list.size() < 5) {
                FRLogger.warn("Shape.read_polygon_path_scope: to few numbers in scope at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            if (layer == null) {
                return null;
            }
            Iterator it = corner_list.iterator();
            double width = 0.0;
            Object next_object = it.next();
            if (next_object instanceof Double) {
                Double double1 = (Double)next_object;
                width = double1;
            } else if (next_object instanceof Integer) {
                Integer integer = (Integer)next_object;
                width = integer.intValue();
            } else {
                FRLogger.warn("Shape.read_polygon_path_scope: number expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            double[] coordinate_arr = new double[corner_list.size() - 1];
            for (int i = 0; i < coordinate_arr.length; ++i) {
                next_object = it.next();
                if (next_object instanceof Double) {
                    Double double1 = (Double)next_object;
                    coordinate_arr[i] = double1;
                    continue;
                }
                if (next_object instanceof Integer) {
                    Integer integer = (Integer)next_object;
                    coordinate_arr[i] = integer.intValue();
                    continue;
                }
                FRLogger.warn("Shape.read_polygon_path_scope: number expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            return new PolygonPath(layer, width, coordinate_arr);
        }
        catch (IOException e) {
            FRLogger.error("Shape.read_polygon_path_scope: IO error scanning file", e);
            return null;
        }
    }

    public static Area transform_area_to_board(Collection<Shape> p_area, CoordinateTransform p_coordinate_transform) {
        Area result;
        int hole_count = p_area.size() - 1;
        if (hole_count <= -1) {
            FRLogger.warn("Shape.transform_area_to_board: p_area.size() > 0 expected");
            return null;
        }
        Iterator<Shape> it = p_area.iterator();
        Shape boundary = it.next();
        app.freerouting.geometry.planar.Shape boundary_shape = boundary.transform_to_board(p_coordinate_transform);
        if (hole_count == 0) {
            result = boundary_shape;
        } else {
            if (!(boundary_shape instanceof PolylineShape)) {
                FRLogger.warn("Shape.transform_area_to_board: PolylineShape expected");
                return null;
            }
            PolylineShape border = (PolylineShape)boundary_shape;
            PolylineShape[] holes = new PolylineShape[hole_count];
            for (int i = 0; i < holes.length; ++i) {
                app.freerouting.geometry.planar.Shape hole_shape = it.next().transform_to_board(p_coordinate_transform);
                if (!(hole_shape instanceof PolylineShape)) {
                    FRLogger.warn("Shape.transform_area_to_board: PolylineShape expected");
                    return null;
                }
                holes[i] = (PolylineShape)hole_shape;
            }
            result = new PolylineArea(border, holes);
        }
        return result;
    }

    public static Area transform_area_to_board_rel(Collection<Shape> p_area, CoordinateTransform p_coordinate_transform) {
        Area result;
        int hole_count = p_area.size() - 1;
        if (hole_count <= -1) {
            FRLogger.warn("Shape.transform_area_to_board_rel: p_area.size() > 0 expected");
            return null;
        }
        Iterator<Shape> it = p_area.iterator();
        Shape boundary = it.next();
        app.freerouting.geometry.planar.Shape boundary_shape = boundary.transform_to_board_rel(p_coordinate_transform);
        if (hole_count == 0) {
            result = boundary_shape;
        } else {
            if (!(boundary_shape instanceof PolylineShape)) {
                FRLogger.warn("Shape.transform_area_to_board_rel: PolylineShape expected");
                return null;
            }
            PolylineShape border = (PolylineShape)boundary_shape;
            PolylineShape[] holes = new PolylineShape[hole_count];
            for (int i = 0; i < holes.length; ++i) {
                app.freerouting.geometry.planar.Shape hole_shape = it.next().transform_to_board_rel(p_coordinate_transform);
                if (!(hole_shape instanceof PolylineShape)) {
                    FRLogger.warn("Shape.transform_area_to_board: PolylineShape expected");
                    return null;
                }
                holes[i] = (PolylineShape)hole_shape;
            }
            result = new PolylineArea(border, holes);
        }
        return result;
    }

    public abstract void write_scope(IndentFileWriter var1, IdentifierType var2) throws IOException;

    public abstract void write_scope_int(IndentFileWriter var1, IdentifierType var2) throws IOException;

    public void write_hole_scope(IndentFileWriter p_file, IdentifierType p_identifier_type) throws IOException {
        p_file.start_scope();
        p_file.write("window");
        this.write_scope(p_file, p_identifier_type);
        p_file.end_scope();
    }

    public abstract app.freerouting.geometry.planar.Shape transform_to_board(CoordinateTransform var1);

    public abstract Rectangle bounding_box();

    public abstract app.freerouting.geometry.planar.Shape transform_to_board_rel(CoordinateTransform var1);

    static class ReadAreaScopeResult {
        final Collection<Shape> shape_list;
        final String clearance_class_name;
        String area_name;

        private ReadAreaScopeResult(String p_area_name, Collection<Shape> p_shape_list, String p_clearance_class_name) {
            this.area_name = p_area_name;
            this.shape_list = p_shape_list;
            this.clearance_class_name = p_clearance_class_name;
        }
    }
}

