/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.designforms.specctra;

import app.freerouting.datastructures.IdentifierType;
import app.freerouting.datastructures.IndentFileWriter;
import app.freerouting.designforms.specctra.CoordinateTransform;
import app.freerouting.designforms.specctra.Layer;
import app.freerouting.designforms.specctra.Path;
import app.freerouting.designforms.specctra.Rectangle;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.PolygonShape;
import app.freerouting.geometry.planar.Shape;
import java.io.IOException;

public class PolygonPath
extends Path {
    public PolygonPath(Layer p_layer, double p_width, double[] p_coordinate_arr) {
        super(p_layer, p_width, p_coordinate_arr);
    }

    @Override
    public void write_scope(IndentFileWriter p_file, IdentifierType p_identifier_type) throws IOException {
        p_file.start_scope();
        p_file.write("path ");
        p_identifier_type.write(this.layer.name, p_file);
        p_file.write(" ");
        p_file.write(String.valueOf(this.width));
        int corner_count = this.coordinate_arr.length / 2;
        for (int i = 0; i < corner_count; ++i) {
            p_file.new_line();
            p_file.write(String.valueOf(this.coordinate_arr[2 * i]));
            p_file.write(" ");
            p_file.write(String.valueOf(this.coordinate_arr[2 * i + 1]));
        }
        p_file.end_scope();
    }

    @Override
    public void write_scope_int(IndentFileWriter p_file, IdentifierType p_identifier_type) throws IOException {
        p_file.start_scope();
        p_file.write("path ");
        p_identifier_type.write(this.layer.name, p_file);
        p_file.write(" ");
        p_file.write(String.valueOf(this.width));
        int corner_count = this.coordinate_arr.length / 2;
        for (int i = 0; i < corner_count; ++i) {
            p_file.new_line();
            int curr_coor = (int)Math.round(this.coordinate_arr[2 * i]);
            p_file.write(String.valueOf(curr_coor));
            p_file.write(" ");
            curr_coor = (int)Math.round(this.coordinate_arr[2 * i + 1]);
            p_file.write(String.valueOf(curr_coor));
        }
        p_file.end_scope();
    }

    @Override
    public Shape transform_to_board(CoordinateTransform p_coordinate_transform) {
        FloatPoint[] corner_arr = new FloatPoint[this.coordinate_arr.length / 2];
        double[] curr_point = new double[2];
        for (int i = 0; i < corner_arr.length; ++i) {
            curr_point[0] = this.coordinate_arr[2 * i];
            curr_point[1] = this.coordinate_arr[2 * i + 1];
            corner_arr[i] = p_coordinate_transform.dsn_to_board(curr_point);
        }
        double offset = p_coordinate_transform.dsn_to_board(this.width) / 2.0;
        if (corner_arr.length <= 2) {
            IntOctagon bounding_oct = FloatPoint.bounding_octagon(corner_arr);
            return bounding_oct.enlarge(offset);
        }
        Point[] rounded_corner_arr = new IntPoint[corner_arr.length];
        for (int i = 0; i < corner_arr.length; ++i) {
            rounded_corner_arr[i] = corner_arr[i].round();
        }
        Shape result = new PolygonShape(rounded_corner_arr);
        if (offset > 0.0) {
            result = result.bounding_tile().enlarge(offset);
        }
        return result;
    }

    @Override
    public Shape transform_to_board_rel(CoordinateTransform p_coordinate_transform) {
        FloatPoint[] corner_arr = new FloatPoint[this.coordinate_arr.length / 2];
        double[] curr_point = new double[2];
        for (int i = 0; i < corner_arr.length; ++i) {
            curr_point[0] = this.coordinate_arr[2 * i];
            curr_point[1] = this.coordinate_arr[2 * i + 1];
            corner_arr[i] = p_coordinate_transform.dsn_to_board_rel(curr_point);
        }
        double offset = p_coordinate_transform.dsn_to_board(this.width) / 2.0;
        if (corner_arr.length <= 2) {
            IntOctagon bounding_oct = FloatPoint.bounding_octagon(corner_arr);
            return bounding_oct.enlarge(offset);
        }
        Point[] rounded_corner_arr = new IntPoint[corner_arr.length];
        for (int i = 0; i < corner_arr.length; ++i) {
            rounded_corner_arr[i] = corner_arr[i].round();
        }
        Shape result = new PolygonShape(rounded_corner_arr);
        if (offset > 0.0) {
            result = result.bounding_tile().enlarge(offset);
        }
        return result;
    }

    @Override
    public Rectangle bounding_box() {
        double offset = this.width / 2.0;
        double[] bounds = new double[]{2.147483647E9, 2.147483647E9, -2.147483648E9, -2.147483648E9};
        for (int i = 0; i < this.coordinate_arr.length; ++i) {
            if (i % 2 == 0) {
                bounds[0] = Math.min(bounds[0], this.coordinate_arr[i] - offset);
                bounds[2] = Math.max(bounds[2], this.coordinate_arr[i]) + offset;
                continue;
            }
            bounds[1] = Math.min(bounds[1], this.coordinate_arr[i] - offset);
            bounds[3] = Math.max(bounds[3], this.coordinate_arr[i] + offset);
        }
        return new Rectangle(this.layer, bounds);
    }
}

