/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.designforms.specctra;

import app.freerouting.board.Component;
import app.freerouting.core.LogicalPart;
import app.freerouting.core.LogicalParts;
import app.freerouting.designforms.specctra.IJFlexScanner;
import app.freerouting.designforms.specctra.ReadScopeParameter;
import app.freerouting.designforms.specctra.ScopeKeyword;
import app.freerouting.designforms.specctra.WriteScopeParameter;
import app.freerouting.logger.FRLogger;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;

public class PartLibrary
extends ScopeKeyword {
    public PartLibrary() {
        super("part_library");
    }

    public static void write_scope(WriteScopeParameter p_par) throws IOException {
        int j;
        app.freerouting.core.LogicalPart curr_part;
        int i;
        LogicalParts logical_parts = p_par.board.library.logical_parts;
        if (logical_parts.count() <= 0) {
            return;
        }
        p_par.file.start_scope();
        p_par.file.write("part_library");
        for (i = 1; i <= logical_parts.count(); ++i) {
            curr_part = logical_parts.get(i);
            p_par.file.start_scope();
            p_par.file.write("logical_part_mapping ");
            p_par.identifier_type.write(curr_part.name, p_par.file);
            p_par.file.new_line();
            p_par.file.write("(comp");
            for (j = 1; j <= p_par.board.components.count(); ++j) {
                Component curr_component = p_par.board.components.get(j);
                if (curr_component.get_logical_part() != curr_part) continue;
                p_par.file.write(" ");
                p_par.file.write(curr_component.name);
            }
            p_par.file.write(")");
            p_par.file.end_scope();
        }
        for (i = 1; i <= logical_parts.count(); ++i) {
            curr_part = logical_parts.get(i);
            p_par.file.start_scope();
            p_par.file.write("logical_part ");
            p_par.identifier_type.write(curr_part.name, p_par.file);
            p_par.file.new_line();
            for (j = 0; j < curr_part.pin_count(); ++j) {
                p_par.file.new_line();
                LogicalPart.PartPin curr_pin = curr_part.get_pin(j);
                p_par.file.write("(pin ");
                p_par.identifier_type.write(curr_pin.pin_name, p_par.file);
                p_par.file.write(" 0 ");
                p_par.identifier_type.write(curr_pin.gate_name, p_par.file);
                p_par.file.write(" ");
                int gate_swap_code = curr_pin.gate_swap_code;
                p_par.file.write(String.valueOf(gate_swap_code));
                p_par.file.write(" ");
                p_par.identifier_type.write(curr_pin.gate_pin_name, p_par.file);
                p_par.file.write(" ");
                int gate_pin_swap_code = curr_pin.gate_pin_swap_code;
                p_par.file.write(String.valueOf(gate_pin_swap_code));
                p_par.file.write(")");
            }
            p_par.file.end_scope();
        }
        p_par.file.end_scope();
    }

    @Override
    public boolean read_scope(ReadScopeParameter p_par) {
        Object next_token = null;
        while (true) {
            Object prev_token = next_token;
            try {
                next_token = p_par.scanner.next_token();
            }
            catch (IOException e) {
                FRLogger.error("PartLibrary.read_scope: IO error scanning file", e);
                return false;
            }
            if (next_token == null) {
                FRLogger.warn("PartLibrary.read_scope: unexpected end of file at '" + p_par.scanner.get_scope_identifier() + "'");
                return false;
            }
            if (next_token == CLOSED_BRACKET) break;
            if (prev_token != OPEN_BRACKET) continue;
            if (next_token == LOGICAL_PART_MAPPING) {
                LogicalPartMapping next_mapping = this.read_logical_part_mapping(p_par.scanner);
                if (next_mapping == null) {
                    return false;
                }
                p_par.logical_part_mappings.add(next_mapping);
                continue;
            }
            if (next_token == LOGICAL_PART) {
                LogicalPart next_part = this.read_logical_part(p_par.scanner);
                if (next_part == null) {
                    return false;
                }
                p_par.logical_parts.add(next_part);
                continue;
            }
            PartLibrary.skip_scope(p_par.scanner);
        }
        return true;
    }

    private LogicalPartMapping read_logical_part_mapping(IJFlexScanner p_scanner) {
        try {
            Object next_token = p_scanner.next_token();
            if (!(next_token instanceof String)) {
                FRLogger.warn("PartLibrary.read_logical_part_mapping: string expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            String name = (String)next_token;
            next_token = p_scanner.next_token();
            if (next_token != OPEN_BRACKET) {
                FRLogger.warn("PartLibrary.read_logical_part_mapping: open bracket expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            next_token = p_scanner.next_token();
            if (next_token != COMPONENT_SCOPE) {
                FRLogger.warn("PartLibrary.read_logical_part_mapping: Keyword.COMPONENT_SCOPE expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            TreeSet<String> result = new TreeSet<String>();
            while (true) {
                p_scanner.yybegin(3);
                next_token = p_scanner.next_token();
                if (next_token == CLOSED_BRACKET) break;
                if (!(next_token instanceof String)) {
                    FRLogger.warn("PartLibrary.read_logical_part_mapping: string expected at '" + p_scanner.get_scope_identifier() + "'");
                    return null;
                }
                result.add((String)next_token);
            }
            next_token = p_scanner.next_token();
            if (next_token != CLOSED_BRACKET) {
                FRLogger.warn("PartLibrary.read_logical_part_mapping: closing bracket expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            return new LogicalPartMapping(name, result);
        }
        catch (IOException e) {
            FRLogger.error("PartLibrary.read_logical_part_mapping: IO error scanning file", e);
            return null;
        }
    }

    private LogicalPart read_logical_part(IJFlexScanner p_scanner) {
        String part_name;
        LinkedList<PartPin> part_pins;
        block9: {
            boolean read_ok;
            Object next_token;
            part_pins = new LinkedList<PartPin>();
            try {
                next_token = p_scanner.next_token();
            }
            catch (IOException e) {
                FRLogger.error("PartLibrary.read_logical_part: IO error scanning file", e);
                return null;
            }
            if (!(next_token instanceof String)) {
                FRLogger.warn("PartLibrary.read_logical_part: string expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            part_name = (String)next_token;
            p_scanner.set_scope_identifier(part_name);
            do {
                Object prev_token = next_token;
                try {
                    next_token = p_scanner.next_token();
                }
                catch (IOException e) {
                    FRLogger.error("PartLibrary.read_logical_part: IO error scanning file", e);
                    return null;
                }
                if (next_token == null) {
                    FRLogger.warn("PartLibrary.read_logical_part: unexpected end of file at '" + p_scanner.get_scope_identifier() + "'");
                    return null;
                }
                if (next_token == CLOSED_BRACKET) break block9;
                read_ok = true;
                if (prev_token != OPEN_BRACKET) continue;
                if (next_token == PIN) {
                    PartPin curr_part_pin = this.read_part_pin(p_scanner);
                    if (curr_part_pin == null) {
                        return null;
                    }
                    part_pins.add(curr_part_pin);
                    continue;
                }
                PartLibrary.skip_scope(p_scanner);
            } while (read_ok);
            return null;
        }
        return new LogicalPart(part_name, part_pins);
    }

    private PartPin read_part_pin(IJFlexScanner p_scanner) {
        try {
            p_scanner.yybegin(3);
            Object next_token = p_scanner.next_token();
            if (!(next_token instanceof String)) {
                FRLogger.warn("PartLibrary.read_part_pin: string expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            String pin_name = (String)next_token;
            p_scanner.set_scope_identifier(pin_name);
            next_token = p_scanner.next_token();
            if (!(next_token instanceof Integer)) {
                FRLogger.warn("PartLibrary.read_part_pin: integer expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            p_scanner.yybegin(3);
            next_token = p_scanner.next_token();
            if (!(next_token instanceof String)) {
                FRLogger.warn("PartLibrary.read_part_pin: string expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            String gate_name = (String)next_token;
            p_scanner.set_scope_identifier(gate_name);
            next_token = p_scanner.next_token();
            if (!(next_token instanceof Integer)) {
                FRLogger.warn("PartLibrary.read_part_pin: integer expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            int gate_swap_code = (Integer)next_token;
            p_scanner.yybegin(3);
            next_token = p_scanner.next_token();
            if (!(next_token instanceof String)) {
                FRLogger.warn("PartLibrary.read_part_pin: string expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            String gate_pin_name = (String)next_token;
            p_scanner.set_scope_identifier(gate_pin_name);
            next_token = p_scanner.next_token();
            if (!(next_token instanceof Integer)) {
                FRLogger.warn("PartLibrary.read_part_pin: integer expected at '" + p_scanner.get_scope_identifier() + "'");
                return null;
            }
            int gate_pin_swap_code = (Integer)next_token;
            while ((next_token = p_scanner.next_token()) != CLOSED_BRACKET) {
            }
            return new PartPin(pin_name, gate_name, gate_swap_code, gate_pin_name, gate_pin_swap_code);
        }
        catch (IOException e) {
            FRLogger.error("PartLibrary.read_part_pin: IO error scanning file", e);
            return null;
        }
    }

    public static class LogicalPartMapping {
        public final String name;
        public final SortedSet<String> components;

        private LogicalPartMapping(String p_name, SortedSet<String> p_components) {
            this.name = p_name;
            this.components = p_components;
        }
    }

    public static class LogicalPart {
        public final String name;
        public final Collection<PartPin> part_pins;

        private LogicalPart(String p_name, Collection<PartPin> p_part_pins) {
            this.name = p_name;
            this.part_pins = p_part_pins;
        }
    }

    public static class PartPin {
        public final String pin_name;
        public final String gate_name;
        public final int gate_swap_code;
        public final String gate_pin_name;
        public final int gate_pin_swap_code;

        private PartPin(String p_pin_name, String p_gate_name, int p_gate_swap_code, String p_gate_pin_name, int p_gate_pin_swap_code) {
            this.pin_name = p_pin_name;
            this.gate_name = p_gate_name;
            this.gate_swap_code = p_gate_swap_code;
            this.gate_pin_name = p_gate_pin_name;
            this.gate_pin_swap_code = p_gate_pin_swap_code;
        }
    }
}

