/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.designforms.specctra;

import app.freerouting.designforms.specctra.Rule;
import app.freerouting.designforms.specctra.WriteScopeParameter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public class Layer {
    public static final Layer PCB = new Layer("pcb", -1, false);
    public static final Layer SIGNAL = new Layer("signal", -1, true);
    public final String name;
    public final int no;
    public final boolean is_signal;
    public final Collection<String> net_names;

    public Layer(String p_name, int p_no, boolean p_is_signal, Collection<String> p_net_names) {
        this.name = p_name;
        this.no = p_no;
        this.is_signal = p_is_signal;
        this.net_names = p_net_names;
    }

    public Layer(String p_name, int p_no, boolean p_is_signal) {
        this.name = p_name;
        this.no = p_no;
        this.is_signal = p_is_signal;
        this.net_names = new LinkedList<String>();
    }

    public static void write_scope(WriteScopeParameter p_par, int p_layer_no, boolean p_write_rule) throws IOException {
        p_par.file.start_scope();
        p_par.file.write("layer ");
        app.freerouting.board.Layer board_layer = p_par.board.layer_structure.arr[p_layer_no];
        p_par.identifier_type.write(board_layer.name, p_par.file);
        p_par.file.new_line();
        p_par.file.write("(type ");
        if (board_layer.is_signal) {
            p_par.file.write("signal)");
        } else {
            p_par.file.write("power)");
        }
        if (p_write_rule) {
            Rule.write_default_rule(p_par, p_layer_no);
        }
        p_par.file.end_scope();
    }
}

