/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.datastructures;

import app.freerouting.logger.FRLogger;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public class IdentifierType {
    private final String string_quote;
    private final String[] reserved_chars;

    public IdentifierType(String[] p_reserved_chars, String p_string_quote) {
        this.reserved_chars = p_reserved_chars;
        this.string_quote = p_string_quote;
    }

    public void write(String p_name, OutputStreamWriter p_file) {
        while (p_name.length() > 2 && p_name.charAt(0) == '\"' && p_name.charAt(p_name.length() - 1) == '\"') {
            p_name = p_name.substring(1, p_name.length() - 2);
        }
        try {
            if (p_name.contains(this.string_quote)) {
                p_name = p_name.replace(this.string_quote, "");
            }
            boolean need_quotes = false;
            for (String reserved_char : this.reserved_chars) {
                if (!p_name.contains(reserved_char)) continue;
                need_quotes = true;
                break;
            }
            for (byte ch : p_name.getBytes(StandardCharsets.UTF_8)) {
                if (ch > 0) continue;
                need_quotes = true;
                break;
            }
            if (!need_quotes && p_name.matches("^-?\\d.*")) {
                need_quotes = true;
            }
            if (need_quotes) {
                p_name = this.quote(p_name);
            }
            p_file.write(p_name);
        }
        catch (IOException iOException) {
            FRLogger.warn("IdentifierType.write: unable to write to file");
        }
    }

    private boolean is_legal(String p_string) {
        if (p_string == null) {
            FRLogger.warn("IdentifierType.is_legal: p_string is null");
            return false;
        }
        for (int i = 0; i < this.reserved_chars.length; ++i) {
            if (!p_string.contains(this.reserved_chars[i])) continue;
            return false;
        }
        return true;
    }

    private String quote(String p_string) {
        return this.string_quote + p_string + this.string_quote;
    }
}

