/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.core;

import app.freerouting.core.RoutingJob;
import app.freerouting.management.RoutingJobScheduler;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.UUID;

public class Session
implements Serializable {
    @SerializedName(value="id")
    public final UUID id = UUID.randomUUID();
    @SerializedName(value="user_id")
    public final UUID userId;
    @SerializedName(value="host")
    public final String host;
    public transient boolean isGuiSession;

    public Session(UUID userId, String host) {
        this.userId = userId;
        this.host = host;
        if (host.split("/").length != 2) {
            throw new IllegalArgumentException("Invalid host value: '" + host + "'. It must contain the host name and version separated by '/'.");
        }
    }

    public void addJob(RoutingJob routingJob) {
        RoutingJobScheduler.getInstance().enqueueJob(routingJob);
    }
}

