/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.boardgraphics;

import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class CoordinateTransform
implements Serializable {
    final IntBox design_box;
    final IntBox design_box_with_offset;
    final Dimension screen_bounds;
    private final double scale_factor;
    private final double display_x_offset;
    private final double display_y_offset;
    private final FloatPoint rotation_pole;
    private boolean mirror_left_right;
    private boolean mirror_top_bottom = true;
    private double rotation = 0.0;

    public CoordinateTransform(IntBox p_design_box, Dimension p_panel_bounds) {
        this.screen_bounds = p_panel_bounds;
        this.design_box = p_design_box;
        this.rotation_pole = p_design_box.centre_of_gravity();
        int min_ll = Math.min(p_design_box.ll.x, p_design_box.ll.y);
        int max_ur = Math.max(p_design_box.ur.x, p_design_box.ur.y);
        if ((double)Math.max(Math.abs(min_ll), Math.abs(max_ur)) <= 1.00663296E7) {
            double design_offset = Math.max(p_design_box.width(), p_design_box.height());
            this.design_box_with_offset = p_design_box.offset(design_offset);
        } else {
            this.design_box_with_offset = p_design_box;
        }
        double x_scale_factor = this.screen_bounds.getWidth() / (double)this.design_box_with_offset.width();
        double y_scale_factor = this.screen_bounds.getHeight() / (double)this.design_box_with_offset.height();
        this.scale_factor = Math.min(x_scale_factor, y_scale_factor);
        this.display_x_offset = this.scale_factor * (double)this.design_box_with_offset.ll.x;
        this.display_y_offset = this.scale_factor * (double)this.design_box_with_offset.ll.y;
    }

    public CoordinateTransform(CoordinateTransform p_coordinate_transform) {
        this.screen_bounds = new Dimension(p_coordinate_transform.screen_bounds);
        this.design_box = new IntBox(p_coordinate_transform.design_box.ll, p_coordinate_transform.design_box.ur);
        this.rotation_pole = new FloatPoint(p_coordinate_transform.rotation_pole.x, p_coordinate_transform.rotation_pole.y);
        this.design_box_with_offset = new IntBox(p_coordinate_transform.design_box_with_offset.ll, p_coordinate_transform.design_box_with_offset.ur);
        this.scale_factor = p_coordinate_transform.scale_factor;
        this.display_x_offset = p_coordinate_transform.display_x_offset;
        this.display_y_offset = p_coordinate_transform.display_y_offset;
        this.mirror_left_right = p_coordinate_transform.mirror_left_right;
        this.mirror_top_bottom = p_coordinate_transform.mirror_top_bottom;
        this.rotation = p_coordinate_transform.rotation;
    }

    public double board_to_screen(double p_val) {
        return p_val * this.scale_factor;
    }

    public double screen_to_board(double p_val) {
        return p_val / this.scale_factor;
    }

    public Point2D board_to_screen(FloatPoint p_point) {
        if (p_point == null) {
            return null;
        }
        FloatPoint rotated_point = p_point.rotate(this.rotation, this.rotation_pole);
        double x = this.mirror_left_right ? ((double)this.design_box_with_offset.width() - rotated_point.x - 1.0) * this.scale_factor + this.display_x_offset : rotated_point.x * this.scale_factor - this.display_x_offset;
        double y = this.mirror_top_bottom ? ((double)this.design_box_with_offset.height() - rotated_point.y - 1.0) * this.scale_factor + this.display_y_offset : rotated_point.y * this.scale_factor - this.display_y_offset;
        return new Point2D.Double(x, y);
    }

    public FloatPoint screen_to_board(Point2D p_point) {
        double x = this.mirror_left_right ? (double)this.design_box_with_offset.width() - (p_point.getX() - this.display_x_offset) / this.scale_factor - 1.0 : (p_point.getX() + this.display_x_offset) / this.scale_factor;
        double y = this.mirror_top_bottom ? (double)this.design_box_with_offset.height() - (p_point.getY() - this.display_y_offset) / this.scale_factor - 1.0 : (p_point.getY() + this.display_y_offset) / this.scale_factor;
        FloatPoint result = new FloatPoint(x, y);
        return result.rotate(-this.rotation, this.rotation_pole);
    }

    public double board_to_screen_angle(double p_angle) {
        double result = p_angle + this.rotation;
        if (this.mirror_left_right) {
            result = Math.PI - result;
        }
        if (this.mirror_top_bottom) {
            result = -result;
        }
        while (result >= Math.PI * 2) {
            result -= Math.PI * 2;
        }
        while (result < 0.0) {
            result += Math.PI * 2;
        }
        return result;
    }

    public Rectangle board_to_screen(IntBox p_box) {
        Point2D corner_1 = this.board_to_screen(p_box.ll.to_float());
        Point2D corner_2 = this.board_to_screen(p_box.ur.to_float());
        double ll_x = Math.min(corner_1.getX(), corner_2.getX());
        double ll_y = Math.min(corner_1.getY(), corner_2.getY());
        double dx = Math.abs(corner_2.getX() - corner_1.getX());
        double dy = Math.abs(corner_2.getY() - corner_1.getY());
        return new Rectangle((int)Math.floor(ll_x), (int)Math.floor(ll_y), (int)Math.ceil(dx), (int)Math.ceil(dy));
    }

    public IntBox screen_to_board(Rectangle p_rect) {
        FloatPoint corner_1 = this.screen_to_board(new Point2D.Double(p_rect.getX(), p_rect.getY()));
        FloatPoint corner_2 = this.screen_to_board(new Point2D.Double(p_rect.getX() + p_rect.getWidth(), p_rect.getY() + p_rect.getHeight()));
        int llx = (int)Math.floor(Math.min(corner_1.x, corner_2.x));
        int lly = (int)Math.floor(Math.min(corner_1.y, corner_2.y));
        int urx = (int)Math.ceil(Math.max(corner_1.x, corner_2.x));
        int ury = (int)Math.ceil(Math.max(corner_1.y, corner_2.y));
        return new IntBox(llx, lly, urx, ury);
    }

    public boolean is_mirror_left_right() {
        return this.mirror_left_right;
    }

    public void set_mirror_left_right(boolean p_value) {
        this.mirror_left_right = p_value;
    }

    public boolean is_mirror_top_bottom() {
        return !this.mirror_top_bottom;
    }

    public void set_mirror_top_bottom(boolean p_value) {
        this.mirror_top_bottom = !p_value;
    }

    public double get_rotation() {
        return this.rotation;
    }

    public void set_rotation(double p_value) {
        this.rotation = p_value;
    }

    public int get_90_degree_rotation() {
        int multiple;
        for (multiple = (int)Math.round(Math.toDegrees(this.rotation) / 90.0); multiple < 0; multiple += 4) {
        }
        while (multiple >= 4) {
            multiple -= 4;
        }
        return multiple;
    }
}

