/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import java.io.Serializable;

public enum Unit implements Serializable
{
    MIL(25.4),
    INCH(25400.0),
    MM(1000.0),
    UM(1.0);

    private final double micrometers;

    private Unit(double micrometers) {
        this.micrometers = micrometers;
    }

    public static double scale(double p_value, Unit p_from_unit, Unit p_to_unit) {
        return p_value * p_from_unit.micrometers / p_to_unit.micrometers;
    }

    public static Unit from_string(String p_string) {
        try {
            return Unit.valueOf(p_string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String toString() {
        return super.toString().toLowerCase();
    }
}

