/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.board.BasicBoard;
import app.freerouting.board.CalcFromSide;
import app.freerouting.board.ComponentObstacleArea;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.FixedState;
import app.freerouting.board.Item;
import app.freerouting.board.Pin;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.board.ViaObstacleArea;
import app.freerouting.geometry.planar.ConvexShape;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.logger.FRLogger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;

public class ShapeTraceEntries {
    private static final double c_offset_add = 1.0;
    final Collection<Via> shove_via_list;
    private final TileShape shape;
    private final int layer;
    private final int[] own_net_nos;
    private final int cl_class;
    private final RoutingBoard board;
    private CalcFromSide from_side;
    private EntryPoint list_anchor;
    private int trace_piece_count;
    private int max_stack_level;
    private boolean shape_contains_trace_tails;
    private Item found_obstacle;

    ShapeTraceEntries(TileShape p_shape, int p_layer, int[] p_own_net_nos, int p_cl_type, CalcFromSide p_from_side, RoutingBoard p_board) {
        this.shape = p_shape;
        this.layer = p_layer;
        this.own_net_nos = p_own_net_nos;
        this.cl_class = p_cl_type;
        this.from_side = p_from_side;
        this.board = p_board;
        this.list_anchor = null;
        this.trace_piece_count = 0;
        this.max_stack_level = 0;
        this.shove_via_list = new LinkedList<Via>();
    }

    public static void cutout_trace(PolylineTrace p_trace, ConvexShape p_shape, int p_cl_class) {
        ConvexShape offset_shape;
        if (!p_trace.is_on_the_board()) {
            FRLogger.warn("ShapeTraceEntries.cutout_trace : trace is deleted");
            return;
        }
        BasicBoard board = p_trace.board;
        ShapeSearchTree search_tree = board.search_tree_manager.get_default_tree();
        if (search_tree.is_clearance_compensation_used()) {
            double curr_offset = (double)p_trace.get_compensated_half_width(search_tree) + 1.0;
            offset_shape = p_shape.offset(curr_offset);
        } else {
            double cl_offset = (double)board.clearance_value(p_trace.clearance_class_no(), p_cl_class, p_trace.get_layer()) + 1.0;
            offset_shape = p_shape.offset(p_trace.get_half_width());
            offset_shape = offset_shape.offset(cl_offset);
        }
        Polyline trace_lines = p_trace.polyline();
        Polyline[] pieces = offset_shape.cutout(trace_lines);
        if (pieces.length == 1 && pieces[0] == trace_lines) {
            return;
        }
        if (pieces.length == 2 && offset_shape.is_outside(pieces[0].first_corner()) && offset_shape.is_outside(pieces[1].last_corner())) {
            ShapeTraceEntries.fast_cutout_trace(p_trace, pieces[0], pieces[1]);
        } else {
            board.remove_item(p_trace);
            for (int i = 0; i < pieces.length; ++i) {
                board.insert_trace_without_cleaning(pieces[i], p_trace.get_layer(), p_trace.get_half_width(), p_trace.net_no_arr, p_trace.clearance_class_no(), FixedState.NOT_FIXED);
            }
        }
    }

    private static void fast_cutout_trace(PolylineTrace p_trace, Polyline p_start_piece, Polyline p_end_piece) {
        BasicBoard board = p_trace.board;
        board.additional_update_after_change(p_trace);
        board.item_list.save_for_undo(p_trace);
        PolylineTrace start_piece = new PolylineTrace(p_start_piece, p_trace.get_layer(), p_trace.get_half_width(), p_trace.net_no_arr, p_trace.clearance_class_no(), 0, 0, FixedState.NOT_FIXED, board);
        start_piece.board = board;
        board.item_list.insert(start_piece);
        start_piece.set_on_the_board(true);
        PolylineTrace end_piece = new PolylineTrace(p_end_piece, p_trace.get_layer(), p_trace.get_half_width(), p_trace.net_no_arr, p_trace.clearance_class_no(), 0, 0, FixedState.NOT_FIXED, board);
        end_piece.board = board;
        board.item_list.insert(end_piece);
        end_piece.set_on_the_board(true);
        board.search_tree_manager.reuse_entries_after_cutout(p_trace, start_piece, end_piece);
        board.remove_item(p_trace);
        if (board.communication != null && board.communication.observers != null) {
            board.communication.observers.notify_new(start_piece);
            board.communication.observers.notify_new(end_piece);
        }
    }

    private static boolean net_nos_equal(int[] p_net_nos_1, int[] p_net_nos_2) {
        if (p_net_nos_1.length != p_net_nos_2.length) {
            return false;
        }
        for (int curr_net_no_1 : p_net_nos_1) {
            boolean net_no_found = false;
            for (int curr_net_no_2 : p_net_nos_2) {
                if (curr_net_no_1 != curr_net_no_2) continue;
                net_no_found = true;
                break;
            }
            if (net_no_found) continue;
            return false;
        }
        return true;
    }

    boolean store_items(Collection<Item> p_item_list, boolean p_is_pad_check, boolean p_copper_sharing_allowed) {
        for (Item curr_item : p_item_list) {
            if (!p_is_pad_check && curr_item instanceof ViaObstacleArea || curr_item instanceof ComponentObstacleArea) continue;
            boolean contains_own_net = curr_item.shares_net_no(this.own_net_nos);
            if (curr_item instanceof ConductionArea) {
                ConductionArea area = (ConductionArea)curr_item;
                if (contains_own_net || !area.get_is_obstacle()) continue;
            }
            if (curr_item.is_shove_fixed() && !contains_own_net) {
                this.found_obstacle = curr_item;
                return false;
            }
            if (curr_item instanceof Via) {
                Via via = (Via)curr_item;
                if (!p_is_pad_check && contains_own_net) continue;
                this.shove_via_list.add(via);
                continue;
            }
            if (curr_item instanceof PolylineTrace) {
                PolylineTrace curr_trace = (PolylineTrace)curr_item;
                if (this.store_trace(curr_trace)) continue;
                return false;
            }
            if (contains_own_net) {
                Pin pin;
                if (!p_copper_sharing_allowed) {
                    this.found_obstacle = curr_item;
                    return false;
                }
                if (!p_is_pad_check || curr_item instanceof Pin && (pin = (Pin)curr_item).drill_allowed()) continue;
                this.found_obstacle = curr_item;
                return false;
            }
            this.found_obstacle = curr_item;
            return false;
        }
        this.search_from_side();
        this.resort();
        return this.calculate_stack_levels();
    }

    PolylineTrace next_substitute_trace_piece() {
        TileShape offset_shape;
        EntryPoint[] entries = this.pop_piece();
        if (entries == null) {
            return null;
        }
        PolylineTrace curr_trace = entries[0].trace;
        ShapeSearchTree search_tree = this.board.search_tree_manager.get_default_tree();
        if (search_tree.is_clearance_compensation_used()) {
            double curr_offset = (double)curr_trace.get_compensated_half_width(search_tree) + 1.0;
            offset_shape = (TileShape)this.shape.offset(curr_offset);
        } else {
            offset_shape = (TileShape)this.shape.offset(curr_trace.get_half_width());
            double cl_offset = (double)this.board.clearance_value(curr_trace.clearance_class_no(), this.cl_class, this.layer) + 1.0;
            offset_shape = (TileShape)offset_shape.offset(cl_offset);
        }
        int edge_count = this.shape.border_line_count();
        int edge_diff = entries[1].edge_no - entries[0].edge_no;
        Line[] piece_lines = new Line[edge_diff + 3];
        piece_lines[0] = entries[0].trace.polyline().arr[entries[0].trace_line_no];
        piece_lines[piece_lines.length - 1] = entries[1].trace.polyline().arr[entries[1].trace_line_no];
        int curr_edge_no = entries[0].edge_no % edge_count;
        for (int i = 1; i < piece_lines.length - 1; ++i) {
            piece_lines[i] = offset_shape.border_line(curr_edge_no);
            if (curr_edge_no == edge_count - 1) {
                curr_edge_no = 0;
                continue;
            }
            ++curr_edge_no;
        }
        Polyline piece_polyline = new Polyline(piece_lines);
        if (piece_polyline.is_empty()) {
            return this.next_substitute_trace_piece();
        }
        return new PolylineTrace(piece_polyline, this.layer, curr_trace.get_half_width(), curr_trace.net_no_arr, curr_trace.clearance_class_no(), 0, 0, FixedState.NOT_FIXED, this.board);
    }

    int stack_depth() {
        return this.max_stack_level;
    }

    int substitute_trace_count() {
        return this.trace_piece_count;
    }

    public boolean trace_tails_in_shape() {
        return this.shape_contains_trace_tails;
    }

    void cutout_traces(Collection<Item> p_item_list) {
        for (Item curr_item : p_item_list) {
            if (!(curr_item instanceof PolylineTrace)) continue;
            PolylineTrace trace = (PolylineTrace)curr_item;
            if (curr_item.shares_net_no(this.own_net_nos)) continue;
            ShapeTraceEntries.cutout_trace(trace, this.shape, this.cl_class);
        }
    }

    Item get_found_obstacle() {
        return this.found_obstacle;
    }

    private boolean store_trace(PolylineTrace p_trace) {
        TileShape offset_shape;
        ShapeSearchTree search_tree = this.board.search_tree_manager.get_default_tree();
        if (search_tree.is_clearance_compensation_used()) {
            double curr_offset = (double)p_trace.get_compensated_half_width(search_tree) + 1.0;
            offset_shape = (TileShape)this.shape.offset(curr_offset);
        } else {
            double cl_offset = (double)this.board.clearance_value(p_trace.clearance_class_no(), this.cl_class, p_trace.get_layer()) + 1.0;
            offset_shape = (TileShape)this.shape.offset(p_trace.get_half_width());
            offset_shape = (TileShape)offset_shape.offset(cl_offset);
        }
        int[][] entries = offset_shape.entrance_points(p_trace.polyline());
        for (int i = 0; i < entries.length; ++i) {
            int[] entry_tuple = entries[i];
            FloatPoint entry_approx = p_trace.polyline().arr[entry_tuple[0]].intersection_approx(offset_shape.border_line(entry_tuple[1]));
            this.insert_entry_point(p_trace, entry_tuple[0], entry_tuple[1], entry_approx);
        }
        if (!p_trace.shares_net_no(this.own_net_nos)) {
            if (!p_trace.nets_normal()) {
                return false;
            }
            Point end_corner = p_trace.first_corner();
            for (int i = 0; i < 2; ++i) {
                if (offset_shape.contains(end_corner)) {
                    Set<Item> contact_list = i == 0 ? p_trace.get_start_contacts() : p_trace.get_end_contacts();
                    int contact_count = 0;
                    boolean store_end_corner = true;
                    for (Item contact_item : contact_list) {
                        if (!contact_item.is_routable()) {
                            this.found_obstacle = contact_item;
                            return false;
                        }
                        if (contact_item instanceof Trace) {
                            Trace trace = (Trace)contact_item;
                            if ((contact_item.is_shove_fixed() || trace.get_half_width() != p_trace.get_half_width() || contact_item.clearance_class_no() != p_trace.clearance_class_no()) && offset_shape.contains_inside(end_corner)) {
                                this.found_obstacle = contact_item;
                                return false;
                            }
                        } else if (contact_item instanceof Via) {
                            Via via = (Via)contact_item;
                            TileShape via_shape = via.get_tile_shape_on_layer(this.layer);
                            double via_trace_diff = via_shape.smallest_radius() - (double)p_trace.get_compensated_half_width(search_tree);
                            if (!search_tree.is_clearance_compensation_used()) {
                                int via_clearance = this.board.clearance_value(contact_item.clearance_class_no(), this.cl_class, this.layer);
                                int trace_clearance = this.board.clearance_value(p_trace.clearance_class_no(), this.cl_class, this.layer);
                                if (trace_clearance > via_clearance) {
                                    via_trace_diff += (double)(via_clearance - trace_clearance);
                                }
                            }
                            if (via_trace_diff < 0.0) {
                                this.found_obstacle = contact_item;
                                return false;
                            }
                            if (via_trace_diff == 0.0 && !offset_shape.contains_inside(end_corner)) {
                                store_end_corner = false;
                            }
                        }
                        ++contact_count;
                    }
                    if (contact_count == 1 && store_end_corner) {
                        Point projection = offset_shape.nearest_border_point(end_corner);
                        int projection_side = offset_shape.contains_on_border_line_no(projection);
                        int trace_line_segment_no = i == 0 ? 0 : p_trace.polyline().arr.length - 1;
                        if (projection_side >= 0) {
                            this.insert_entry_point(p_trace, trace_line_segment_no, projection_side, projection.to_float());
                        }
                    } else if (contact_count == 0 && offset_shape.contains_inside(end_corner)) {
                        this.shape_contains_trace_tails = true;
                    }
                }
                end_corner = p_trace.last_corner();
            }
        }
        this.found_obstacle = p_trace;
        return true;
    }

    private void search_from_side() {
        if (this.from_side != null && this.from_side.no >= 0) {
            return;
        }
        EntryPoint curr_node = this.list_anchor;
        int curr_fromside_no = 0;
        FloatPoint curr_entry_approx = null;
        while (curr_node != null) {
            if (curr_node.trace.shares_net_no(this.own_net_nos)) {
                curr_fromside_no = curr_node.edge_no;
                curr_entry_approx = curr_node.entry_approx;
                break;
            }
            curr_node = curr_node.next;
        }
        this.from_side = new CalcFromSide(curr_fromside_no, curr_entry_approx);
    }

    private void resort() {
        EntryPoint next;
        int[] curr_net_nos;
        FloatPoint curr_projection;
        int edge_count = this.shape.border_line_count();
        if (this.from_side.no < 0 || this.from_side.no >= edge_count) {
            FRLogger.warn("ShapeTraceEntries.resort: from side not calculated");
            return;
        }
        FloatPoint compare_corner_1 = this.shape.corner_approx(this.from_side.no);
        FloatPoint compare_corner_2 = this.from_side.no == edge_count - 1 ? this.shape.corner_approx(0) : this.shape.corner_approx(this.from_side.no + 1);
        double from_point_dist = 0.0;
        FloatPoint from_point_projection = null;
        if (this.from_side.border_intersection != null && (from_point_dist = (from_point_projection = this.from_side.border_intersection.projection_approx(this.shape.border_line(this.from_side.no))).distance_square(compare_corner_1)) >= compare_corner_1.distance_square(compare_corner_2)) {
            this.from_side = new CalcFromSide(this.from_side.no, null);
        }
        EntryPoint curr = this.list_anchor;
        EntryPoint prev = null;
        while (!(curr == null || curr.edge_no > this.from_side.no || curr.edge_no == this.from_side.no && (this.from_side.border_intersection != null ? (curr_projection = curr.entry_approx.projection_approx(this.shape.border_line(this.from_side.no))).distance_square(compare_corner_1) >= from_point_dist && curr_projection.distance_square(from_point_projection) <= curr_projection.distance_square(compare_corner_1) : curr.entry_approx.distance_square(compare_corner_2) <= curr.entry_approx.distance_square(compare_corner_1)))) {
            prev = curr;
            curr = prev.next;
        }
        if (curr != null && curr != this.list_anchor) {
            EntryPoint new_anchor = curr;
            while (curr != null) {
                prev = curr;
                curr = prev.next;
            }
            prev.next = this.list_anchor;
            curr = this.list_anchor;
            while (curr != new_anchor) {
                curr.edge_no += edge_count;
                prev = curr;
                curr = prev.next;
            }
            prev.next = null;
            this.list_anchor = new_anchor;
        }
        if (this.list_anchor == null) {
            return;
        }
        prev = this.list_anchor;
        int[] prev_net_nos = prev.trace.net_no_arr;
        curr = this.list_anchor.next;
        if (curr != null) {
            curr_net_nos = curr.trace.net_no_arr;
            next = curr.next;
        } else {
            next = null;
            curr_net_nos = new int[]{};
        }
        EntryPoint before_prev = null;
        while (next != null) {
            int[] next_net_nos = next.trace.net_no_arr;
            if (ShapeTraceEntries.net_nos_equal(prev_net_nos, curr_net_nos) && ShapeTraceEntries.net_nos_equal(curr_net_nos, next_net_nos)) {
                prev.next = next;
            } else {
                before_prev = prev;
                prev = curr;
                prev_net_nos = curr_net_nos;
            }
            curr_net_nos = next_net_nos;
            curr = next;
            next = curr.next;
        }
        if (curr != null && ShapeTraceEntries.net_nos_equal(curr_net_nos, this.own_net_nos)) {
            prev.next = null;
            if (ShapeTraceEntries.net_nos_equal(prev_net_nos, this.own_net_nos)) {
                if (before_prev != null) {
                    before_prev.next = null;
                } else {
                    this.list_anchor = null;
                }
            }
        }
        if (this.list_anchor != null && this.list_anchor.trace.nets_equal(this.own_net_nos)) {
            this.list_anchor = this.list_anchor.next;
            if (this.list_anchor != null && this.list_anchor.trace.nets_equal(this.own_net_nos)) {
                this.list_anchor = this.list_anchor.next;
            }
        }
    }

    private boolean calculate_stack_levels() {
        if (this.list_anchor == null) {
            return true;
        }
        EntryPoint curr_entry = this.list_anchor;
        int[] curr_net_nos = curr_entry.trace.net_no_arr;
        int curr_level = ShapeTraceEntries.net_nos_equal(curr_net_nos, this.own_net_nos) ? 0 : 1;
        while (curr_entry != null) {
            if (curr_entry.stack_level < 0) {
                ++this.trace_piece_count;
                curr_entry.stack_level = curr_level;
                if (curr_level > this.max_stack_level) {
                    if (this.max_stack_level > 1) {
                        this.found_obstacle = curr_entry.trace;
                    }
                    this.max_stack_level = curr_level;
                }
            }
            EntryPoint check_entry = curr_entry.next;
            int index_of_next_foreign_set = 0;
            int index_of_last_occurrence_of_set = 0;
            int next_index = 0;
            EntryPoint last_own_entry = null;
            EntryPoint first_foreign_entry = null;
            while (check_entry != null) {
                ++next_index;
                int[] check_net_nos = check_entry.trace.net_no_arr;
                if (ShapeTraceEntries.net_nos_equal(check_net_nos, curr_net_nos)) {
                    index_of_last_occurrence_of_set = next_index;
                    last_own_entry = check_entry;
                    check_entry.stack_level = curr_entry.stack_level;
                } else if (index_of_next_foreign_set == 0) {
                    index_of_next_foreign_set = next_index;
                    first_foreign_entry = check_entry;
                }
                check_entry = check_entry.next;
            }
            if (next_index != 0) {
                EntryPoint next_entry;
                if (index_of_next_foreign_set != 0 && index_of_next_foreign_set < index_of_last_occurrence_of_set) {
                    next_entry = first_foreign_entry;
                    if (next_entry.stack_level >= 0) {
                        return false;
                    }
                    ++curr_level;
                } else if (index_of_last_occurrence_of_set != 0) {
                    next_entry = last_own_entry;
                } else {
                    next_entry = first_foreign_entry;
                    if (next_entry.stack_level >= 0 && next_entry.stack_level != --curr_level) {
                        return false;
                    }
                }
                curr_net_nos = next_entry.trace.net_no_arr;
                check_entry = curr_entry.next;
                while (check_entry != next_entry) {
                    check_entry = check_entry.next;
                }
                curr_entry.next = next_entry;
                curr_entry = next_entry;
                continue;
            }
            curr_entry = null;
        }
        if (curr_level != 1) {
            FRLogger.warn("ShapeTraceEntries.calculate_stack_levels: curr_level inconsistent");
            return false;
        }
        return true;
    }

    private EntryPoint[] pop_piece() {
        if (this.list_anchor == null) {
            if (this.trace_piece_count != 0) {
                FRLogger.warn("ShapeTraceEntries: trace_piece_count is inconsistent");
            }
            return null;
        }
        EntryPoint first = this.list_anchor;
        EntryPoint prev_first = null;
        while (first != null && first.stack_level != this.max_stack_level) {
            prev_first = first;
            first = first.next;
        }
        if (first == null) {
            FRLogger.warn("ShapeTraceEntries: max_stack_level not found");
            return null;
        }
        EntryPoint[] result = new EntryPoint[2];
        result[0] = first;
        EntryPoint last = first;
        EntryPoint after_last = first.next;
        while (after_last != null && after_last.stack_level == this.max_stack_level && after_last.trace.nets_equal(first.trace)) {
            last = after_last;
            after_last = last.next;
        }
        result[1] = last;
        if (prev_first != null) {
            prev_first.next = after_last;
        } else {
            this.list_anchor = after_last;
        }
        this.max_stack_level = 0;
        EntryPoint curr = this.list_anchor;
        while (curr != null) {
            if (curr.stack_level > this.max_stack_level) {
                this.max_stack_level = curr.stack_level;
            }
            curr = curr.next;
        }
        --this.trace_piece_count;
        if (first.trace.nets_equal(this.own_net_nos)) {
            result = this.pop_piece();
        }
        return result;
    }

    private void insert_entry_point(PolylineTrace p_trace, int p_trace_line_no, int p_edge_no, FloatPoint p_entry_approx) {
        FloatPoint next_corner;
        FloatPoint prev_corner;
        EntryPoint new_entry = new EntryPoint(p_trace, p_trace_line_no, p_edge_no, p_entry_approx);
        EntryPoint curr_prev = null;
        EntryPoint curr_next = this.list_anchor;
        while (!(curr_next == null || curr_next.edge_no > new_entry.edge_no || curr_next.edge_no == new_entry.edge_no && (prev_corner = this.shape.corner_approx(p_edge_no)).scalar_product(p_entry_approx, next_corner = p_edge_no == this.shape.border_line_count() - 1 ? this.shape.corner_approx(0) : this.shape.corner_approx(new_entry.edge_no + 1)) <= prev_corner.scalar_product(curr_next.entry_approx, next_corner))) {
            curr_prev = curr_next;
            curr_next = curr_next.next;
        }
        new_entry.next = curr_next;
        if (curr_prev != null) {
            curr_prev.next = new_entry;
        } else {
            this.list_anchor = new_entry;
        }
    }

    private static class EntryPoint {
        final PolylineTrace trace;
        final int trace_line_no;
        final FloatPoint entry_approx;
        int edge_no;
        int stack_level;
        EntryPoint next;

        EntryPoint(PolylineTrace p_trace, int p_trace_line_no, int p_edge_no, FloatPoint p_entry_approx) {
            this.trace = p_trace;
            this.edge_no = p_edge_no;
            this.trace_line_no = p_trace_line_no;
            this.entry_approx = p_entry_approx;
            this.stack_level = -1;
        }
    }
}

