/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.autoroute.CompleteFreeSpaceExpansionRoom;
import app.freerouting.autoroute.IncompleteFreeSpaceExpansionRoom;
import app.freerouting.board.BasicBoard;
import app.freerouting.board.BoardOutline;
import app.freerouting.board.DrillItem;
import app.freerouting.board.ObstacleArea;
import app.freerouting.board.SearchTreeObject;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.datastructures.ShapeTree;
import app.freerouting.geometry.planar.FortyfiveDegreeBoundingDirections;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.Shape;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.Simplex;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.logger.FRLogger;
import java.util.Collection;
import java.util.LinkedList;

public class ShapeSearchTree45Degree
extends ShapeSearchTree {
    public ShapeSearchTree45Degree(BasicBoard p_board, int p_compensated_clearance_class_no) {
        super(FortyfiveDegreeBoundingDirections.INSTANCE, p_board, p_compensated_clearance_class_no);
    }

    private static boolean obstacle_segment_touches_inside(IntOctagon p_obstacle_shape, int p_obstacle_border_line_no, IntOctagon p_room_shape) {
        int curr_border_line_no = p_obstacle_border_line_no;
        int curr_obstacle_corner_x = p_obstacle_shape.corner_x(p_obstacle_border_line_no);
        int curr_obstacle_corner_y = p_obstacle_shape.corner_y(p_obstacle_border_line_no);
        for (int j = 0; j < 5; ++j) {
            if (p_room_shape.side_of_border_line(curr_obstacle_corner_x, curr_obstacle_corner_y, curr_border_line_no) != Side.ON_THE_LEFT) {
                return false;
            }
            curr_border_line_no = (curr_border_line_no + 1) % 8;
        }
        int next_obstacle_border_line_no = (p_obstacle_border_line_no + 1) % 8;
        int next_obstacle_corner_x = p_obstacle_shape.corner_x(next_obstacle_border_line_no);
        int next_obstacle_corner_y = p_obstacle_shape.corner_y(next_obstacle_border_line_no);
        curr_border_line_no = (p_obstacle_border_line_no + 5) % 8;
        for (int j = 0; j < 3; ++j) {
            if (p_room_shape.side_of_border_line(next_obstacle_corner_x, next_obstacle_corner_y, curr_border_line_no) != Side.ON_THE_LEFT) {
                return false;
            }
            curr_border_line_no = (curr_border_line_no + 1) % 8;
        }
        return true;
    }

    private static double signed_line_distance(IntOctagon p_obstacle_shape, int p_obstacle_line_no, IntOctagon p_contained_shape) {
        return switch (p_obstacle_line_no) {
            case 0 -> p_obstacle_shape.bottomY - p_contained_shape.topY;
            case 2 -> p_contained_shape.leftX - p_obstacle_shape.rightX;
            case 4 -> p_contained_shape.bottomY - p_obstacle_shape.topY;
            case 6 -> p_obstacle_shape.leftX - p_contained_shape.rightX;
            case 1 -> 0.5 * (double)(p_contained_shape.upperLeftDiagonalX - p_obstacle_shape.lowerRightDiagonalX);
            case 3 -> 0.5 * (double)(p_contained_shape.lowerLeftDiagonalX - p_obstacle_shape.upperRightDiagonalX);
            case 5 -> 0.5 * (double)(p_obstacle_shape.upperLeftDiagonalX - p_contained_shape.lowerRightDiagonalX);
            case 7 -> 0.5 * (double)(p_obstacle_shape.lowerLeftDiagonalX - p_contained_shape.upperRightDiagonalX);
            default -> {
                FRLogger.warn("ShapeSearchTree45Degree.signed_line_distance: p_obstacle_line_no out of range");
                yield 0.0;
            }
        };
    }

    @Override
    public Collection<IncompleteFreeSpaceExpansionRoom> complete_shape(IncompleteFreeSpaceExpansionRoom p_room, int p_net_no, SearchTreeObject p_ignore_object, TileShape p_ignore_shape) {
        ShapeTree.TreeNode curr_node;
        IntOctagon shape_to_be_contained;
        TileShape contained_shape = p_room.get_contained_shape();
        if (contained_shape.is_IntOctagon()) {
            shape_to_be_contained = contained_shape.bounding_octagon();
        } else if (contained_shape instanceof Simplex) {
            Simplex simplex = (Simplex)contained_shape;
            int lineCount = simplex.border_line_count();
            for (int i = 0; i < lineCount && i >= 0; ++i) {
                Line line = simplex.border_line(i);
                Line nextLine = simplex.border_line((i + 1) % lineCount);
                if (!(line.length() < 10.0f) && !line.equals(nextLine.opposite())) continue;
                simplex = simplex.remove_border_line(i);
                lineCount = simplex.border_line_count();
                --i;
            }
            if (simplex.border_line_count() < 3) {
                return new LinkedList<IncompleteFreeSpaceExpansionRoom>();
            }
            shape_to_be_contained = simplex.bounding_octagon();
            if (shape_to_be_contained == null) {
                FRLogger.debug("ShapeSearchTree45Degree.complete_shape: cannot convert Simplex to IntOctagon");
                return new LinkedList<IncompleteFreeSpaceExpansionRoom>();
            }
        } else {
            FRLogger.debug("ShapeSearchTree45Degree.complete_shape: unexpected shape type");
            return new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        }
        if (this.root == null) {
            return new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        }
        IntOctagon start_shape = this.board.get_bounding_box().bounding_octagon();
        if (p_room.get_shape() != null) {
            IntOctagon octagon_room_shape;
            TileShape room_shape = p_room.get_shape();
            if (room_shape instanceof IntOctagon) {
                IntOctagon octagon;
                octagon_room_shape = octagon = (IntOctagon)room_shape;
            } else if (room_shape instanceof Simplex) {
                octagon_room_shape = room_shape.bounding_octagon();
                if (octagon_room_shape == null) {
                    FRLogger.warn("ShapeSearchTree45Degree.complete_shape: cannot convert room shape Simplex to IntOctagon");
                    return new LinkedList<IncompleteFreeSpaceExpansionRoom>();
                }
            } else {
                FRLogger.warn("ShapeSearchTree45Degree.complete_shape: room shape type not supported");
                return new LinkedList<IncompleteFreeSpaceExpansionRoom>();
            }
            start_shape = octagon_room_shape.intersection(start_shape);
        }
        IntOctagon bounding_shape = start_shape;
        int room_layer = p_room.get_layer();
        Collection<IncompleteFreeSpaceExpansionRoom> result = new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        result.add(new IncompleteFreeSpaceExpansionRoom(start_shape, room_layer, shape_to_be_contained));
        this.node_stack.reset();
        this.node_stack.push(this.root);
        while ((curr_node = (ShapeTree.TreeNode)this.node_stack.pop()) != null) {
            if (!curr_node.bounding_shape.intersects(bounding_shape)) continue;
            if (curr_node instanceof ShapeTree.Leaf) {
                ShapeTree.Leaf curr_leaf = (ShapeTree.Leaf)curr_node;
                SearchTreeObject curr_object = (SearchTreeObject)curr_leaf.object;
                boolean is_obstacle = curr_object.is_trace_obstacle(p_net_no);
                int shape_index = curr_leaf.shape_index_in_object;
                if (!is_obstacle || curr_object.shape_layer(shape_index) != room_layer || curr_object == p_ignore_object) continue;
                IntOctagon curr_object_shape = curr_object.get_tree_shape(this, shape_index).bounding_octagon();
                LinkedList<IncompleteFreeSpaceExpansionRoom> new_result = new LinkedList<IncompleteFreeSpaceExpansionRoom>();
                IntOctagon new_bounding_shape = IntOctagon.EMPTY;
                for (IncompleteFreeSpaceExpansionRoom curr_room : result) {
                    IntOctagon curr_shape = (IntOctagon)curr_room.get_shape();
                    if (curr_shape.overlaps(curr_object_shape)) {
                        IntOctagon intersection;
                        if (curr_object instanceof CompleteFreeSpaceExpansionRoom && p_ignore_shape != null && p_ignore_shape.contains(intersection = curr_shape.intersection(curr_object_shape))) {
                            if (p_ignore_shape.contains(curr_shape)) continue;
                            new_result.add(curr_room);
                            new_bounding_shape = new_bounding_shape.union(curr_shape.bounding_box());
                            continue;
                        }
                        Collection<IncompleteFreeSpaceExpansionRoom> new_restrained_shapes = this.restrain_shape(curr_room, curr_object_shape);
                        new_result.addAll(new_restrained_shapes);
                        for (IncompleteFreeSpaceExpansionRoom tmp_shape : new_result) {
                            new_bounding_shape = new_bounding_shape.union(tmp_shape.get_shape().bounding_box());
                        }
                        continue;
                    }
                    new_result.add(curr_room);
                    new_bounding_shape = new_bounding_shape.union(curr_shape.bounding_box());
                }
                result = new_result;
                bounding_shape = new_bounding_shape;
                continue;
            }
            this.node_stack.push(((ShapeTree.InnerNode)curr_node).first_child);
            this.node_stack.push(((ShapeTree.InnerNode)curr_node).second_child);
        }
        result = this.divide_large_room(result, this.board.get_bounding_box());
        result.removeIf(room -> room.get_contained_shape().contains(room.get_shape()));
        return result;
    }

    @Override
    protected Collection<IncompleteFreeSpaceExpansionRoom> divide_large_room(Collection<IncompleteFreeSpaceExpansionRoom> p_room_list, IntBox p_board_bounding_box) {
        Collection<IncompleteFreeSpaceExpansionRoom> result = super.divide_large_room(p_room_list, p_board_bounding_box);
        for (IncompleteFreeSpaceExpansionRoom curr_room : result) {
            curr_room.set_shape(curr_room.get_shape().bounding_octagon());
            curr_room.set_contained_shape(curr_room.get_contained_shape().bounding_octagon());
        }
        return result;
    }

    private Collection<IncompleteFreeSpaceExpansionRoom> restrain_shape(IncompleteFreeSpaceExpansionRoom p_incomplete_room, IntOctagon p_obstacle_shape) {
        IntOctagon rest_shape_to_be_contained;
        IntOctagon rest_piece;
        IntOctagon new_shape_to_be_contained;
        int obstacle_line_no;
        IntOctagon room_shape;
        IntOctagon shape_to_be_contained;
        LinkedList<IncompleteFreeSpaceExpansionRoom> result = new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        TileShape contained_shape = p_incomplete_room.get_contained_shape();
        if (contained_shape == null || contained_shape.is_empty()) {
            FRLogger.trace("ShapeSearchTree45Degree.restrain_shape: p_shape_to_be_contained is empty");
            return result;
        }
        if (contained_shape.is_IntOctagon()) {
            shape_to_be_contained = contained_shape.bounding_octagon();
        } else if (contained_shape instanceof Simplex) {
            shape_to_be_contained = contained_shape.bounding_octagon();
            if (shape_to_be_contained == null) {
                FRLogger.warn("restrain_shape: cannot convert Simplex to IntOctagon");
                return new LinkedList<IncompleteFreeSpaceExpansionRoom>();
            }
        } else {
            FRLogger.warn("restrain_shape: incompatible shape type");
            return new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        }
        if (p_incomplete_room.get_shape() instanceof IntOctagon) {
            room_shape = p_incomplete_room.get_shape().bounding_octagon();
        } else if (p_incomplete_room.get_shape() instanceof Simplex) {
            room_shape = p_incomplete_room.get_shape().bounding_octagon();
            if (room_shape == null) {
                FRLogger.warn("restrain_shape: cannot convert room shape Simplex to IntOctagon");
                return new LinkedList<IncompleteFreeSpaceExpansionRoom>();
            }
        } else {
            FRLogger.warn("restrain_shape: unsupported room shape type");
            return new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        }
        double cut_line_distance = -1.0;
        int restraining_line_no = -1;
        for (obstacle_line_no = 0; obstacle_line_no < 8; ++obstacle_line_no) {
            double curr_distance = ShapeSearchTree45Degree.signed_line_distance(p_obstacle_shape, obstacle_line_no, shape_to_be_contained);
            if (!(curr_distance > cut_line_distance) || !ShapeSearchTree45Degree.obstacle_segment_touches_inside(p_obstacle_shape, obstacle_line_no, room_shape)) continue;
            cut_line_distance = curr_distance;
            restraining_line_no = obstacle_line_no;
        }
        if (cut_line_distance >= 0.0) {
            IntOctagon restrained_shape = this.calc_outside_restrained_shape(p_obstacle_shape, restraining_line_no, room_shape);
            result.add(new IncompleteFreeSpaceExpansionRoom(restrained_shape, p_incomplete_room.get_layer(), shape_to_be_contained));
            return result;
        }
        if (shape_to_be_contained.dimension() < 1) {
            return result;
        }
        restraining_line_no = -1;
        for (obstacle_line_no = 0; obstacle_line_no < 8; ++obstacle_line_no) {
            Line curr_line;
            if (!ShapeSearchTree45Degree.obstacle_segment_touches_inside(p_obstacle_shape, obstacle_line_no, room_shape) || shape_to_be_contained.side_of(curr_line = p_obstacle_shape.border_line(obstacle_line_no)) != Side.COLLINEAR) continue;
            restraining_line_no = obstacle_line_no;
            break;
        }
        if (restraining_line_no < 0) {
            return result;
        }
        IntOctagon restrained_shape = this.calc_outside_restrained_shape(p_obstacle_shape, restraining_line_no, room_shape);
        if (restrained_shape.dimension() == 2 && (new_shape_to_be_contained = shape_to_be_contained.intersection(restrained_shape)).dimension() > 0) {
            result.add(new IncompleteFreeSpaceExpansionRoom(restrained_shape, p_incomplete_room.get_layer(), new_shape_to_be_contained));
        }
        if ((rest_piece = this.calc_inside_restrained_shape(p_obstacle_shape, restraining_line_no, room_shape)).dimension() >= 2 && (rest_shape_to_be_contained = shape_to_be_contained.intersection(rest_piece)).dimension() >= 0) {
            IncompleteFreeSpaceExpansionRoom rest_incomplete_room = new IncompleteFreeSpaceExpansionRoom(rest_piece, p_incomplete_room.get_layer(), rest_shape_to_be_contained);
            result.addAll(this.restrain_shape(rest_incomplete_room, p_obstacle_shape));
        }
        return result;
    }

    IntOctagon calc_outside_restrained_shape(IntOctagon p_obstacle_shape, int p_obstacle_line_no, IntOctagon p_room_shape) {
        int lx = p_room_shape.leftX;
        int ly = p_room_shape.bottomY;
        int rx = p_room_shape.rightX;
        int uy = p_room_shape.topY;
        int ulx = p_room_shape.upperLeftDiagonalX;
        int lrx = p_room_shape.lowerRightDiagonalX;
        int llx = p_room_shape.lowerLeftDiagonalX;
        int urx = p_room_shape.upperRightDiagonalX;
        switch (p_obstacle_line_no) {
            case 0: {
                uy = p_obstacle_shape.bottomY;
                break;
            }
            case 2: {
                lx = p_obstacle_shape.rightX;
                break;
            }
            case 4: {
                ly = p_obstacle_shape.topY;
                break;
            }
            case 6: {
                rx = p_obstacle_shape.leftX;
                break;
            }
            case 1: {
                ulx = p_obstacle_shape.lowerRightDiagonalX;
                break;
            }
            case 3: {
                llx = p_obstacle_shape.upperRightDiagonalX;
                break;
            }
            case 5: {
                lrx = p_obstacle_shape.upperLeftDiagonalX;
                break;
            }
            case 7: {
                urx = p_obstacle_shape.lowerLeftDiagonalX;
                break;
            }
            default: {
                FRLogger.warn("ShapeSearchTree45Degree.calc_outside_restrained_shape: p_obstacle_line_no out of range");
            }
        }
        IntOctagon result = new IntOctagon(lx, ly, rx, uy, ulx, lrx, llx, urx);
        return result.normalize();
    }

    IntOctagon calc_inside_restrained_shape(IntOctagon p_obstacle_shape, int p_obstacle_line_no, IntOctagon p_room_shape) {
        int lx = p_room_shape.leftX;
        int ly = p_room_shape.bottomY;
        int rx = p_room_shape.rightX;
        int uy = p_room_shape.topY;
        int ulx = p_room_shape.upperLeftDiagonalX;
        int lrx = p_room_shape.lowerRightDiagonalX;
        int llx = p_room_shape.lowerLeftDiagonalX;
        int urx = p_room_shape.upperRightDiagonalX;
        switch (p_obstacle_line_no) {
            case 0: {
                ly = p_obstacle_shape.bottomY;
                break;
            }
            case 2: {
                rx = p_obstacle_shape.rightX;
                break;
            }
            case 4: {
                uy = p_obstacle_shape.topY;
                break;
            }
            case 6: {
                lx = p_obstacle_shape.leftX;
                break;
            }
            case 1: {
                lrx = p_obstacle_shape.lowerRightDiagonalX;
                break;
            }
            case 3: {
                urx = p_obstacle_shape.upperRightDiagonalX;
                break;
            }
            case 5: {
                ulx = p_obstacle_shape.upperLeftDiagonalX;
                break;
            }
            case 7: {
                llx = p_obstacle_shape.lowerLeftDiagonalX;
                break;
            }
            default: {
                FRLogger.warn("ShapeSearchTree45Degree.calc_inside_restrained_shape: p_obstacle_line_no out of range");
            }
        }
        IntOctagon result = new IntOctagon(lx, ly, rx, uy, ulx, lrx, llx, urx);
        return result.normalize();
    }

    @Override
    TileShape[] calculate_tree_shapes(DrillItem p_drill_item) {
        if (this.board == null) {
            return new TileShape[0];
        }
        TileShape[] result = new TileShape[p_drill_item.tile_shape_count()];
        for (int i = 0; i < result.length; ++i) {
            Shape curr_shape = p_drill_item.get_shape(i);
            if (curr_shape == null) {
                result[i] = null;
                continue;
            }
            TileShape curr_tile_shape = curr_shape.bounding_octagon();
            if (curr_tile_shape.is_IntBox()) {
                curr_tile_shape = curr_shape.bounding_box();
            }
            int offset_width = this.clearance_compensation_value(p_drill_item.clearance_class_no(), p_drill_item.shape_layer(i));
            curr_tile_shape = (TileShape)curr_tile_shape.offset(offset_width);
            result[i] = curr_tile_shape.bounding_octagon();
        }
        return result;
    }

    @Override
    TileShape[] calculate_tree_shapes(ObstacleArea p_obstacle_area) {
        TileShape[] result = super.calculate_tree_shapes(p_obstacle_area);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].bounding_octagon();
        }
        return result;
    }

    @Override
    TileShape[] calculate_tree_shapes(BoardOutline p_outline) {
        TileShape[] result = super.calculate_tree_shapes(p_outline);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].bounding_octagon();
        }
        return result;
    }
}

