/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.management.TextManager;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

public abstract class PrintableShape {
    protected final Locale locale;

    protected PrintableShape(Locale p_locale) {
        this.locale = p_locale;
    }

    public abstract String toString();

    static class Polygon
    extends PrintableShape {
        public final FloatPoint[] corner_arr;

        public Polygon(FloatPoint[] p_corners, Locale p_locale) {
            super(p_locale);
            this.corner_arr = p_corners;
        }

        @Override
        public String toString() {
            TextManager tm = new TextManager(this.getClass(), this.locale);
            return tm.getText("polygon", new String[0]) + ": " + Arrays.stream(this.corner_arr).map(c -> c.to_string(this.locale)).collect(Collectors.joining(", "));
        }
    }

    static class Rectangle
    extends PrintableShape {
        public final FloatPoint lower_left;
        public final FloatPoint upper_right;

        public Rectangle(FloatPoint p_lower_left, FloatPoint p_upper_right, Locale p_locale) {
            super(p_locale);
            this.lower_left = p_lower_left;
            this.upper_right = p_upper_right;
        }

        @Override
        public String toString() {
            TextManager tm = new TextManager(this.getClass(), this.locale);
            return tm.getText("rectangle", new String[0]) + ": " + tm.getText("lower_left", new String[0]) + " = " + this.lower_left.to_string(this.locale) + ", " + tm.getText("upper_right", new String[0]) + " = " + this.upper_right.to_string(this.locale);
        }
    }

    static class Circle
    extends PrintableShape {
        public final FloatPoint center;
        public final double radius;

        public Circle(FloatPoint p_center, double p_radius, Locale p_locale) {
            super(p_locale);
            this.center = p_center;
            this.radius = p_radius;
        }

        @Override
        public String toString() {
            TextManager tm = new TextManager(this.getClass(), this.locale);
            String result = tm.getText("circle", new String[0]) + ": ";
            if (this.center.x != 0.0 || this.center.y != 0.0) {
                String center_string = tm.getText("center", new String[0]) + " =" + this.center.to_string(this.locale);
                result = result + center_string;
            }
            NumberFormat nf = NumberFormat.getInstance(this.locale);
            nf.setMaximumFractionDigits(4);
            String radius_string = tm.getText("radius", new String[0]) + " = " + nf.format((float)this.radius);
            result = result + radius_string;
            return result;
        }
    }
}

