/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.board.BasicBoard;
import app.freerouting.board.Component;
import app.freerouting.board.DrillItem;
import app.freerouting.board.FixedState;
import app.freerouting.board.Item;
import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.board.ObstacleArea;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.core.LogicalPart;
import app.freerouting.core.Package;
import app.freerouting.core.Padstack;
import app.freerouting.geometry.planar.ConvexShape;
import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.geometry.planar.Shape;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.TextManager;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class Pin
extends DrillItem
implements Serializable {
    public final int pin_no;
    private Pin changed_to = this;
    private transient Shape[] precalculated_shapes;

    Pin(int p_component_no, int p_pin_no, int[] p_net_no_arr, int p_clearance_type, int p_id_no, FixedState p_fixed_state, BasicBoard p_board) {
        super(null, p_net_no_arr, p_clearance_type, p_id_no, p_component_no, p_fixed_state, p_board);
        this.pin_no = p_pin_no;
    }

    public Vector relative_location() {
        Component component = this.board.components.get(this.get_component_no());
        Package lib_package = component.get_package();
        Package.Pin package_pin = lib_package.get_pin(this.pin_no);
        Vector rel_location = package_pin.relative_location;
        double component_rotation = component.get_rotation_in_degree();
        if (!component.placed_on_front() && !this.board.components.get_flip_style_rotate_first()) {
            rel_location = package_pin.relative_location.mirror_at_y_axis();
        }
        if (component_rotation % 90.0 == 0.0) {
            int component_ninety_degree_factor = (int)component_rotation / 90;
            if (component_ninety_degree_factor != 0) {
                rel_location = rel_location.turn_90_degree(component_ninety_degree_factor);
            }
        } else {
            FloatPoint location_approx = rel_location.to_float();
            location_approx = location_approx.rotate(Math.toRadians(component_rotation), FloatPoint.ZERO);
            rel_location = location_approx.round().difference_by((Point)Point.ZERO);
        }
        if (!component.placed_on_front() && this.board.components.get_flip_style_rotate_first()) {
            rel_location = rel_location.mirror_at_y_axis();
        }
        return rel_location;
    }

    @Override
    public Point get_center() {
        Point pin_center = super.get_center();
        if (pin_center == null) {
            Component component = this.board.components.get(this.get_component_no());
            pin_center = component.get_location().translate_by(this.relative_location());
            Padstack padstack = this.get_padstack();
            int from_layer = padstack.from_layer();
            int to_layer = padstack.to_layer();
            Shape curr_shape = null;
            for (int i = 0; i < to_layer - from_layer + 1 && (curr_shape = this.get_shape(i)) == null; ++i) {
            }
            if (curr_shape == null) {
                FRLogger.warn("Pin: At least 1 shape != null expected");
            } else if (!curr_shape.contains_inside(pin_center)) {
                pin_center = curr_shape.centre_of_gravity().round();
            }
            this.set_center(pin_center);
        }
        return pin_center;
    }

    @Override
    public Padstack get_padstack() {
        Component component = this.board.components.get(this.get_component_no());
        if (component == null) {
            FRLogger.warn("Pin.get_padstack; component not found");
            return null;
        }
        int padstack_no = component.get_package().get_pin((int)this.pin_no).padstack_no;
        return this.board.library.padstacks.get(padstack_no);
    }

    @Override
    public Item copy(int p_id_no) {
        int[] curr_net_no_arr = new int[this.net_count()];
        for (int i = 0; i < curr_net_no_arr.length; ++i) {
            curr_net_no_arr[i] = this.get_net_no(i);
        }
        return new Pin(this.get_component_no(), this.pin_no, curr_net_no_arr, this.clearance_class_no(), p_id_no, this.get_fixed_state(), this.board);
    }

    public String name() {
        Component component = this.board.components.get(this.get_component_no());
        if (component == null) {
            FRLogger.warn("Pin.name: component not found");
            return null;
        }
        return component.get_package().get_pin((int)this.pin_no).name;
    }

    public int get_index_in_package() {
        return this.pin_no;
    }

    @Override
    public Shape get_shape(int p_index) {
        Padstack padstack = this.get_padstack();
        if (this.precalculated_shapes == null) {
            boolean mirror_at_y_axis;
            this.precalculated_shapes = new Shape[padstack.to_layer() - padstack.from_layer() + 1];
            Component component = this.board.components.get(this.get_component_no());
            if (component == null) {
                FRLogger.warn("Pin.get_shape: component not found");
                return null;
            }
            Package lib_package = component.get_package();
            if (lib_package == null) {
                FRLogger.warn("Pin.get_shape: package not found");
                return null;
            }
            Package.Pin package_pin = lib_package.get_pin(this.pin_no);
            if (package_pin == null) {
                FRLogger.warn("Pin.get_shape: pin_no out of range");
                return null;
            }
            Vector rel_location = package_pin.relative_location;
            double component_rotation = component.get_rotation_in_degree();
            boolean bl = mirror_at_y_axis = !component.placed_on_front() && !this.board.components.get_flip_style_rotate_first();
            if (mirror_at_y_axis) {
                rel_location = package_pin.relative_location.mirror_at_y_axis();
            }
            Vector component_translation = component.get_location().difference_by((Point)Point.ZERO);
            for (int index = 0; index < this.precalculated_shapes.length; ++index) {
                int padstack_layer = this.get_padstack_layer(index);
                ConvexShape curr_shape = padstack.get_shape(padstack_layer);
                if (curr_shape == null) continue;
                double pin_rotation = package_pin.rotation_in_degree;
                if (pin_rotation % 90.0 == 0.0) {
                    int pin_ninety_degree_factor = (int)pin_rotation / 90;
                    if (pin_ninety_degree_factor != 0) {
                        curr_shape = (ConvexShape)curr_shape.turn_90_degree(pin_ninety_degree_factor, Point.ZERO);
                    }
                } else {
                    curr_shape = (ConvexShape)curr_shape.rotate_approx(Math.toRadians(pin_rotation), FloatPoint.ZERO);
                }
                if (mirror_at_y_axis) {
                    curr_shape = (ConvexShape)curr_shape.mirror_vertical(Point.ZERO);
                }
                ConvexShape translated_shape = (ConvexShape)curr_shape.translate_by(rel_location);
                if (component_rotation % 90.0 == 0.0) {
                    int component_ninety_degree_factor = (int)component_rotation / 90;
                    if (component_ninety_degree_factor != 0) {
                        translated_shape = (ConvexShape)translated_shape.turn_90_degree(component_ninety_degree_factor, Point.ZERO);
                    }
                } else {
                    translated_shape = (ConvexShape)translated_shape.rotate_approx(Math.toRadians(component_rotation), FloatPoint.ZERO);
                }
                if (!component.placed_on_front() && this.board.components.get_flip_style_rotate_first()) {
                    translated_shape = (ConvexShape)translated_shape.mirror_vertical(Point.ZERO);
                }
                this.precalculated_shapes[index] = (ConvexShape)translated_shape.translate_by(component_translation);
            }
        }
        return this.precalculated_shapes[p_index];
    }

    int get_padstack_layer(int p_index) {
        Padstack padstack = this.get_padstack();
        Component component = this.board.components.get(this.get_component_no());
        int padstack_layer = component.placed_on_front() || padstack.placed_absolute ? p_index + this.first_layer() : padstack.board_layer_count() - p_index - this.first_layer() - 1;
        return padstack_layer;
    }

    public Collection<TraceExitRestriction> get_trace_exit_restrictions(int p_layer) {
        Collection<Direction> padstack_exit_directions;
        LinkedList<TraceExitRestriction> result = new LinkedList<TraceExitRestriction>();
        int padstack_layer = this.get_padstack_layer(p_layer - this.first_layer());
        double pad_xy_factor = 1.5;
        Component component = this.board.components.get(this.get_component_no());
        if (component != null && component.get_package().pin_count() <= 3) {
            pad_xy_factor *= 2.0;
        }
        if ((padstack_exit_directions = this.get_padstack().get_trace_exit_directions(padstack_layer, pad_xy_factor)).isEmpty()) {
            return result;
        }
        if (component == null) {
            return result;
        }
        Shape curr_shape = this.get_shape(p_layer - this.first_layer());
        if (!(curr_shape instanceof TileShape)) {
            return result;
        }
        TileShape pad_shape = (TileShape)curr_shape;
        double component_rotation = component.get_rotation_in_degree();
        Point pin_center = this.get_center();
        FloatPoint center_approx = pin_center.to_float();
        for (Direction curr_padstack_exit_direction : padstack_exit_directions) {
            Direction curr_exit_direction;
            Package.Pin package_pin;
            Package lib_package = component.get_package();
            if (lib_package == null || (package_pin = lib_package.get_pin(this.pin_no)) == null) continue;
            double curr_rotation_in_degree = component_rotation + package_pin.rotation_in_degree;
            if (curr_rotation_in_degree % 45.0 == 0.0) {
                int fortyfive_degree_factor = (int)curr_rotation_in_degree / 45;
                curr_exit_direction = curr_padstack_exit_direction.turn_45_degree(fortyfive_degree_factor);
            } else {
                double curr_angle_in_radian = Math.toRadians(curr_rotation_in_degree) + curr_padstack_exit_direction.angle_approx();
                curr_exit_direction = Direction.get_instance_approx(curr_angle_in_radian);
            }
            int intersecting_border_line_no = pad_shape.intersecting_border_line_no(pin_center, curr_exit_direction);
            if (intersecting_border_line_no < 0) {
                FRLogger.warn("Pin.get_trace_exit_restrictions: border line not found");
                continue;
            }
            Line curr_exit_line = new Line(pin_center, curr_exit_direction);
            FloatPoint nearest_border_point = curr_exit_line.intersection_approx(pad_shape.border_line(intersecting_border_line_no));
            TraceExitRestriction curr_exit_restriction = new TraceExitRestriction(curr_exit_direction, center_approx.distance(nearest_border_point));
            result.add(curr_exit_restriction);
        }
        return result;
    }

    public boolean has_trace_exit_restrictions() {
        for (int i = this.first_layer(); i <= this.last_layer(); ++i) {
            Collection<TraceExitRestriction> curr_exit_restrictions = this.get_trace_exit_restrictions(i);
            if (curr_exit_restrictions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean drill_allowed() {
        return this.first_layer() == this.last_layer();
    }

    @Override
    public boolean is_obstacle(Item p_other) {
        if (p_other == this || p_other instanceof ObstacleArea) {
            return false;
        }
        if (!p_other.shares_net(this)) {
            return true;
        }
        if (p_other instanceof Trace) {
            return false;
        }
        return !this.drill_allowed() || !(p_other instanceof Via) || !((Via)p_other).attach_allowed;
    }

    @Override
    public void turn_90_degree(int p_factor, IntPoint p_pole) {
        this.set_center(null);
        this.clear_derived_data();
    }

    @Override
    public void rotate_approx(double p_angle_in_degree, FloatPoint p_pole) {
        this.set_center(null);
        this.clear_derived_data();
    }

    @Override
    public void change_placement_side(IntPoint p_pole) {
        this.set_center(null);
        this.clear_derived_data();
    }

    @Override
    public void clear_derived_data() {
        super.clear_derived_data();
        this.precalculated_shapes = null;
    }

    public Set<Pin> get_swappable_pins() {
        TreeSet<Pin> result = new TreeSet<Pin>();
        Component component = this.board.components.get(this.get_component_no());
        if (component == null) {
            return result;
        }
        LogicalPart logical_part = component.get_logical_part();
        if (logical_part == null) {
            return result;
        }
        LogicalPart.PartPin this_part_pin = logical_part.get_pin(this.pin_no);
        if (this_part_pin == null) {
            return result;
        }
        if (this_part_pin.gate_pin_swap_code <= 0) {
            return result;
        }
        for (int i = 0; i < logical_part.pin_count(); ++i) {
            LogicalPart.PartPin curr_part_pin;
            if (i == this.pin_no || (curr_part_pin = logical_part.get_pin(i)) == null || curr_part_pin.gate_pin_swap_code != this_part_pin.gate_pin_swap_code || !curr_part_pin.gate_name.equals(this_part_pin.gate_name)) continue;
            Pin curr_swappeble_pin = this.board.get_pin(this.get_component_no(), curr_part_pin.pin_no);
            if (curr_swappeble_pin != null) {
                result.add(curr_swappeble_pin);
                continue;
            }
            FRLogger.warn("Pin.get_swappable_pins: swappable pin not found");
        }
        return result;
    }

    @Override
    public boolean is_selected_by_filter(ItemSelectionFilter p_filter) {
        if (!this.is_selected_by_fixed_filter(p_filter)) {
            return false;
        }
        return p_filter.is_selected(ItemSelectionFilter.SelectableChoices.PINS);
    }

    @Override
    public Color[] get_draw_colors(GraphicsContext p_graphics_context) {
        Color[] result = this.net_count() > 0 ? p_graphics_context.get_pin_colors() : p_graphics_context.get_obstacle_colors();
        return result;
    }

    @Override
    public double get_draw_intensity(GraphicsContext p_graphics_context) {
        return p_graphics_context.get_pin_color_intensity();
    }

    public boolean swap(Pin p_other) {
        if (this.net_count() > 1 || p_other.net_count() > 1) {
            FRLogger.warn("Pin.swap not yet implemented for pins belonging to more than 1 net ");
            return false;
        }
        int this_net_no = this.net_count() > 0 ? this.get_net_no(0) : 0;
        int other_net_no = p_other.net_count() > 0 ? p_other.get_net_no(0) : 0;
        this.assign_net_no(other_net_no);
        p_other.assign_net_no(this_net_no);
        Pin tmp = this.changed_to;
        this.changed_to = p_other.changed_to;
        p_other.changed_to = tmp;
        return true;
    }

    public Pin get_changed_to() {
        return this.changed_to;
    }

    @Override
    public boolean write(ObjectOutputStream p_stream) {
        try {
            p_stream.writeObject(this);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean is_placed_on_front() {
        boolean result = true;
        Component component = this.board.components.get(this.get_component_no());
        if (component != null) {
            result = component.placed_on_front();
        }
        return result;
    }

    public double get_min_width(int p_layer) {
        int padstack_layer = this.get_padstack_layer(p_layer - this.first_layer());
        ConvexShape padstack_shape = this.get_padstack().get_shape(padstack_layer);
        if (padstack_shape == null) {
            FRLogger.warn("Pin.get_min_width: padstack_shape is null");
            return 0.0;
        }
        IntBox padstack_bounding_box = padstack_shape.bounding_box();
        if (padstack_bounding_box == null) {
            FRLogger.warn("Pin.get_min_width: padstack_bounding_box is null");
            return 0.0;
        }
        return padstack_bounding_box.min_width();
    }

    public int get_trace_neckdown_halfwidth(int p_layer) {
        double result = Math.max(0.5 * this.get_min_width(p_layer) - 1.0, 1.0);
        return (int)result;
    }

    public double get_max_width(int p_layer) {
        int padstack_layer = this.get_padstack_layer(p_layer - this.first_layer());
        ConvexShape padstack_shape = this.get_padstack().get_shape(padstack_layer);
        if (padstack_shape == null) {
            FRLogger.warn("Pin.get_max_width: padstack_shape is null");
            return 0.0;
        }
        IntBox padstack_bounding_box = padstack_shape.bounding_box();
        if (padstack_bounding_box == null) {
            FRLogger.warn("Pin.get_max_width: padstack_bounding_box is null");
            return 0.0;
        }
        return padstack_bounding_box.max_width();
    }

    @Override
    public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
        TextManager tm = new TextManager(this.getClass(), p_locale);
        p_window.append_bold(tm.getText("pin", new String[0]) + ": ");
        p_window.append(tm.getText("component_2", new String[0]) + " ");
        Component component = this.board.components.get(this.get_component_no());
        p_window.append(component.name, tm.getText("component_info", new String[0]), component);
        p_window.append(", " + tm.getText("pin_2", new String[0]) + " ");
        p_window.append(component.get_package().get_pin((int)this.pin_no).name);
        p_window.append(", " + tm.getText("padstack", new String[0]) + " ");
        Padstack padstack = this.get_padstack();
        p_window.append(padstack.name, tm.getText("padstack_info", new String[0]), padstack);
        p_window.append(" " + tm.getText("at", new String[0]) + " ");
        p_window.append(this.get_center().to_float());
        this.print_connectable_item_info(p_window, p_locale);
        p_window.newline();
    }

    @Override
    public String get_hover_info(Locale p_locale) {
        TextManager tm = new TextManager(this.getClass(), p_locale);
        Component component = this.board.components.get(this.get_component_no());
        Padstack padstack = this.get_padstack();
        String hover_info = tm.getText("pin", new String[0]) + " : " + tm.getText("component_2", new String[0]) + " " + component.name + " " + tm.getText("pin_2", new String[0]) + " " + component.get_package().get_pin((int)this.pin_no).name + " " + tm.getText("padstack", new String[0]) + " " + padstack.name + " " + this.get_connectable_item_hover_info(p_locale);
        return hover_info;
    }

    Direction calc_nearest_exit_restriction_direction(Polyline p_trace_polyline, int p_trace_half_width, int p_layer) {
        Collection<TraceExitRestriction> trace_exit_restrictions = this.get_trace_exit_restrictions(p_layer);
        if (trace_exit_restrictions.isEmpty()) {
            return null;
        }
        Shape pin_shape = this.get_shape(p_layer - this.first_layer());
        Point pin_center = this.get_center();
        if (!(pin_shape instanceof TileShape)) {
            return null;
        }
        double edge_to_turn_dist = this.board.rules.get_pin_edge_to_turn_dist();
        if (edge_to_turn_dist < 0.0) {
            return null;
        }
        TileShape offset_pin_shape = (TileShape)((TileShape)pin_shape).offset(edge_to_turn_dist + (double)p_trace_half_width);
        int[][] entries = offset_pin_shape.entrance_points(p_trace_polyline);
        if (entries.length == 0) {
            return null;
        }
        int[] latest_entry_tuple = entries[entries.length - 1];
        FloatPoint trace_entry_location_approx = p_trace_polyline.arr[latest_entry_tuple[0]].intersection_approx(offset_pin_shape.border_line(latest_entry_tuple[1]));
        double min_exit_corner_distance = Double.MAX_VALUE;
        FloatPoint nearest_exit_corner = null;
        Direction pin_exit_direction = null;
        double TOLERANCE = 1.0;
        for (TraceExitRestriction curr_exit_restriction : trace_exit_restrictions) {
            int curr_intersecting_border_line_no = offset_pin_shape.intersecting_border_line_no(pin_center, curr_exit_restriction.direction);
            Line curr_pin_exit_ray = new Line(pin_center, curr_exit_restriction.direction);
            FloatPoint curr_exit_corner = curr_pin_exit_ray.intersection_approx(offset_pin_shape.border_line(curr_intersecting_border_line_no));
            double curr_exit_corner_distance = curr_exit_corner.distance_square(trace_entry_location_approx);
            boolean new_nearest_corner_found = false;
            if (curr_exit_corner_distance + 1.0 < min_exit_corner_distance) {
                new_nearest_corner_found = true;
            } else if (curr_exit_corner_distance < min_exit_corner_distance + 1.0) {
                for (int i = 1; i < p_trace_polyline.corner_count(); ++i) {
                    double old_trace_corner_distance;
                    FloatPoint curr_trace_corner = p_trace_polyline.corner_approx(i);
                    double curr_trace_corner_distance = curr_trace_corner.distance_square(curr_exit_corner);
                    if (curr_trace_corner_distance + 1.0 < (old_trace_corner_distance = curr_trace_corner.distance_square(nearest_exit_corner))) {
                        new_nearest_corner_found = true;
                        break;
                    }
                    if (curr_trace_corner_distance > old_trace_corner_distance + 1.0) break;
                }
            }
            if (!new_nearest_corner_found) continue;
            min_exit_corner_distance = curr_exit_corner_distance;
            pin_exit_direction = curr_exit_restriction.direction;
            nearest_exit_corner = curr_exit_corner;
        }
        return pin_exit_direction;
    }

    public FloatPoint nearest_trace_exit_corner(FloatPoint p_from_point, int p_trace_half_width, int p_layer) {
        Collection<TraceExitRestriction> trace_exit_restrictions = this.get_trace_exit_restrictions(p_layer);
        if (trace_exit_restrictions.isEmpty()) {
            return null;
        }
        Shape pin_shape = this.get_shape(p_layer - this.first_layer());
        Point pin_center = this.get_center();
        if (!(pin_shape instanceof TileShape)) {
            return null;
        }
        double edge_to_turn_dist = this.board.rules.get_pin_edge_to_turn_dist();
        if (edge_to_turn_dist < 0.0) {
            return null;
        }
        TileShape offset_pin_shape = (TileShape)((TileShape)pin_shape).offset(edge_to_turn_dist + (double)p_trace_half_width);
        double min_exit_corner_distance = Double.MAX_VALUE;
        FloatPoint nearest_exit_corner = null;
        for (TraceExitRestriction curr_exit_restriction : trace_exit_restrictions) {
            Line curr_pin_exit_ray = new Line(pin_center, curr_exit_restriction.direction);
            int curr_intersecting_border_line_no = offset_pin_shape.intersecting_border_line_no(pin_center, curr_exit_restriction.direction);
            FloatPoint curr_exit_corner = curr_pin_exit_ray.intersection_approx(offset_pin_shape.border_line(curr_intersecting_border_line_no));
            double curr_exit_corner_distance = curr_exit_corner.distance_square(p_from_point);
            if (!(curr_exit_corner_distance < min_exit_corner_distance)) continue;
            min_exit_corner_distance = curr_exit_corner_distance;
            nearest_exit_corner = curr_exit_corner;
        }
        return nearest_exit_corner;
    }

    @Override
    public String toString() {
        StringBuilder simpleName = new StringBuilder();
        simpleName.append(this.getClass().getSimpleName().toLowerCase());
        if (this.pin_no > 0) {
            simpleName.append(" #");
            simpleName.append(this.pin_no);
        }
        if (this.component_no > 0) {
            simpleName.append(" of component #");
            simpleName.append(this.component_no);
        }
        return simpleName.toString();
    }

    public static class TraceExitRestriction {
        public final Direction direction;
        public final double min_length;

        public TraceExitRestriction(Direction p_direction, double p_min_length) {
            this.direction = p_direction;
            this.min_length = p_min_length;
        }
    }
}

