/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.board.PrintableShape;
import app.freerouting.board.Unit;
import app.freerouting.geometry.planar.Circle;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.PolylineShape;
import app.freerouting.geometry.planar.Shape;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.util.Locale;

public class CoordinateTransform
implements Serializable {
    public final Unit user_unit;
    public final double user_unit_factor;
    public final Unit board_unit;
    public final double board_unit_factor;
    private final double scale_factor;

    public CoordinateTransform(double p_user_unit_factor, Unit p_user_unit, double p_board_unit_factor, Unit p_board_unit) {
        this.user_unit = p_user_unit;
        this.board_unit = p_board_unit;
        this.user_unit_factor = p_user_unit_factor;
        this.board_unit_factor = p_board_unit_factor;
        this.scale_factor = this.board_unit_factor / this.user_unit_factor;
        if (this.user_unit_factor != 1.0) {
            throw new RuntimeException("user_unit_factor must be 1.0");
        }
    }

    public double board_to_user(double p_value) {
        return Unit.scale(p_value * this.scale_factor, this.board_unit, this.user_unit);
    }

    public double user_to_board(double p_value) {
        return Unit.scale(p_value / this.scale_factor, this.user_unit, this.board_unit);
    }

    public FloatPoint board_to_user(FloatPoint p_point) {
        return new FloatPoint(this.board_to_user(p_point.x), this.board_to_user(p_point.y));
    }

    public FloatPoint user_to_board(FloatPoint p_point) {
        return new FloatPoint(this.user_to_board(p_point.x), this.user_to_board(p_point.y));
    }

    public PrintableShape board_to_user(Shape p_shape, Locale p_locale) {
        PrintableShape result;
        if (p_shape instanceof Circle) {
            Circle circle = (Circle)p_shape;
            result = this.board_to_user(circle, p_locale);
        } else if (p_shape instanceof IntBox) {
            IntBox box = (IntBox)p_shape;
            result = this.board_to_user(box, p_locale);
        } else if (p_shape instanceof PolylineShape) {
            PolylineShape shape = (PolylineShape)p_shape;
            result = this.board_to_user(shape, p_locale);
        } else {
            FRLogger.warn("CoordinateTransform.board_to_user not yet implemented for p_shape");
            result = null;
        }
        return result;
    }

    public PrintableShape.Circle board_to_user(Circle p_circle, Locale p_locale) {
        return new PrintableShape.Circle(this.board_to_user(p_circle.center.to_float()), this.board_to_user(p_circle.radius), p_locale);
    }

    public PrintableShape.Rectangle board_to_user(IntBox p_box, Locale p_locale) {
        return new PrintableShape.Rectangle(this.board_to_user(p_box.ll.to_float()), this.board_to_user(p_box.ur.to_float()), p_locale);
    }

    public PrintableShape.Polygon board_to_user(PolylineShape p_shape, Locale p_locale) {
        FloatPoint[] corners = p_shape.corner_approx_arr();
        FloatPoint[] transformed_corners = new FloatPoint[corners.length];
        for (int i = 0; i < corners.length; ++i) {
            transformed_corners[i] = this.board_to_user(corners[i]);
        }
        return new PrintableShape.Polygon(transformed_corners, p_locale);
    }
}

