/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.board.ItemIdentificationNumberGenerator;
import app.freerouting.core.RoutingJob;
import app.freerouting.gui.FileFormat;
import app.freerouting.interactive.HeadlessBoardManager;
import app.freerouting.logger.FRLogger;

public class BoardLoader {
    private BoardLoader() {
    }

    public static boolean loadBoardIfNeeded(RoutingJob job) {
        if (job.board != null) {
            return true;
        }
        if (job.input == null) {
            FRLogger.error("Cannot load board: job has no input", null);
            return false;
        }
        if (job.input.format != FileFormat.DSN) {
            FRLogger.error("Cannot load board: only DSN format is supported, got " + String.valueOf((Object)job.input.format), null);
            return false;
        }
        try {
            HeadlessBoardManager boardManager = new HeadlessBoardManager(null, job);
            boardManager.loadFromSpecctraDsn(job.input.getData(), null, new ItemIdentificationNumberGenerator());
            job.board = boardManager.get_routing_board();
            return job.board != null;
        }
        catch (Exception e) {
            FRLogger.error("Failed to load board from DSN file", e);
            return false;
        }
    }
}

