/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.autoroute.AutorouteControl;
import app.freerouting.board.BoardOutline;
import app.freerouting.board.ChangedArea;
import app.freerouting.board.Communication;
import app.freerouting.board.ComponentObstacleArea;
import app.freerouting.board.ComponentOutline;
import app.freerouting.board.Components;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.Connectable;
import app.freerouting.board.FixedState;
import app.freerouting.board.Item;
import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.board.LayerStructure;
import app.freerouting.board.ObstacleArea;
import app.freerouting.board.Pin;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.SearchTreeManager;
import app.freerouting.board.SearchTreeObject;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.board.ViaObstacleArea;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.core.BoardLibrary;
import app.freerouting.core.Padstack;
import app.freerouting.datastructures.ShapeTree;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.geometry.planar.Area;
import app.freerouting.geometry.planar.ConvexShape;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.geometry.planar.PolylineShape;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.BoardRules;
import java.awt.Graphics;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

public class BasicBoard
implements Serializable {
    public final UndoableObjects item_list;
    public final Components components;
    public final BoardRules rules;
    public final BoardLibrary library;
    public final LayerStructure layer_structure;
    public final Communication communication;
    public final IntBox bounding_box;
    public transient SearchTreeManager search_tree_manager;
    private transient IntBox update_box = IntBox.EMPTY;
    private int max_trace_half_width = 1000;
    private int min_trace_half_width = 10000;

    public BasicBoard(IntBox p_bounding_box, LayerStructure p_layer_structure, PolylineShape[] p_outline_shapes, int p_outline_cl_class_no, BoardRules p_rules, Communication p_communication) {
        this.layer_structure = p_layer_structure;
        this.rules = p_rules;
        this.library = new BoardLibrary();
        this.item_list = new UndoableObjects();
        this.components = new Components();
        this.communication = p_communication;
        this.bounding_box = p_bounding_box;
        this.search_tree_manager = new SearchTreeManager(this);
        p_rules.nets.set_board(this);
        this.insert_outline(p_outline_shapes, p_outline_cl_class_no);
    }

    public static BasicBoard deserialize(byte[] object_byte_array) {
        try {
            ByteArrayInputStream input_stream = new ByteArrayInputStream(object_byte_array);
            ObjectInputStream object_stream = new ObjectInputStream(input_stream);
            return (BasicBoard)object_stream.readObject();
        }
        catch (Exception e) {
            FRLogger.error("Couldn't deserialize board", e);
            return null;
        }
    }

    private static String convert_byte_array_to_hex_string(byte[] arrayBytes) {
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < arrayBytes.length; ++i) {
            stringBuffer.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    public byte[] serialize(boolean basicProfile) {
        try {
            ByteArrayOutputStream output_stream = new ByteArrayOutputStream();
            ObjectOutputStream object_stream = new ObjectOutputStream(output_stream);
            if (basicProfile) {
                object_stream.writeObject(this.get_traces());
                object_stream.writeObject(this.get_vias());
                object_stream.writeObject(this.item_list);
            } else {
                object_stream.writeObject(this);
            }
            object_stream.close();
            return output_stream.toByteArray();
        }
        catch (Exception e) {
            FRLogger.error("Couldn't serialize board", e);
            return null;
        }
    }

    public BasicBoard clone() {
        return BasicBoard.deserialize(this.serialize(false));
    }

    public String get_hash() {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(this.serialize(true));
            byte[] hashedBytes = digest.digest();
            return BasicBoard.convert_byte_array_to_hex_string(hashedBytes);
        }
        catch (Exception e) {
            FRLogger.error("Couldn't calculate hash for board", e);
            return null;
        }
    }

    public int diff_traces(BasicBoard compare_to) {
        int result = 0;
        HashSet<Integer> traceIds = new HashSet<Integer>();
        for (Trace trace : this.get_traces()) {
            traceIds.add(trace.get_id_no());
        }
        for (Trace trace : compare_to.get_traces()) {
            if (!traceIds.contains(trace.get_id_no())) {
                ++result;
                continue;
            }
            traceIds.remove(trace.get_id_no());
        }
        return result += traceIds.size();
    }

    public PolylineTrace insert_trace_without_cleaning(Polyline p_polyline, int p_layer, int p_half_width, int[] p_net_no_arr, int p_clearance_class, FixedState p_fixed_state) {
        if (p_polyline.corner_count() < 2) {
            return null;
        }
        PolylineTrace new_trace = new PolylineTrace(p_polyline, p_layer, p_half_width, p_net_no_arr, p_clearance_class, 0, 0, p_fixed_state, this);
        if (new_trace.first_corner().equals(new_trace.last_corner()) && p_fixed_state.ordinal() < FixedState.USER_FIXED.ordinal()) {
            return null;
        }
        this.insert_item(new_trace);
        if (new_trace.nets_normal()) {
            this.max_trace_half_width = Math.max(this.max_trace_half_width, p_half_width);
            this.min_trace_half_width = Math.min(this.min_trace_half_width, p_half_width);
        }
        return new_trace;
    }

    public void insert_trace(Polyline p_polyline, int p_layer, int p_half_width, int[] p_net_no_arr, int p_clearance_class, FixedState p_fixed_state) {
        PolylineTrace new_trace = this.insert_trace_without_cleaning(p_polyline, p_layer, p_half_width, p_net_no_arr, p_clearance_class, p_fixed_state);
        if (new_trace == null) {
            return;
        }
        IntOctagon clip_shape = null;
        BasicBoard basicBoard = this;
        if (basicBoard instanceof RoutingBoard) {
            RoutingBoard board = (RoutingBoard)basicBoard;
            ChangedArea changed_area = board.changed_area;
            if (changed_area != null) {
                clip_shape = changed_area.get_area(p_layer);
            }
        }
        try {
            new_trace.normalize(clip_shape);
        }
        catch (Exception e) {
            FRLogger.error("Couldn't insert new trace, because its normalization failed.", e);
        }
    }

    public void insert_trace(Point[] p_points, int p_layer, int p_half_width, int[] p_net_no_arr, int p_clearance_class, FixedState p_fixed_state) {
        for (int i = 0; i < p_points.length; ++i) {
            if (this.bounding_box.contains(p_points[i])) continue;
            FRLogger.warn("LayeredBoard.insert_trace: input point out of range");
        }
        Polyline poly = new Polyline(p_points);
        this.insert_trace(poly, p_layer, p_half_width, p_net_no_arr, p_clearance_class, p_fixed_state);
    }

    public Via insert_via(Padstack p_padstack, Point p_center, int[] p_net_no_arr, int p_clearance_class, FixedState p_fixed_state, boolean p_attach_allowed) {
        Via new_via = new Via(p_padstack, p_center, p_net_no_arr, p_clearance_class, 0, 0, p_fixed_state, p_attach_allowed, this);
        this.insert_item(new_via);
        int from_layer = p_padstack.from_layer();
        int to_layer = p_padstack.to_layer();
        for (int i = from_layer; i < to_layer; ++i) {
            for (int curr_net_no : p_net_no_arr) {
                this.split_traces(p_center, i, curr_net_no);
            }
        }
        return new_via;
    }

    public Pin insert_pin(int p_component_no, int p_pin_no, int[] p_net_no_arr, int p_clearance_class, FixedState p_fixed_state) {
        Pin new_pin = new Pin(p_component_no, p_pin_no, p_net_no_arr, p_clearance_class, 0, p_fixed_state, this);
        this.insert_item(new_pin);
        return new_pin;
    }

    public ObstacleArea insert_obstacle(Area p_area, int p_layer, int p_clearance_class, FixedState p_fixed_state) {
        if (p_area == null) {
            FRLogger.warn("BasicBoard.insert_obstacle: p_area is null");
            return null;
        }
        ObstacleArea obs = new ObstacleArea(p_area, p_layer, Vector.ZERO, 0.0, false, p_clearance_class, 0, 0, null, p_fixed_state, this);
        this.insert_item(obs);
        return obs;
    }

    public ObstacleArea insert_obstacle(Area p_area, int p_layer, Vector p_translation, double p_rotation_in_degree, boolean p_side_changed, int p_clearance_class, int p_component_no, String p_name, FixedState p_fixed_state) {
        if (p_area == null) {
            FRLogger.warn("BasicBoard.insert_obstacle: p_area is null");
            return null;
        }
        ObstacleArea obs = new ObstacleArea(p_area, p_layer, p_translation, p_rotation_in_degree, p_side_changed, p_clearance_class, 0, p_component_no, p_name, p_fixed_state, this);
        this.insert_item(obs);
        return obs;
    }

    public ViaObstacleArea insert_via_obstacle(Area p_area, int p_layer, int p_clearance_class, FixedState p_fixed_state) {
        if (p_area == null) {
            FRLogger.warn("BasicBoard.insert_via_obstacle: p_area is null");
            return null;
        }
        ViaObstacleArea obs = new ViaObstacleArea(p_area, p_layer, Vector.ZERO, 0.0, false, p_clearance_class, 0, 0, null, p_fixed_state, this);
        this.insert_item(obs);
        return obs;
    }

    public ViaObstacleArea insert_via_obstacle(Area p_area, int p_layer, Vector p_translation, double p_rotation_in_degree, boolean p_side_changed, int p_clearance_class, int p_component_no, String p_name, FixedState p_fixed_state) {
        if (p_area == null) {
            FRLogger.warn("BasicBoard.insert_via_obstacle: p_area is null");
            return null;
        }
        ViaObstacleArea obs = new ViaObstacleArea(p_area, p_layer, p_translation, p_rotation_in_degree, p_side_changed, p_clearance_class, 0, p_component_no, p_name, p_fixed_state, this);
        this.insert_item(obs);
        return obs;
    }

    public ComponentObstacleArea insert_component_obstacle(Area p_area, int p_layer, int p_clearance_class, FixedState p_fixed_state) {
        if (p_area == null) {
            FRLogger.warn("BasicBoard.insert_component_obstacle: p_area is null");
            return null;
        }
        ComponentObstacleArea obs = new ComponentObstacleArea(p_area, p_layer, Vector.ZERO, 0.0, false, p_clearance_class, 0, 0, null, p_fixed_state, this);
        this.insert_item(obs);
        return obs;
    }

    public ComponentObstacleArea insert_component_obstacle(Area p_area, int p_layer, Vector p_translation, double p_rotation_in_degree, boolean p_side_changed, int p_clearance_class, int p_component_no, String p_name, FixedState p_fixed_state) {
        if (p_area == null) {
            FRLogger.warn("BasicBoard.insert_component_obstacle: p_area is null");
            return null;
        }
        ComponentObstacleArea obs = new ComponentObstacleArea(p_area, p_layer, p_translation, p_rotation_in_degree, p_side_changed, p_clearance_class, 0, p_component_no, p_name, p_fixed_state, this);
        this.insert_item(obs);
        return obs;
    }

    public ComponentOutline insert_component_outline(Area p_area, boolean p_is_front, Vector p_translation, double p_rotation_in_degree, int p_component_no, FixedState p_fixed_state) {
        if (p_area == null) {
            FRLogger.warn("BasicBoard.insert_component_outline: p_area is null");
            return null;
        }
        if (!p_area.is_bounded()) {
            FRLogger.warn("BasicBoard.insert_component_outline: p_area is not bounded");
            return null;
        }
        ComponentOutline outline = new ComponentOutline(p_area, p_is_front, p_translation, p_rotation_in_degree, 0, p_component_no, p_fixed_state, this);
        this.insert_item(outline);
        return outline;
    }

    public ConductionArea insert_conduction_area(Area p_area, int p_layer, int[] p_net_no_arr, int p_clearance_class, boolean p_is_obstacle, FixedState p_fixed_state) {
        if (p_area == null) {
            FRLogger.warn("BasicBoard.insert_conduction_area: p_area is null");
            return null;
        }
        ConductionArea c = new ConductionArea(p_area, p_layer, Vector.ZERO, 0.0, false, p_net_no_arr, p_clearance_class, 0, 0, null, p_is_obstacle, p_fixed_state, this);
        this.insert_item(c);
        return c;
    }

    public BoardOutline insert_outline(PolylineShape[] p_outline_shapes, int p_clearance_class_no) {
        BoardOutline result = new BoardOutline(p_outline_shapes, p_clearance_class_no, 0, this);
        this.insert_item(result);
        return result;
    }

    public BoardOutline get_outline() {
        UndoableObjects.Storable curr_item;
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = this.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof BoardOutline)) continue;
            BoardOutline outline = (BoardOutline)curr_item;
            return outline;
        }
        return null;
    }

    public void remove_item(Item p_item) {
        if (p_item == null) {
            return;
        }
        this.additional_update_after_change(p_item);
        this.search_tree_manager.remove(p_item);
        this.item_list.delete(p_item);
        if (this.communication != null && this.communication.observers != null) {
            this.communication.observers.notify_deleted(p_item);
        }
    }

    public Item get_item(int p_id_no) {
        Item curr_item;
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = (Item)this.item_list.read_object(it)) != null) {
            if (curr_item.get_id_no() != p_id_no) continue;
            return curr_item;
        }
        return null;
    }

    public Collection<Item> get_items() {
        Item curr_item;
        LinkedList<Item> result = new LinkedList<Item>();
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = (Item)this.item_list.read_object(it)) != null) {
            result.add(curr_item);
        }
        return result;
    }

    public Collection<Item> get_connectable_items(int p_net_no) {
        Item curr_item;
        LinkedList<Item> result = new LinkedList<Item>();
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = (Item)this.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof Connectable) || !curr_item.contains_net(p_net_no)) continue;
            result.add(curr_item);
        }
        return result;
    }

    public int connectable_item_count(int p_net_no) {
        Item curr_item;
        int result = 0;
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = (Item)this.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof Connectable) || !curr_item.contains_net(p_net_no)) continue;
            ++result;
        }
        return result;
    }

    public Collection<Item> get_component_items(int p_component_no) {
        Item curr_item;
        LinkedList<Item> result = new LinkedList<Item>();
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = (Item)this.item_list.read_object(it)) != null) {
            if (curr_item.get_component_no() != p_component_no) continue;
            result.add(curr_item);
        }
        return result;
    }

    public Collection<Pin> get_component_pins(int p_component_no) {
        Item curr_item;
        LinkedList<Pin> result = new LinkedList<Pin>();
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = (Item)this.item_list.read_object(it)) != null) {
            if (curr_item.get_component_no() != p_component_no || !(curr_item instanceof Pin)) continue;
            Pin pin = (Pin)curr_item;
            result.add(pin);
        }
        return result;
    }

    public Pin get_pin(int p_component_no, int p_pin_no) {
        Item curr_item;
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = (Item)this.item_list.read_object(it)) != null) {
            if (curr_item.get_component_no() != p_component_no || !(curr_item instanceof Pin)) continue;
            Pin curr_pin = (Pin)curr_item;
            if (curr_pin.pin_no != p_pin_no) continue;
            return curr_pin;
        }
        return null;
    }

    public boolean remove_items(Collection<Item> p_item_list) {
        boolean result = true;
        for (Item curr_item : p_item_list) {
            if (curr_item.isDeletionForbidden() || curr_item.is_user_fixed()) {
                result = false;
                continue;
            }
            this.remove_item(curr_item);
        }
        return result;
    }

    public Collection<ConductionArea> get_conduction_areas() {
        UndoableObjects.Storable curr_item;
        LinkedList<ConductionArea> result = new LinkedList<ConductionArea>();
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = this.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof ConductionArea)) continue;
            ConductionArea area = (ConductionArea)curr_item;
            result.add(area);
        }
        return result;
    }

    public Collection<Pin> get_pins() {
        UndoableObjects.Storable curr_item;
        LinkedList<Pin> result = new LinkedList<Pin>();
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = this.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof Pin)) continue;
            Pin pin = (Pin)curr_item;
            result.add(pin);
        }
        return result;
    }

    public Collection<Pin> get_smd_pins() {
        UndoableObjects.Storable curr_item;
        LinkedList<Pin> result = new LinkedList<Pin>();
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = this.item_list.read_object(it)) != null) {
            Pin curr_pin;
            if (!(curr_item instanceof Pin) || (curr_pin = (Pin)curr_item).first_layer() != curr_pin.last_layer()) continue;
            result.add(curr_pin);
        }
        return result;
    }

    public Collection<Via> get_vias() {
        UndoableObjects.Storable curr_item;
        LinkedList<Via> result = new LinkedList<Via>();
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = this.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof Via)) continue;
            Via via = (Via)curr_item;
            result.add(via);
        }
        return result;
    }

    public Collection<Trace> get_traces() {
        UndoableObjects.Storable curr_item;
        LinkedList<Trace> result = new LinkedList<Trace>();
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = this.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof Trace)) continue;
            Trace trace = (Trace)curr_item;
            result.add(trace);
        }
        return result;
    }

    public double cumulative_trace_length() {
        UndoableObjects.Storable curr_item;
        double result = 0.0;
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = this.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof Trace)) continue;
            Trace trace = (Trace)curr_item;
            result += trace.get_length();
        }
        return result;
    }

    public boolean combine_traces(int p_net_no) {
        boolean result = false;
        boolean something_changed = true;
        block0: while (something_changed) {
            Item curr_item;
            something_changed = false;
            Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
            while ((curr_item = (Item)this.item_list.read_object(it)) != null) {
                if (p_net_no >= 0 && !curr_item.contains_net(p_net_no) || !(curr_item instanceof Trace)) continue;
                Trace trace = (Trace)curr_item;
                if (!curr_item.is_on_the_board() || !trace.combine()) continue;
                something_changed = true;
                result = true;
                continue block0;
            }
        }
        return result;
    }

    public boolean normalize_traces(int p_net_no) throws Exception {
        boolean result = false;
        boolean something_changed = true;
        block2: while (something_changed) {
            something_changed = false;
            Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
            while (true) {
                Item curr_item;
                try {
                    curr_item = (Item)this.item_list.read_object(it);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    something_changed = true;
                    continue block2;
                }
                if (curr_item == null) continue block2;
                if (!curr_item.contains_net(p_net_no) || !(curr_item instanceof PolylineTrace)) continue;
                PolylineTrace curr_trace = (PolylineTrace)curr_item;
                if (!curr_item.is_on_the_board()) continue;
                if (curr_trace.normalize(null)) {
                    something_changed = true;
                    result = true;
                    continue;
                }
                if (curr_trace.is_user_fixed() || !this.remove_if_cycle(curr_trace)) continue;
                something_changed = true;
                result = true;
            }
        }
        return result;
    }

    public boolean split_traces(Point p_location, int p_layer, int p_net_no) {
        ItemSelectionFilter filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.TRACES);
        Set<Item> picked_items = this.pick_items(p_location, p_layer, filter);
        IntOctagon location_shape = TileShape.get_instance(p_location).bounding_octagon();
        boolean trace_split = false;
        for (Item curr_item : picked_items) {
            Collection<PolylineTrace> split_pieces;
            Trace curr_trace = (Trace)curr_item;
            if (!curr_trace.contains_net(p_net_no) || (split_pieces = curr_trace.split(location_shape)).size() == 1) continue;
            trace_split = true;
        }
        return trace_split;
    }

    public Collection<Collection<Item>> get_connected_sets(int p_net_no) {
        Item curr_item;
        LinkedList<Collection<Item>> result = new LinkedList<Collection<Item>>();
        if (p_net_no <= 0) {
            return result;
        }
        TreeSet<Item> items_to_handle = new TreeSet<Item>();
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = (Item)this.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof Connectable) || !curr_item.contains_net(p_net_no)) continue;
            items_to_handle.add(curr_item);
        }
        Iterator it2 = items_to_handle.iterator();
        while (it2.hasNext()) {
            Item curr_item2 = (Item)it2.next();
            Set<Item> next_connected_set = curr_item2.get_connected_set(p_net_no);
            result.add(next_connected_set);
            items_to_handle.removeAll(next_connected_set);
            it2 = items_to_handle.iterator();
        }
        return result;
    }

    public Set<SearchTreeObject> overlapping_objects(ConvexShape p_shape, int p_layer) {
        return this.search_tree_manager.get_default_tree().overlapping_objects(p_shape, p_layer);
    }

    public Set<Item> overlapping_items_with_clearance(ConvexShape p_shape, int p_layer, int[] p_ignore_net_nos, int p_clearance_class) {
        ShapeSearchTree default_tree = this.search_tree_manager.get_default_tree();
        return default_tree.overlapping_items_with_clearance(p_shape, p_layer, p_ignore_net_nos, p_clearance_class);
    }

    public Set<Item> overlapping_items(Area p_area, int p_layer) {
        TreeSet<Item> result = new TreeSet<Item>();
        TileShape[] tile_shapes = p_area.split_to_convex();
        for (int i = 0; i < tile_shapes.length; ++i) {
            Set<SearchTreeObject> curr_overlaps = this.overlapping_objects(tile_shapes[i], p_layer);
            for (SearchTreeObject curr_overlap : curr_overlaps) {
                if (!(curr_overlap instanceof Item)) continue;
                Item item = (Item)curr_overlap;
                result.add(item);
            }
        }
        return result;
    }

    public boolean check_shape(Area p_shape, int p_layer, int[] p_net_no_arr, int p_cl_class) {
        TileShape[] tiles = p_shape.split_to_convex();
        ShapeSearchTree default_tree = this.search_tree_manager.get_default_tree();
        for (int i = 0; i < tiles.length; ++i) {
            TileShape curr_shape = tiles[i];
            if (!curr_shape.is_contained_in(this.bounding_box)) {
                return false;
            }
            TreeSet<SearchTreeObject> obstacles = new TreeSet<SearchTreeObject>();
            default_tree.overlapping_objects_with_clearance(curr_shape, p_layer, p_net_no_arr, p_cl_class, obstacles);
            for (SearchTreeObject curr_ob : obstacles) {
                boolean is_obstacle = true;
                for (int j = 0; j < p_net_no_arr.length; ++j) {
                    if (curr_ob.is_obstacle(p_net_no_arr[j])) continue;
                    is_obstacle = false;
                }
                if (!is_obstacle) continue;
                return false;
            }
        }
        return true;
    }

    public boolean check_trace_shape(TileShape p_shape, int p_layer, int[] p_net_no_arr, int p_cl_class, Set<Pin> p_contact_pins) {
        if (!p_shape.is_contained_in(this.bounding_box)) {
            return false;
        }
        ShapeSearchTree default_tree = this.search_tree_manager.get_default_tree();
        LinkedList<ShapeTree.TreeEntry> tree_entries = new LinkedList<ShapeTree.TreeEntry>();
        int[] ignore_net_nos = new int[]{};
        if (default_tree.is_clearance_compensation_used()) {
            default_tree.overlapping_tree_entries(p_shape, p_layer, ignore_net_nos, tree_entries);
        } else {
            default_tree.overlapping_tree_entries_with_clearance(p_shape, p_layer, ignore_net_nos, p_cl_class, tree_entries);
        }
        for (ShapeTree.TreeEntry curr_tree_entry : tree_entries) {
            ShapeTree.Storable storable = curr_tree_entry.object;
            if (!(storable instanceof Item)) continue;
            Item curr_item = (Item)storable;
            if (p_contact_pins != null) {
                if (p_contact_pins.contains(curr_item)) continue;
                if (curr_item instanceof Pin) {
                    return false;
                }
            }
            boolean is_obstacle = true;
            for (int i = 0; i < p_net_no_arr.length; ++i) {
                if (curr_item.is_trace_obstacle(p_net_no_arr[i])) continue;
                is_obstacle = false;
            }
            if (is_obstacle && curr_item instanceof PolylineTrace && p_contact_pins != null) {
                TileShape intersection = null;
                for (Pin curr_contact_pin : p_contact_pins) {
                    TileShape pin_shape;
                    if (curr_contact_pin.net_count() <= 1 || !curr_contact_pin.shares_net(curr_item)) continue;
                    if (intersection == null) {
                        TileShape obstacle_trace_shape = curr_item.get_tile_shape(curr_tree_entry.shape_index_in_object);
                        intersection = p_shape.intersection(obstacle_trace_shape);
                    }
                    if (!(pin_shape = curr_contact_pin.get_tile_shape_on_layer(p_layer)).contains_approx(intersection)) continue;
                    is_obstacle = false;
                    break;
                }
            }
            if (!is_obstacle) continue;
            return false;
        }
        return true;
    }

    public boolean check_polyline_trace(Polyline p_polyline, int p_layer, int p_pen_half_width, int[] p_net_no_arr, int p_clearance_class) {
        PolylineTrace tmp_trace = new PolylineTrace(p_polyline, p_layer, p_pen_half_width, p_net_no_arr, p_clearance_class, 0, 0, FixedState.NOT_FIXED, this);
        Set<Pin> contact_pins = tmp_trace.touching_pins_at_end_corners();
        for (int i = 0; i < ((Item)tmp_trace).tile_shape_count(); ++i) {
            if (this.check_trace_shape(tmp_trace.get_tile_shape(i), p_layer, p_net_no_arr, p_clearance_class, contact_pins)) continue;
            return false;
        }
        return true;
    }

    public int get_layer_count() {
        return this.layer_structure.arr.length;
    }

    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context) {
        if (p_graphics_context == null) {
            return;
        }
        for (int curr_priority = 1; curr_priority <= 3; ++curr_priority) {
            Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
            try {
                Item curr_item;
                while ((curr_item = (Item)this.item_list.read_object(it)) != null) {
                    if (curr_item.get_draw_priority() != curr_priority) continue;
                    curr_item.draw(p_graphics, p_graphics_context);
                }
                continue;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return;
            }
        }
    }

    public Set<Item> pick_items(Point p_location, int p_layer, ItemSelectionFilter p_filter) {
        IntBox point_shape = TileShape.get_instance(p_location);
        Set<SearchTreeObject> overlaps = this.overlapping_objects(point_shape, p_layer);
        Set<Item> result = new TreeSet<Item>();
        for (SearchTreeObject curr_object : overlaps) {
            if (!(curr_object instanceof Item)) continue;
            Item item = (Item)curr_object;
            result.add(item);
        }
        if (p_filter != null) {
            result = p_filter.filter(result);
        }
        return result;
    }

    public boolean contains(Point p_point) {
        return p_point.is_contained_in(this.bounding_box);
    }

    public int clearance_value(int p_class_1, int p_class_2, int p_layer) {
        if (this.rules == null || this.rules.clearance_matrix == null) {
            return 0;
        }
        return this.rules.clearance_matrix.get_value(p_class_1, p_class_2, p_layer, true);
    }

    public int get_max_trace_half_width() {
        return this.max_trace_half_width;
    }

    public int get_min_trace_half_width() {
        return this.min_trace_half_width;
    }

    public IntBox get_bounding_box() {
        return this.bounding_box;
    }

    public IntBox get_bounding_box(Collection<Item> p_item_list) {
        IntBox result = IntBox.EMPTY;
        for (Item curr_item : p_item_list) {
            result = result.union(curr_item.bounding_box());
        }
        return result;
    }

    public void reset_graphics_update_box() {
        this.update_box = IntBox.EMPTY;
    }

    public IntBox get_graphics_update_box() {
        return this.update_box;
    }

    public void join_graphics_update_box(IntBox p_box) {
        if (this.update_box == null) {
            this.reset_graphics_update_box();
        }
        this.update_box = this.update_box.union(p_box);
    }

    public void start_notify_observers() {
        if (this.communication != null && this.communication.observers != null) {
            this.communication.observers.activate();
        }
    }

    public void end_notify_observers() {
        if (this.communication != null && this.communication.observers != null) {
            this.communication.observers.deactivate();
        }
    }

    public boolean observers_active() {
        boolean result = this.communication != null && this.communication.observers != null ? this.communication.observers.is_active() : false;
        return result;
    }

    public Connectable make_conductive(ObstacleArea p_area, int p_net_no) {
        Area curr_area = p_area.get_relative_area();
        int layer = p_area.get_layer();
        FixedState fixed_state = p_area.get_fixed_state();
        Vector translation = p_area.get_translation();
        double rotation = p_area.get_rotation_in_degree();
        boolean side_changed = p_area.get_side_changed();
        int[] net_no_arr = new int[]{p_net_no};
        ConductionArea new_item = new ConductionArea(curr_area, layer, translation, rotation, side_changed, net_no_arr, p_area.clearance_class_no(), 0, p_area.get_component_no(), p_area.name, true, fixed_state, this);
        this.remove_item(p_area);
        this.insert_item(new_item);
        return new_item;
    }

    public void insert_item(Item p_item) {
        if (p_item == null) {
            return;
        }
        if (this.rules == null || this.rules.clearance_matrix == null || p_item.clearance_class_no() < 0 || p_item.clearance_class_no() >= this.rules.clearance_matrix.get_class_count()) {
            FRLogger.warn("LayeredBoard.insert_item: clearance_class no out of range");
            p_item.set_clearance_class_no(0);
        }
        p_item.board = this;
        this.item_list.insert(p_item);
        this.search_tree_manager.insert(p_item);
        if (this.communication != null && this.communication.observers != null) {
            this.communication.observers.notify_new(p_item);
        }
        this.additional_update_after_change(p_item);
    }

    public void additional_update_after_change(Item p_item) {
    }

    public boolean undo(Set<Integer> p_changed_nets) {
        int i;
        this.components.undo(this.communication.observers);
        LinkedList<UndoableObjects.Storable> cancelled_objects = new LinkedList<UndoableObjects.Storable>();
        LinkedList<UndoableObjects.Storable> restored_objects = new LinkedList<UndoableObjects.Storable>();
        boolean result = this.item_list.undo(cancelled_objects, restored_objects);
        for (Item item : cancelled_objects) {
            this.search_tree_manager.remove(item);
            if (this.communication != null && this.communication.observers != null) {
                this.communication.observers.notify_deleted(item);
            }
            if (p_changed_nets == null) continue;
            for (i = 0; i < item.net_count(); ++i) {
                p_changed_nets.add(item.get_net_no(i));
            }
        }
        for (Item item : restored_objects) {
            item.board = this;
            this.search_tree_manager.insert(item);
            item.clear_autoroute_info();
            if (this.communication != null && this.communication.observers != null) {
                this.communication.observers.notify_new(item);
            }
            if (p_changed_nets == null) continue;
            for (i = 0; i < item.net_count(); ++i) {
                p_changed_nets.add(item.get_net_no(i));
            }
        }
        return result;
    }

    public boolean redo(Set<Integer> p_changed_nets) {
        int i;
        this.components.redo(this.communication.observers);
        LinkedList<UndoableObjects.Storable> cancelled_objects = new LinkedList<UndoableObjects.Storable>();
        LinkedList<UndoableObjects.Storable> restored_objects = new LinkedList<UndoableObjects.Storable>();
        boolean result = this.item_list.redo(cancelled_objects, restored_objects);
        for (Item item : cancelled_objects) {
            this.search_tree_manager.remove(item);
            this.communication.observers.notify_deleted(item);
            if (p_changed_nets == null) continue;
            for (i = 0; i < item.net_count(); ++i) {
                p_changed_nets.add(item.get_net_no(i));
            }
        }
        for (Item item : restored_objects) {
            item.board = this;
            this.search_tree_manager.insert(item);
            item.clear_autoroute_info();
            if (this.communication != null && this.communication.observers != null) {
                this.communication.observers.notify_new(item);
            }
            if (p_changed_nets == null) continue;
            for (i = 0; i < item.net_count(); ++i) {
                p_changed_nets.add(item.get_net_no(i));
            }
        }
        return result;
    }

    public void generate_snapshot() {
        this.item_list.generate_snapshot();
        this.components.generate_snapshot();
    }

    public boolean pop_snapshot() {
        return this.item_list.pop_snapshot();
    }

    public Trace get_trace_tail(Point p_location, int p_layer, int[] p_net_no_arr) {
        IntBox point_shape = TileShape.get_instance(p_location);
        Set<SearchTreeObject> found_items = this.overlapping_objects(point_shape, p_layer);
        for (SearchTreeObject curr_ob : found_items) {
            Set<Item> contacts;
            Trace curr_trace;
            if (!(curr_ob instanceof Trace) || !(curr_trace = (Trace)curr_ob).nets_equal(p_net_no_arr)) continue;
            if (curr_trace.first_corner().equals(p_location) && (contacts = curr_trace.get_start_contacts()).isEmpty()) {
                return curr_trace;
            }
            if (!curr_trace.last_corner().equals(p_location) || !(contacts = curr_trace.get_end_contacts()).isEmpty()) continue;
            return curr_trace;
        }
        return null;
    }

    public boolean remove_if_cycle(Trace p_trace) {
        if (!p_trace.is_on_the_board()) {
            return false;
        }
        if (!p_trace.is_cycle()) {
            return false;
        }
        int curr_layer = p_trace.get_layer();
        int[] curr_net_no_arr = p_trace.net_no_arr;
        Point[] end_corners = new Point[]{p_trace.first_corner(), p_trace.last_corner()};
        boolean[] tail_at_endpoint_before = new boolean[2];
        for (int i = 0; i < 2; ++i) {
            Trace tail = this.get_trace_tail(end_corners[i], curr_layer, curr_net_no_arr);
            tail_at_endpoint_before[i] = tail != null;
        }
        Set<Item> connection_items = p_trace.get_connection_items();
        this.remove_items(connection_items);
        for (int i = 0; i < 2; ++i) {
            Trace tail;
            if (tail_at_endpoint_before[i] || (tail = this.get_trace_tail(end_corners[i], curr_layer, curr_net_no_arr)) == null) continue;
            this.remove_items(tail.get_connection_items());
        }
        return true;
    }

    private void readObject(ObjectInputStream p_stream) throws IOException, ClassNotFoundException {
        p_stream.defaultReadObject();
        this.search_tree_manager = new SearchTreeManager(this);
        for (Item curr_item : this.get_items()) {
            curr_item.board = this;
            this.search_tree_manager.insert(curr_item);
        }
    }

    public void delete_all_tracks_and_vias() {
        UndoableObjects.Storable curr_item;
        Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
        while ((curr_item = this.item_list.read_object(it)) != null) {
            if (curr_item instanceof Trace) {
                this.item_list.delete(curr_item);
            }
            if (!(curr_item instanceof Via)) continue;
            this.item_list.delete(curr_item);
        }
    }

    public void areThereItemsOnInactiveLayer(AutorouteControl p_ctrl) {
        if (this.get_layer_count() > 2) {
            UndoableObjects.Storable curr_ob;
            boolean hasSomethingOnInactiveLayer = false;
            Iterator<UndoableObjects.UndoableObjectNode> it = this.item_list.start_read_object();
            while ((curr_ob = this.item_list.read_object(it)) != null) {
                PolylineTrace curr_item;
                if (!(curr_ob instanceof PolylineTrace) || p_ctrl.layer_active[(curr_item = (PolylineTrace)curr_ob).get_layer()]) continue;
                hasSomethingOnInactiveLayer = true;
                FRLogger.warn("There is an item on an inactive layer.");
                break;
            }
        }
    }
}

