/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteEngine;
import app.freerouting.autoroute.CompleteExpansionRoom;
import app.freerouting.autoroute.CompleteFreeSpaceExpansionRoom;
import app.freerouting.autoroute.ExpansionDoor;
import app.freerouting.autoroute.ExpansionRoom;
import app.freerouting.autoroute.IncompleteFreeSpaceExpansionRoom;
import app.freerouting.autoroute.ItemAutorouteInfo;
import app.freerouting.autoroute.ObstacleExpansionRoom;
import app.freerouting.autoroute.SortedRoomNeighbours;
import app.freerouting.board.Item;
import app.freerouting.board.SearchTreeObject;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.datastructures.ShapeTree;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.logger.FRLogger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class Sorted45DegreeRoomNeighbours {
    public final CompleteExpansionRoom completed_room;
    public final SortedSet<SortedRoomNeighbour> sorted_neighbours;
    private final ExpansionRoom from_room;
    private final IntOctagon room_shape;
    private final boolean[] edge_interior_touches_obstacle;

    private Sorted45DegreeRoomNeighbours(ExpansionRoom p_from_room, CompleteExpansionRoom p_completed_room) {
        this.from_room = p_from_room;
        this.completed_room = p_completed_room;
        this.room_shape = p_completed_room.get_shape().bounding_octagon();
        this.sorted_neighbours = new TreeSet<SortedRoomNeighbour>();
        this.edge_interior_touches_obstacle = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            this.edge_interior_touches_obstacle[i] = false;
        }
    }

    public static CompleteExpansionRoom calculate(ExpansionRoom p_room, AutorouteEngine p_autoroute_engine) {
        int net_no = p_autoroute_engine.get_net_no();
        Sorted45DegreeRoomNeighbours room_neighbours = Sorted45DegreeRoomNeighbours.calculate_neighbours(p_room, net_no, p_autoroute_engine.autoroute_search_tree, p_autoroute_engine.generate_room_id_no());
        if (room_neighbours == null) {
            return null;
        }
        boolean edge_removed = room_neighbours.try_remove_edge_line(net_no, p_autoroute_engine.autoroute_search_tree);
        CompleteExpansionRoom result = room_neighbours.completed_room;
        if (edge_removed) {
            p_autoroute_engine.remove_all_doors(result);
            return Sorted45DegreeRoomNeighbours.calculate(p_room, p_autoroute_engine);
        }
        if (room_neighbours.sorted_neighbours.isEmpty()) {
            if (result instanceof ObstacleExpansionRoom) {
                room_neighbours.calculate_edge_incomplete_rooms_of_obstacle_expansion_room(0, 7, p_autoroute_engine);
            }
        } else {
            room_neighbours.calculate_new_incomplete_rooms(p_autoroute_engine);
        }
        return result;
    }

    private static Sorted45DegreeRoomNeighbours calculate_neighbours(ExpansionRoom p_room, int p_net_no, ShapeSearchTree p_autoroute_search_tree, int p_room_id_no) {
        CompleteExpansionRoom completed_room;
        TileShape room_shape = p_room.get_shape();
        if (p_room instanceof IncompleteFreeSpaceExpansionRoom) {
            completed_room = new CompleteFreeSpaceExpansionRoom(room_shape, p_room.get_layer(), p_room_id_no);
        } else if (p_room instanceof ObstacleExpansionRoom) {
            ObstacleExpansionRoom room = (ObstacleExpansionRoom)p_room;
            completed_room = room;
        } else {
            FRLogger.warn("Sorted45DegreeRoomNeighbours.calculate_neighbours: unexpected expansion room type");
            return null;
        }
        IntOctagon room_oct = room_shape.bounding_octagon();
        Sorted45DegreeRoomNeighbours result = new Sorted45DegreeRoomNeighbours(p_room, completed_room);
        LinkedList<ShapeTree.TreeEntry> overlapping_objects = new LinkedList<ShapeTree.TreeEntry>();
        p_autoroute_search_tree.overlapping_tree_entries(room_shape, p_room.get_layer(), overlapping_objects);
        for (ShapeTree.TreeEntry curr_entry : overlapping_objects) {
            Item curr_item;
            TileShape curr_shape;
            IntOctagon curr_oct;
            IntOctagon intersection;
            int dimension;
            SearchTreeObject curr_object = (SearchTreeObject)curr_entry.object;
            if (curr_object == p_room) continue;
            if (completed_room instanceof CompleteFreeSpaceExpansionRoom) {
                CompleteExpansionRoom room = completed_room;
                if (!curr_object.is_trace_obstacle(p_net_no)) {
                    ((CompleteFreeSpaceExpansionRoom)room).calculate_target_doors(curr_entry, p_net_no, p_autoroute_search_tree);
                    continue;
                }
            }
            if ((dimension = (intersection = room_oct.intersection(curr_oct = (curr_shape = curr_object.get_tree_shape(p_autoroute_search_tree, curr_entry.shape_index_in_object)).bounding_octagon())).dimension()) > 1 && completed_room instanceof ObstacleExpansionRoom) {
                Item curr_item2;
                ObstacleExpansionRoom room = (ObstacleExpansionRoom)completed_room;
                if (!(curr_object instanceof Item) || !(curr_item2 = (Item)curr_object).is_routable()) continue;
                ItemAutorouteInfo item_info = curr_item2.get_autoroute_info();
                ObstacleExpansionRoom curr_overlap_room = item_info.get_expansion_room(curr_entry.shape_index_in_object, p_autoroute_search_tree);
                room.create_overlap_door(curr_overlap_room);
                continue;
            }
            if (dimension < 0) continue;
            result.add_sorted_neighbour(curr_oct, intersection);
            if (dimension <= 0) continue;
            ExpansionRoom neighbour_room = null;
            if (curr_object instanceof ExpansionRoom) {
                ExpansionRoom room;
                neighbour_room = room = (ExpansionRoom)((Object)curr_object);
            } else if (curr_object instanceof Item && (curr_item = (Item)curr_object).is_routable()) {
                ItemAutorouteInfo item_info = curr_item.get_autoroute_info();
                neighbour_room = item_info.get_expansion_room(curr_entry.shape_index_in_object, p_autoroute_search_tree);
            }
            if (neighbour_room == null || !SortedRoomNeighbours.insert_door_ok(completed_room, neighbour_room, intersection)) continue;
            ExpansionDoor new_door = new ExpansionDoor(completed_room, neighbour_room);
            neighbour_room.add_door(new_door);
            completed_room.add_door(new_door);
        }
        return result;
    }

    private static IntOctagon remove_not_touching_border_lines(IntOctagon p_room_oct, boolean[] p_edge_interior_touches_obstacle) {
        int lx = p_edge_interior_touches_obstacle[6] ? p_room_oct.leftX : -33554432;
        int ly = p_edge_interior_touches_obstacle[0] ? p_room_oct.bottomY : -33554432;
        int rx = p_edge_interior_touches_obstacle[2] ? p_room_oct.rightX : 0x2000000;
        int uy = p_edge_interior_touches_obstacle[4] ? p_room_oct.topY : 0x2000000;
        int ulx = p_edge_interior_touches_obstacle[5] ? p_room_oct.upperLeftDiagonalX : -33554432;
        int lrx = p_edge_interior_touches_obstacle[1] ? p_room_oct.lowerRightDiagonalX : 0x2000000;
        int llx = p_edge_interior_touches_obstacle[7] ? p_room_oct.lowerLeftDiagonalX : -33554432;
        int urx = p_edge_interior_touches_obstacle[3] ? p_room_oct.upperRightDiagonalX : 0x2000000;
        IntOctagon result = new IntOctagon(lx, ly, rx, uy, ulx, lrx, llx, urx);
        return result.normalize();
    }

    private void add_sorted_neighbour(IntOctagon p_neighbour_shape, IntOctagon p_intersection) {
        SortedRoomNeighbour new_neighbour = new SortedRoomNeighbour(this, p_neighbour_shape, p_intersection);
        if (new_neighbour.last_touching_side >= 0) {
            this.sorted_neighbours.add(new_neighbour);
        }
    }

    private void calculate_edge_incomplete_rooms_of_obstacle_expansion_room(int p_from_side_no, int p_to_side_no, AutorouteEngine p_autoroute_engine) {
        if (!(this.from_room instanceof ObstacleExpansionRoom)) {
            FRLogger.warn("Sorted45DegreeRoomNeighbours.calculate_side_incomplete_rooms_of_obstacle_expansion_room: ObstacleExpansionRoom expected for this.from_room");
            return;
        }
        IntOctagon board_bounding_oct = p_autoroute_engine.board.get_bounding_box().bounding_octagon();
        IntPoint curr_corner = this.room_shape.corner(p_from_side_no);
        int curr_side_no = p_from_side_no;
        while (true) {
            int next_side_no;
            IntPoint next_corner;
            if (!curr_corner.equals(next_corner = this.room_shape.corner(next_side_no = (curr_side_no + 1) % 8))) {
                int lx = board_bounding_oct.leftX;
                int ly = board_bounding_oct.bottomY;
                int rx = board_bounding_oct.rightX;
                int uy = board_bounding_oct.topY;
                int ulx = board_bounding_oct.upperLeftDiagonalX;
                int lrx = board_bounding_oct.lowerRightDiagonalX;
                int llx = board_bounding_oct.lowerLeftDiagonalX;
                int urx = board_bounding_oct.upperRightDiagonalX;
                switch (curr_side_no) {
                    case 0: {
                        uy = this.room_shape.bottomY;
                        break;
                    }
                    case 1: {
                        ulx = this.room_shape.lowerRightDiagonalX;
                        break;
                    }
                    case 2: {
                        lx = this.room_shape.rightX;
                        break;
                    }
                    case 3: {
                        llx = this.room_shape.upperRightDiagonalX;
                        break;
                    }
                    case 4: {
                        ly = this.room_shape.topY;
                        break;
                    }
                    case 5: {
                        lrx = this.room_shape.upperLeftDiagonalX;
                        break;
                    }
                    case 6: {
                        rx = this.room_shape.leftX;
                        break;
                    }
                    case 7: {
                        urx = this.room_shape.lowerLeftDiagonalX;
                        break;
                    }
                    default: {
                        FRLogger.warn("SortedOrthoganelRoomNeighbours.calculate_edge_incomplete_rooms_of_obstacle_expansion_room: curr_side_no illegal");
                        return;
                    }
                }
                this.insert_incomplete_room(p_autoroute_engine, lx, ly, rx, uy, ulx, lrx, llx, urx);
            }
            if (curr_side_no == p_to_side_no) break;
            curr_side_no = next_side_no;
        }
    }

    private boolean try_remove_edge_line(int p_net_no, ShapeSearchTree p_autoroute_search_tree) {
        ExpansionRoom expansionRoom = this.from_room;
        if (!(expansionRoom instanceof IncompleteFreeSpaceExpansionRoom)) {
            return false;
        }
        IncompleteFreeSpaceExpansionRoom curr_incomplete_room = (IncompleteFreeSpaceExpansionRoom)expansionRoom;
        TileShape tileShape = curr_incomplete_room.get_shape();
        if (!(tileShape instanceof IntOctagon)) {
            FRLogger.warn("Sorted45DegreeRoomNeighbours.try_remove_edge_line: IntOctagon expected for room_shape type");
            return false;
        }
        IntOctagon room_oct = (IntOctagon)tileShape;
        double room_area = room_oct.area();
        boolean try_remove_edge_lines = false;
        for (int i = 0; i < 8; ++i) {
            FloatPoint next_corner;
            FloatPoint prev_corner;
            if (this.edge_interior_touches_obstacle[i] || !((prev_corner = this.room_shape.corner_approx(i)).distance_square(next_corner = this.room_shape.corner_approx(this.room_shape.next_no(i))) > 1.0)) continue;
            try_remove_edge_lines = true;
            break;
        }
        if (try_remove_edge_lines) {
            IncompleteFreeSpaceExpansionRoom new_room;
            IntOctagon enlarged_oct = Sorted45DegreeRoomNeighbours.remove_not_touching_border_lines(room_oct, this.edge_interior_touches_obstacle);
            List<ExpansionDoor> door_list = this.completed_room.get_doors();
            TileShape ignore_shape = null;
            CompleteFreeSpaceExpansionRoom ignore_object = null;
            double max_door_area = 0.0;
            for (ExpansionDoor curr_door : door_list) {
                CompleteExpansionRoom other_room;
                if (curr_door.dimension != 2 || !((other_room = curr_door.other_room(this.completed_room)) instanceof CompleteFreeSpaceExpansionRoom)) continue;
                CompleteFreeSpaceExpansionRoom room = (CompleteFreeSpaceExpansionRoom)other_room;
                TileShape curr_door_shape = curr_door.get_shape();
                double curr_door_area = curr_door_shape.area();
                if (!(curr_door_area > max_door_area)) continue;
                max_door_area = curr_door_area;
                ignore_shape = curr_door_shape;
                ignore_object = room;
            }
            IncompleteFreeSpaceExpansionRoom enlarged_room = new IncompleteFreeSpaceExpansionRoom(enlarged_oct, curr_incomplete_room.get_layer(), curr_incomplete_room.get_contained_shape());
            Collection<IncompleteFreeSpaceExpansionRoom> new_rooms = p_autoroute_search_tree.complete_shape(enlarged_room, p_net_no, ignore_object, ignore_shape);
            if (new_rooms.size() == 1 && (new_room = new_rooms.iterator().next()).get_shape().area() > room_area) {
                curr_incomplete_room.set_shape(new_room.get_shape());
                curr_incomplete_room.set_contained_shape(new_room.get_contained_shape());
                return true;
            }
        }
        return false;
    }

    private void insert_incomplete_room(AutorouteEngine p_autoroute_engine, int p_lx, int p_ly, int p_rx, int p_uy, int p_ulx, int p_lrx, int p_llx, int p_urx) {
        int door_dimension;
        IntOctagon new_contained_shape;
        IntOctagon new_incomplete_room_shape = new IntOctagon(p_lx, p_ly, p_rx, p_uy, p_ulx, p_lrx, p_llx, p_urx);
        if ((new_incomplete_room_shape = new_incomplete_room_shape.normalize()).dimension() == 2 && !(new_contained_shape = this.room_shape.intersection(new_incomplete_room_shape)).is_empty() && (door_dimension = new_contained_shape.dimension()) > 0) {
            IncompleteFreeSpaceExpansionRoom new_room = p_autoroute_engine.add_incomplete_expansion_room(new_incomplete_room_shape, this.from_room.get_layer(), new_contained_shape);
            ExpansionDoor new_door = new ExpansionDoor(this.completed_room, new_room, door_dimension);
            this.completed_room.add_door(new_door);
            new_room.add_door(new_door);
        }
    }

    private void calculate_new_incomplete_rooms_for_obstacle_expansion_room(SortedRoomNeighbour p_prev_neighbour, SortedRoomNeighbour p_next_neighbour, AutorouteEngine p_autoroute_engine) {
        int from_side_no = p_prev_neighbour.last_touching_side;
        int to_side_no = p_next_neighbour.first_touching_side;
        if (from_side_no == to_side_no && p_prev_neighbour != p_next_neighbour) {
            return;
        }
        IntOctagon board_bounding_oct = p_autoroute_engine.board.bounding_box.bounding_octagon();
        int lx = board_bounding_oct.leftX;
        int ly = board_bounding_oct.bottomY;
        int rx = board_bounding_oct.rightX;
        int uy = board_bounding_oct.topY;
        int ulx = board_bounding_oct.upperLeftDiagonalX;
        int lrx = board_bounding_oct.lowerRightDiagonalX;
        int llx = board_bounding_oct.lowerLeftDiagonalX;
        int urx = board_bounding_oct.upperRightDiagonalX;
        switch (from_side_no) {
            case 0: {
                uy = this.room_shape.bottomY;
                ulx = p_prev_neighbour.intersection.lowerRightDiagonalX;
                break;
            }
            case 1: {
                ulx = this.room_shape.lowerRightDiagonalX;
                lx = p_prev_neighbour.intersection.rightX;
                break;
            }
            case 2: {
                lx = this.room_shape.rightX;
                llx = p_prev_neighbour.intersection.upperRightDiagonalX;
                break;
            }
            case 3: {
                llx = this.room_shape.upperRightDiagonalX;
                ly = p_prev_neighbour.intersection.topY;
                break;
            }
            case 4: {
                ly = this.room_shape.topY;
                lrx = p_prev_neighbour.intersection.upperLeftDiagonalX;
                break;
            }
            case 5: {
                lrx = this.room_shape.upperLeftDiagonalX;
                rx = p_prev_neighbour.intersection.leftX;
                break;
            }
            case 6: {
                rx = this.room_shape.leftX;
                urx = p_prev_neighbour.intersection.lowerLeftDiagonalX;
                break;
            }
            case 7: {
                urx = this.room_shape.lowerLeftDiagonalX;
                uy = p_prev_neighbour.intersection.bottomY;
            }
        }
        this.insert_incomplete_room(p_autoroute_engine, lx, ly, rx, uy, ulx, lrx, llx, urx);
        lx = board_bounding_oct.leftX;
        ly = board_bounding_oct.bottomY;
        rx = board_bounding_oct.rightX;
        uy = board_bounding_oct.topY;
        ulx = board_bounding_oct.upperLeftDiagonalX;
        lrx = board_bounding_oct.lowerRightDiagonalX;
        llx = board_bounding_oct.lowerLeftDiagonalX;
        urx = board_bounding_oct.upperRightDiagonalX;
        switch (to_side_no) {
            case 0: {
                uy = this.room_shape.bottomY;
                urx = p_next_neighbour.intersection.lowerLeftDiagonalX;
                break;
            }
            case 1: {
                ulx = this.room_shape.lowerRightDiagonalX;
                uy = p_next_neighbour.intersection.bottomY;
                break;
            }
            case 2: {
                lx = this.room_shape.rightX;
                ulx = p_next_neighbour.intersection.lowerRightDiagonalX;
                break;
            }
            case 3: {
                llx = this.room_shape.upperRightDiagonalX;
                lx = p_next_neighbour.intersection.rightX;
                break;
            }
            case 4: {
                ly = this.room_shape.topY;
                llx = p_next_neighbour.intersection.upperRightDiagonalX;
                break;
            }
            case 5: {
                lrx = this.room_shape.upperLeftDiagonalX;
                ly = p_next_neighbour.intersection.topY;
                break;
            }
            case 6: {
                rx = this.room_shape.leftX;
                lrx = p_next_neighbour.intersection.upperLeftDiagonalX;
                break;
            }
            case 7: {
                urx = this.room_shape.lowerLeftDiagonalX;
                rx = p_next_neighbour.intersection.leftX;
            }
        }
        this.insert_incomplete_room(p_autoroute_engine, lx, ly, rx, uy, ulx, lrx, llx, urx);
        int curr_from_side_no = (from_side_no + 1) % 8;
        if (curr_from_side_no == to_side_no) {
            return;
        }
        int curr_to_side_no = (to_side_no + 7) % 8;
        this.calculate_edge_incomplete_rooms_of_obstacle_expansion_room(curr_from_side_no, curr_to_side_no, p_autoroute_engine);
    }

    private void calculate_new_incomplete_rooms(AutorouteEngine p_autoroute_engine) {
        IntOctagon board_bounding_oct = p_autoroute_engine.board.bounding_box.bounding_octagon();
        SortedRoomNeighbour prev_neighbour = this.sorted_neighbours.getLast();
        if (this.from_room instanceof ObstacleExpansionRoom && this.sorted_neighbours.size() == 1) {
            this.calculate_new_incomplete_rooms_for_obstacle_expansion_room(prev_neighbour, prev_neighbour, p_autoroute_engine);
            return;
        }
        for (SortedRoomNeighbour next_neighbour : this.sorted_neighbours) {
            boolean insert_incomplete_room;
            if (this.completed_room instanceof ObstacleExpansionRoom && this.sorted_neighbours.size() == 2) {
                IntOctagon intersection = next_neighbour.intersection.intersection(prev_neighbour.intersection);
                insert_incomplete_room = intersection.is_empty() ? true : (intersection.dimension() >= 1 ? false : (prev_neighbour.last_touching_side == next_neighbour.first_touching_side ? false : prev_neighbour.last_touching_side != (next_neighbour.first_touching_side + 1) % 8));
            } else {
                boolean bl = insert_incomplete_room = !next_neighbour.intersection.intersects(prev_neighbour.intersection);
            }
            if (insert_incomplete_room) {
                if (this.from_room instanceof ObstacleExpansionRoom && next_neighbour.first_touching_side != prev_neighbour.last_touching_side) {
                    this.calculate_new_incomplete_rooms_for_obstacle_expansion_room(prev_neighbour, next_neighbour, p_autoroute_engine);
                } else {
                    int lx = board_bounding_oct.leftX;
                    int ly = board_bounding_oct.bottomY;
                    int rx = board_bounding_oct.rightX;
                    int uy = board_bounding_oct.topY;
                    int ulx = board_bounding_oct.upperLeftDiagonalX;
                    int lrx = board_bounding_oct.lowerRightDiagonalX;
                    int llx = board_bounding_oct.lowerLeftDiagonalX;
                    int urx = board_bounding_oct.upperRightDiagonalX;
                    switch (next_neighbour.first_touching_side) {
                        case 0: {
                            if (prev_neighbour.intersection.lowerLeftDiagonalX < next_neighbour.intersection.lowerLeftDiagonalX) {
                                urx = next_neighbour.intersection.lowerLeftDiagonalX;
                                uy = prev_neighbour.intersection.bottomY;
                                if (prev_neighbour.last_touching_side != 0) break;
                                ulx = prev_neighbour.intersection.lowerRightDiagonalX;
                                break;
                            }
                            if (prev_neighbour.intersection.lowerLeftDiagonalX > next_neighbour.intersection.lowerLeftDiagonalX) {
                                rx = next_neighbour.intersection.leftX;
                                urx = prev_neighbour.intersection.lowerLeftDiagonalX;
                                break;
                            }
                            urx = next_neighbour.intersection.lowerLeftDiagonalX;
                            break;
                        }
                        case 1: {
                            if (prev_neighbour.intersection.bottomY < next_neighbour.intersection.bottomY) {
                                uy = next_neighbour.intersection.bottomY;
                                ulx = prev_neighbour.intersection.lowerRightDiagonalX;
                                if (prev_neighbour.last_touching_side != 1) break;
                                lx = prev_neighbour.intersection.rightX;
                                break;
                            }
                            if (prev_neighbour.intersection.bottomY > next_neighbour.intersection.bottomY) {
                                uy = prev_neighbour.intersection.bottomY;
                                urx = next_neighbour.intersection.lowerLeftDiagonalX;
                                break;
                            }
                            uy = next_neighbour.intersection.bottomY;
                            break;
                        }
                        case 2: {
                            if (prev_neighbour.intersection.lowerRightDiagonalX > next_neighbour.intersection.lowerRightDiagonalX) {
                                ulx = next_neighbour.intersection.lowerRightDiagonalX;
                                lx = prev_neighbour.intersection.rightX;
                                if (prev_neighbour.last_touching_side != 2) break;
                                llx = prev_neighbour.intersection.upperRightDiagonalX;
                                break;
                            }
                            if (prev_neighbour.intersection.lowerRightDiagonalX < next_neighbour.intersection.lowerRightDiagonalX) {
                                uy = next_neighbour.intersection.bottomY;
                                ulx = prev_neighbour.intersection.lowerRightDiagonalX;
                                break;
                            }
                            ulx = next_neighbour.intersection.lowerRightDiagonalX;
                            break;
                        }
                        case 3: {
                            if (prev_neighbour.intersection.rightX > next_neighbour.intersection.rightX) {
                                lx = next_neighbour.intersection.rightX;
                                llx = prev_neighbour.intersection.upperRightDiagonalX;
                                if (prev_neighbour.last_touching_side != 3) break;
                                ly = prev_neighbour.intersection.topY;
                                break;
                            }
                            if (prev_neighbour.intersection.rightX < next_neighbour.intersection.rightX) {
                                lx = prev_neighbour.intersection.rightX;
                                ulx = next_neighbour.intersection.lowerRightDiagonalX;
                                break;
                            }
                            lx = next_neighbour.intersection.rightX;
                            break;
                        }
                        case 4: {
                            if (prev_neighbour.intersection.upperRightDiagonalX > next_neighbour.intersection.upperRightDiagonalX) {
                                llx = next_neighbour.intersection.upperRightDiagonalX;
                                ly = prev_neighbour.intersection.topY;
                                if (prev_neighbour.last_touching_side != 4) break;
                                lrx = prev_neighbour.intersection.upperLeftDiagonalX;
                                break;
                            }
                            if (prev_neighbour.intersection.upperRightDiagonalX < next_neighbour.intersection.upperRightDiagonalX) {
                                lx = next_neighbour.intersection.rightX;
                                llx = prev_neighbour.intersection.upperRightDiagonalX;
                                break;
                            }
                            llx = next_neighbour.intersection.upperRightDiagonalX;
                            break;
                        }
                        case 5: {
                            if (prev_neighbour.intersection.topY > next_neighbour.intersection.topY) {
                                ly = next_neighbour.intersection.topY;
                                lrx = prev_neighbour.intersection.upperLeftDiagonalX;
                                if (prev_neighbour.last_touching_side != 5) break;
                                rx = prev_neighbour.intersection.leftX;
                                break;
                            }
                            if (prev_neighbour.intersection.topY < next_neighbour.intersection.topY) {
                                ly = prev_neighbour.intersection.topY;
                                llx = next_neighbour.intersection.upperRightDiagonalX;
                                break;
                            }
                            ly = next_neighbour.intersection.topY;
                            break;
                        }
                        case 6: {
                            if (prev_neighbour.intersection.upperLeftDiagonalX < next_neighbour.intersection.upperLeftDiagonalX) {
                                lrx = next_neighbour.intersection.upperLeftDiagonalX;
                                rx = prev_neighbour.intersection.leftX;
                                if (prev_neighbour.last_touching_side != 6) break;
                                urx = prev_neighbour.intersection.lowerLeftDiagonalX;
                                break;
                            }
                            if (prev_neighbour.intersection.upperLeftDiagonalX > next_neighbour.intersection.upperLeftDiagonalX) {
                                ly = next_neighbour.intersection.topY;
                                lrx = prev_neighbour.intersection.upperLeftDiagonalX;
                                break;
                            }
                            lrx = next_neighbour.intersection.upperLeftDiagonalX;
                            break;
                        }
                        case 7: {
                            if (prev_neighbour.intersection.leftX < next_neighbour.intersection.leftX) {
                                rx = next_neighbour.intersection.leftX;
                                urx = prev_neighbour.intersection.lowerLeftDiagonalX;
                                if (prev_neighbour.last_touching_side != 7) break;
                                uy = prev_neighbour.intersection.bottomY;
                                break;
                            }
                            if (prev_neighbour.intersection.leftX > next_neighbour.intersection.leftX) {
                                rx = prev_neighbour.intersection.leftX;
                                lrx = next_neighbour.intersection.upperLeftDiagonalX;
                                break;
                            }
                            rx = next_neighbour.intersection.leftX;
                            break;
                        }
                        default: {
                            FRLogger.warn("Sorted45DegreeRoomNeighbour.calculate_new_incomplete: illegal touching side");
                        }
                    }
                    this.insert_incomplete_room(p_autoroute_engine, lx, ly, rx, uy, ulx, lrx, llx, urx);
                }
            }
            prev_neighbour = next_neighbour;
        }
    }

    private class SortedRoomNeighbour
    implements Comparable<SortedRoomNeighbour> {
        public final IntOctagon shape;
        public final IntOctagon intersection;
        public final int first_touching_side;
        public final int last_touching_side;

        public SortedRoomNeighbour(Sorted45DegreeRoomNeighbours sorted45DegreeRoomNeighbours, IntOctagon p_neighbour_shape, IntOctagon p_intersection) {
            int curr_side_no;
            Objects.requireNonNull(sorted45DegreeRoomNeighbours);
            this.shape = p_neighbour_shape;
            this.intersection = p_intersection;
            if (this.intersection.bottomY == sorted45DegreeRoomNeighbours.room_shape.bottomY && this.intersection.lowerLeftDiagonalX > sorted45DegreeRoomNeighbours.room_shape.lowerLeftDiagonalX) {
                this.first_touching_side = 0;
            } else if (this.intersection.lowerRightDiagonalX == sorted45DegreeRoomNeighbours.room_shape.lowerRightDiagonalX && this.intersection.bottomY > sorted45DegreeRoomNeighbours.room_shape.bottomY) {
                this.first_touching_side = 1;
            } else if (this.intersection.rightX == sorted45DegreeRoomNeighbours.room_shape.rightX && this.intersection.lowerRightDiagonalX < sorted45DegreeRoomNeighbours.room_shape.lowerRightDiagonalX) {
                this.first_touching_side = 2;
            } else if (this.intersection.upperRightDiagonalX == sorted45DegreeRoomNeighbours.room_shape.upperRightDiagonalX && this.intersection.rightX < sorted45DegreeRoomNeighbours.room_shape.rightX) {
                this.first_touching_side = 3;
            } else if (this.intersection.topY == sorted45DegreeRoomNeighbours.room_shape.topY && this.intersection.upperRightDiagonalX < sorted45DegreeRoomNeighbours.room_shape.upperRightDiagonalX) {
                this.first_touching_side = 4;
            } else if (this.intersection.upperLeftDiagonalX == sorted45DegreeRoomNeighbours.room_shape.upperLeftDiagonalX && this.intersection.topY < sorted45DegreeRoomNeighbours.room_shape.topY) {
                this.first_touching_side = 5;
            } else if (this.intersection.leftX == sorted45DegreeRoomNeighbours.room_shape.leftX && this.intersection.upperLeftDiagonalX > sorted45DegreeRoomNeighbours.room_shape.upperLeftDiagonalX) {
                this.first_touching_side = 6;
            } else if (this.intersection.lowerLeftDiagonalX == sorted45DegreeRoomNeighbours.room_shape.lowerLeftDiagonalX && this.intersection.leftX > sorted45DegreeRoomNeighbours.room_shape.leftX) {
                this.first_touching_side = 7;
            } else {
                this.first_touching_side = -1;
                this.last_touching_side = -1;
                return;
            }
            if (this.intersection.lowerLeftDiagonalX == sorted45DegreeRoomNeighbours.room_shape.lowerLeftDiagonalX && this.intersection.bottomY > sorted45DegreeRoomNeighbours.room_shape.bottomY) {
                this.last_touching_side = 7;
            } else if (this.intersection.leftX == sorted45DegreeRoomNeighbours.room_shape.leftX && this.intersection.lowerLeftDiagonalX > sorted45DegreeRoomNeighbours.room_shape.lowerLeftDiagonalX) {
                this.last_touching_side = 6;
            } else if (this.intersection.upperLeftDiagonalX == sorted45DegreeRoomNeighbours.room_shape.upperLeftDiagonalX && this.intersection.leftX > sorted45DegreeRoomNeighbours.room_shape.leftX) {
                this.last_touching_side = 5;
            } else if (this.intersection.topY == sorted45DegreeRoomNeighbours.room_shape.topY && this.intersection.upperLeftDiagonalX > sorted45DegreeRoomNeighbours.room_shape.upperLeftDiagonalX) {
                this.last_touching_side = 4;
            } else if (this.intersection.upperRightDiagonalX == sorted45DegreeRoomNeighbours.room_shape.upperRightDiagonalX && this.intersection.topY < sorted45DegreeRoomNeighbours.room_shape.topY) {
                this.last_touching_side = 3;
            } else if (this.intersection.rightX == sorted45DegreeRoomNeighbours.room_shape.rightX && this.intersection.upperRightDiagonalX < sorted45DegreeRoomNeighbours.room_shape.upperRightDiagonalX) {
                this.last_touching_side = 2;
            } else if (this.intersection.lowerRightDiagonalX == sorted45DegreeRoomNeighbours.room_shape.lowerRightDiagonalX && this.intersection.rightX < sorted45DegreeRoomNeighbours.room_shape.rightX) {
                this.last_touching_side = 1;
            } else if (this.intersection.bottomY == sorted45DegreeRoomNeighbours.room_shape.bottomY && this.intersection.lowerRightDiagonalX < sorted45DegreeRoomNeighbours.room_shape.lowerRightDiagonalX) {
                this.last_touching_side = 0;
            } else {
                this.last_touching_side = -1;
                return;
            }
            int next_side_no = this.first_touching_side;
            do {
                curr_side_no = next_side_no;
                next_side_no = (next_side_no + 1) % 8;
                if (sorted45DegreeRoomNeighbours.edge_interior_touches_obstacle[curr_side_no]) continue;
                boolean touch_only_at_corner = false;
                if (curr_side_no == this.first_touching_side && this.intersection.corner(curr_side_no).equals(sorted45DegreeRoomNeighbours.room_shape.corner(next_side_no))) {
                    touch_only_at_corner = true;
                }
                if (curr_side_no == this.last_touching_side && this.intersection.corner(next_side_no).equals(sorted45DegreeRoomNeighbours.room_shape.corner(curr_side_no))) {
                    touch_only_at_corner = true;
                }
                if (touch_only_at_corner) continue;
                sorted45DegreeRoomNeighbours.edge_interior_touches_obstacle[curr_side_no] = true;
            } while (curr_side_no != this.last_touching_side);
        }

        @Override
        public int compareTo(SortedRoomNeighbour p_other) {
            int cmp_value;
            if (this.first_touching_side > p_other.first_touching_side) {
                return 1;
            }
            if (this.first_touching_side < p_other.first_touching_side) {
                return -1;
            }
            IntOctagon is1 = this.intersection;
            IntOctagon is2 = p_other.intersection;
            switch (this.first_touching_side) {
                case 0: {
                    cmp_value = is1.corner((int)0).x - is2.corner((int)0).x;
                    break;
                }
                case 1: {
                    cmp_value = is1.corner((int)1).x - is2.corner((int)1).x;
                    break;
                }
                case 2: {
                    cmp_value = is1.corner((int)2).y - is2.corner((int)2).y;
                    break;
                }
                case 3: {
                    cmp_value = is1.corner((int)3).y - is2.corner((int)3).y;
                    break;
                }
                case 4: {
                    cmp_value = is2.corner((int)4).x - is1.corner((int)4).x;
                    break;
                }
                case 5: {
                    cmp_value = is2.corner((int)5).x - is1.corner((int)5).x;
                    break;
                }
                case 6: {
                    cmp_value = is2.corner((int)6).y - is1.corner((int)6).y;
                    break;
                }
                case 7: {
                    cmp_value = is2.corner((int)7).y - is1.corner((int)7).y;
                    break;
                }
                default: {
                    FRLogger.warn("SortedRoomNeighbour.compareTo: first_touching_side out of range ");
                    return 0;
                }
            }
            if (cmp_value == 0) {
                int this_touching_side_diff = (this.last_touching_side - this.first_touching_side + 8) % 8;
                int other_touching_side_diff = (p_other.last_touching_side - p_other.first_touching_side + 8) % 8;
                if (this_touching_side_diff > other_touching_side_diff) {
                    return 1;
                }
                if (this_touching_side_diff < other_touching_side_diff) {
                    return -1;
                }
                switch (this.last_touching_side) {
                    case 0: {
                        cmp_value = is1.corner((int)1).x - is2.corner((int)1).x;
                        break;
                    }
                    case 1: {
                        cmp_value = is1.corner((int)2).x - is2.corner((int)2).x;
                        break;
                    }
                    case 2: {
                        cmp_value = is1.corner((int)3).y - is2.corner((int)3).y;
                        break;
                    }
                    case 3: {
                        cmp_value = is1.corner((int)4).y - is2.corner((int)4).y;
                        break;
                    }
                    case 4: {
                        cmp_value = is2.corner((int)5).x - is1.corner((int)5).x;
                        break;
                    }
                    case 5: {
                        cmp_value = is2.corner((int)6).x - is1.corner((int)6).x;
                        break;
                    }
                    case 6: {
                        cmp_value = is2.corner((int)7).y - is1.corner((int)7).y;
                        break;
                    }
                    case 7: {
                        cmp_value = is2.corner((int)0).y - is1.corner((int)0).y;
                    }
                }
            }
            return cmp_value;
        }
    }
}

