/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteControl;
import app.freerouting.autoroute.CompleteExpansionRoom;
import app.freerouting.autoroute.ExpandableObject;
import app.freerouting.autoroute.ExpansionDoor;
import app.freerouting.autoroute.ExpansionRoom;
import app.freerouting.autoroute.MazeListElement;
import app.freerouting.autoroute.ObstacleExpansionRoom;
import app.freerouting.board.DrillItem;
import app.freerouting.board.Item;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.ShoveTraceAlgo;
import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.FloatLine;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.LineSegment;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.logger.FRLogger;
import java.util.Collection;
import java.util.List;

public class MazeShoveTraceAlgo {
    private MazeShoveTraceAlgo() {
    }

    public static boolean check_shove_trace_line(MazeListElement p_list_element, ObstacleExpansionRoom p_obstacle_room, RoutingBoard p_board, AutorouteControl p_ctrl, boolean p_shove_to_the_left, Collection<DoorSection> p_to_door_list) {
        FloatPoint to_corner;
        FloatPoint from_corner;
        boolean segment_ist_point;
        LineSegment shove_line_segment;
        ExpandableObject expandableObject = p_list_element.door;
        if (!(expandableObject instanceof ExpansionDoor)) {
            return true;
        }
        ExpansionDoor from_door = (ExpansionDoor)expandableObject;
        Item item = p_obstacle_room.get_item();
        if (!(item instanceof PolylineTrace)) {
            return true;
        }
        PolylineTrace obstacle_trace = (PolylineTrace)item;
        int trace_layer = p_obstacle_room.get_layer();
        if (obstacle_trace.get_half_width() != p_ctrl.trace_half_width[trace_layer] || obstacle_trace.clearance_class_no() != p_ctrl.trace_clearance_class_no) {
            return true;
        }
        double compensated_trace_half_width = p_ctrl.compensated_trace_half_width[trace_layer];
        TileShape from_door_shape = from_door.get_shape();
        if (from_door_shape.max_width() < 2.0 * compensated_trace_half_width) {
            return true;
        }
        int trace_corner_no = p_obstacle_room.get_index_in_item();
        Polyline trace_polyline = obstacle_trace.polyline();
        if (trace_corner_no >= trace_polyline.arr.length - 1) {
            FRLogger.warn("MazeShoveTraceAlgo.check_shove_trace_line: trace_corner_no to big");
            return false;
        }
        List<ExpansionDoor> room_doors = p_obstacle_room.get_doors();
        if (from_door.dimension == 2) {
            FloatPoint corner_2;
            CompleteExpansionRoom other_room = from_door.other_room(p_obstacle_room);
            if (!(other_room instanceof ObstacleExpansionRoom)) {
                return false;
            }
            if (!MazeShoveTraceAlgo.end_points_matching(obstacle_trace, ((ObstacleExpansionRoom)other_room).get_item())) {
                return false;
            }
            FloatPoint door_center = from_door_shape.centre_of_gravity();
            FloatPoint corner_1 = trace_polyline.corner_approx(trace_corner_no);
            if (corner_1.distance_square(corner_2 = trace_polyline.corner_approx(trace_corner_no + 1)) < 1.0) {
                return false;
            }
            boolean shove_into_direction_of_trace_start = door_center.distance_square(corner_2) < door_center.distance_square(corner_1);
            shove_line_segment = new LineSegment(trace_polyline, trace_corner_no + 1);
            if (shove_into_direction_of_trace_start) {
                shove_line_segment = shove_line_segment.opposite();
            }
        } else {
            boolean section_ok;
            CompleteExpansionRoom from_room = from_door.other_room(p_obstacle_room);
            FloatPoint from_point = from_room.get_shape().centre_of_gravity();
            Line shove_trace_line = trace_polyline.arr[trace_corner_no + 1];
            FloatLine door_line_segment = from_door_shape.diagonal_corner_segment();
            Side side_of_trace_line = shove_trace_line.side_of(door_line_segment.a, 0.0);
            FloatLine polar_line_segment = from_door_shape.polar_line_segment(from_point);
            boolean door_line_swapped = polar_line_segment.b.distance_square(door_line_segment.a) < polar_line_segment.a.distance_square(door_line_segment.a);
            double shape_entry_check_distance = compensated_trace_half_width + 5.0;
            double check_dist_square = shape_entry_check_distance * shape_entry_check_distance;
            if (p_shove_to_the_left && !door_line_swapped || !p_shove_to_the_left && door_line_swapped) {
                section_ok = p_list_element.section_no_of_door == p_list_element.door.maze_search_element_count() - 1 && (p_list_element.shape_entry.a.distance_square(door_line_segment.b) <= check_dist_square || p_list_element.shape_entry.b.distance_square(door_line_segment.b) <= check_dist_square);
            } else {
                boolean bl = section_ok = p_list_element.section_no_of_door == 0 && (p_list_element.shape_entry.a.distance_square(door_line_segment.a) <= check_dist_square || p_list_element.shape_entry.b.distance_square(door_line_segment.a) <= check_dist_square);
            }
            if (!section_ok) {
                return false;
            }
            FloatLine shrinked_line_segment = polar_line_segment.shrink_segment(compensated_trace_half_width);
            Direction perpendicular_direction = shove_trace_line.direction().turn_45_degree(2);
            if (side_of_trace_line == Side.ON_THE_LEFT) {
                if (p_shove_to_the_left) {
                    start_closing_line = new Line((Point)shrinked_line_segment.b.round(), perpendicular_direction);
                    shove_line_segment = new LineSegment(start_closing_line, trace_polyline.arr[trace_corner_no + 1], trace_polyline.arr[trace_corner_no + 2]);
                } else {
                    start_closing_line = new Line((Point)shrinked_line_segment.a.round(), perpendicular_direction);
                    shove_line_segment = new LineSegment(start_closing_line, trace_polyline.arr[trace_corner_no + 1].opposite(), trace_polyline.arr[trace_corner_no].opposite());
                }
            } else if (p_shove_to_the_left) {
                start_closing_line = new Line((Point)shrinked_line_segment.b.round(), perpendicular_direction);
                shove_line_segment = new LineSegment(start_closing_line, trace_polyline.arr[trace_corner_no + 1].opposite(), trace_polyline.arr[trace_corner_no].opposite());
            } else {
                start_closing_line = new Line((Point)shrinked_line_segment.a.round(), perpendicular_direction);
                shove_line_segment = new LineSegment(start_closing_line, trace_polyline.arr[trace_corner_no + 1], trace_polyline.arr[trace_corner_no + 2]);
            }
        }
        int trace_half_width = p_ctrl.trace_half_width[trace_layer];
        int[] net_no_arr = new int[]{p_ctrl.net_no};
        double shove_width = p_board.check_trace_segment(shove_line_segment, trace_layer, net_no_arr, trace_half_width, p_ctrl.trace_clearance_class_no, true);
        boolean segment_shortened = false;
        if (shove_width < 2.147483647E9) {
            if ((shove_width -= 1.0) <= 0.0) {
                return true;
            }
            shove_line_segment = shove_line_segment.change_length_approx(shove_width);
            segment_shortened = true;
        }
        boolean bl = segment_ist_point = (from_corner = shove_line_segment.start_point_approx()).distance_square(to_corner = shove_line_segment.end_point_approx()) < 0.1;
        if (!segment_ist_point && (shove_width = ShoveTraceAlgo.check(p_board, shove_line_segment, p_shove_to_the_left, trace_layer, net_no_arr, trace_half_width, p_ctrl.trace_clearance_class_no, p_ctrl.max_shove_trace_recursion_depth, p_ctrl.max_shove_via_recursion_depth)) <= 0.0) {
            return true;
        }
        if (segment_shortened) {
            shove_width = Math.min(shove_width, from_corner.distance(to_corner));
        }
        Line shove_line = shove_line_segment.get_line();
        double from_door_compare_distance = from_door.dimension == 2 || segment_ist_point ? Double.MAX_VALUE : to_corner.distance_square(from_door_shape.corner_approx(0));
        for (ExpansionDoor curr_door : room_doors) {
            FloatPoint curr_door_projection;
            if (curr_door == from_door) continue;
            ExpansionRoom expansionRoom = curr_door.first_room;
            if (expansionRoom instanceof ObstacleExpansionRoom) {
                ObstacleExpansionRoom room = (ObstacleExpansionRoom)expansionRoom;
                expansionRoom = curr_door.second_room;
                if (expansionRoom instanceof ObstacleExpansionRoom) {
                    Item second_room_item;
                    ObstacleExpansionRoom room1 = (ObstacleExpansionRoom)expansionRoom;
                    Item first_room_item = room.get_item();
                    if (first_room_item != (second_room_item = room1.get_item())) continue;
                }
            }
            TileShape curr_door_shape = curr_door.get_shape();
            if (curr_door.dimension == 2 && shove_width >= 2.147483647E9) {
                boolean add_link_door = curr_door_shape.contains(to_corner);
                if (!add_link_door) continue;
                FloatLine[] line_sections = curr_door.get_section_segments(compensated_trace_half_width);
                p_to_door_list.add(new DoorSection(curr_door, 0, line_sections[0]));
                continue;
            }
            if (segment_ist_point) continue;
            FloatLine curr_door_segment = curr_door_shape.diagonal_corner_segment();
            if (curr_door_segment == null) {
                FRLogger.trace("MazeShoveTraceAlgo.check_shove_trace_line: door shape is empty");
                continue;
            }
            Side start_corner_side_of_trace_line = shove_line.side_of(curr_door_segment.a, 0.0);
            Side end_corner_side_of_trace_line = shove_line.side_of(curr_door_segment.b, 0.0);
            if (p_shove_to_the_left ? start_corner_side_of_trace_line != Side.ON_THE_LEFT || end_corner_side_of_trace_line != Side.ON_THE_LEFT : start_corner_side_of_trace_line != Side.ON_THE_RIGHT || end_corner_side_of_trace_line != Side.ON_THE_RIGHT) continue;
            FloatLine curr_door_line = curr_door_shape.polar_line_segment(from_corner);
            FloatPoint curr_door_nearest_corner = curr_door_line.a.distance_square(from_corner) <= curr_door_line.b.distance_square(from_corner) ? curr_door_line.a : curr_door_line.b;
            if (to_corner.distance_square(curr_door_nearest_corner) >= from_door_compare_distance || !((curr_door_projection = curr_door_nearest_corner.projection_approx(shove_line)).distance(from_corner) + compensated_trace_half_width <= shove_width)) continue;
            FloatLine[] line_sections = curr_door.get_section_segments(compensated_trace_half_width);
            for (int i = 0; i < line_sections.length; ++i) {
                FloatLine curr_line_section = line_sections[i];
                FloatPoint curr_section_nearest_corner = curr_line_section.a.distance_square(from_corner) <= curr_line_section.b.distance_square(from_corner) ? curr_line_section.a : curr_line_section.b;
                FloatPoint curr_section_projection = curr_section_nearest_corner.projection_approx(shove_line);
                if (!(curr_section_projection.distance(from_corner) <= shove_width)) continue;
                p_to_door_list.add(new DoorSection(curr_door, i, curr_line_section));
            }
        }
        return true;
    }

    private static boolean end_points_matching(PolylineTrace p_trace, Item p_from_item) {
        boolean points_matching;
        if (p_from_item == p_trace) {
            return true;
        }
        if (!p_trace.shares_net(p_from_item)) {
            return false;
        }
        if (p_from_item instanceof DrillItem) {
            DrillItem item = (DrillItem)p_from_item;
            Point from_center = item.get_center();
            points_matching = from_center.equals(p_trace.first_corner()) || from_center.equals(p_trace.last_corner());
        } else if (p_from_item instanceof PolylineTrace) {
            PolylineTrace from_trace = (PolylineTrace)p_from_item;
            points_matching = p_trace.first_corner().equals(from_trace.first_corner()) || p_trace.first_corner().equals(from_trace.last_corner()) || p_trace.last_corner().equals(from_trace.first_corner()) || p_trace.last_corner().equals(from_trace.last_corner());
        } else {
            points_matching = false;
        }
        return points_matching;
    }

    public static class DoorSection {
        final ExpansionDoor door;
        final int section_no;
        final FloatLine section_line;

        DoorSection(ExpansionDoor p_door, int p_section_no, FloatLine p_section_line) {
            this.door = p_door;
            this.section_no = p_section_no;
            this.section_line = p_section_line;
        }
    }
}

