/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteControl;
import app.freerouting.autoroute.LocateFoundConnectionAlgo;
import app.freerouting.board.ForcedViaAlgo;
import app.freerouting.board.Item;
import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.board.Pin;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.Trace;
import app.freerouting.core.Padstack;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.ViaInfo;
import java.util.Arrays;
import java.util.Set;

public class InsertFoundConnectionAlgo {
    private final RoutingBoard board;
    private final AutorouteControl ctrl;
    private IntPoint last_corner;
    private IntPoint first_corner;

    private InsertFoundConnectionAlgo(RoutingBoard p_board, AutorouteControl p_ctrl) {
        this.board = p_board;
        this.ctrl = p_ctrl;
    }

    public static InsertFoundConnectionAlgo get_instance(LocateFoundConnectionAlgo p_connection, RoutingBoard p_board, AutorouteControl p_ctrl) {
        PolylineTrace to_trace;
        if (p_connection == null || p_connection.connection_items == null) {
            return null;
        }
        int curr_layer = p_connection.target_layer;
        InsertFoundConnectionAlgo new_instance = new InsertFoundConnectionAlgo(p_board, p_ctrl);
        for (LocateFoundConnectionAlgo.ResultItem curr_new_item : p_connection.connection_items) {
            if (!new_instance.insert_via(curr_new_item.corners[0], curr_layer, curr_new_item.layer)) {
                FRLogger.debug("InsertFoundConnectionAlgo: insert via failed for net #" + p_ctrl.net_no);
                return null;
            }
            curr_layer = curr_new_item.layer;
            if (new_instance.insert_trace(curr_new_item)) continue;
            FRLogger.debug("InsertFoundConnectionAlgo: insert trace failed for net #" + p_ctrl.net_no);
            return null;
        }
        if (!new_instance.insert_via(new_instance.last_corner, curr_layer, p_connection.start_layer)) {
            return null;
        }
        Item item = p_connection.target_item;
        if (item instanceof PolylineTrace) {
            to_trace = (PolylineTrace)item;
            p_board.connect_to_trace(new_instance.first_corner, to_trace, p_ctrl.trace_half_width[p_connection.start_layer], p_ctrl.trace_clearance_class_no);
        }
        if ((item = p_connection.start_item) instanceof PolylineTrace) {
            to_trace = (PolylineTrace)item;
            p_board.connect_to_trace(new_instance.last_corner, to_trace, p_ctrl.trace_half_width[p_connection.target_layer], p_ctrl.trace_clearance_class_no);
        }
        try {
            p_board.normalize_traces(p_ctrl.net_no);
        }
        catch (Exception exception) {
            FRLogger.warn("The normalization of net '" + p_board.rules.nets.get((int)p_ctrl.net_no).name + "' failed.");
        }
        return new_instance;
    }

    private boolean insert_trace(LocateFoundConnectionAlgo.ResultItem p_trace) {
        int i;
        if (p_trace.corners.length == 1) {
            if (this.first_corner == null) {
                this.first_corner = p_trace.corners[0];
            }
            this.last_corner = p_trace.corners[0];
            return true;
        }
        boolean result = true;
        double saved_edge_to_turn_dist = this.board.rules.get_pin_edge_to_turn_dist();
        this.board.rules.set_pin_edge_to_turn_dist(-1.0);
        Pin start_pin = null;
        Pin end_pin = null;
        if (this.ctrl.with_neckdown) {
            ItemSelectionFilter item_filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.PINS);
            IntPoint curr_end_corner = p_trace.corners[0];
            for (i = 0; i < 2; ++i) {
                Set<Item> picked_items = this.board.pick_items(curr_end_corner, p_trace.layer, item_filter);
                for (Item curr_item : picked_items) {
                    Pin curr_pin = (Pin)curr_item;
                    if (!curr_pin.contains_net(this.ctrl.net_no) || !curr_pin.get_center().equals(curr_end_corner)) continue;
                    if (i == 0) {
                        start_pin = curr_pin;
                        continue;
                    }
                    end_pin = curr_pin;
                }
                curr_end_corner = p_trace.corners[p_trace.corners.length - 1];
            }
        }
        int[] net_no_arr = new int[]{this.ctrl.net_no};
        int from_corner_no = 0;
        for (i = 1; i < p_trace.corners.length; ++i) {
            Point[] curr_corner_arr = Arrays.copyOfRange(p_trace.corners, from_corner_no, i + 1);
            Polyline insert_polyline = new Polyline(curr_corner_arr);
            Point ok_point = this.board.insert_forced_trace_polyline(insert_polyline, this.ctrl.trace_half_width[p_trace.layer], p_trace.layer, net_no_arr, this.ctrl.trace_clearance_class_no, this.ctrl.max_shove_trace_recursion_depth, this.ctrl.max_shove_via_recursion_depth, this.ctrl.max_spring_over_recursion_depth, Integer.MAX_VALUE, this.ctrl.pull_tight_accuracy, true, null);
            boolean neckdown_inserted = false;
            if (ok_point != null && ok_point != insert_polyline.last_corner() && this.ctrl.with_neckdown && curr_corner_arr.length == 2) {
                neckdown_inserted = this.insert_neckdown(ok_point, curr_corner_arr[1], p_trace.layer, start_pin, end_pin);
            }
            if (ok_point == insert_polyline.last_corner() || neckdown_inserted) {
                from_corner_no = i;
                continue;
            }
            if (ok_point == insert_polyline.first_corner() && i != p_trace.corners.length - 1) {
                if (from_corner_no > 0 && curr_corner_arr.length < 3) {
                    --from_corner_no;
                }
                FRLogger.trace("InsertFoundConnectionAlgo: violation corrected");
                continue;
            }
            result = false;
            break;
        }
        for (i = 0; i < p_trace.corners.length - 1; ++i) {
            Trace trace_stub = this.board.get_trace_tail(p_trace.corners[i], p_trace.layer, net_no_arr);
            if (trace_stub == null) continue;
            this.board.remove_item(trace_stub);
        }
        this.board.rules.set_pin_edge_to_turn_dist(saved_edge_to_turn_dist);
        if (this.first_corner == null) {
            this.first_corner = p_trace.corners[0];
        }
        this.last_corner = p_trace.corners[p_trace.corners.length - 1];
        return result;
    }

    boolean insert_neckdown(Point p_from_corner, Point p_to_corner, int p_layer, Pin p_start_pin, Pin p_end_pin) {
        Point ok_point;
        if (p_start_pin != null && (ok_point = this.try_neck_down(p_to_corner, p_from_corner, p_layer, p_start_pin, true)) == p_from_corner) {
            return true;
        }
        if (p_end_pin != null) {
            ok_point = this.try_neck_down(p_from_corner, p_to_corner, p_layer, p_end_pin, false);
            return ok_point == p_to_corner;
        }
        return false;
    }

    private Point try_neck_down(Point p_from_corner, Point p_to_corner, int p_layer, Pin p_pin, boolean p_at_start) {
        Point neck_down_end_point;
        if (!p_pin.is_on_layer(p_layer)) {
            return null;
        }
        FloatPoint pin_center = p_pin.get_center().to_float();
        double curr_clearance = this.board.rules.clearance_matrix.get_value(this.ctrl.trace_clearance_class_no, p_pin.clearance_class_no(), p_layer, true);
        double pin_neck_down_distance = 2.0 * (0.5 * p_pin.get_max_width(p_layer) + curr_clearance);
        if (pin_center.distance(p_to_corner.to_float()) >= pin_neck_down_distance) {
            return null;
        }
        int neck_down_halfwidth = p_pin.get_trace_neckdown_halfwidth(p_layer);
        if (neck_down_halfwidth >= this.ctrl.trace_half_width[p_layer]) {
            return null;
        }
        FloatPoint float_from_corner = p_from_corner.to_float();
        FloatPoint float_to_corner = p_to_corner.to_float();
        int TOLERANCE = 2;
        int[] net_no_arr = new int[]{this.ctrl.net_no};
        double ok_length = this.board.check_trace_segment(p_from_corner, p_to_corner, p_layer, net_no_arr, this.ctrl.trace_half_width[p_layer], this.ctrl.trace_clearance_class_no, true);
        if (ok_length >= 2.147483647E9) {
            return p_from_corner;
        }
        if ((ok_length -= 2.0) <= 2.0) {
            neck_down_end_point = p_from_corner;
        } else {
            FloatPoint float_neck_down_end_point = float_from_corner.change_length(float_to_corner, ok_length);
            neck_down_end_point = float_neck_down_end_point.round();
            boolean horizontal_first = Math.abs(float_from_corner.x - float_neck_down_end_point.x) >= Math.abs(float_from_corner.y - float_neck_down_end_point.y);
            IntPoint add_corner = LocateFoundConnectionAlgo.calculate_additional_corner(float_from_corner, float_neck_down_end_point, horizontal_first, this.board.rules.get_trace_angle_restriction()).round();
            Point curr_ok_point = this.board.insert_forced_trace_segment(p_from_corner, add_corner, this.ctrl.trace_half_width[p_layer], p_layer, net_no_arr, this.ctrl.trace_clearance_class_no, this.ctrl.max_shove_trace_recursion_depth, this.ctrl.max_shove_via_recursion_depth, this.ctrl.max_spring_over_recursion_depth, Integer.MAX_VALUE, this.ctrl.pull_tight_accuracy, true, null);
            if (curr_ok_point != add_corner) {
                return p_from_corner;
            }
            curr_ok_point = this.board.insert_forced_trace_segment(add_corner, neck_down_end_point, this.ctrl.trace_half_width[p_layer], p_layer, net_no_arr, this.ctrl.trace_clearance_class_no, this.ctrl.max_shove_trace_recursion_depth, this.ctrl.max_shove_via_recursion_depth, this.ctrl.max_spring_over_recursion_depth, Integer.MAX_VALUE, this.ctrl.pull_tight_accuracy, true, null);
            if (curr_ok_point != neck_down_end_point) {
                return p_from_corner;
            }
            add_corner = LocateFoundConnectionAlgo.calculate_additional_corner(float_neck_down_end_point, float_to_corner, !horizontal_first, this.board.rules.get_trace_angle_restriction()).round();
            if (!add_corner.equals(p_to_corner)) {
                curr_ok_point = this.board.insert_forced_trace_segment(neck_down_end_point, add_corner, this.ctrl.trace_half_width[p_layer], p_layer, net_no_arr, this.ctrl.trace_clearance_class_no, this.ctrl.max_shove_trace_recursion_depth, this.ctrl.max_shove_via_recursion_depth, this.ctrl.max_spring_over_recursion_depth, Integer.MAX_VALUE, this.ctrl.pull_tight_accuracy, true, null);
                if (curr_ok_point != add_corner) {
                    return p_from_corner;
                }
                neck_down_end_point = add_corner;
            }
        }
        Point ok_point = this.board.insert_forced_trace_segment(neck_down_end_point, p_to_corner, neck_down_halfwidth, p_layer, net_no_arr, this.ctrl.trace_clearance_class_no, this.ctrl.max_shove_trace_recursion_depth, this.ctrl.max_shove_via_recursion_depth, this.ctrl.max_spring_over_recursion_depth, Integer.MAX_VALUE, this.ctrl.pull_tight_accuracy, true, null);
        return ok_point;
    }

    private boolean insert_via(Point p_location, int p_from_layer, int p_to_layer) {
        int to_layer;
        int from_layer;
        if (p_from_layer == p_to_layer) {
            return true;
        }
        if (p_from_layer < p_to_layer) {
            from_layer = p_from_layer;
            to_layer = p_to_layer;
        } else {
            from_layer = p_to_layer;
            to_layer = p_from_layer;
        }
        int[] net_no_arr = new int[]{this.ctrl.net_no};
        ViaInfo via_info = null;
        for (int i = 0; i < this.ctrl.via_rule.via_count(); ++i) {
            ViaInfo curr_via_info = this.ctrl.via_rule.get_via(i);
            Padstack curr_via_padstack = curr_via_info.get_padstack();
            if (curr_via_padstack.from_layer() > from_layer || curr_via_padstack.to_layer() < to_layer || !ForcedViaAlgo.check(curr_via_info, p_location, net_no_arr, this.ctrl.max_shove_trace_recursion_depth, this.ctrl.max_shove_via_recursion_depth, this.board)) continue;
            via_info = curr_via_info;
            break;
        }
        if (via_info == null) {
            FRLogger.debug("InsertFoundConnectionAlgo: via mask not found for net #" + this.ctrl.net_no);
            return false;
        }
        if (!ForcedViaAlgo.insert(via_info, p_location, net_no_arr, this.ctrl.trace_clearance_class_no, this.ctrl.trace_half_width, this.ctrl.max_shove_trace_recursion_depth, this.ctrl.max_shove_via_recursion_depth, this.board)) {
            FRLogger.debug("InsertFoundConnectionAlgo: forced via failed for net #" + this.ctrl.net_no);
            return false;
        }
        return true;
    }
}

