/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteEngine;
import app.freerouting.autoroute.CompleteExpansionRoom;
import app.freerouting.autoroute.ExpandableObject;
import app.freerouting.autoroute.ExpansionDrill;
import app.freerouting.autoroute.MazeSearchElement;
import app.freerouting.board.Item;
import app.freerouting.board.Pin;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.datastructures.ShapeTree;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.PolylineArea;
import app.freerouting.geometry.planar.PolylineShape;
import app.freerouting.geometry.planar.TileShape;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

class DrillPage
implements ExpandableObject {
    final IntBox shape;
    private final MazeSearchElement[] maze_search_info_arr;
    private final RoutingBoard board;
    private Collection<ExpansionDrill> drills;
    private int net_no = -1;

    public DrillPage(IntBox p_shape, RoutingBoard p_board) {
        this.shape = p_shape;
        this.board = p_board;
        this.maze_search_info_arr = new MazeSearchElement[p_board.get_layer_count()];
        for (int i = 0; i < this.maze_search_info_arr.length; ++i) {
            this.maze_search_info_arr[i] = new MazeSearchElement();
        }
    }

    private static Point calc_pin_center_in_drill(TileShape p_drill_shape, int p_layer, RoutingBoard p_board) {
        Set<Item> overlapping_items = p_board.overlapping_items(p_drill_shape, p_layer);
        Point result = null;
        for (Item curr_item : overlapping_items) {
            Pin curr_pin;
            if (!(curr_item instanceof Pin) || !(curr_pin = (Pin)curr_item).drill_allowed() || !p_drill_shape.contains_inside(curr_pin.get_center())) continue;
            result = curr_pin.get_center();
        }
        return result;
    }

    public Collection<ExpansionDrill> get_drills(AutorouteEngine p_autoroute_engine, boolean p_attach_smd) {
        if (this.drills == null || p_autoroute_engine.get_net_no() != this.net_no) {
            this.net_no = p_autoroute_engine.get_net_no();
            this.drills = new LinkedList<ExpansionDrill>();
            ShapeSearchTree search_tree = this.board.search_tree_manager.get_default_tree();
            LinkedList<ShapeTree.TreeEntry> overlaps = new LinkedList<ShapeTree.TreeEntry>();
            search_tree.overlapping_tree_entries(this.shape, -1, overlaps);
            LinkedList<TileShape> cutout_shapes = new LinkedList<TileShape>();
            TileShape prev_obstacle_shape = IntBox.EMPTY;
            for (ShapeTree.TreeEntry curr_entry : overlaps) {
                TileShape curr_cutout_shape;
                TileShape curr_obstacle_shape;
                Item curr_item;
                ShapeTree.Storable storable = curr_entry.object;
                if (!(storable instanceof Item) || (curr_item = (Item)storable).is_drillable(this.net_no)) continue;
                if (curr_item instanceof Pin) {
                    Pin pin = (Pin)curr_item;
                    if (p_attach_smd && pin.drill_allowed()) continue;
                }
                if (!prev_obstacle_shape.contains(curr_obstacle_shape = curr_item.get_tree_shape(search_tree, curr_entry.shape_index_in_object)) && (curr_cutout_shape = curr_obstacle_shape.intersection((TileShape)this.shape)).dimension() == 2) {
                    cutout_shapes.add(curr_cutout_shape);
                }
                prev_obstacle_shape = curr_obstacle_shape;
            }
            PolylineShape[] holes = new TileShape[cutout_shapes.size()];
            Iterator it = cutout_shapes.iterator();
            for (int i = 0; i < holes.length; ++i) {
                holes[i] = (TileShape)it.next();
            }
            PolylineArea shape_with_holes = new PolylineArea(this.shape, holes);
            TileShape[] drill_shapes = shape_with_holes.split_to_convex(p_autoroute_engine.stoppable_thread);
            int drill_first_layer = 0;
            int drill_last_layer = this.board.get_layer_count() - 1;
            for (int i = 0; i < drill_shapes.length; ++i) {
                ExpansionDrill new_drill;
                TileShape curr_drill_shape = drill_shapes[i];
                Point curr_drill_location = null;
                if (p_attach_smd && (curr_drill_location = DrillPage.calc_pin_center_in_drill(curr_drill_shape, drill_first_layer, p_autoroute_engine.board)) == null) {
                    curr_drill_location = DrillPage.calc_pin_center_in_drill(curr_drill_shape, drill_last_layer, p_autoroute_engine.board);
                }
                if (curr_drill_location == null) {
                    curr_drill_location = curr_drill_shape.centre_of_gravity().round();
                }
                if (!(new_drill = new ExpansionDrill(curr_drill_shape, curr_drill_location, drill_first_layer, drill_last_layer)).calculate_expansion_rooms(p_autoroute_engine)) continue;
                this.drills.add(new_drill);
            }
        }
        return this.drills;
    }

    @Override
    public TileShape get_shape() {
        return this.shape;
    }

    @Override
    public int get_dimension() {
        return 2;
    }

    @Override
    public int maze_search_element_count() {
        return this.maze_search_info_arr.length;
    }

    @Override
    public MazeSearchElement get_maze_search_element(int p_no) {
        return this.maze_search_info_arr[p_no];
    }

    @Override
    public void reset() {
        if (this.drills != null) {
            for (ExpansionDrill curr_drill : this.drills) {
                curr_drill.reset();
            }
        }
        for (MazeSearchElement curr_info : this.maze_search_info_arr) {
            curr_info.reset();
        }
    }

    public void invalidate() {
        this.drills = null;
    }

    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context, double p_intensity) {
    }

    @Override
    public CompleteExpansionRoom other_room(CompleteExpansionRoom p_room) {
        return null;
    }
}

