/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.BatchOptimizer;
import app.freerouting.autoroute.BoardUpdateStrategy;
import app.freerouting.autoroute.ItemRouteResult;
import app.freerouting.autoroute.ItemSelectionStrategy;
import app.freerouting.autoroute.OptimizeRouteTask;
import app.freerouting.board.Item;
import app.freerouting.core.RouterCounters;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.scoring.BoardStatistics;
import app.freerouting.logger.FRLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BatchOptimizerMultiThreaded
extends BatchOptimizer {
    private final BoardUpdateStrategy board_update_strategy;
    private final ItemSelectionStrategy item_selection_strategy;
    private final int thread_pool_size;
    private final ArrayList<Integer> item_ids = new ArrayList();
    private final HashMap<Integer, ItemRouteResult> result_map = new HashMap();
    private final ArrayList<BoardUpdateStrategy> hybrid_list = new ArrayList();
    private ThreadPoolExecutor pool;
    private ItemRouteResult best_route_result;
    private OptimizeRouteTask winning_candidate;
    private int num_tasks_finished;
    private int update_count;
    private CountDownLatch task_completion_signal = new CountDownLatch(1);
    private int hybrid_index = -1;

    public BatchOptimizerMultiThreaded(RoutingJob job) {
        super(job);
        this.thread_pool_size = job.routerSettings.optimizer.maxThreads;
        this.board_update_strategy = job.routerSettings.optimizer.boardUpdateStrategy;
        this.item_selection_strategy = job.routerSettings.optimizer.boardUpdateStrategy == BoardUpdateStrategy.GLOBAL_OPTIMAL ? ItemSelectionStrategy.SEQUENTIAL : job.routerSettings.optimizer.itemSelectionStrategy;
        this.best_route_result = new ItemRouteResult(-1);
        this.winning_candidate = null;
        if (this.board_update_strategy == BoardUpdateStrategy.HYBRID) {
            int num_optimal = 1;
            int num_prioritized = 1;
            if (job.routerSettings.optimizer.hybridRatio != null && job.routerSettings.optimizer.hybridRatio.indexOf(":") > 0) {
                int i;
                String[] ratio = job.routerSettings.optimizer.hybridRatio.split(":");
                try {
                    num_optimal = Integer.parseInt(ratio[0], 10);
                    num_prioritized = Integer.parseInt(ratio[1], 10);
                }
                catch (NumberFormatException e) {
                    job.logError("Invalid hybrid ratio", e);
                    num_optimal = 1;
                    num_prioritized = 1;
                }
                for (i = 0; i < num_optimal; ++i) {
                    this.hybrid_list.add(BoardUpdateStrategy.GLOBAL_OPTIMAL);
                }
                for (i = 0; i < num_prioritized; ++i) {
                    this.hybrid_list.add(BoardUpdateStrategy.GREEDY);
                }
            }
        }
    }

    public int get_num_tasks() {
        return this.item_ids.size();
    }

    public int get_num_tasks_finished() {
        return this.num_tasks_finished;
    }

    private BoardUpdateStrategy current_board_update_strategy() {
        if (this.board_update_strategy == BoardUpdateStrategy.HYBRID) {
            return this.hybrid_list.get(this.hybrid_index);
        }
        return this.board_update_strategy;
    }

    private ItemSelectionStrategy current_item_selection_strategy() {
        return this.current_board_update_strategy() == BoardUpdateStrategy.GLOBAL_OPTIMAL ? ItemSelectionStrategy.SEQUENTIAL : this.item_selection_strategy;
    }

    synchronized void prepare_task_completion_signal() {
        if (this.task_completion_signal.getCount() <= 0L) {
            this.task_completion_signal = new CountDownLatch(1);
        }
    }

    public synchronized boolean is_winning_candidate(OptimizeRouteTask task) {
        ++this.num_tasks_finished;
        ItemRouteResult r = task.getRouteResult();
        this.result_map.put(r.item_id(), r);
        boolean won = false;
        if (r.improved()) {
            if (this.winning_candidate == null) {
                won = true;
                this.winning_candidate = task;
                this.best_route_result = r;
            } else if (r.improved_over(this.best_route_result)) {
                won = true;
                this.winning_candidate.clean();
                this.winning_candidate = task;
                this.best_route_result = r;
            }
        }
        if (won && this.current_board_update_strategy() == BoardUpdateStrategy.GREEDY) {
            this.replaceMasterRoutingBoardWithTheWinningCandidate();
        }
        this.task_completion_signal.countDown();
        return won;
    }

    private void replaceMasterRoutingBoardWithTheWinningCandidate() {
        this.board = this.winning_candidate.board;
        BoardStatistics boardStatistics = this.board.get_statistics();
        this.fireBoardUpdatedEvent(boardStatistics, null, this.board);
        this.min_cumulative_trace_length = boardStatistics.traces.totalWeightedLength.floatValue();
        ++this.update_count;
    }

    private void prepare_next_round_of_route_items() {
        if (this.board_update_strategy == BoardUpdateStrategy.HYBRID) {
            this.hybrid_index = (this.hybrid_index + 1) % this.hybrid_list.size();
        }
        this.item_ids.clear();
        this.sorted_route_items = new BatchOptimizer.ReadSortedRouteItems(this);
        if (this.current_item_selection_strategy() == ItemSelectionStrategy.PRIORITIZED && !this.result_map.isEmpty()) {
            ArrayList<Integer> new_item_ids = new ArrayList<Integer>();
            PriorityQueue<ItemRouteResult> pq = new PriorityQueue<ItemRouteResult>();
            Item item = this.sorted_route_items.next();
            while (item != null) {
                ItemRouteResult r = this.result_map.get(item.get_id_no());
                if (r != null) {
                    pq.add(r);
                } else {
                    new_item_ids.add(item.get_id_no());
                }
                item = this.sorted_route_items.next();
            }
            ItemRouteResult r = (ItemRouteResult)pq.poll();
            while (r != null) {
                this.item_ids.add(r.item_id());
                r = (ItemRouteResult)pq.poll();
            }
            this.item_ids.addAll(new_item_ids);
        } else {
            Item item = this.sorted_route_items.next();
            while (item != null) {
                this.item_ids.add(item.get_id_no());
                item = this.sorted_route_items.next();
            }
            if (this.current_item_selection_strategy() == ItemSelectionStrategy.RANDOM) {
                Collections.shuffle(this.item_ids);
            }
        }
        this.sorted_route_items = null;
        this.result_map.clear();
    }

    @Override
    protected float opt_route_pass(int p_pass_no, boolean p_with_preferred_directions) {
        String us;
        long startTime = System.currentTimeMillis();
        this.update_count = 0;
        this.num_tasks_finished = 0;
        if (this.winning_candidate != null) {
            this.winning_candidate.clean();
            this.winning_candidate = null;
        }
        BoardStatistics boardStatisticsBefore = this.board.get_statistics();
        RouterCounters routerCounters = new RouterCounters();
        routerCounters.passCount = p_pass_no;
        this.fireBoardUpdatedEvent(boardStatisticsBefore, routerCounters, this.board);
        this.min_cumulative_trace_length = boardStatisticsBefore.traces.totalWeightedLength.floatValue();
        String optimizationPassId = "BatchOptRouteMT.opt_route_pass #" + p_pass_no + " with " + this.item_ids.size() + " items, " + boardStatisticsBefore.items.viaCount + " vias and " + "%(,.2f".formatted(boardStatisticsBefore.traces.totalLength) + " trace length running on " + this.thread_pool_size + " threads.";
        FRLogger.traceEntry(optimizationPassId);
        this.prepare_next_round_of_route_items();
        this.best_route_result = new ItemRouteResult(-1);
        this.winning_candidate = null;
        this.pool = (ThreadPoolExecutor)Executors.newFixedThreadPool(this.thread_pool_size, r -> {
            Thread t2 = new Thread(r);
            t2.setUncaughtExceptionHandler((t1, e) -> this.job.logError("Exception in thread pool worker thread: " + String.valueOf(t1), e));
            return t2;
        });
        for (int t2 = 0; t2 < this.item_ids.size(); ++t2) {
            int item_id = this.item_ids.get(t2);
            this.job.logDebug("Scheduling task #" + (t2 + 1) + " of " + this.item_ids.size() + " for item #" + item_id + ".");
            OptimizeRouteTask newTask = new OptimizeRouteTask(this, this.job, item_id, p_pass_no, p_with_preferred_directions);
            this.pool.execute(newTask);
        }
        this.job.logDebug("All items are queued for execution, waiting for the tasks to finish.");
        this.pool.shutdown();
        boolean interrupted = false;
        try {
            boolean i = false;
            while (!this.pool.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.job.logDebug("Running route optimizer on " + this.pool.getActiveCount() + " thread(s). Completed " + this.pool.getCompletedTaskCount() + " of " + this.pool.getTaskCount() + " tasks.");
                if (!this.thread.isStopRequested()) continue;
                this.pool.shutdownNow();
                return this.best_route_result.improvement_percentage();
            }
        }
        catch (InterruptedException ie) {
            this.job.logError("Exception with pool.awaitTermination", ie);
            interrupted = true;
            this.pool.shutdownNow();
        }
        this.pool = null;
        if (!interrupted && this.best_route_result.improved() && this.current_board_update_strategy() == BoardUpdateStrategy.GLOBAL_OPTIMAL) {
            this.replaceMasterRoutingBoardWithTheWinningCandidate();
        }
        float route_improved = this.best_route_result.improvement_percentage();
        if (this.use_increased_ripup_costs && !this.best_route_result.improved()) {
            this.use_increased_ripup_costs = false;
            route_improved = -1.0f;
        }
        long duration = System.currentTimeMillis() - startTime;
        long minutes = duration / 60000L;
        float sec = (float)(duration % 60000L) / 1000.0f;
        String string = us = this.current_board_update_strategy() == BoardUpdateStrategy.GLOBAL_OPTIMAL ? "Global Optimal" : "Greedy";
        String is = this.current_item_selection_strategy() == ItemSelectionStrategy.SEQUENTIAL ? "Sequential" : (this.current_item_selection_strategy() == ItemSelectionStrategy.RANDOM ? "Random" : "Prioritized");
        BoardStatistics boardStatisticsAfter = this.board.get_statistics();
        this.fireBoardUpdatedEvent(boardStatisticsAfter, routerCounters, this.board);
        this.job.logDebug("Finished optimizer pass #" + p_pass_no + " in " + minutes + " minutes " + sec + " seconds with " + this.update_count + " board updates using " + this.thread_pool_size + " thread(s) with '" + us + "' strategy and '" + is + "' item selection strategy.");
        this.job.logDebug("Route optimizer pass summary - Improved: " + this.best_route_result.improved() + ", interrupted: " + interrupted + ", via count: " + this.best_route_result.via_count() + ", trace length: " + boardStatisticsAfter.traces.totalLength + ", via count delta: " + (boardStatisticsBefore.items.viaCount - this.best_route_result.via_count()) + ", trace length delta: " + (boardStatisticsBefore.traces.totalLength.floatValue() - boardStatisticsAfter.traces.totalLength.floatValue()) + ".");
        FRLogger.traceExit(optimizationPassId);
        return route_improved;
    }

    public double getWinningCandidateScore() {
        return this.board.get_statistics().traces.totalLength.floatValue();
    }
}

