/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteAttemptResult;
import app.freerouting.autoroute.AutorouteAttemptState;
import app.freerouting.autoroute.AutorouteControl;
import app.freerouting.autoroute.AutorouteEngine;
import app.freerouting.autoroute.BatchAutorouterThread;
import app.freerouting.autoroute.BoardHistory;
import app.freerouting.autoroute.NamedAlgorithm;
import app.freerouting.autoroute.NamedAlgorithmType;
import app.freerouting.autoroute.TaskState;
import app.freerouting.autoroute.events.BoardUpdatedEvent;
import app.freerouting.autoroute.events.BoardUpdatedEventListener;
import app.freerouting.autoroute.events.TaskStateChangedEvent;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.Connectable;
import app.freerouting.board.DrillItem;
import app.freerouting.board.Item;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.RoutingBoard;
import app.freerouting.core.RouterCounters;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.RoutingJobState;
import app.freerouting.core.StoppableThread;
import app.freerouting.core.scoring.BoardStatistics;
import app.freerouting.datastructures.TimeLimit;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.geometry.planar.FloatLine;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.RatsNest;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.Net;
import app.freerouting.settings.RouterSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class BatchAutorouter
extends NamedAlgorithm {
    private static final int BOARD_RANK_LIMIT = 50;
    private static final int MAXIMUM_TRIES_ON_THE_SAME_BOARD = 3;
    private static final int TIME_LIMIT_TO_PREVENT_ENDLESS_LOOP = 1000;
    private static final int STOP_AT_PASS_MINIMUM = 8;
    private static final int STOP_AT_PASS_MODULO = 4;
    private final boolean remove_unconnected_vias;
    private final AutorouteControl.ExpansionCostFactor[] trace_cost_arr;
    private final boolean retain_autoroute_database;
    private final int start_ripup_costs;
    private final int trace_pull_tight_accuracy;
    protected RoutingJob job;
    private Random random;
    private FloatLine air_line;

    public BatchAutorouter(RoutingJob job) {
        this(job.thread, job.board, job.routerSettings, !job.routerSettings.getRunFanout(), true, job.routerSettings.get_start_ripup_costs(), job.routerSettings.trace_pull_tight_accuracy);
        this.job = job;
    }

    public BatchAutorouter(StoppableThread p_thread, RoutingBoard board, RouterSettings settings, boolean p_remove_unconnected_vias, boolean p_with_preferred_directions, int p_start_ripup_costs, int p_pull_tight_accuracy) {
        super(p_thread, board, settings);
        this.random = new Random(settings.random_seed);
        this.remove_unconnected_vias = p_remove_unconnected_vias;
        if (p_with_preferred_directions) {
            this.trace_cost_arr = this.settings.get_trace_cost_arr();
        } else {
            this.trace_cost_arr = new AutorouteControl.ExpansionCostFactor[this.board.get_layer_count()];
            for (int i = 0; i < this.trace_cost_arr.length; ++i) {
                double curr_min_cost = this.settings.get_preferred_direction_trace_costs(i);
                this.trace_cost_arr[i] = new AutorouteControl.ExpansionCostFactor(curr_min_cost, curr_min_cost);
            }
        }
        this.start_ripup_costs = p_start_ripup_costs;
        this.trace_pull_tight_accuracy = p_pull_tight_accuracy;
        this.retain_autoroute_database = false;
    }

    public static int autoroute_passes_for_optimizing_item(RoutingJob job, int p_max_pass_count, int p_ripup_costs, int trace_pull_tight_accuracy, boolean p_with_preferred_directions, RoutingBoard updated_routing_board, RouterSettings routerSettings) {
        int curr_pass_no;
        BatchAutorouter router_instance = new BatchAutorouter(job.thread, updated_routing_board, routerSettings, true, p_with_preferred_directions, p_ripup_costs, trace_pull_tight_accuracy);
        router_instance.job = job;
        boolean still_unrouted_items = true;
        for (curr_pass_no = 1; still_unrouted_items && !job.thread.is_stop_auto_router_requested() && curr_pass_no <= p_max_pass_count; ++curr_pass_no) {
            still_unrouted_items = router_instance.autoroute_pass(curr_pass_no);
            if (!still_unrouted_items || job.thread.is_stop_auto_router_requested() || updated_routing_board != null) continue;
            routerSettings.increment_pass_no();
        }
        router_instance.remove_tails(Item.StopConnectionOption.NONE);
        if (!still_unrouted_items) {
            --curr_pass_no;
        }
        return curr_pass_no;
    }

    private static LinkedList<Item> getAutorouteItems(RoutingBoard board) {
        UndoableObjects.Storable curr_ob;
        LinkedList<Item> autoroute_item_list = new LinkedList<Item>();
        TreeSet<Item> handled_items = new TreeSet<Item>();
        Iterator<UndoableObjects.UndoableObjectNode> it = board.item_list.start_read_object();
        while ((curr_ob = board.item_list.read_object(it)) != null) {
            Item curr_item;
            if (!(curr_ob instanceof Connectable) || !(curr_ob instanceof Item) || (curr_item = (Item)curr_ob).is_routable() || handled_items.contains(curr_item)) continue;
            for (int i = 0; i < curr_item.net_count(); ++i) {
                int curr_net_no = curr_item.get_net_no(i);
                Set<Item> connected_set = curr_item.get_connected_set(curr_net_no);
                for (Item curr_connected_item : connected_set) {
                    if (curr_connected_item.net_count() > 1) continue;
                    handled_items.add(curr_connected_item);
                }
                int net_item_count = board.connectable_item_count(curr_net_no);
                if (connected_set.size() >= net_item_count || curr_item.has_ignored_nets()) continue;
                autoroute_item_list.add(curr_item);
            }
        }
        return autoroute_item_list;
    }

    private boolean autoroute_pass_multi_thread(int p_pass_no) {
        try {
            int threadIndex;
            LinkedList<Item> autoroute_item_list = BatchAutorouter.getAutorouteItems(this.board);
            if (autoroute_item_list.isEmpty()) {
                this.air_line = null;
                return false;
            }
            boolean useSlowAlgorithm = p_pass_no % 4 == 0;
            final BatchAutorouterThread[] autorouterThreads = new BatchAutorouterThread[this.job.routerSettings.maxThreads];
            BoardHistory bh = new BoardHistory(this.job.routerSettings.scoring);
            for (threadIndex = 0; threadIndex < this.job.routerSettings.maxThreads; ++threadIndex) {
                RoutingBoard clonedBoard = this.board.deepCopy();
                ArrayList<Item> clonedAutorouteItemList = new ArrayList<Item>(BatchAutorouter.getAutorouteItems(clonedBoard));
                Collections.shuffle(clonedAutorouteItemList, this.random);
                autorouterThreads[threadIndex] = new BatchAutorouterThread(clonedBoard, clonedAutorouteItemList, p_pass_no, useSlowAlgorithm, this.job.routerSettings, this.start_ripup_costs, this.trace_pull_tight_accuracy, this.remove_unconnected_vias, true);
                autorouterThreads[threadIndex].setName("Router thread #" + p_pass_no + "." + this.ThreadIndexToLetter(threadIndex));
                autorouterThreads[threadIndex].setDaemon(true);
                autorouterThreads[threadIndex].setPriority(1);
            }
            autorouterThreads[0].addBoardUpdatedEventListener(new BoardUpdatedEventListener(){
                final /* synthetic */ BatchAutorouter this$0;
                {
                    BatchAutorouter batchAutorouter = this$0;
                    Objects.requireNonNull(batchAutorouter);
                    this.this$0 = batchAutorouter;
                }

                @Override
                public void onBoardUpdatedEvent(BoardUpdatedEvent event) {
                    this.this$0.air_line = autorouterThreads[0].latest_air_line;
                    this.this$0.fireBoardUpdatedEvent(event.getBoardStatistics(), event.getRouterCounters(), event.getBoard());
                }
            });
            for (threadIndex = 0; threadIndex < this.job.routerSettings.maxThreads; ++threadIndex) {
                autorouterThreads[threadIndex].start();
            }
            for (threadIndex = 0; threadIndex < this.job.routerSettings.maxThreads; ++threadIndex) {
                BatchAutorouterThread autorouterThread = autorouterThreads[threadIndex];
                try {
                    autorouterThread.join(1000L);
                }
                catch (InterruptedException e) {
                    this.job.logError("Autorouter thread #" + p_pass_no + "." + this.ThreadIndexToLetter(threadIndex) + " was interrupted", e);
                    this.thread.requestStop();
                    break;
                }
                bh.add(autorouterThread.getBoard());
                BoardStatistics clonedBoardStatistics = autorouterThread.getBoard().get_statistics();
                float clonedBoardScore = clonedBoardStatistics.getNormalizedScore(this.job.routerSettings.scoring);
                this.job.logDebug("Router thread #" + p_pass_no + "." + this.ThreadIndexToLetter(threadIndex) + " finished with score: " + FRLogger.formatScore(clonedBoardScore, clonedBoardStatistics.connections.incompleteCount, clonedBoardStatistics.clearanceViolations.totalCount));
            }
            this.board = bh.restoreBestBoard();
            bh.clear();
            this.air_line = null;
            return true;
        }
        catch (Exception e) {
            this.job.logError("Something went wrong during the auto-routing", e);
            this.air_line = null;
            return false;
        }
    }

    private boolean autoroute_pass(int p_pass_no) {
        try {
            LinkedList<Item> autoroute_item_list = BatchAutorouter.getAutorouteItems(this.board);
            if (autoroute_item_list.isEmpty()) {
                this.air_line = null;
                return false;
            }
            int items_to_go_count = autoroute_item_list.size();
            int ripped_item_count = 0;
            int not_routed = 0;
            int routed = 0;
            int skipped = 0;
            BoardStatistics stats = this.board.get_statistics();
            RouterCounters routerCounters = new RouterCounters();
            routerCounters.passCount = p_pass_no;
            routerCounters.queuedToBeRoutedCount = items_to_go_count;
            routerCounters.skippedCount = skipped;
            routerCounters.rippedCount = ripped_item_count;
            routerCounters.failedToBeRoutedCount = not_routed;
            routerCounters.routedCount = routed;
            routerCounters.incompleteCount = new RatsNest(this.board).incomplete_count();
            this.fireBoardUpdatedEvent(stats, routerCounters, this.board);
            Collections.shuffle(autoroute_item_list, this.random);
            for (Item curr_item : autoroute_item_list) {
                if (this.thread.is_stop_auto_router_requested()) break;
                for (int i = 0; i < curr_item.net_count() && !this.thread.is_stop_auto_router_requested(); ++i) {
                    this.board.start_marking_changed_area();
                    TreeSet<Item> ripped_item_list = new TreeSet<Item>();
                    boolean useSlowAlgorithm = p_pass_no % 4 == 0;
                    AutorouteAttemptResult autorouterResult = this.autoroute_item(curr_item, curr_item.get_net_no(i), ripped_item_list, p_pass_no, useSlowAlgorithm);
                    if (autorouterResult.state == AutorouteAttemptState.ROUTED) {
                        ++routed;
                    } else if (autorouterResult.state == AutorouteAttemptState.ALREADY_CONNECTED || autorouterResult.state == AutorouteAttemptState.NO_UNCONNECTED_NETS || autorouterResult.state == AutorouteAttemptState.CONNECTED_TO_PLANE) {
                        ++skipped;
                    } else {
                        this.job.logDebug("Autorouter " + autorouterResult.details);
                        ++not_routed;
                    }
                    BoardStatistics boardStatistics = this.board.get_statistics();
                    routerCounters.passCount = p_pass_no;
                    routerCounters.queuedToBeRoutedCount = --items_to_go_count;
                    routerCounters.skippedCount = skipped;
                    routerCounters.rippedCount = ripped_item_count += ripped_item_list.size();
                    routerCounters.failedToBeRoutedCount = not_routed;
                    routerCounters.routedCount = routed;
                    routerCounters.incompleteCount = new RatsNest(this.board).incomplete_count();
                    this.fireBoardUpdatedEvent(boardStatistics, routerCounters, this.board);
                }
            }
            if (this.remove_unconnected_vias) {
                this.remove_tails(Item.StopConnectionOption.NONE);
            } else {
                this.remove_tails(Item.StopConnectionOption.FANOUT_VIA);
            }
            this.air_line = null;
            return true;
        }
        catch (Exception e) {
            this.job.logError("Something went wrong during the auto-routing", e);
            this.air_line = null;
            return false;
        }
    }

    @Override
    public String getId() {
        return "freerouting-router";
    }

    @Override
    public String getName() {
        return "Freerouting Auto-router";
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public String getDescription() {
        return "Freerouting Auto-router v1.0";
    }

    @Override
    public NamedAlgorithmType getType() {
        return NamedAlgorithmType.ROUTER;
    }

    public boolean runBatchLoop() {
        this.fireTaskStateChangedEvent(new TaskStateChangedEvent(this, TaskState.STARTED, 0, this.board.get_hash()));
        boolean continueAutorouting = true;
        BoardHistory bh = new BoardHistory(this.job.routerSettings.scoring);
        while (continueAutorouting && !this.thread.is_stop_auto_router_requested()) {
            if (this.job != null && this.job.state == RoutingJobState.TIMED_OUT) {
                this.thread.request_stop_auto_router();
            }
            String current_board_hash = this.board.get_hash();
            int curr_pass_no = this.settings.get_start_pass_no();
            if (curr_pass_no > this.settings.get_stop_pass_no()) {
                this.thread.request_stop_auto_router();
                break;
            }
            this.fireTaskStateChangedEvent(new TaskStateChangedEvent(this, TaskState.RUNNING, curr_pass_no, current_board_hash));
            float boardScoreBefore = new BoardStatistics(this.board).getNormalizedScore(this.job.routerSettings.scoring);
            bh.add(this.board);
            FRLogger.traceEntry("BatchAutorouter.autoroute_pass #" + curr_pass_no + " on board '" + current_board_hash + "'");
            continueAutorouting = this.autoroute_pass(curr_pass_no);
            BoardStatistics boardStatisticsAfter = new BoardStatistics(this.board);
            float boardScoreAfter = boardStatisticsAfter.getNormalizedScore(this.job.routerSettings.scoring);
            if ((bh.size() >= 8 || this.thread.is_stop_auto_router_requested()) && (curr_pass_no % 4 == 0 && curr_pass_no >= 8 || this.thread.is_stop_auto_router_requested()) && bh.getMaxScore() >= boardScoreAfter) {
                RoutingBoard boardToRestore = bh.restoreBoard(3);
                if (boardToRestore == null) {
                    this.job.logInfo("The router was not able to improve the board, stopping the auto-router.");
                    this.thread.request_stop_auto_router();
                    break;
                }
                int boardToRestoreRank = bh.getRank(boardToRestore);
                if (boardToRestoreRank > 50) {
                    this.thread.request_stop_auto_router();
                    break;
                }
                this.board = boardToRestore;
                BoardStatistics boardStatistics = this.board.get_statistics();
                this.job.logInfo("Restoring an earlier board that has the score of " + FRLogger.formatScore(boardStatistics.getNormalizedScore(this.job.routerSettings.scoring), boardStatistics.connections.incompleteCount, boardStatistics.clearanceViolations.totalCount) + ".");
            }
            double autorouter_pass_duration = FRLogger.traceExit("BatchAutorouter.autoroute_pass #" + curr_pass_no + " on board '" + current_board_hash + "'");
            String passCompletedMessage = "Auto-router pass #" + curr_pass_no + " on board '" + current_board_hash + "' was completed in " + FRLogger.formatDuration(autorouter_pass_duration) + " with the score of " + FRLogger.formatScore(boardScoreAfter, boardStatisticsAfter.connections.incompleteCount, boardStatisticsAfter.clearanceViolations.totalCount);
            passCompletedMessage = this.job.resourceUsage.cpuTimeUsed > 0.0f ? passCompletedMessage + ", using " + FRLogger.defaultFloatFormat.format(this.job.resourceUsage.cpuTimeUsed) + " CPU seconds and the job allocated " + (int)this.job.resourceUsage.maxMemoryUsed + " MB of memory so far." : passCompletedMessage + ".";
            this.job.logInfo(passCompletedMessage);
            if (this.settings.save_intermediate_stages) {
                this.fireBoardSnapshotEvent(this.board);
            }
            if (!continueAutorouting || this.thread.is_stop_auto_router_requested()) continue;
            this.settings.increment_pass_no();
        }
        this.job.board = this.board;
        if (!(this.remove_unconnected_vias || continueAutorouting || this.thread.is_stop_auto_router_requested())) {
            this.remove_tails(Item.StopConnectionOption.NONE);
        }
        bh.clear();
        if (!this.thread.is_stop_auto_router_requested()) {
            this.fireTaskStateChangedEvent(new TaskStateChangedEvent(this, TaskState.FINISHED, this.settings.get_start_pass_no(), this.board.get_hash()));
        } else {
            this.fireTaskStateChangedEvent(new TaskStateChangedEvent(this, TaskState.CANCELLED, this.settings.get_start_pass_no(), this.board.get_hash()));
        }
        return !this.thread.is_stop_auto_router_requested();
    }

    private void remove_tails(Item.StopConnectionOption p_stop_connection_option) {
        this.board.start_marking_changed_area();
        this.board.remove_trace_tails(-1, p_stop_connection_option);
        this.board.opt_changed_area(new int[0], null, this.trace_pull_tight_accuracy, this.trace_cost_arr, this.thread, 1000);
    }

    private AutorouteAttemptResult autoroute_item(Item p_item, int p_route_net_no, SortedSet<Item> p_ripped_item_list, int p_ripup_pass_no, boolean useSlowAlgorithm) {
        try {
            Set<Item> route_dest_set;
            Set<Item> route_start_set;
            boolean contains_plane = false;
            Net route_net = this.board.rules.nets.get(p_route_net_no);
            if (route_net != null) {
                contains_plane = route_net.contains_plane();
            }
            int curr_via_costs = contains_plane ? this.settings.get_plane_via_costs() : this.settings.get_via_costs();
            AutorouteControl autoroute_control = new AutorouteControl(this.board, p_route_net_no, this.settings, curr_via_costs, this.trace_cost_arr);
            autoroute_control.ripup_allowed = true;
            autoroute_control.ripup_costs = this.start_ripup_costs * p_ripup_pass_no;
            autoroute_control.remove_unconnected_vias = this.remove_unconnected_vias;
            Set<Item> unconnected_set = p_item.get_unconnected_set(p_route_net_no);
            if (unconnected_set.isEmpty()) {
                return new AutorouteAttemptResult(AutorouteAttemptState.NO_UNCONNECTED_NETS);
            }
            Set<Item> connected_set = p_item.get_connected_set(p_route_net_no);
            if (contains_plane) {
                for (Item curr_item : connected_set) {
                    if (!(curr_item instanceof ConductionArea)) continue;
                    return new AutorouteAttemptResult(AutorouteAttemptState.CONNECTED_TO_PLANE);
                }
            }
            if (contains_plane) {
                route_start_set = connected_set;
                route_dest_set = unconnected_set;
            } else {
                route_start_set = unconnected_set;
                route_dest_set = connected_set;
            }
            this.calc_airline(route_start_set, route_dest_set);
            double max_milliseconds = 100000.0 * Math.pow(2.0, p_ripup_pass_no - 1);
            max_milliseconds = Math.min(max_milliseconds, 2.147483647E9);
            TimeLimit time_limit = new TimeLimit((int)max_milliseconds);
            AutorouteEngine autoroute_engine = this.board.init_autoroute(p_route_net_no, autoroute_control.trace_clearance_class_no, this.thread, time_limit, this.retain_autoroute_database, useSlowAlgorithm);
            AutorouteAttemptResult autoroute_result = autoroute_engine.autoroute_connection(route_start_set, route_dest_set, autoroute_control, p_ripped_item_list);
            if (autoroute_result.state == AutorouteAttemptState.ROUTED) {
                this.board.opt_changed_area(new int[0], null, this.trace_pull_tight_accuracy, autoroute_control.trace_costs, this.thread, 1000);
            }
            return autoroute_result;
        }
        catch (Exception e) {
            this.job.logError("Error during autoroute_item", e);
            return new AutorouteAttemptResult(AutorouteAttemptState.FAILED);
        }
    }

    public FloatLine get_air_line() {
        if (this.air_line == null) {
            return null;
        }
        if (this.air_line.a == null || this.air_line.b == null) {
            return null;
        }
        return this.air_line;
    }

    private void calc_airline(Collection<Item> p_from_items, Collection<Item> p_to_items) {
        double curr_distance;
        PolylineTrace to_trace;
        FloatPoint curr_to_corner;
        FloatPoint from_corner = null;
        FloatPoint to_corner = null;
        double min_distance = Double.MAX_VALUE;
        for (Item curr_from_item : p_from_items) {
            if (!(curr_from_item instanceof DrillItem)) {
                if (!(curr_from_item instanceof PolylineTrace)) continue;
                PolylineTrace from_trace = (PolylineTrace)curr_from_item;
                continue;
            }
            DrillItem item = (DrillItem)curr_from_item;
            FloatPoint curr_from_corner = item.get_center().to_float();
            for (Item curr_to_item : p_to_items) {
                if (curr_to_item instanceof DrillItem) {
                    DrillItem drillItem = (DrillItem)curr_to_item;
                    curr_to_corner = drillItem.get_center().to_float();
                } else {
                    if (!(curr_to_item instanceof PolylineTrace)) continue;
                    to_trace = (PolylineTrace)curr_to_item;
                    curr_to_corner = this.nearest_point_on_trace(to_trace, curr_from_corner);
                }
                if (!((curr_distance = curr_from_corner.distance(curr_to_corner)) < min_distance)) continue;
                min_distance = curr_distance;
                from_corner = curr_from_corner;
                to_corner = curr_to_corner;
            }
        }
        for (Item curr_from_item : p_from_items) {
            if (!(curr_from_item instanceof PolylineTrace)) continue;
            PolylineTrace from_trace = (PolylineTrace)curr_from_item;
            for (Item curr_to_item : p_to_items) {
                FloatPoint curr_from_corner;
                if (curr_to_item instanceof DrillItem) {
                    DrillItem item = (DrillItem)curr_to_item;
                    curr_to_corner = item.get_center().to_float();
                    curr_from_corner = this.nearest_point_on_trace(from_trace, curr_to_corner);
                } else {
                    if (!(curr_to_item instanceof PolylineTrace)) continue;
                    to_trace = (PolylineTrace)curr_to_item;
                    FloatPoint[] closest_points = this.find_closest_points_between_traces(from_trace, to_trace);
                    curr_from_corner = closest_points[0];
                    curr_to_corner = closest_points[1];
                }
                if (!((curr_distance = curr_from_corner.distance(curr_to_corner)) < min_distance)) continue;
                min_distance = curr_distance;
                from_corner = curr_from_corner;
                to_corner = curr_to_corner;
            }
        }
        this.air_line = from_corner != null && to_corner != null ? new FloatLine(from_corner, to_corner) : null;
    }

    private FloatPoint nearest_point_on_trace(PolylineTrace p_trace, FloatPoint p_point) {
        double min_distance = Double.MAX_VALUE;
        FloatPoint nearest_point = null;
        FloatPoint first_corner = p_trace.first_corner().to_float();
        FloatPoint last_corner = p_trace.last_corner().to_float();
        double distance_to_first = p_point.distance(first_corner);
        double distance_to_last = p_point.distance(last_corner);
        if (distance_to_first < min_distance) {
            min_distance = distance_to_first;
            nearest_point = first_corner;
        }
        if (distance_to_last < min_distance) {
            min_distance = distance_to_last;
            nearest_point = last_corner;
        }
        for (int i = 0; i < p_trace.corner_count() - 1; ++i) {
            double distance;
            FloatPoint segment_end;
            FloatPoint segment_start = p_trace.polyline().corner_approx(i);
            FloatLine segment = new FloatLine(segment_start, segment_end = p_trace.polyline().corner_approx(i + 1));
            FloatPoint projection = segment.perpendicular_projection(p_point);
            if (!projection.is_contained_in_box(segment_start, segment_end, 0.01) || !((distance = p_point.distance(projection)) < min_distance)) continue;
            min_distance = distance;
            nearest_point = projection;
        }
        return nearest_point;
    }

    private FloatPoint[] find_closest_points_between_traces(PolylineTrace p_first_trace, PolylineTrace p_second_trace) {
        double min_distance = Double.MAX_VALUE;
        FloatPoint[] result = new FloatPoint[2];
        FloatPoint first_trace_start = p_first_trace.first_corner().to_float();
        FloatPoint first_trace_end = p_first_trace.last_corner().to_float();
        FloatPoint second_trace_start = p_second_trace.first_corner().to_float();
        FloatPoint second_trace_end = p_second_trace.last_corner().to_float();
        double distance = first_trace_start.distance(second_trace_start);
        if (distance < min_distance) {
            min_distance = distance;
            result[0] = first_trace_start;
            result[1] = second_trace_start;
        }
        if ((distance = first_trace_start.distance(second_trace_end)) < min_distance) {
            min_distance = distance;
            result[0] = first_trace_start;
            result[1] = second_trace_end;
        }
        if ((distance = first_trace_end.distance(second_trace_start)) < min_distance) {
            min_distance = distance;
            result[0] = first_trace_end;
            result[1] = second_trace_start;
        }
        if ((distance = first_trace_end.distance(second_trace_end)) < min_distance) {
            min_distance = distance;
            result[0] = first_trace_end;
            result[1] = second_trace_end;
        }
        for (int i = 0; i < p_first_trace.corner_count() - 1; ++i) {
            FloatPoint first_segment_start = p_first_trace.polyline().corner_approx(i);
            FloatPoint first_segment_end = p_first_trace.polyline().corner_approx(i + 1);
            FloatLine first_segment = new FloatLine(first_segment_start, first_segment_end);
            for (int j = 0; j < p_second_trace.corner_count() - 1; ++j) {
                FloatPoint point_on_first;
                FloatPoint second_segment_end;
                FloatPoint second_segment_start = p_second_trace.polyline().corner_approx(j);
                FloatLine second_segment = new FloatLine(second_segment_start, second_segment_end = p_second_trace.polyline().corner_approx(j + 1));
                FloatPoint point_on_second = second_segment.perpendicular_projection(point_on_first = first_segment.nearest_segment_point(second_segment_start));
                if (!point_on_second.is_contained_in_box(second_segment_start, second_segment_end, 0.01)) {
                    double dist_to_end;
                    double dist_to_start = point_on_first.distance(second_segment_start);
                    FloatPoint floatPoint = point_on_second = dist_to_start < (dist_to_end = point_on_first.distance(second_segment_end)) ? second_segment_start : second_segment_end;
                }
                if (!((distance = (point_on_first = first_segment.nearest_segment_point(point_on_second)).distance(point_on_second)) < min_distance)) continue;
                min_distance = distance;
                result[0] = point_on_first;
                result[1] = point_on_second;
            }
        }
        return result;
    }

    private String ThreadIndexToLetter(int threadIndex) {
        if (threadIndex < 0) {
            return "";
        }
        if (threadIndex < 26) {
            return String.valueOf((char)(65 + threadIndex));
        }
        if (threadIndex < 676) {
            int firstLetterIndex = threadIndex / 26;
            int secondLetterIndex = threadIndex % 26;
            return String.valueOf((char)(65 + firstLetterIndex)) + (char)(65 + secondLetterIndex);
        }
        int firstLetterIndex = threadIndex / 676;
        int secondLetterIndex = threadIndex / 26 % 26;
        int thirdLetterIndex = threadIndex % 26;
        return String.valueOf((char)(65 + firstLetterIndex)) + (char)(65 + secondLetterIndex) + (char)(65 + thirdLetterIndex);
    }
}

