/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.board.RoutingBoard;
import app.freerouting.core.Padstack;
import app.freerouting.geometry.planar.ConvexShape;
import app.freerouting.rules.Net;
import app.freerouting.rules.NetClass;
import app.freerouting.rules.ViaInfo;
import app.freerouting.rules.ViaRule;
import app.freerouting.settings.RouterSettings;

public class AutorouteControl {
    public final RouterSettings settings;
    public final ExpansionCostFactor[] trace_costs;
    public final boolean with_neckdown;
    public final boolean[] layer_active;
    final int layer_count;
    final int[] trace_half_width;
    final int[] compensated_trace_half_width;
    final double[] via_radius_arr;
    final ViaCost[] add_via_costs;
    public int trace_clearance_class_no;
    public boolean vias_allowed;
    public boolean attach_smd_allowed;
    public double min_normal_via_cost;
    public boolean ripup_allowed;
    public int ripup_costs;
    public int ripup_pass_no;
    public boolean is_fanout;
    public boolean remove_unconnected_vias;
    int net_no;
    int via_clearance_class;
    ViaRule via_rule;
    ViaMask[] via_info_arr;
    int via_lower_bound;
    int via_upper_bound;
    double max_via_radius;
    int tidy_region_width;
    int pull_tight_accuracy;
    int max_shove_trace_recursion_depth;
    int max_shove_via_recursion_depth;
    int max_spring_over_recursion_depth;
    double min_cheap_via_cost;

    public AutorouteControl(RoutingBoard p_board, int p_net_no, RouterSettings p_settings) {
        this(p_board, p_settings, p_settings.get_trace_cost_arr());
        this.init_net(p_net_no, p_board, p_settings.get_via_costs());
    }

    public AutorouteControl(RoutingBoard p_board, int p_net_no, RouterSettings p_settings, int p_via_costs, ExpansionCostFactor[] p_trace_cost_arr) {
        this(p_board, p_settings, p_trace_cost_arr);
        this.init_net(p_net_no, p_board, p_via_costs);
    }

    private AutorouteControl(RoutingBoard p_board, RouterSettings p_settings, ExpansionCostFactor[] p_trace_costs_arr) {
        int i;
        this.settings = p_settings;
        this.layer_count = p_board.get_layer_count();
        this.trace_half_width = new int[this.layer_count];
        this.compensated_trace_half_width = new int[this.layer_count];
        this.layer_active = new boolean[this.layer_count];
        this.vias_allowed = p_settings.get_vias_allowed();
        this.via_radius_arr = new double[this.layer_count];
        this.add_via_costs = new ViaCost[this.layer_count];
        for (i = 0; i < this.layer_count; ++i) {
            this.add_via_costs[i] = new ViaCost(this.layer_count);
            this.layer_active[i] = p_settings.get_layer_active(i);
        }
        this.is_fanout = false;
        this.remove_unconnected_vias = true;
        this.with_neckdown = p_settings.get_automatic_neckdown();
        this.tidy_region_width = Integer.MAX_VALUE;
        this.pull_tight_accuracy = 500;
        this.max_shove_trace_recursion_depth = 20;
        this.max_shove_via_recursion_depth = 5;
        this.max_spring_over_recursion_depth = 5;
        for (i = 0; i < this.layer_count; ++i) {
            for (int j = 0; j < this.layer_count; ++j) {
                this.add_via_costs[i].to_layer[j] = 0;
            }
        }
        this.trace_costs = p_trace_costs_arr;
        this.attach_smd_allowed = false;
        this.via_lower_bound = 0;
        this.via_upper_bound = this.layer_count;
        this.ripup_allowed = false;
        this.ripup_costs = 1000;
        this.ripup_pass_no = 1;
    }

    private void init_net(int p_net_no, RoutingBoard p_board, int p_via_costs) {
        int i;
        NetClass curr_net_class;
        this.net_no = p_net_no;
        Net curr_net = p_board.rules.nets.get(p_net_no);
        if (curr_net != null) {
            curr_net_class = curr_net.get_class();
            this.trace_clearance_class_no = curr_net_class.get_trace_clearance_class();
            this.via_rule = curr_net_class.get_via_rule();
        } else {
            this.trace_clearance_class_no = 1;
            this.via_rule = p_board.rules.via_rules.firstElement();
            curr_net_class = null;
        }
        for (i = 0; i < this.layer_count; ++i) {
            this.trace_half_width[i] = this.net_no > 0 ? p_board.rules.get_trace_half_width(this.net_no, i) : p_board.rules.get_trace_half_width(1, i);
            this.compensated_trace_half_width[i] = this.trace_half_width[i] + p_board.rules.clearance_matrix.clearance_compensation_value(this.trace_clearance_class_no, i);
            if (curr_net_class == null || curr_net_class.is_active_routing_layer(i)) continue;
            this.layer_active[i] = false;
        }
        this.via_clearance_class = this.via_rule.via_count() > 0 ? this.via_rule.get_via(0).get_clearance_class() : 1;
        this.via_info_arr = new ViaMask[this.via_rule.via_count()];
        for (i = 0; i < this.via_rule.via_count(); ++i) {
            ViaInfo curr_via = this.via_rule.get_via(i);
            if (curr_via.attach_smd_allowed()) {
                this.attach_smd_allowed = true;
            }
            Padstack curr_via_padstack = curr_via.get_padstack();
            int from_layer = curr_via_padstack.from_layer();
            int to_layer = curr_via_padstack.to_layer();
            for (int j = from_layer; j <= to_layer; ++j) {
                ConvexShape curr_shape = curr_via_padstack.get_shape(j);
                double curr_radius = curr_shape != null ? 0.5 * curr_shape.max_width() : 0.0;
                this.via_radius_arr[j] = Math.max(this.via_radius_arr[j], curr_radius);
            }
            this.via_info_arr[i] = new ViaMask(from_layer, to_layer, curr_via.attach_smd_allowed());
        }
        for (int j = 0; j < this.layer_count; ++j) {
            this.via_radius_arr[j] = Math.max(this.via_radius_arr[j], (double)this.trace_half_width[j]);
            this.max_via_radius = Math.max(this.max_via_radius, this.via_radius_arr[j]);
        }
        double via_cost_factor = this.max_via_radius;
        via_cost_factor = Math.max(via_cost_factor, 1.0);
        this.min_normal_via_cost = (double)p_via_costs * via_cost_factor;
        this.min_cheap_via_cost = 0.8 * this.min_normal_via_cost;
    }

    public static class ExpansionCostFactor {
        public final double horizontal;
        public final double vertical;

        public ExpansionCostFactor(double p_horizontal, double p_vertical) {
            this.horizontal = p_horizontal;
            this.vertical = p_vertical;
        }
    }

    static class ViaCost {
        public int[] to_layer;

        private ViaCost(int p_layer_count) {
            this.to_layer = new int[p_layer_count];
        }
    }

    static class ViaMask {
        final int from_layer;
        final int to_layer;
        final boolean attach_smd_allowed;

        ViaMask(int p_from_layer, int p_to_layer, boolean p_attach_smd_allowed) {
            this.from_layer = p_from_layer;
            this.to_layer = p_to_layer;
            this.attach_smd_allowed = p_attach_smd_allowed;
        }
    }
}

