/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api.v1;

import app.freerouting.api.BaseController;
import app.freerouting.api.dto.BoardFilePayload;
import app.freerouting.board.BoardLoader;
import app.freerouting.board.ItemIdentificationNumberGenerator;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.RoutingJobState;
import app.freerouting.core.Session;
import app.freerouting.drc.DesignRulesChecker;
import app.freerouting.gui.FileFormat;
import app.freerouting.interactive.HeadlessBoardManager;
import app.freerouting.logger.FRLogger;
import app.freerouting.logger.LogEntries;
import app.freerouting.logger.LogEntry;
import app.freerouting.management.RoutingJobScheduler;
import app.freerouting.management.SessionManager;
import app.freerouting.management.TextManager;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.management.gson.GsonProvider;
import app.freerouting.settings.RouterSettings;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Path(value="/v1/jobs")
@Tag(name="Jobs", description="Routing job management endpoints for creating, monitoring, and controlling PCB routing jobs")
public class JobControllerV1
extends BaseController {
    private static final ConcurrentHashMap<String, Long> previousOutputChecksums = new ConcurrentHashMap();

    @Operation(summary="Enqueue new routing job", description="Creates and enqueues a new PCB routing job within a session. The job must have both input file and settings uploaded before it can be started.")
    @RequestBody(description="Routing job configuration", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=RoutingJob.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Job enqueued successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoutingJob.class))}), @ApiResponse(responseCode="400", description="Invalid job data or session ID", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"error\":\"The job data is invalid.\"}")})})})
    @POST
    @Path(value="/enqueue")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response enqueueJob(String requestBody) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = GsonProvider.GSON.fromJson(requestBody, RoutingJob.class);
        if (job == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The job data is invalid.\"}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        String request = GsonProvider.GSON.toJson(job);
        try {
            job = RoutingJobScheduler.getInstance().enqueueJob(job);
            RoutingJobScheduler.getInstance().saveJob(job);
            job.addSettingsUpdatedEventListener(e -> RoutingJobScheduler.getInstance().saveJob(e.getJob()));
            job.addInputUpdatedEventListener(e -> RoutingJobScheduler.getInstance().saveJob(e.getJob()));
            job.addOutputUpdatedEventListener(e -> RoutingJobScheduler.getInstance().saveJob(e.getJob()));
        }
        catch (Exception e2) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"" + e2.getMessage() + "\"}").build();
        }
        String response = GsonProvider.GSON.toJson(job);
        FRAnalytics.apiEndpointCalled("POST v1/jobs/enqueue", request, response);
        return Response.ok(response).build();
    }

    @Operation(summary="List routing jobs", description="Retrieves a list of all routing jobs in the specified session. Use 'all' as sessionId to list all jobs for the authenticated user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of jobs retrieved successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoutingJob[].class))})})
    @GET
    @Path(value="/list/{sessionId}")
    @Produces(value={"application/json"})
    public Response listJobs(@Parameter(description="Session ID or 'all' for all jobs", example="550e8400-e29b-41d4-a716-446655440000") @PathParam(value="sessionId") String sessionId) {
        UUID userId = this.AuthenticateUser();
        Session session = SessionManager.getInstance().getSession(sessionId, userId);
        RoutingJob[] result = session == null || sessionId.isEmpty() || "all".equals(sessionId) ? RoutingJobScheduler.getInstance().listJobs(null, userId) : RoutingJobScheduler.getInstance().listJobs(sessionId);
        String response = GsonProvider.GSON.toJson(result);
        FRAnalytics.apiEndpointCalled("GET v1/jobs/list/" + sessionId, "", response);
        return Response.ok(response).build();
    }

    @Operation(summary="Get job details", description="Retrieves detailed status and statistics of a routing job, including progress information if the job has started.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Job details retrieved successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoutingJob.class))}), @ApiResponse(responseCode="404", description="Job not found", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{}")})}), @ApiResponse(responseCode="400", description="Invalid session ID")})
    @GET
    @Path(value="/{jobId}")
    @Produces(value={"application/json"})
    public Response getJob(@Parameter(description="Unique identifier of the job", example="550e8400-e29b-41d4-a716-446655440000") @PathParam(value="jobId") String jobId) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        String response = GsonProvider.GSON.toJson(job);
        FRAnalytics.apiEndpointCalled("GET v1/jobs/" + jobId, "", response);
        return Response.ok(response).build();
    }

    @Operation(summary="Start routing job", description="Starts or continues a queued routing job. The job must have both input file and settings uploaded before it can be started.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Job started successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoutingJob.class))}), @ApiResponse(responseCode="404", description="Job not found"), @ApiResponse(responseCode="400", description="Job already started or invalid session")})
    @PUT
    @Path(value="/{jobId}/start")
    @Produces(value={"application/json"})
    public Response startJob(@Parameter(description="Unique identifier of the job", example="550e8400-e29b-41d4-a716-446655440000") @PathParam(value="jobId") String jobId) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        if (job.state != RoutingJobState.QUEUED) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The job is already started and cannot be changed.\"}").build();
        }
        job.state = RoutingJobState.READY_TO_START;
        RoutingJobScheduler.getInstance().saveJob(job);
        String response = GsonProvider.GSON.toJson(job);
        FRAnalytics.apiEndpointCalled("PUT v1/jobs/" + jobId + "/start", "", response);
        return Response.ok(response).build();
    }

    @Operation(summary="Cancel routing job", description="Cancels a routing job. Note: This endpoint is currently not fully implemented.")
    @ApiResponses(value={@ApiResponse(responseCode="501", description="Not implemented", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"error\":\"This method is not implemented yet.\"}")})}), @ApiResponse(responseCode="404", description="Job not found"), @ApiResponse(responseCode="400", description="Invalid session ID")})
    @PUT
    @Path(value="/{jobId}/cancel")
    @Produces(value={"application/json"})
    public Response cancelJob(@Parameter(description="Unique identifier of the job", example="550e8400-e29b-41d4-a716-446655440000") @PathParam(value="jobId") String jobId) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        job.state = RoutingJobState.CANCELLED;
        RoutingJobScheduler.getInstance().saveJob(job);
        String response = GsonProvider.GSON.toJson(job);
        FRAnalytics.apiEndpointCalled("PUT v1/jobs/" + jobId + "/cancel", "", response);
        return Response.status(Response.Status.NOT_IMPLEMENTED).entity("{\"error\":\"This method is not implemented yet.\"}").build();
    }

    @Operation(summary="Update job settings", description="Updates the router settings for a queued job. The job must be in QUEUED state and not yet started.")
    @RequestBody(description="Router settings configuration", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=RouterSettings.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Settings updated successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoutingJob.class))}), @ApiResponse(responseCode="404", description="Job not found"), @ApiResponse(responseCode="400", description="Invalid settings or job already started")})
    @POST
    @Path(value="/{jobId}/settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response changeSettings(@Parameter(description="Unique identifier of the job", example="550e8400-e29b-41d4-a716-446655440000") @PathParam(value="jobId") String jobId, String requestBody) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        if (job.state != RoutingJobState.QUEUED) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The job is already started and cannot be changed.\"}").build();
        }
        RouterSettings routerSettings = GsonProvider.GSON.fromJson(requestBody, RouterSettings.class);
        if (routerSettings == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The router settings are invalid.\"}").build();
        }
        job.setSettings(routerSettings);
        String response = GsonProvider.GSON.toJson(job);
        FRAnalytics.apiEndpointCalled("POST v1/jobs/" + jobId + "/settings", GsonProvider.GSON.toJson(routerSettings), response);
        return Response.ok(response).build();
    }

    @Operation(summary="Upload job input file", description="Uploads the input PCB design file for a routing job, typically in Specctra DSN format. The file must be Base64-encoded. Note: File size limit depends on server configuration (typically 1-30MB).")
    @RequestBody(description="Board file payload with Base64-encoded data", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=BoardFilePayload.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Input uploaded successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoutingJob.class))}), @ApiResponse(responseCode="404", description="Job not found"), @ApiResponse(responseCode="400", description="Invalid input data or job already started")})
    @POST
    @Path(value="/{jobId}/input")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response uploadInput(@Parameter(description="Unique identifier of the job", example="550e8400-e29b-41d4-a716-446655440000") @PathParam(value="jobId") String jobId, String requestBody) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        if (job.state != RoutingJobState.QUEUED) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The job is already started and cannot be changed.\"}").build();
        }
        BoardFilePayload input = GsonProvider.GSON.fromJson(requestBody, BoardFilePayload.class);
        if (input == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The input data is invalid.\"}").build();
        }
        if (input.dataBase64 == null || input.dataBase64.isEmpty()) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The input data must be base-64 encoded and put into the data_base64 field.\"}").build();
        }
        byte[] inputByteArray = Base64.getDecoder().decode(input.dataBase64);
        if (!job.setInput(inputByteArray)) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The input data is invalid.\"}").build();
        }
        if (job.input.getFilename().isEmpty()) {
            job.input.setFilename(job.name);
        }
        job.setSettings(new RouterSettings(job.input.statistics.layers.totalCount));
        String request = GsonProvider.GSON.toJson(input).replace(input.dataBase64, TextManager.shortenString(input.dataBase64, 4));
        String response = GsonProvider.GSON.toJson(job);
        FRAnalytics.apiEndpointCalled("POST v1/jobs/" + jobId + "/input", request, response);
        return Response.ok(response).build();
    }

    @Operation(summary="Download job output file", description="Downloads the output file of a completed routing job, typically in Specctra SES format. The file is returned as Base64-encoded data.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Output downloaded successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=BoardFilePayload.class))}), @ApiResponse(responseCode="404", description="Job not found"), @ApiResponse(responseCode="400", description="Job not completed or invalid session")})
    @GET
    @Path(value="/{jobId}/output")
    @Produces(value={"application/json"})
    public Response downloadOutput(@Parameter(description="Unique identifier of the job", example="550e8400-e29b-41d4-a716-446655440000") @PathParam(value="jobId") String jobId) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        if (job.state != RoutingJobState.COMPLETED) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The job hasn't finished yet.\"}").build();
        }
        BoardFilePayload result = new BoardFilePayload();
        result.jobId = job.id;
        result.setFilename(job.output.getFilename());
        result.setData(job.output.getData().readAllBytes());
        result.dataBase64 = Base64.getEncoder().encodeToString(result.getData().readAllBytes());
        String response = GsonProvider.GSON.toJson(result);
        FRAnalytics.apiEndpointCalled("GET v1/jobs/" + jobId + "/output", "", response.replace(result.dataBase64, TextManager.shortenString(result.dataBase64, 4)));
        return Response.ok(response).build();
    }

    @Operation(summary="Stream job output in real-time", description="Streams the output file of a routing job in real-time using Server-Sent Events (SSE). Updates are sent every 200ms when the output changes.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="SSE stream established", content={@Content(mediaType="text/event-stream")})})
    @GET
    @Path(value="/{jobId}/output/stream")
    @Produces(value={"text/event-stream"})
    public void streamOutput(@Parameter(description="Unique identifier of the job", example="550e8400-e29b-41d4-a716-446655440000") @PathParam(value="jobId") String jobId, @Context SseEventSink eventSink, @Context Sse sse) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null || SessionManager.getInstance().getSession(job.sessionId.toString(), userId) == null) {
            try {
                eventSink.close();
            }
            catch (Exception e) {
                FRLogger.error("Error closing SSE event sink", e);
            }
            return;
        }
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(() -> {
            block8: {
                try {
                    if (job.output != null && job.output.getData() != null) {
                        BoardFilePayload result = new BoardFilePayload();
                        result.jobId = job.id;
                        result.setFilename(job.output.getFilename());
                        result.setData(job.output.getData().readAllBytes());
                        result.dataBase64 = Base64.getEncoder().encodeToString(result.getData().readAllBytes());
                        Long previousOutputChecksum = previousOutputChecksums.get(jobId);
                        if (previousOutputChecksum == null || result.crc32 != previousOutputChecksum) {
                            previousOutputChecksums.put(jobId, result.crc32);
                            OutboundSseEvent event = sse.newEventBuilder().id(String.valueOf(System.currentTimeMillis())).data(GsonProvider.GSON.toJson(result)).build();
                            eventSink.send(event);
                        }
                    }
                    if (job.state != RoutingJobState.COMPLETED && job.state != RoutingJobState.CANCELLED) break block8;
                    try {
                        eventSink.close();
                    }
                    catch (Exception ex) {
                        FRLogger.error("Error closing SSE event sink", ex);
                    }
                    executor.shutdown();
                }
                catch (Exception e) {
                    FRLogger.error("Error while streaming output", e);
                    try {
                        eventSink.close();
                    }
                    catch (Exception ex) {
                        FRLogger.error("Error closing SSE event sink", ex);
                    }
                    executor.shutdown();
                }
            }
        }, 0L, 200L, TimeUnit.MILLISECONDS);
        FRAnalytics.apiEndpointCalled("GET v1/jobs/" + jobId + "/output/stream", "", "stream-started");
    }

    @Operation(summary="Get job logs", description="Retrieves all log entries associated with a specific routing job.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Logs retrieved successfully", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Job not found"), @ApiResponse(responseCode="400", description="Invalid session ID")})
    @GET
    @Path(value="/{jobId}/logs")
    @Produces(value={"application/json"})
    public Response logs(@Parameter(description="Unique identifier of the job", example="550e8400-e29b-41d4-a716-446655440000") @PathParam(value="jobId") String jobId) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        LogEntries logEntries = FRLogger.getLogEntries();
        LogEntry[] logs = logEntries.getEntries(null, job.id);
        String response = GsonProvider.GSON.toJson(logs);
        FRAnalytics.apiEndpointCalled("GET v1/jobs/" + jobId + "/logs", "", response);
        return Response.ok(response).build();
    }

    @Operation(summary="Stream job logs in real-time", description="Streams log entries of a routing job in real-time using Server-Sent Events (SSE). New log entries are sent as they are generated.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="SSE stream established", content={@Content(mediaType="text/event-stream")})})
    @GET
    @Path(value="/{jobId}/logs/stream")
    @Produces(value={"text/event-stream"})
    public void streamLogs(@Parameter(description="Unique identifier of the job", example="550e8400-e29b-41d4-a716-446655440000") @PathParam(value="jobId") String jobId, @Context SseEventSink eventSink, @Context Sse sse) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null || SessionManager.getInstance().getSession(job.sessionId.toString(), userId) == null) {
            try {
                eventSink.close();
            }
            catch (Exception e2) {
                FRLogger.error("Error closing SSE event sink", e2);
            }
            return;
        }
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        job.addLogEntryAddedEventListener(e -> {
            block6: {
                try {
                    LogEntry result = e.getLogEntry();
                    OutboundSseEvent event = sse.newEventBuilder().id(String.valueOf(System.currentTimeMillis())).data(GsonProvider.GSON.toJson(result)).build();
                    eventSink.send(event);
                    if (job.state != RoutingJobState.COMPLETED && job.state != RoutingJobState.CANCELLED) break block6;
                    try {
                        eventSink.close();
                    }
                    catch (Exception closeEx) {
                        FRLogger.error("Error closing SSE event sink", closeEx);
                    }
                    executor.shutdown();
                }
                catch (Exception ex) {
                    FRLogger.error("Error while streaming logs", ex);
                    try {
                        eventSink.close();
                    }
                    catch (Exception closeEx) {
                        FRLogger.error("Error closing SSE event sink", closeEx);
                    }
                    executor.shutdown();
                }
            }
        });
        FRAnalytics.apiEndpointCalled("GET v1/jobs/" + jobId + "/logs/stream", "", "stream-started");
    }

    @Operation(summary="Get DRC report", description="Generates and retrieves a Design Rules Check (DRC) report for a routing job. The report includes violations and statistics in JSON format.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="DRC report generated successfully", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Job not found"), @ApiResponse(responseCode="400", description="Invalid session or failed to load board"), @ApiResponse(responseCode="500", description="Failed to load board for DRC check")})
    @GET
    @Path(value="/{jobId}/drc")
    @Produces(value={"application/json"})
    public Response getDrcReport(@Parameter(description="Unique identifier of the job", example="550e8400-e29b-41d4-a716-446655440000") @PathParam(value="jobId") String jobId) {
        UUID userId = this.AuthenticateUser();
        RoutingJob job = RoutingJobScheduler.getInstance().getJob(jobId);
        if (job == null) {
            return Response.status(Response.Status.NOT_FOUND).entity("{\"error\":\"Job not found.\"}").build();
        }
        Session session = SessionManager.getInstance().getSession(job.sessionId.toString(), userId);
        if (session == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The session ID '" + String.valueOf(job.sessionId) + "' is invalid.\"}").build();
        }
        if (!BoardLoader.loadBoardIfNeeded(job)) {
            if (job.input != null && job.input.format == FileFormat.DSN) {
                try {
                    HeadlessBoardManager boardManager = new HeadlessBoardManager(null, job);
                    boardManager.loadFromSpecctraDsn(job.input.getData(), null, new ItemIdentificationNumberGenerator());
                    job.board = boardManager.get_routing_board();
                }
                catch (Exception e) {
                    FRLogger.error("Couldn't load the board for DRC check", e);
                    return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("{\"error\":\"Failed to load board: " + e.getMessage() + "\"}").build();
                }
            } else {
                return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"Failed to load board for DRC check.\"}").build();
            }
        }
        DesignRulesChecker drcChecker = new DesignRulesChecker(job.board, job.drcSettings);
        String coordinateUnit = "mm";
        String sourceFileName = job.input != null ? job.input.getFilename() : "unknown";
        String drcReportJson = drcChecker.generateReportJson(sourceFileName, coordinateUnit);
        FRAnalytics.apiEndpointCalled("GET v1/jobs/" + jobId + "/drc", "", "drc-report-generated");
        return Response.ok(drcReportJson).build();
    }
}

