/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api.v1;

import app.freerouting.Freerouting;
import app.freerouting.management.analytics.BigQueryClient;
import app.freerouting.management.analytics.dto.Payload;
import app.freerouting.management.gson.GsonProvider;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;

@Path(value="/v1/analytics")
@Tag(name="Analytics", description="Endpoints for tracking user actions and analytics data")
public class AnalyticsControllerV1 {
    @Operation(summary="Track user action", description="Records an analytics event for tracking user actions and behavior. This endpoint accepts event data and stores it in BigQuery for analysis.")
    @RequestBody(description="Analytics tracking payload containing user identification and event data", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=Payload.class), examples={@ExampleObject(name="Job Started Event", value="{\n  \"userId\": \"user_12345\",\n  \"anonymousId\": \"anon_67890\",\n  \"event\": \"job_started\",\n  \"properties\": {\n    \"jobId\": \"550e8400-e29b-41d4-a716-446655440000\",\n    \"sessionId\": \"660e8400-e29b-41d4-a716-446655440001\"\n  }\n}\n")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Event tracked successfully"), @ApiResponse(responseCode="400", description="Invalid request data", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"error\":\"The input data is invalid.\"}")})}), @ApiResponse(responseCode="500", description="Server error or BigQuery configuration issue", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"error\":\"The BigQuery service account key is not configured.\"}")})})})
    @POST
    @Path(value="/track")
    @Consumes(value={"application/json"})
    public Response trackAction(String requestBody) {
        Payload trackPayload = GsonProvider.GSON.fromJson(requestBody, Payload.class);
        if (trackPayload == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The input data is invalid.\"}").build();
        }
        if (Freerouting.globalSettings.usageAndDiagnosticData.bigqueryServiceAccountKey == null) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("{\"error\":\"The BigQuery service account key is not configured. It must be set to the 'FREEROUTING__USAGE_AND_DIAGNOSTIC_DATA__BIGQUERY_SERVICE_ACCOUNT_KEY' environment variable in JSON format.\"}").build();
        }
        try {
            BigQueryClient bigqueryClient = new BigQueryClient("2.1.2-SNAPSHOT", Freerouting.globalSettings.usageAndDiagnosticData.bigqueryServiceAccountKey);
            bigqueryClient.track(trackPayload.userId, trackPayload.anonymousId, trackPayload.event, trackPayload.properties);
        }
        catch (Exception e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("{\n  \"error\": \"An error occurred while processing the request.\"\n  \"message\": \"%s\"\n}\n".formatted(e.getMessage())).build();
        }
        return Response.ok().build();
    }

    @Operation(summary="Identify user", description="Associates user traits with a user ID for analytics purposes. This endpoint is currently not implemented.")
    @RequestBody(description="User identification payload containing user traits", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=Payload.class))})
    @ApiResponses(value={@ApiResponse(responseCode="501", description="Operation not implemented", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"error\":\"The operation is not implemented.\"}")})}), @ApiResponse(responseCode="400", description="Invalid request data", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"error\":\"The input data is invalid.\"}")})}), @ApiResponse(responseCode="500", description="Server error or BigQuery configuration issue")})
    @POST
    @Path(value="/identify")
    @Consumes(value={"application/json"})
    public Response identity(String requestBody) {
        Payload trackPayload = GsonProvider.GSON.fromJson(requestBody, Payload.class);
        if (trackPayload == null) {
            return Response.status(Response.Status.BAD_REQUEST).entity("{\"error\":\"The input data is invalid.\"}").build();
        }
        if (Freerouting.globalSettings.usageAndDiagnosticData.bigqueryServiceAccountKey == null) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("{\"error\":\"The BigQuery service account key is not configured. It must be set to the 'FREEROUTING__USAGE_AND_DIAGNOSTIC_DATA__BIGQUERY_SERVICE_ACCOUNT_KEY' environment variable in JSON format.\"}").build();
        }
        return Response.status(Response.Status.NOT_IMPLEMENTED).entity("{\"error\":\"The operation is not implemented.\"}").build();
    }
}

