/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api.security;

import app.freerouting.Freerouting;
import app.freerouting.api.security.ApiKeyProvider;
import app.freerouting.api.security.GoogleSheetsApiKeyProvider;
import app.freerouting.logger.FRLogger;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.Collections;

@Provider
@Priority(value=1000)
public class ApiKeyValidationFilter
implements ContainerRequestFilter {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_PREFIX = "Bearer ";
    private static ApiKeyProvider apiKeyProvider;
    private static boolean isInitialized;

    private static synchronized void initializeProvider() {
        if (isInitialized) {
            return;
        }
        String googleSheetsUrl = Freerouting.globalSettings.apiServerSettings.keysLocation.googleSheets;
        String googleApiKey = Freerouting.globalSettings.apiServerSettings.keysLocation.googleApiKey;
        if (googleSheetsUrl != null && !googleSheetsUrl.trim().isEmpty() && googleApiKey != null && !googleApiKey.trim().isEmpty()) {
            try {
                apiKeyProvider = new GoogleSheetsApiKeyProvider(googleSheetsUrl, googleApiKey);
                FRLogger.info("API key validation enabled with Google Sheets provider");
            }
            catch (Exception e) {
                FRLogger.error("Failed to initialize Google Sheets API key provider. API key validation will deny all requests.", null, e);
                apiKeyProvider = null;
            }
        } else {
            FRLogger.warn("Google Sheets URL or API key not configured (FREEROUTING__API_SERVER__KEYS_LOCATION__GOOGLE_SHEETS and FREEROUTING__API_SERVER__KEYS_LOCATION__GOOGLE_API_KEY). API key validation will deny all requests to protected endpoints.");
            apiKeyProvider = null;
        }
        isInitialized = true;
    }

    static ApiKeyProvider getApiKeyProvider() {
        return apiKeyProvider;
    }

    static void resetForTesting() {
        isInitialized = false;
        apiKeyProvider = null;
    }

    private boolean isExcludedPath(String path) {
        if (path == null) {
            return false;
        }
        String normalizedPath = path.startsWith("/") ? path.substring(1) : path;
        return normalizedPath.startsWith("v1/system/") || normalizedPath.startsWith("v1/analytics/") || normalizedPath.startsWith("dev/") || normalizedPath.startsWith("openapi/") || normalizedPath.equals("swagger-ui") || normalizedPath.startsWith("swagger-ui/");
    }

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String path = requestContext.getUriInfo().getPath();
        if (this.isExcludedPath(path)) {
            FRLogger.debug("API key validation skipped for excluded path: " + path);
            return;
        }
        if (!isInitialized) {
            ApiKeyValidationFilter.initializeProvider();
        }
        String authHeader = requestContext.getHeaderString(AUTHORIZATION_HEADER);
        String apiKey = null;
        if (authHeader != null && authHeader.startsWith(BEARER_PREFIX)) {
            apiKey = authHeader.substring(BEARER_PREFIX.length()).trim();
        }
        if (apiKey == null || apiKey.isEmpty()) {
            FRLogger.warn("API key validation failed: missing or invalid Authorization header for path " + path);
            this.abortWithUnauthorized(requestContext, "Missing API key. Please provide a valid API key in the Authorization header using Bearer scheme (Authorization: Bearer <API_KEY>). You can apply for a free API key at https://www.freerouting.app.");
            return;
        }
        if (apiKeyProvider == null) {
            FRLogger.error("API key validation failed: provider not initialized for path " + path, null, null);
            this.abortWithUnauthorized(requestContext, "API key validation is not properly configured.");
            return;
        }
        if (!apiKeyProvider.validateApiKey(apiKey)) {
            FRLogger.warn("API key validation failed: invalid or unauthorized API key for path " + path);
            this.abortWithUnauthorized(requestContext, "Invalid or unauthorized API key.");
            return;
        }
        FRLogger.debug("API key validation successful for path: " + path);
    }

    private void abortWithUnauthorized(ContainerRequestContext requestContext, String message) {
        Response response = Response.status(Response.Status.UNAUTHORIZED).entity(Collections.singletonMap("error", message)).type("application/json").build();
        requestContext.abortWith(response);
    }

    static {
        isInitialized = false;
    }
}

