/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api.dev;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/dev/system")
@Tag(name="Dev - System", description="Mock system endpoints for testing and development. Returns static test data.")
public class SystemControllerMocked {
    @Operation(summary="Get system status (mock)", description="Returns mock system status data for testing purposes. This endpoint always returns the same static data.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mock system status retrieved successfully", content={@Content(mediaType="application/json")})})
    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    public Response getStatus() {
        return Response.ok("{\n    \"status\": \"OK\",\n    \"cpu_load\": 3.954818264180926,\n    \"ram_used\": 86,\n    \"ram_available\": 73,\n    \"storage_available\": 481,\n    \"session_count\": 1\n}\n").build();
    }

    @Operation(summary="Get environment information (mock)", description="Returns mock environment information for testing purposes. This endpoint always returns the same static data.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mock environment information retrieved successfully", content={@Content(mediaType="application/json")})})
    @GET
    @Path(value="/environment")
    @Produces(value={"application/json"})
    public Response getEnvironment() {
        return Response.ok("{\n    \"freerouting_version\": \"2.0.0,2024-10-14\",\n    \"app_started_at\": \"2024-10-14T10:56:26.730145900Z\",\n    \"command_line_arguments\": \"\",\n    \"architecture\": \"Windows 11,amd64,10.0\",\n    \"java\": \"21.0.2,Eclipse Adoptium\",\n    \"system_language\": \"en,en_US\",\n    \"cpu_cores\": 12,\n    \"ram\": 8176\n}\n").build();
    }
}

