/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api.dev;

import app.freerouting.api.dto.BoardFilePayload;
import app.freerouting.core.RoutingJob;
import app.freerouting.settings.RouterSettings;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/dev/jobs")
@Tag(name="Dev - Jobs", description="Mock job endpoints for testing and development. Returns static test data.")
public class JobControllerMocked {
    @Operation(summary="Enqueue a new job (mock)", description="Returns mock data for an enqueued job for testing purposes.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mock job enqueued successfully", content={@Content(mediaType="application/json")})})
    @POST
    @Path(value="/enqueue")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response enqueueJob(@RequestBody(description="Job details (ignored in mock)") RoutingJob job) {
        return Response.ok("{\n     \"id\": \"934291f2-8498-4294-a4f4-2058dcfd4edd\",\n     \"createdAt\": \"2024-10-14T11:18:24.094005900Z\",\n     \"sessionId\": \"8c6b2f64-b6db-4fb6-9a2f-17610acad966\",\n     \"name\": \"Issue102-Mars-64-revE-rot00\",\n     \"state\": \"QUEUED\",\n     \"priority\": \"NORMAL\",\n     \"stage\": \"IDLE\",\n     \"routerSettings\": {\n         \"default_preferred_direction_trace_cost\": 1.0,\n         \"default_undesired_direction_trace_cost\": 1.0,\n         \"max_passes\": 100,\n         \"fanout_max_passes\": 20,\n         \"max_threads\": 11,\n         \"improvement_threshold\": 0.01,\n         \"trace_pull_tight_accuracy\": 500,\n         \"allowed_via_types\": true,\n         \"via_costs\": 50,\n         \"plane_via_costs\": 5,\n         \"start_ripup_costs\": 100,\n         \"automatic_neckdown\": true\n     }\n}\n").build();
    }

    @Operation(summary="List jobs in session (mock)", description="Returns a mock list of jobs for testing purposes.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mock job list retrieved successfully", content={@Content(mediaType="application/json")})})
    @GET
    @Path(value="/list/{sessionId}")
    @Produces(value={"application/json"})
    public Response listJobs(@Parameter(description="Session ID (ignored in mock)", example="8c6b2f64-b6db-4fb6-9a2f-17610acad966") @PathParam(value="sessionId") String sessionId) {
        return Response.ok("[\n     {\n         \"id\": \"934291f2-8498-4294-a4f4-2058dcfd4edd\",\n         \"createdAt\": \"2024-10-14T11:18:24.094005900Z\",\n         \"sessionId\": \"8c6b2f64-b6db-4fb6-9a2f-17610acad966\",\n         \"name\": \"Issue102-Mars-64-revE-rot00\",\n         \"state\": \"QUEUED\",\n         \"priority\": \"NORMAL\",\n         \"stage\": \"IDLE\",\n         \"routerSettings\": {\n             \"default_preferred_direction_trace_cost\": 1.0,\n             \"default_undesired_direction_trace_cost\": 1.0,\n             \"max_passes\": 100,\n             \"fanout_max_passes\": 20,\n             \"max_threads\": 11,\n             \"improvement_threshold\": 0.01,\n             \"trace_pull_tight_accuracy\": 500,\n             \"allowed_via_types\": true,\n             \"via_costs\": 50,\n             \"plane_via_costs\": 5,\n             \"start_ripup_costs\": 100,\n             \"automatic_neckdown\": true\n         }\n     },\n     {\n         \"id\": \"4edaebab-ae08-4abe-9ef4-33316fe93821\",\n         \"createdAt\": \"2024-10-14T11:20:02.755544600Z\",\n         \"sessionId\": \"8c6b2f64-b6db-4fb6-9a2f-17610acad966\",\n         \"name\": \"Issue102-Mars-64-revE-rot00\",\n         \"state\": \"QUEUED\",\n         \"priority\": \"NORMAL\",\n         \"stage\": \"IDLE\",\n         \"routerSettings\": {\n             \"default_preferred_direction_trace_cost\": 1.0,\n             \"default_undesired_direction_trace_cost\": 1.0,\n             \"max_passes\": 100,\n             \"fanout_max_passes\": 20,\n             \"max_threads\": 11,\n             \"improvement_threshold\": 0.01,\n             \"trace_pull_tight_accuracy\": 500,\n             \"allowed_via_types\": true,\n             \"via_costs\": 50,\n             \"plane_via_costs\": 5,\n             \"start_ripup_costs\": 100,\n             \"automatic_neckdown\": true\n         }\n     },\n     {\n         \"id\": \"482abd42-b6be-47e9-8f33-93b0236f443e\",\n         \"createdAt\": \"2024-10-14T11:20:04.282402900Z\",\n         \"sessionId\": \"8c6b2f64-b6db-4fb6-9a2f-17610acad966\",\n         \"name\": \"Issue102-Mars-64-revE-rot00\",\n         \"state\": \"QUEUED\",\n         \"priority\": \"NORMAL\",\n         \"stage\": \"IDLE\",\n         \"routerSettings\": {\n             \"default_preferred_direction_trace_cost\": 1.0,\n             \"default_undesired_direction_trace_cost\": 1.0,\n             \"max_passes\": 100,\n             \"fanout_max_passes\": 20,\n             \"max_threads\": 11,\n             \"improvement_threshold\": 0.01,\n             \"trace_pull_tight_accuracy\": 500,\n             \"allowed_via_types\": true,\n             \"via_costs\": 50,\n             \"plane_via_costs\": 5,\n             \"start_ripup_costs\": 100,\n             \"automatic_neckdown\": true\n         }\n     }\n]\n").build();
    }

    @Operation(summary="Get job details (mock)", description="Returns mock job details for testing purposes.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mock job details retrieved successfully", content={@Content(mediaType="application/json")})})
    @GET
    @Path(value="/{jobId}")
    @Produces(value={"application/json"})
    public Response getJob(@Parameter(description="Job ID (ignored in mock)", example="934291f2-8498-4294-a4f4-2058dcfd4edd") @PathParam(value="jobId") String jobId) {
        return Response.ok("{\n     \"id\": \"934291f2-8498-4294-a4f4-2058dcfd4edd\",\n     \"createdAt\": \"2024-10-14T11:18:24.094005900Z\",\n     \"sessionId\": \"8c6b2f64-b6db-4fb6-9a2f-17610acad966\",\n     \"name\": \"Issue102-Mars-64-revE-rot00\",\n     \"state\": \"READY_TO_START\",\n     \"priority\": \"NORMAL\",\n     \"stage\": \"IDLE\",\n     \"routerSettings\": {\n         \"default_preferred_direction_trace_cost\": 1.0,\n         \"default_undesired_direction_trace_cost\": 1.0,\n         \"max_passes\": 100,\n         \"fanout_max_passes\": 20,\n         \"max_threads\": 11,\n         \"improvement_threshold\": 0.01,\n         \"trace_pull_tight_accuracy\": 500,\n         \"allowed_via_types\": true,\n         \"via_costs\": 50,\n         \"plane_via_costs\": 5,\n         \"start_ripup_costs\": 100,\n         \"automatic_neckdown\": true\n     }\n}\n").build();
    }

    @Operation(summary="Start job (mock)", description="Returns mock data for a started job for testing purposes.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mock job started successfully", content={@Content(mediaType="application/json")})})
    @PUT
    @Path(value="/{jobId}/start")
    @Produces(value={"application/json"})
    public Response startJob(@Parameter(description="Job ID (ignored in mock)", example="934291f2-8498-4294-a4f4-2058dcfd4edd") @PathParam(value="jobId") String jobId) {
        return Response.ok("{\n     \"id\": \"934291f2-8498-4294-a4f4-2058dcfd4edd\",\n     \"createdAt\": \"2024-10-14T11:18:24.094005900Z\",\n     \"sessionId\": \"8c6b2f64-b6db-4fb6-9a2f-17610acad966\",\n     \"name\": \"Issue102-Mars-64-revE-rot00\",\n     \"state\": \"RUNNING\",\n     \"priority\": \"NORMAL\",\n     \"stage\": \"IDLE\",\n     \"routerSettings\": {\n         \"default_preferred_direction_trace_cost\": 1.0,\n         \"default_undesired_direction_trace_cost\": 1.0,\n         \"max_passes\": 100,\n         \"fanout_max_passes\": 20,\n         \"max_threads\": 11,\n         \"improvement_threshold\": 0.01,\n         \"trace_pull_tight_accuracy\": 500,\n         \"allowed_via_types\": true,\n         \"via_costs\": 50,\n         \"plane_via_costs\": 5,\n         \"start_ripup_costs\": 100,\n         \"automatic_neckdown\": true\n     }\n}\n").build();
    }

    @Operation(summary="Cancel job (mock)", description="Returns mock data for a cancelled job for testing purposes.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mock job cancelled successfully", content={@Content(mediaType="application/json")})})
    @PUT
    @Path(value="/{jobId}/cancel")
    @Produces(value={"application/json"})
    public Response cancelJob(@Parameter(description="Job ID (ignored in mock)", example="934291f2-8498-4294-a4f4-2058dcfd4edd") @PathParam(value="jobId") String jobId) {
        return Response.ok("{\n     \"id\": \"934291f2-8498-4294-a4f4-2058dcfd4edd\",\n     \"createdAt\": \"2024-10-14T11:18:24.094005900Z\",\n     \"sessionId\": \"8c6b2f64-b6db-4fb6-9a2f-17610acad966\",\n     \"name\": \"Issue102-Mars-64-revE-rot00\",\n     \"state\": \"CANCELLED\",\n     \"priority\": \"NORMAL\",\n     \"stage\": \"IDLE\",\n     \"routerSettings\": {\n         \"default_preferred_direction_trace_cost\": 1.0,\n         \"default_undesired_direction_trace_cost\": 1.0,\n         \"max_passes\": 100,\n         \"fanout_max_passes\": 20,\n         \"max_threads\": 11,\n         \"improvement_threshold\": 0.01,\n         \"trace_pull_tight_accuracy\": 500,\n         \"allowed_via_types\": true,\n         \"via_costs\": 50,\n         \"plane_via_costs\": 5,\n         \"start_ripup_costs\": 100,\n         \"automatic_neckdown\": true\n     }\n}\n").build();
    }

    @Operation(summary="Change job settings (mock)", description="Returns mock data for updated job settings for testing purposes.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mock job settings updated successfully", content={@Content(mediaType="application/json")})})
    @POST
    @Path(value="/{jobId}/settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response changeSettings(@Parameter(description="Job ID (ignored in mock)", example="934291f2-8498-4294-a4f4-2058dcfd4edd") @PathParam(value="jobId") String jobId, @RequestBody(description="Router settings (ignored in mock)") RouterSettings routerSettings) {
        return Response.ok("{\n     \"id\": \"9af24675-4000-4f3f-a3d4-8784820cda97\",\n     \"createdAt\": \"2024-10-14T11:22:02.231487Z\",\n     \"sessionId\": \"8c6b2f64-b6db-4fb6-9a2f-17610acad966\",\n     \"name\": \"Issue102-Mars-64-revE-rot00\",\n     \"state\": \"QUEUED\",\n     \"priority\": \"NORMAL\",\n     \"stage\": \"IDLE\",\n     \"routerSettings\": {\n         \"default_preferred_direction_trace_cost\": 1.0,\n         \"default_undesired_direction_trace_cost\": 1.0,\n         \"max_passes\": 100,\n         \"fanout_max_passes\": 20,\n         \"max_threads\": 11,\n         \"improvement_threshold\": 0.01,\n         \"trace_pull_tight_accuracy\": 500,\n         \"allowed_via_types\": true,\n         \"via_costs\": 42,\n         \"plane_via_costs\": 5,\n         \"start_ripup_costs\": 100,\n         \"automatic_neckdown\": true\n     }\n}\n").build();
    }

    @Operation(summary="Upload job input (mock)", description="Returns mock data for uploaded input for testing purposes.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mock input uploaded successfully", content={@Content(mediaType="application/json")})})
    @POST
    @Path(value="/{jobId}/input")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response uploadInput(@Parameter(description="Job ID (ignored in mock)", example="934291f2-8498-4294-a4f4-2058dcfd4edd") @PathParam(value="jobId") String jobId, @RequestBody(description="Board file payload (ignored in mock)") BoardFilePayload input) {
        return Response.ok("{\n     \"id\": \"9af24675-4000-4f3f-a3d4-8784820cda97\",\n     \"createdAt\": \"2024-10-14T11:22:02.231487Z\",\n     \"input\": {\n         \"size\": 50853,\n         \"crc32\": 4085067588,\n         \"format\": \"DSN\",\n         \"layer_count\": 0,\n         \"component_count\": 0,\n         \"netclass_count\": 0,\n         \"net_count\": 0,\n         \"track_count\": 0,\n         \"trace_count\": 0,\n         \"via_count\": 0,\n         \"filename\": \"Issue102-Mars-64-revE-rot00.dsn\",\n         \"path\": \"\"\n     },\n     \"sessionId\": \"8c6b2f64-b6db-4fb6-9a2f-17610acad966\",\n     \"name\": \"Issue102-Mars-64-revE-rot00\",\n     \"state\": \"QUEUED\",\n     \"priority\": \"NORMAL\",\n     \"stage\": \"IDLE\",\n     \"routerSettings\": {\n         \"default_preferred_direction_trace_cost\": 1.0,\n         \"default_undesired_direction_trace_cost\": 1.0,\n         \"max_passes\": 100,\n         \"fanout_max_passes\": 20,\n         \"max_threads\": 11,\n         \"improvement_threshold\": 0.01,\n         \"trace_pull_tight_accuracy\": 500,\n         \"allowed_via_types\": true,\n         \"via_costs\": 42,\n         \"plane_via_costs\": 5,\n         \"start_ripup_costs\": 100,\n         \"automatic_neckdown\": true\n     }\n}\n").build();
    }

    @Operation(summary="Download job output (mock)", description="Returns mock output data for testing purposes.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mock output retrieved successfully", content={@Content(mediaType="application/json")})})
    @GET
    @Path(value="/{jobId}/output")
    @Produces(value={"application/json"})
    public Response downloadOutput(@Parameter(description="Job ID (ignored in mock)", example="934291f2-8498-4294-a4f4-2058dcfd4edd") @PathParam(value="jobId") String jobId) {
        return Response.ok("{\n     \"jobId\": \"0a5447bf-45bd-4793-bf07-09916a8ca10b\",\n     \"dataBase64\": \"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\",\n     \"size\": 13150,\n     \"crc32\": 264089660,\n     \"format\": \"SES\",\n     \"layer_count\": 0,\n     \"component_count\": 0,\n     \"netclass_count\": 0,\n     \"net_count\": 0,\n     \"track_count\": 0,\n     \"trace_count\": 0,\n     \"via_count\": 0,\n     \"filename\": \"Issue102-Mars-64-revE-rot00.ses\",\n     \"path\": \"\"\n}\n").build();
    }

    @Operation(summary="Get job logs (mock)", description="Returns empty mock logs for testing purposes.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mock logs retrieved successfully (always empty)", content={@Content(mediaType="application/json")})})
    @GET
    @Path(value="/{jobId}/logs")
    @Produces(value={"application/json"})
    public Response logs(@Parameter(description="Job ID (ignored in mock)", example="934291f2-8498-4294-a4f4-2058dcfd4edd") @PathParam(value="jobId") String jobId) {
        return Response.ok("[\n]\n").build();
    }
}

