/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/swagger-ui")
@Tag(name="API Documentation", description="Interactive API documentation interface")
public class SwaggerUIResource {
    @Operation(summary="Swagger UI interface", description="Serves the interactive Swagger UI interface for exploring and testing the Freerouting API. Provides a user-friendly way to view all endpoints, their parameters, and try out API calls directly from the browser.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Swagger UI page loaded successfully", content={@Content(mediaType="text/html")})})
    @GET
    @Produces(value={"text/html"})
    public Response redirectToIndex() {
        String html = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>Freerouting API Documentation</title>\n    <link rel=\"stylesheet\" type=\"text/css\" href=\"https://cdn.jsdelivr.net/npm/swagger-ui-dist@5.11.0/swagger-ui.css\">\n    <link rel=\"icon\" type=\"image/png\" href=\"https://cdn.jsdelivr.net/npm/swagger-ui-dist@5.11.0/favicon-32x32.png\" sizes=\"32x32\">\n    <style>\n        html { box-sizing: border-box; overflow: -moz-scrollbars-vertical; overflow-y: scroll; }\n        *, *:before, *:after { box-sizing: inherit; }\n        body { margin:0; padding:0; }\n    </style>\n</head>\n<body>\n    <div id=\"swagger-ui\"></div>\n    <script src=\"https://cdn.jsdelivr.net/npm/swagger-ui-dist@5.11.0/swagger-ui-bundle.js\"></script>\n    <script src=\"https://cdn.jsdelivr.net/npm/swagger-ui-dist@5.11.0/swagger-ui-standalone-preset.js\"></script>\n    <script>\n        window.onload = function() {\n            window.ui = SwaggerUIBundle({\n                url: \"/openapi/openapi.json\",\n                dom_id: '#swagger-ui',\n                deepLinking: true,\n                presets: [\n                    SwaggerUIBundle.presets.apis,\n                    SwaggerUIStandalonePreset\n                ],\n                plugins: [\n                    SwaggerUIBundle.plugins.DownloadUrl\n                ],\n                layout: \"StandaloneLayout\"\n            });\n        };\n    </script>\n</body>\n</html>\n";
        return Response.ok(html).type("text/html").build();
    }
}

