/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeIn;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;

@ApplicationPath(value="/api")
@OpenAPIDefinition(info=@Info(title="Freerouting API", version="1.0", description="The Freerouting API provides a comprehensive interface for automated PCB routing.\n\nThis API enables developers and AI agents to:\n- Create and manage routing sessions\n- Submit PCB design files for automated routing\n- Monitor routing job progress in real-time\n- Retrieve routing results and DRC reports\n- Track usage analytics\n\nThe API is fully compliant with OpenAPI 3.0 specification, providing standardized,\nclear, and machine-readable documentation for seamless integration.\n", contact=@Contact(name="Freerouting Team", url="https://github.com/freerouting/freerouting", email="support@freerouting.app"), license=@License(name="GNU General Public License v3.0", url="https://www.gnu.org/licenses/gpl-3.0.en.html")), servers={@Server(description="Production Server", url="https://api.freerouting.app"), @Server(description="Local Development Server", url="http://localhost:37864")}, tags={@Tag(name="OpenAPI Specification", description="Endpoints for retrieving the OpenAPI specification in various formats"), @Tag(name="API Documentation", description="Interactive API documentation interface"), @Tag(name="System", description="System information and monitoring endpoints"), @Tag(name="Sessions", description="Session management endpoints"), @Tag(name="Jobs", description="Routing job management endpoints"), @Tag(name="Analytics", description="Analytics and tracking endpoints"), @Tag(name="Dev - System", description="Mock system endpoints for testing and development"), @Tag(name="Dev - Sessions", description="Mock session endpoints for testing and development"), @Tag(name="Dev - Jobs", description="Mock job endpoints for testing and development")}, security={@SecurityRequirement(name="ApiKeyAuth")})
@SecurityScheme(name="ApiKeyAuth", type=SecuritySchemeType.APIKEY, in=SecuritySchemeIn.HEADER, paramName="Freerouting-Api-Key", description="API Key authentication for Freerouting API.\n\nThe API key should be included in the 'Freerouting-Api-Key' header for all requests.\nThis key is used to identify and authenticate users accessing the API.\n")
public class OpenApiConfig
extends Application {
}

