/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.api;

import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.UUID;

public class BaseController {
    @Context
    private HttpHeaders httpHeaders;

    protected UUID AuthenticateUser() {
        String userIdString = this.httpHeaders.getHeaderString("Freerouting-Profile-ID");
        String userEmailString = this.httpHeaders.getHeaderString("Freerouting-Profile-Email");
        if ((userIdString == null || userIdString.isEmpty()) && (userEmailString == null || userEmailString.isEmpty())) {
            throw new IllegalArgumentException("Freerouting-Profile-ID or Freerouting-Profile-Email HTTP request header must be set in order to get authenticated.");
        }
        UUID userId = null;
        if (userIdString != null && !userIdString.isEmpty()) {
            try {
                userId = UUID.fromString(userIdString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (userEmailString == null || !userEmailString.isEmpty()) {
            // empty if block
        }
        if (userId == null) {
            throw new IllegalArgumentException("The user couldn't be authenticated based on the Freerouting-Profile-ID or Freerouting-Profile-Email HTTP request header values.");
        }
        return userId;
    }
}

