/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting;

import app.freerouting.api.AppContextListener;
import app.freerouting.board.BoardLoader;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.RoutingJobState;
import app.freerouting.core.Session;
import app.freerouting.core.scoring.BoardStatistics;
import app.freerouting.drc.DesignRulesChecker;
import app.freerouting.gui.DefaultExceptionHandler;
import app.freerouting.gui.WindowWelcome;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.SessionManager;
import app.freerouting.management.TextManager;
import app.freerouting.management.VersionChecker;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.management.gson.GsonProvider;
import app.freerouting.settings.ApiServerSettings;
import app.freerouting.settings.GlobalSettings;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.glassfish.jersey.servlet.ServletContainer;

public class Freerouting {
    public static final String WEB_URL = "https://www.freerouting.app";
    public static final String VERSION_NUMBER_STRING = "v2.1.2-SNAPSHOT (build-date: 2026-01-08)";
    public static GlobalSettings globalSettings;
    private static Server apiServer;

    private static void InitializeCLI(GlobalSettings globalSettings) {
        if (globalSettings.design_input_filename == null || globalSettings.design_output_filename == null) {
            FRLogger.error("Both an input file and an output file must be specified with command line arguments if you are running in CLI mode.", null);
            System.exit(1);
        }
        Session cliSession = SessionManager.getInstance().createSession(UUID.fromString(globalSettings.userProfileSettings.userId), "Freerouting/" + globalSettings.version);
        RoutingJob routingJob = new RoutingJob(cliSession.id);
        try {
            routingJob.setInput(globalSettings.design_input_filename);
        }
        catch (Exception e) {
            FRLogger.error("Couldn't load the input file '" + globalSettings.design_input_filename + "'", e);
        }
        cliSession.addJob(routingJob);
        File desiredOutputFile = new File(globalSettings.design_output_filename);
        if (desiredOutputFile != null && desiredOutputFile.exists() && !desiredOutputFile.delete()) {
            FRLogger.warn("Couldn't delete the file '" + globalSettings.design_output_filename + "'");
        }
        routingJob.tryToSetOutputFile(new File(globalSettings.design_output_filename));
        routingJob.routerSettings = Freerouting.globalSettings.routerSettings.clone();
        routingJob.routerSettings.set_stop_pass_no(routingJob.routerSettings.get_start_pass_no() + routingJob.routerSettings.maxPasses - 1);
        routingJob.routerSettings.setLayerCount(routingJob.input.statistics.layers.totalCount);
        routingJob.drcSettings = Freerouting.globalSettings.drcSettings.clone();
        routingJob.state = RoutingJobState.READY_TO_START;
        while (routingJob.state != RoutingJobState.COMPLETED && routingJob.state != RoutingJobState.TERMINATED) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                routingJob.state = RoutingJobState.CANCELLED;
                break;
            }
        }
        IO.println((Object)GsonProvider.GSON.toJson(new BoardStatistics(routingJob.board)));
        if (routingJob.state == RoutingJobState.COMPLETED) {
            try {
                Path outputFilePath = Path.of(globalSettings.design_output_filename, new String[0]);
                Files.write(outputFilePath, routingJob.output.getData().readAllBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                FRLogger.error("Couldn't save the output file '" + globalSettings.design_output_filename + "'", e);
            }
        }
    }

    private static void InitializeDRC(GlobalSettings globalSettings) {
        if (globalSettings.design_input_filename == null) {
            FRLogger.error("An input file must be specified with -de argument in DRC mode.", null);
            System.exit(1);
        }
        Session drcSession = SessionManager.getInstance().createSession(UUID.fromString(globalSettings.userProfileSettings.userId), "Freerouting/" + globalSettings.version);
        RoutingJob drcJob = new RoutingJob(drcSession.id);
        drcJob.drc = globalSettings.drc_report_file;
        try {
            drcJob.setInput(globalSettings.design_input_filename);
        }
        catch (Exception e) {
            FRLogger.error("Couldn't load the input file '" + globalSettings.design_input_filename + "'", e);
            System.exit(1);
        }
        if (!BoardLoader.loadBoardIfNeeded(drcJob)) {
            FRLogger.error("Failed to load board for DRC check", null);
            System.exit(1);
        }
        DesignRulesChecker drcChecker = new DesignRulesChecker(drcJob.board, globalSettings.drcSettings);
        String coordinateUnit = "mm";
        String sourceFileName = new File(globalSettings.design_input_filename).getName();
        String drcReportJson = drcChecker.generateReportJson(sourceFileName, coordinateUnit);
        if (drcJob.drc != null) {
            String outputFileName = drcJob.drc.getAbsolutePath();
            try {
                Path outputFilePath = Path.of(outputFileName, new String[0]);
                Files.write(outputFilePath, drcReportJson.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                FRLogger.info("DRC report written to: " + outputFileName);
            }
            catch (IOException e) {
                FRLogger.error("Couldn't save the DRC report to '" + outputFileName + "'", e);
                System.exit(1);
            }
        } else {
            IO.println((Object)drcReportJson);
        }
    }

    private static void ShutdownApplication() {
        try {
            if (apiServer != null) {
                apiServer.stop();
            }
        }
        catch (Exception e) {
            FRLogger.error("Error stopping API server", e);
        }
        FRAnalytics.appClosed();
    }

    public static Server InitializeAPI(ApiServerSettings apiServerSettings) {
        if (apiServerSettings.endpoints.length == 0) {
            FRLogger.warn("Can't start API server, because no endpoints are defined in ApiServerSettings.");
            return null;
        }
        Server apiServer = new Server();
        for (String endpointUrl : apiServerSettings.endpoints) {
            endpointUrl = endpointUrl.toLowerCase();
            String[] endpointParts = endpointUrl.split("://");
            String protocol = endpointParts[0];
            String hostAndPort = endpointParts[1];
            String[] hostAndPortParts = hostAndPort.split(":");
            String host = hostAndPortParts[0];
            int port = Integer.parseInt(hostAndPortParts[1]);
            if (!"http".equals(protocol) && !"https".equals(protocol)) {
                FRLogger.warn("Can't use the endpoint '%s' for the API server, because its protocol is not HTTP or HTTPS.".formatted(endpointUrl));
                continue;
            }
            if (!apiServerSettings.isHttpAllowed.booleanValue() && "http".equals(protocol)) {
                FRLogger.warn("Can't use the endpoint '%s' for the API server, because HTTP is not allowed.".formatted(endpointUrl));
                continue;
            }
            if ("https".equals(protocol)) {
                FRLogger.warn("HTTPS support is not implemented yet, falling back to HTTP.".formatted(endpointUrl));
            }
            ServerConnector connector = new ServerConnector(apiServer);
            connector.setHost(host);
            connector.setPort(port);
            apiServer.addConnector(connector);
        }
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        apiServer.setHandler(context);
        ServletHolder jerseyServlet = context.addServlet(ServletContainer.class, "/*");
        jerseyServlet.setInitOrder(0);
        jerseyServlet.setInitParameter("jersey.config.server.provider.packages", "app.freerouting.api");
        context.addEventListener(new AppContextListener());
        new Thread(() -> {
            try {
                apiServer.start();
                apiServer.join();
            }
            catch (Exception e) {
                FRLogger.error("Error starting or joining API server", e);
            }
        }).start();
        return apiServer;
    }

    void main(String[] args) {
        int logLevelIndex;
        Optional<String> userDataPathArg;
        FRLogger.traceEntry("MainApplication.main()");
        Path userdataPath = Path.of(System.getProperty("java.io.tmpdir"), "freerouting");
        if (System.getenv("FREEROUTING__USER_DATA_PATH") != null) {
            userdataPath = Path.of(System.getenv("FREEROUTING__USER_DATA_PATH"), new String[0]);
        }
        if (args.length > 0 && Arrays.stream(args).anyMatch(s2 -> s2.startsWith("--user_data_path=")) && (userDataPathArg = Arrays.stream(args).filter(s2 -> s2.startsWith("--user_data_path=")).findFirst()).isPresent()) {
            userdataPath = Path.of(userDataPathArg.get().substring("--user_data_path=".length()), new String[0]);
        }
        if (!userdataPath.toFile().exists()) {
            userdataPath.toFile().mkdirs();
        }
        if (userdataPath.toFile().exists()) {
            GlobalSettings.setUserDataPath(userdataPath);
        }
        GlobalSettings.lockUserDataPath();
        if (args.length > 0 && Arrays.asList(args).contains("-dl")) {
            FRLogger.disableLogging();
        } else if (args.length > 0 && Arrays.asList(args).contains("-ll") && (logLevelIndex = Arrays.asList(args).indexOf("-ll") + 1) < args.length) {
            FRLogger.changeFileLogLevel(args[logLevelIndex]);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            FRLogger.error(ex.getLocalizedMessage(), ex);
        }
        FRLogger.info("Freerouting v2.1.2-SNAPSHOT (build-date: 2026-01-08)");
        Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
        try {
            globalSettings = GlobalSettings.load();
            FRLogger.info("Settings were loaded from freerouting.json");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (globalSettings == null || Freerouting.globalSettings.version != "2.1.2-SNAPSHOT") {
            globalSettings = new GlobalSettings();
            try {
                GlobalSettings.saveAsJson(globalSettings);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        globalSettings.applyEnvironmentVariables();
        if (!Freerouting.globalSettings.guiSettings.isEnabled.booleanValue() && System.console() == null) {
            FRLogger.warn("GUI is disabled and you don't have a console available, so the only feedback from Freerouting is in the log.");
        }
        Freerouting.globalSettings.environmentSettings.freeroutingVersion = "2.1.2-SNAPSHOT,2026-01-08";
        Freerouting.globalSettings.environmentSettings.appStartedAt = Instant.now();
        Freerouting.globalSettings.environmentSettings.commandLineArguments = String.join((CharSequence)" ", args);
        Freerouting.globalSettings.environmentSettings.architecture = System.getProperty("os.name") + "," + System.getProperty("os.arch") + "," + System.getProperty("os.version");
        Freerouting.globalSettings.environmentSettings.java = System.getProperty("java.version") + "," + System.getProperty("java.vendor");
        Freerouting.globalSettings.environmentSettings.systemLanguage = Locale.getDefault().getLanguage() + "," + String.valueOf(Locale.getDefault());
        Freerouting.globalSettings.environmentSettings.cpuCores = Runtime.getRuntime().availableProcessors();
        Freerouting.globalSettings.environmentSettings.ram = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        FRLogger.debug("Version: " + Freerouting.globalSettings.environmentSettings.freeroutingVersion);
        FRLogger.debug("Command line arguments: '" + Freerouting.globalSettings.environmentSettings.commandLineArguments + "'");
        FRLogger.debug("Architecture: " + Freerouting.globalSettings.environmentSettings.architecture);
        FRLogger.debug("Java: " + Freerouting.globalSettings.environmentSettings.java);
        FRLogger.debug("System Language: " + Freerouting.globalSettings.environmentSettings.systemLanguage);
        FRLogger.debug("Hardware: " + Freerouting.globalSettings.environmentSettings.cpuCores + " CPU cores," + Freerouting.globalSettings.environmentSettings.ram + " MB RAM");
        FRLogger.debug("UTC Time: " + String.valueOf(Freerouting.globalSettings.environmentSettings.appStartedAt));
        globalSettings.applyCommandLineArguments(args);
        FRLogger.debug("GUI Language: " + String.valueOf(Freerouting.globalSettings.currentLocale));
        FRLogger.debug("Host: " + Freerouting.globalSettings.environmentSettings.host);
        int width = 0;
        int height = 0;
        int dpi = 0;
        if (Freerouting.globalSettings.guiSettings.isEnabled.booleanValue()) {
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Dimension screenSize = toolkit.getScreenSize();
                width = screenSize.width;
                height = screenSize.height;
                dpi = toolkit.getScreenResolution();
                FRLogger.debug("Screen: " + width + "x" + height + ", " + dpi + " DPI");
            }
            catch (Exception toolkit) {
                FRLogger.warn("Couldn't get screen resolution. If you are running in a headless environment, disable the GUI by setting gui.enabled to false.");
                Freerouting.globalSettings.guiSettings.isEnabled = false;
            }
        }
        boolean allowAnalytics = false;
        FRAnalytics.setAccessKey("2.1.2-SNAPSHOT", Freerouting.globalSettings.usageAndDiagnosticData.loggerKey);
        int analyticsModulo = 1;
        String userIdString = Freerouting.globalSettings.userProfileSettings.userId.length() >= 4 ? Freerouting.globalSettings.userProfileSettings.userId.substring(0, 4) : "0000";
        int userIdValue = Integer.parseInt(userIdString, 16);
        boolean bl = allowAnalytics = !Freerouting.globalSettings.usageAndDiagnosticData.disableAnalytics && userIdValue % analyticsModulo == 0 && Freerouting.globalSettings.userProfileSettings.isTelemetryAllowed != false;
        if (!allowAnalytics) {
            FRLogger.debug("Analytics are disabled");
        }
        FRAnalytics.setEnabled(allowAnalytics);
        FRAnalytics.setUserId(Freerouting.globalSettings.userProfileSettings.userId, Freerouting.globalSettings.userProfileSettings.userEmail);
        FRAnalytics.identify();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FRAnalytics.setAppLocation("app.freerouting.gui", "Freerouting");
        FRAnalytics.appStarted("2.1.2-SNAPSHOT", "2026-01-08 00:00", String.join((CharSequence)" ", args), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.version"), System.getProperty("java.vendor"), Locale.getDefault(), Freerouting.globalSettings.currentLocale, Freerouting.globalSettings.environmentSettings.cpuCores, Freerouting.globalSettings.environmentSettings.ram, Freerouting.globalSettings.environmentSettings.host, width, height, dpi);
        VersionChecker checker = new VersionChecker("2.1.2-SNAPSHOT");
        new Thread(checker).start();
        TextManager tm = new TextManager(Freerouting.class, Freerouting.globalSettings.currentLocale);
        if (Freerouting.globalSettings.show_help_option) {
            IO.print((Object)tm.getText("command_line_help", new String[0]));
            System.exit(0);
        }
        if (Freerouting.globalSettings.drc_report_file != null) {
            Freerouting.globalSettings.guiSettings.isEnabled = false;
            Freerouting.globalSettings.apiServerSettings.isEnabled = false;
        }
        if (Freerouting.globalSettings.apiServerSettings.isEnabled.booleanValue()) {
            apiServer = Freerouting.InitializeAPI(Freerouting.globalSettings.apiServerSettings);
            Freerouting.globalSettings.apiServerSettings.isEnabled = apiServer != null;
            Freerouting.globalSettings.apiServerSettings.isRunning = apiServer != null;
        }
        if (Freerouting.globalSettings.guiSettings.isEnabled.booleanValue()) {
            if (!WindowWelcome.InitializeGUI(globalSettings)) {
                FRLogger.error("Couldn't initialize the GUI", null);
                Freerouting.globalSettings.guiSettings.isEnabled = false;
            } else {
                Freerouting.globalSettings.guiSettings.isRunning = true;
            }
        }
        if (!Freerouting.globalSettings.guiSettings.isEnabled.booleanValue() && !Freerouting.globalSettings.apiServerSettings.isEnabled.booleanValue()) {
            if (!Freerouting.globalSettings.routerSettings.enabled && Freerouting.globalSettings.drcSettings.enabled) {
                Freerouting.InitializeDRC(globalSettings);
            } else {
                Freerouting.InitializeCLI(globalSettings);
            }
        }
        while (Freerouting.globalSettings.guiSettings.isRunning.booleanValue() || Freerouting.globalSettings.apiServerSettings.isRunning.booleanValue()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        Freerouting.ShutdownApplication();
        FRLogger.traceExit("MainApplication.main()");
        System.exit(0);
    }
}

