%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.2
%% Purpose: Encoding and decoding of the types in PKIXAlgs-2009.

-module('PKIXAlgs-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("PKIXAlgs-2009.hrl").
-asn1_info([{vsn,'5.4.2'},
            {module,'PKIXAlgs-2009'},
            {options,[{i,"/daily_build/otp_src/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/daily_build/otp_src/lib/public_key/asn1"},
 {outdir,"/daily_build/otp_src/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/daily_build/otp_src/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_RSAPublicKey/2,
'enc_DSA-Params'/2,
enc_DSAPublicKey/2,
enc_DomainParameters/2,
enc_ValidationParams/2,
enc_DiffieHellmanPublicNumber/2,
enc_DHPublicKey/2,
'enc_KEA-Params-Id'/2,
enc_ECPoint/2,
enc_ECParameters/2,
'enc_DSA-Sig-Value'/2,
'enc_ECDSA-Sig-Value'/2
]).

-export([
dec_RSAPublicKey/2,
'dec_DSA-Params'/2,
dec_DSAPublicKey/2,
dec_DomainParameters/2,
dec_ValidationParams/2,
dec_DiffieHellmanPublicNumber/2,
dec_DHPublicKey/2,
'dec_KEA-Params-Id'/2,
dec_ECPoint/2,
dec_ECParameters/2,
'dec_DSA-Sig-Value'/2,
'dec_ECDSA-Sig-Value'/2
]).

-export([
'enc_pk-rsa'/3,
'enc_pk-dsa'/3,
'enc_pk-dh'/3,
'enc_pk-kea'/3,
'enc_pk-ec'/3,
'enc_pk-ecDH'/3,
'enc_pk-ecMQV'/3,
'enc_sa-rsaWithMD2'/3,
'enc_sa-rsaWithMD5'/3,
'enc_sa-rsaWithSHA1'/3,
'enc_sa-dsaWithSHA1'/3,
'enc_sa-dsaWithSHA224'/3,
'enc_sa-dsaWithSHA256'/3,
'enc_sa-ecdsaWithSHA1'/3,
'enc_sa-ecdsaWithSHA224'/3,
'enc_sa-ecdsaWithSHA256'/3,
'enc_sa-ecdsaWithSHA384'/3,
'enc_sa-ecdsaWithSHA512'/3,
'enc_mda-md2'/3,
'enc_mda-md5'/3,
'enc_mda-sha1'/3,
'enc_sa-dsaWithSHA256_smimeCaps'/3,
'enc_sa-dsaWithSHA224_smimeCaps'/3,
'enc_sa-ecdsaWithSHA1_smimeCaps'/3,
'enc_sa-ecdsaWithSHA512_smimeCaps'/3,
'enc_sa-ecdsaWithSHA384_smimeCaps'/3,
'enc_sa-ecdsaWithSHA256_smimeCaps'/3,
'enc_sa-ecdsaWithSHA224_smimeCaps'/3,
'enc_sa-dsaWithSHA1_smimeCaps'/3,
'enc_sa-rsaWithSHA1_smimeCaps'/3,
'enc_sa-rsaWithMD5_smimeCaps'/3,
'enc_sa-rsaWithMD2_smimeCaps'/3
]).

-export([
'dec_pk-rsa'/3,
'dec_pk-dsa'/3,
'dec_pk-dh'/3,
'dec_pk-kea'/3,
'dec_pk-ec'/3,
'dec_pk-ecDH'/3,
'dec_pk-ecMQV'/3,
'dec_sa-rsaWithMD2'/3,
'dec_sa-rsaWithMD5'/3,
'dec_sa-rsaWithSHA1'/3,
'dec_sa-dsaWithSHA1'/3,
'dec_sa-dsaWithSHA224'/3,
'dec_sa-dsaWithSHA256'/3,
'dec_sa-ecdsaWithSHA1'/3,
'dec_sa-ecdsaWithSHA224'/3,
'dec_sa-ecdsaWithSHA256'/3,
'dec_sa-ecdsaWithSHA384'/3,
'dec_sa-ecdsaWithSHA512'/3,
'dec_mda-md2'/3,
'dec_mda-md5'/3,
'dec_mda-sha1'/3,
'dec_sa-dsaWithSHA256_smimeCaps'/3,
'dec_sa-dsaWithSHA224_smimeCaps'/3,
'dec_sa-ecdsaWithSHA1_smimeCaps'/3,
'dec_sa-ecdsaWithSHA512_smimeCaps'/3,
'dec_sa-ecdsaWithSHA384_smimeCaps'/3,
'dec_sa-ecdsaWithSHA256_smimeCaps'/3,
'dec_sa-ecdsaWithSHA224_smimeCaps'/3,
'dec_sa-dsaWithSHA1_smimeCaps'/3,
'dec_sa-rsaWithSHA1_smimeCaps'/3,
'dec_sa-rsaWithMD5_smimeCaps'/3,
'dec_sa-rsaWithMD2_smimeCaps'/3
]).

-export([
getenc_PublicKeys/1,
getenc_SignatureAlgs/1,
getenc_SMimeCaps/1,
getenc_NamedCurve/1,
getenc_HashAlgs/1
]).

-export([
getdec_PublicKeys/1,
getdec_SignatureAlgs/1,
getdec_SMimeCaps/1,
getdec_NamedCurve/1,
getdec_HashAlgs/1
]).

-export([
rsaEncryption/0,
'id-dsa'/0,
dhpublicnumber/0,
'id-keyExchangeAlgorithm'/0,
'id-ecPublicKey'/0,
'id-ecDH'/0,
'id-ecMQV'/0,
secp192r1/0,
sect163k1/0,
sect163r2/0,
secp224r1/0,
sect233k1/0,
sect233r1/0,
secp256r1/0,
sect283k1/0,
sect283r1/0,
secp384r1/0,
sect409k1/0,
sect409r1/0,
secp521r1/0,
sect571k1/0,
sect571r1/0,
md2WithRSAEncryption/0,
md5WithRSAEncryption/0,
sha1WithRSAEncryption/0,
'dsa-with-sha1'/0,
'dsa-with-sha224'/0,
'dsa-with-sha256'/0,
'ecdsa-with-SHA1'/0,
'ecdsa-with-SHA224'/0,
'ecdsa-with-SHA256'/0,
'ecdsa-with-SHA384'/0,
'ecdsa-with-SHA512'/0,
'id-md2'/0,
'id-md5'/0,
'id-sha1'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('RSAPublicKey', Data) -> enc_RSAPublicKey(Data);
encode_disp('DSA-Params', Data) -> 'enc_DSA-Params'(Data);
encode_disp('DSAPublicKey', Data) -> enc_DSAPublicKey(Data);
encode_disp('DomainParameters', Data) -> enc_DomainParameters(Data);
encode_disp('ValidationParams', Data) -> enc_ValidationParams(Data);
encode_disp('DiffieHellmanPublicNumber', Data) -> enc_DiffieHellmanPublicNumber(Data);
encode_disp('DHPublicKey', Data) -> enc_DHPublicKey(Data);
encode_disp('KEA-Params-Id', Data) -> 'enc_KEA-Params-Id'(Data);
encode_disp('ECPoint', Data) -> enc_ECPoint(Data);
encode_disp('ECParameters', Data) -> enc_ECParameters(Data);
encode_disp('DSA-Sig-Value', Data) -> 'enc_DSA-Sig-Value'(Data);
encode_disp('ECDSA-Sig-Value', Data) -> 'enc_ECDSA-Sig-Value'(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('RSAPublicKey', Data) -> dec_RSAPublicKey(Data);
decode_disp('DSA-Params', Data) -> 'dec_DSA-Params'(Data);
decode_disp('DSAPublicKey', Data) -> dec_DSAPublicKey(Data);
decode_disp('DomainParameters', Data) -> dec_DomainParameters(Data);
decode_disp('ValidationParams', Data) -> dec_ValidationParams(Data);
decode_disp('DiffieHellmanPublicNumber', Data) -> dec_DiffieHellmanPublicNumber(Data);
decode_disp('DHPublicKey', Data) -> dec_DHPublicKey(Data);
decode_disp('KEA-Params-Id', Data) -> 'dec_KEA-Params-Id'(Data);
decode_disp('ECPoint', Data) -> dec_ECPoint(Data);
decode_disp('ECParameters', Data) -> dec_ECParameters(Data);
decode_disp('DSA-Sig-Value', Data) -> 'dec_DSA-Sig-Value'(Data);
decode_disp('ECDSA-Sig-Value', Data) -> 'dec_ECDSA-Sig-Value'(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  RSAPublicKey
%%================================
enc_RSAPublicKey(Val) ->
    enc_RSAPublicKey(Val, [<<48>>]).

enc_RSAPublicKey(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute modulus(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute publicExponent(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RSAPublicKey(Tlv) ->
   dec_RSAPublicKey(Tlv, [16]).

dec_RSAPublicKey(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute modulus(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute publicExponent(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RSAPublicKey',Term1,Term2},
Res1.


%%================================
%%  DSA-Params
%%================================
'enc_DSA-Params'(Val) ->
    'enc_DSA-Params'(Val, [<<48>>]).

'enc_DSA-Params'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute p(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute q(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute g(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_DSA-Params'(Tlv) ->
   'dec_DSA-Params'(Tlv, [16]).

'dec_DSA-Params'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute p(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute q(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute g(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_integer(V3, [2]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'DSA-Params',Term1,Term2,Term3},
Res1.


%%================================
%%  DSAPublicKey
%%================================
enc_DSAPublicKey(Val) ->
    enc_DSAPublicKey(Val, [<<2>>]).

enc_DSAPublicKey(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_DSAPublicKey(Tlv) ->
   dec_DSAPublicKey(Tlv, [2]).

dec_DSAPublicKey(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  DomainParameters
%%================================
enc_DomainParameters(Val) ->
    enc_DomainParameters(Val, [<<48>>]).

enc_DomainParameters(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5} = Val,

%%-------------------------------------------------
%% attribute p(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute g(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute q(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

%%-------------------------------------------------
%% attribute j(4) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex4, [<<2>>])
       end,

%%-------------------------------------------------
%% attribute validationParams(5)   External PKIXAlgs-2009:ValidationParams OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ValidationParams'(Cindex5, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DomainParameters(Tlv) ->
   dec_DomainParameters(Tlv, [16]).

dec_DomainParameters(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute p(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute g(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute q(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_integer(V3, [2]),

%%-------------------------------------------------
%% attribute j(4) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{2,V4}|TempTlv5] ->
    {decode_integer(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute validationParams(5)   External PKIXAlgs-2009:ValidationParams OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{16,V5}|TempTlv6] ->
    {'dec_ValidationParams'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'DomainParameters',Term1,Term2,Term3,Term4,Term5},
Res1.


%%================================
%%  ValidationParams
%%================================
enc_ValidationParams(Val) ->
    enc_ValidationParams(Val, [<<48>>]).

enc_ValidationParams(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute seed(1) with type BIT STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_unnamed_bit_string(Cindex1, [<<3>>]),

%%-------------------------------------------------
%% attribute pgenCounter(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ValidationParams(Tlv) ->
   dec_ValidationParams(Tlv, [16]).

dec_ValidationParams(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute seed(1) with type BIT STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_native_bit_string(V1, [3]),

%%-------------------------------------------------
%% attribute pgenCounter(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ValidationParams',Term1,Term2},
Res1.


%%================================
%%  DiffieHellmanPublicNumber
%%================================
enc_DiffieHellmanPublicNumber(Val) ->
    enc_DiffieHellmanPublicNumber(Val, [<<2>>]).

enc_DiffieHellmanPublicNumber(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_DiffieHellmanPublicNumber(Tlv) ->
   dec_DiffieHellmanPublicNumber(Tlv, [2]).

dec_DiffieHellmanPublicNumber(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  DHPublicKey
%%================================
enc_DHPublicKey(Val) ->
    enc_DHPublicKey(Val, [<<2>>]).

enc_DHPublicKey(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_DHPublicKey(Tlv) ->
   dec_DHPublicKey(Tlv, [2]).

dec_DHPublicKey(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  KEA-Params-Id
%%================================
'enc_KEA-Params-Id'(Val) ->
    'enc_KEA-Params-Id'(Val, [<<4>>]).

'enc_KEA-Params-Id'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_KEA-Params-Id'(Tlv) ->
   'dec_KEA-Params-Id'(Tlv, [4]).

'dec_KEA-Params-Id'(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  ECPoint
%%================================
enc_ECPoint(Val) ->
    enc_ECPoint(Val, [<<4>>]).

enc_ECPoint(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_ECPoint(Tlv) ->
   dec_ECPoint(Tlv, [4]).

dec_ECPoint(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  ECParameters
%%================================
enc_ECParameters(Val) ->
    enc_ECParameters(Val, []).

enc_ECParameters(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      namedCurve ->
         encode_object_identifier(element(2,Val), [<<6>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_ECParameters(Tlv) ->
   dec_ECParameters(Tlv, []).

dec_ECParameters(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'namedCurve'
    {6, V1} -> 
        {namedCurve, decode_object_identifier(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  DSA-Sig-Value
%%================================
'enc_DSA-Sig-Value'(Val) ->
    'enc_DSA-Sig-Value'(Val, [<<48>>]).

'enc_DSA-Sig-Value'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute r(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute s(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_DSA-Sig-Value'(Tlv) ->
   'dec_DSA-Sig-Value'(Tlv, [16]).

'dec_DSA-Sig-Value'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute r(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute s(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DSA-Sig-Value',Term1,Term2},
Res1.


%%================================
%%  ECDSA-Sig-Value
%%================================
'enc_ECDSA-Sig-Value'(Val) ->
    'enc_ECDSA-Sig-Value'(Val, [<<48>>]).

'enc_ECDSA-Sig-Value'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute r(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute s(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ECDSA-Sig-Value'(Tlv) ->
   'dec_ECDSA-Sig-Value'(Tlv, [16]).

'dec_ECDSA-Sig-Value'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute r(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute s(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ECDSA-Sig-Value',Term1,Term2},
Res1.
rsaEncryption() ->
{1,2,840,113549,1,1,1}.

'id-dsa'() ->
{1,2,840,10040,4,1}.

dhpublicnumber() ->
{1,2,840,10046,2,1}.

'id-keyExchangeAlgorithm'() ->
{2,16,840,1,101,2,1,1,22}.

'id-ecPublicKey'() ->
{1,2,840,10045,2,1}.

'id-ecDH'() ->
{1,3,132,1,12}.

'id-ecMQV'() ->
{1,3,132,1,13}.

secp192r1() ->
{1,2,840,10045,3,1,1}.

sect163k1() ->
{1,3,132,0,1}.

sect163r2() ->
{1,3,132,0,15}.

secp224r1() ->
{1,3,132,0,33}.

sect233k1() ->
{1,3,132,0,26}.

sect233r1() ->
{1,3,132,0,27}.

secp256r1() ->
{1,2,840,10045,3,1,7}.

sect283k1() ->
{1,3,132,0,16}.

sect283r1() ->
{1,3,132,0,17}.

secp384r1() ->
{1,3,132,0,34}.

sect409k1() ->
{1,3,132,0,36}.

sect409r1() ->
{1,3,132,0,37}.

secp521r1() ->
{1,3,132,0,35}.

sect571k1() ->
{1,3,132,0,38}.

sect571r1() ->
{1,3,132,0,39}.

md2WithRSAEncryption() ->
{1,2,840,113549,1,1,2}.

md5WithRSAEncryption() ->
{1,2,840,113549,1,1,4}.

sha1WithRSAEncryption() ->
{1,2,840,113549,1,1,5}.

'dsa-with-sha1'() ->
{1,2,840,10040,4,3}.

'dsa-with-sha224'() ->
{2,16,840,1,101,3,4,3,1}.

'dsa-with-sha256'() ->
{2,16,840,1,101,3,4,3,2}.

'ecdsa-with-SHA1'() ->
{1,2,840,10045,4,1}.

'ecdsa-with-SHA224'() ->
{1,2,840,10045,4,3,1}.

'ecdsa-with-SHA256'() ->
{1,2,840,10045,4,3,2}.

'ecdsa-with-SHA384'() ->
{1,2,840,10045,4,3,3}.

'ecdsa-with-SHA512'() ->
{1,2,840,10045,4,3,4}.

'id-md2'() ->
{1,2,840,113549,2,2}.

'id-md5'() ->
{1,2,840,113549,2,5}.

'id-sha1'() ->
{1,3,14,3,2,26}.




%%================================
%%  pk-rsa
%%================================
'enc_pk-rsa'('KeyValue', Val, _RestPrimFieldName) ->
   enc_RSAPublicKey(Val, [<<48>>]);
'enc_pk-rsa'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_pk-rsa'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-rsa'('KeyValue', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_RSAPublicKey(Tlv, [16]);
'dec_pk-rsa'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_pk-rsa'('PrivateKey',  Bytes,_) ->
   Bytes.

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  pk-dsa
%%================================
'enc_pk-dsa'('KeyValue', Val, _RestPrimFieldName) ->
   enc_DSAPublicKey(Val, [<<2>>]);
'enc_pk-dsa'('Params', Val, _RestPrimFieldName) ->
   'enc_DSA-Params'(Val, [<<48>>]);
'enc_pk-dsa'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-dsa'('KeyValue', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DSAPublicKey(Tlv, [2]);
'dec_pk-dsa'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_DSA-Params'(Tlv, [16]);
'dec_pk-dsa'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-dh
%%================================
'enc_pk-dh'('KeyValue', Val, _RestPrimFieldName) ->
   enc_DHPublicKey(Val, [<<2>>]);
'enc_pk-dh'('Params', Val, _RestPrimFieldName) ->
   enc_DomainParameters(Val, [<<48>>]);
'enc_pk-dh'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-dh'('KeyValue', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DHPublicKey(Tlv, [2]);
'dec_pk-dh'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_DomainParameters(Tlv, [16]);
'dec_pk-dh'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-kea
%%================================
'enc_pk-kea'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-kea'('Params', Val, _RestPrimFieldName) ->
   'enc_KEA-Params-Id'(Val, [<<4>>]);
'enc_pk-kea'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-kea'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-kea'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_KEA-Params-Id'(Tlv, [4]);
'dec_pk-kea'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-ec
%%================================
'enc_pk-ec'('KeyValue', Val, _RestPrimFieldName) ->
   enc_ECPoint(Val, [<<4>>]);
'enc_pk-ec'('Params', Val, _RestPrimFieldName) ->
   enc_ECParameters(Val, []);
'enc_pk-ec'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-ec'('KeyValue', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ECPoint(Tlv, [4]);
'dec_pk-ec'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ECParameters(Tlv, []);
'dec_pk-ec'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-ecDH
%%================================
'enc_pk-ecDH'('KeyValue', Val, _RestPrimFieldName) ->
   enc_ECPoint(Val, [<<4>>]);
'enc_pk-ecDH'('Params', Val, _RestPrimFieldName) ->
   enc_ECParameters(Val, []);
'enc_pk-ecDH'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-ecDH'('KeyValue', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ECPoint(Tlv, [4]);
'dec_pk-ecDH'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ECParameters(Tlv, []);
'dec_pk-ecDH'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-ecMQV
%%================================
'enc_pk-ecMQV'('KeyValue', Val, _RestPrimFieldName) ->
   enc_ECPoint(Val, [<<4>>]);
'enc_pk-ecMQV'('Params', Val, _RestPrimFieldName) ->
   enc_ECParameters(Val, []);
'enc_pk-ecMQV'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-ecMQV'('KeyValue', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ECPoint(Tlv, [4]);
'dec_pk-ecMQV'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ECParameters(Tlv, []);
'dec_pk-ecMQV'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-rsaWithMD2
%%================================
'enc_sa-rsaWithMD2'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-rsaWithMD2'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-rsaWithMD2'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-rsaWithMD2_smimeCaps'(H, Val, T).


'dec_sa-rsaWithMD2'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-rsaWithMD2'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-rsaWithMD2'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-rsaWithMD2_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-rsaWithMD5
%%================================
'enc_sa-rsaWithMD5'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-rsaWithMD5'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-rsaWithMD5'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-rsaWithMD5_smimeCaps'(H, Val, T).


'dec_sa-rsaWithMD5'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-rsaWithMD5'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-rsaWithMD5'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-rsaWithMD5_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-rsaWithSHA1
%%================================
'enc_sa-rsaWithSHA1'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-rsaWithSHA1'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-rsaWithSHA1'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-rsaWithSHA1_smimeCaps'(H, Val, T).


'dec_sa-rsaWithSHA1'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-rsaWithSHA1'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-rsaWithSHA1'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-rsaWithSHA1_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-dsaWithSHA1
%%================================
'enc_sa-dsaWithSHA1'('Value', Val, _RestPrimFieldName) ->
   'enc_DSA-Sig-Value'(Val, [<<48>>]);
'enc_sa-dsaWithSHA1'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-dsaWithSHA1'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-dsaWithSHA1_smimeCaps'(H, Val, T).


'dec_sa-dsaWithSHA1'('Value', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_DSA-Sig-Value'(Tlv, [16]);
'dec_sa-dsaWithSHA1'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-dsaWithSHA1'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-dsaWithSHA1_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-dsaWithSHA224
%%================================
'enc_sa-dsaWithSHA224'('Value', Val, _RestPrimFieldName) ->
   'enc_DSA-Sig-Value'(Val, [<<48>>]);
'enc_sa-dsaWithSHA224'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-dsaWithSHA224'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-dsaWithSHA224_smimeCaps'(H, Val, T).


'dec_sa-dsaWithSHA224'('Value', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_DSA-Sig-Value'(Tlv, [16]);
'dec_sa-dsaWithSHA224'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-dsaWithSHA224'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-dsaWithSHA224_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-dsaWithSHA256
%%================================
'enc_sa-dsaWithSHA256'('Value', Val, _RestPrimFieldName) ->
   'enc_DSA-Sig-Value'(Val, [<<48>>]);
'enc_sa-dsaWithSHA256'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-dsaWithSHA256'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-dsaWithSHA256_smimeCaps'(H, Val, T).


'dec_sa-dsaWithSHA256'('Value', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_DSA-Sig-Value'(Tlv, [16]);
'dec_sa-dsaWithSHA256'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-dsaWithSHA256'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-dsaWithSHA256_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-ecdsaWithSHA1
%%================================
'enc_sa-ecdsaWithSHA1'('Value', Val, _RestPrimFieldName) ->
   'enc_ECDSA-Sig-Value'(Val, [<<48>>]);
'enc_sa-ecdsaWithSHA1'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-ecdsaWithSHA1'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-ecdsaWithSHA1_smimeCaps'(H, Val, T).


'dec_sa-ecdsaWithSHA1'('Value', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ECDSA-Sig-Value'(Tlv, [16]);
'dec_sa-ecdsaWithSHA1'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-ecdsaWithSHA1'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-ecdsaWithSHA1_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-ecdsaWithSHA224
%%================================
'enc_sa-ecdsaWithSHA224'('Value', Val, _RestPrimFieldName) ->
   'enc_ECDSA-Sig-Value'(Val, [<<48>>]);
'enc_sa-ecdsaWithSHA224'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-ecdsaWithSHA224'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-ecdsaWithSHA224_smimeCaps'(H, Val, T).


'dec_sa-ecdsaWithSHA224'('Value', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ECDSA-Sig-Value'(Tlv, [16]);
'dec_sa-ecdsaWithSHA224'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-ecdsaWithSHA224'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-ecdsaWithSHA224_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-ecdsaWithSHA256
%%================================
'enc_sa-ecdsaWithSHA256'('Value', Val, _RestPrimFieldName) ->
   'enc_ECDSA-Sig-Value'(Val, [<<48>>]);
'enc_sa-ecdsaWithSHA256'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-ecdsaWithSHA256'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-ecdsaWithSHA256_smimeCaps'(H, Val, T).


'dec_sa-ecdsaWithSHA256'('Value', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ECDSA-Sig-Value'(Tlv, [16]);
'dec_sa-ecdsaWithSHA256'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-ecdsaWithSHA256'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-ecdsaWithSHA256_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-ecdsaWithSHA384
%%================================
'enc_sa-ecdsaWithSHA384'('Value', Val, _RestPrimFieldName) ->
   'enc_ECDSA-Sig-Value'(Val, [<<48>>]);
'enc_sa-ecdsaWithSHA384'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-ecdsaWithSHA384'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-ecdsaWithSHA384_smimeCaps'(H, Val, T).


'dec_sa-ecdsaWithSHA384'('Value', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ECDSA-Sig-Value'(Tlv, [16]);
'dec_sa-ecdsaWithSHA384'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-ecdsaWithSHA384'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-ecdsaWithSHA384_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-ecdsaWithSHA512
%%================================
'enc_sa-ecdsaWithSHA512'('Value', Val, _RestPrimFieldName) ->
   'enc_ECDSA-Sig-Value'(Val, [<<48>>]);
'enc_sa-ecdsaWithSHA512'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-ecdsaWithSHA512'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-ecdsaWithSHA512_smimeCaps'(H, Val, T).


'dec_sa-ecdsaWithSHA512'('Value', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_ECDSA-Sig-Value'(Tlv, [16]);
'dec_sa-ecdsaWithSHA512'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-ecdsaWithSHA512'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-ecdsaWithSHA512_smimeCaps'(H, Bytes, T).




%%================================
%%  mda-md2
%%================================
'enc_mda-md2'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_mda-md2'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  mda-md5
%%================================
'enc_mda-md5'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_mda-md5'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  mda-sha1
%%================================
'enc_mda-sha1'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_mda-sha1'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  sa-dsaWithSHA256_smimeCaps
%%================================
'enc_sa-dsaWithSHA256_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-dsaWithSHA256_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-dsaWithSHA224_smimeCaps
%%================================
'enc_sa-dsaWithSHA224_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-dsaWithSHA224_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-ecdsaWithSHA1_smimeCaps
%%================================
'enc_sa-ecdsaWithSHA1_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-ecdsaWithSHA1_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-ecdsaWithSHA512_smimeCaps
%%================================
'enc_sa-ecdsaWithSHA512_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-ecdsaWithSHA512_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-ecdsaWithSHA384_smimeCaps
%%================================
'enc_sa-ecdsaWithSHA384_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-ecdsaWithSHA384_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-ecdsaWithSHA256_smimeCaps
%%================================
'enc_sa-ecdsaWithSHA256_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-ecdsaWithSHA256_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-ecdsaWithSHA224_smimeCaps
%%================================
'enc_sa-ecdsaWithSHA224_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-ecdsaWithSHA224_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-dsaWithSHA1_smimeCaps
%%================================
'enc_sa-dsaWithSHA1_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-dsaWithSHA1_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-rsaWithSHA1_smimeCaps
%%================================
'enc_sa-rsaWithSHA1_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-rsaWithSHA1_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-rsaWithMD5_smimeCaps
%%================================
'enc_sa-rsaWithMD5_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-rsaWithMD5_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-rsaWithMD2_smimeCaps
%%================================
'enc_sa-rsaWithMD2_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-rsaWithMD2_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  PublicKeys
%%================================
getenc_PublicKeys(Id) when Id =:= {1,3,132,1,12} ->
    fun 'enc_pk-ecDH'/3;
getenc_PublicKeys(Id) when Id =:= {1,3,132,1,13} ->
    fun 'enc_pk-ecMQV'/3;
getenc_PublicKeys(Id) when Id =:= {1,2,840,10040,4,1} ->
    fun 'enc_pk-dsa'/3;
getenc_PublicKeys(Id) when Id =:= {1,2,840,10045,2,1} ->
    fun 'enc_pk-ec'/3;
getenc_PublicKeys(Id) when Id =:= {1,2,840,10046,2,1} ->
    fun 'enc_pk-dh'/3;
getenc_PublicKeys(Id) when Id =:= {1,2,840,113549,1,1,1} ->
    fun 'enc_pk-rsa'/3;
getenc_PublicKeys(Id) when Id =:= {2,16,840,1,101,2,1,1,22} ->
    fun 'enc_pk-kea'/3;
getenc_PublicKeys(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_PublicKeys(Id) when Id =:= {1,3,132,1,12} ->
    fun 'dec_pk-ecDH'/3;
getdec_PublicKeys(Id) when Id =:= {1,3,132,1,13} ->
    fun 'dec_pk-ecMQV'/3;
getdec_PublicKeys(Id) when Id =:= {1,2,840,10040,4,1} ->
    fun 'dec_pk-dsa'/3;
getdec_PublicKeys(Id) when Id =:= {1,2,840,10045,2,1} ->
    fun 'dec_pk-ec'/3;
getdec_PublicKeys(Id) when Id =:= {1,2,840,10046,2,1} ->
    fun 'dec_pk-dh'/3;
getdec_PublicKeys(Id) when Id =:= {1,2,840,113549,1,1,1} ->
    fun 'dec_pk-rsa'/3;
getdec_PublicKeys(Id) when Id =:= {2,16,840,1,101,2,1,1,22} ->
    fun 'dec_pk-kea'/3;
getdec_PublicKeys(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SignatureAlgs
%%================================
getenc_SignatureAlgs(Id) when Id =:= {1,2,840,10040,4,3} ->
    fun 'enc_sa-dsaWithSHA1'/3;
getenc_SignatureAlgs(Id) when Id =:= {1,2,840,10045,4,1} ->
    fun 'enc_sa-ecdsaWithSHA1'/3;
getenc_SignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,1} ->
    fun 'enc_sa-ecdsaWithSHA224'/3;
getenc_SignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,2} ->
    fun 'enc_sa-ecdsaWithSHA256'/3;
getenc_SignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,3} ->
    fun 'enc_sa-ecdsaWithSHA384'/3;
getenc_SignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,4} ->
    fun 'enc_sa-ecdsaWithSHA512'/3;
getenc_SignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,2} ->
    fun 'enc_sa-rsaWithMD2'/3;
getenc_SignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,4} ->
    fun 'enc_sa-rsaWithMD5'/3;
getenc_SignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,5} ->
    fun 'enc_sa-rsaWithSHA1'/3;
getenc_SignatureAlgs(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
    fun 'enc_sa-dsaWithSHA224'/3;
getenc_SignatureAlgs(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
    fun 'enc_sa-dsaWithSHA256'/3;
getenc_SignatureAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SignatureAlgs(Id) when Id =:= {1,2,840,10040,4,3} ->
    fun 'dec_sa-dsaWithSHA1'/3;
getdec_SignatureAlgs(Id) when Id =:= {1,2,840,10045,4,1} ->
    fun 'dec_sa-ecdsaWithSHA1'/3;
getdec_SignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,1} ->
    fun 'dec_sa-ecdsaWithSHA224'/3;
getdec_SignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,2} ->
    fun 'dec_sa-ecdsaWithSHA256'/3;
getdec_SignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,3} ->
    fun 'dec_sa-ecdsaWithSHA384'/3;
getdec_SignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,4} ->
    fun 'dec_sa-ecdsaWithSHA512'/3;
getdec_SignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,2} ->
    fun 'dec_sa-rsaWithMD2'/3;
getdec_SignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,4} ->
    fun 'dec_sa-rsaWithMD5'/3;
getdec_SignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,5} ->
    fun 'dec_sa-rsaWithSHA1'/3;
getdec_SignatureAlgs(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
    fun 'dec_sa-dsaWithSHA224'/3;
getdec_SignatureAlgs(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
    fun 'dec_sa-dsaWithSHA256'/3;
getdec_SignatureAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SMimeCaps
%%================================
getenc_SMimeCaps({1,2,840,10040,4,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({1,2,840,10045,4,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({1,2,840,10045,4,3,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({1,2,840,10045,4,3,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({1,2,840,10045,4,3,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({1,2,840,10045,4,3,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({1,2,840,113549,1,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({1,2,840,113549,1,1,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({1,2,840,113549,1,1,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_SMimeCaps'({1,2,840,10040,4,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({1,2,840,10045,4,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({1,2,840,10045,4,3,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({1,2,840,10045,4,3,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({1,2,840,10045,4,3,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({1,2,840,10045,4,3,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({1,2,840,113549,1,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({1,2,840,113549,1,1,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({1,2,840,113549,1,1,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
getdec_SMimeCaps(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  NamedCurve
%%================================
getenc_NamedCurve(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_NamedCurve(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  HashAlgs
%%================================
getenc_HashAlgs(Id) when Id =:= {1,2,840,113549,2,2} ->
    fun 'enc_mda-md2'/3;
getenc_HashAlgs(Id) when Id =:= {1,2,840,113549,2,5} ->
    fun 'enc_mda-md5'/3;
getenc_HashAlgs(Id) when Id =:= {1,3,14,3,2,26} ->
    fun 'enc_mda-sha1'/3;
getenc_HashAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_HashAlgs(Id) when Id =:= {1,2,840,113549,2,2} ->
    fun 'dec_mda-md2'/3;
getdec_HashAlgs(Id) when Id =:= {1,2,840,113549,2,5} ->
    fun 'dec_mda-md5'/3;
getdec_HashAlgs(Id) when Id =:= {1,3,14,3,2,26} ->
    fun 'dec_mda-sha1'/3;
getdec_HashAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_native_bit_string(Buffer, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            <<>>;
        <<Unused,Bits/binary>> ->
            Size = bit_size(Bits) - Unused,
            <<Val:Size/bitstring,_:Unused/bitstring>> = Bits,
            Val
    end.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error, {asn1, {decode_null, Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

encode_unnamed_bit_string(Bits, TagIn) ->
    Unused = (8 - bit_size(Bits) band 7) band 7,
    Bin = <<Unused,Bits/bitstring,0:Unused>>,
    encode_tags(TagIn, Bin, byte_size(Bin)).

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).
