/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.emf.util;

import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.emf.DTDAnyContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDAttribute;
import org.eclipse.wst.dtd.core.internal.emf.DTDBasicType;
import org.eclipse.wst.dtd.core.internal.emf.DTDDefaultKind;
import org.eclipse.wst.dtd.core.internal.emf.DTDElement;
import org.eclipse.wst.dtd.core.internal.emf.DTDElementReferenceContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDEmptyContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDEntity;
import org.eclipse.wst.dtd.core.internal.emf.DTDEntityReferenceContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDEnumGroupKind;
import org.eclipse.wst.dtd.core.internal.emf.DTDEnumerationType;
import org.eclipse.wst.dtd.core.internal.emf.DTDExternalEntity;
import org.eclipse.wst.dtd.core.internal.emf.DTDFile;
import org.eclipse.wst.dtd.core.internal.emf.DTDGroupContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDGroupKind;
import org.eclipse.wst.dtd.core.internal.emf.DTDInternalEntity;
import org.eclipse.wst.dtd.core.internal.emf.DTDNotation;
import org.eclipse.wst.dtd.core.internal.emf.DTDOccurrenceType;
import org.eclipse.wst.dtd.core.internal.emf.DTDPCDataContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDParameterEntityReference;
import org.eclipse.wst.dtd.core.internal.emf.DTDType;
import org.eclipse.wst.dtd.core.internal.emf.impl.DTDFactoryImpl;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDUtil;
import org.eclipse.wst.dtd.core.internal.emf.util.ExternalDTDModel;
import org.eclipse.wst.dtd.core.internal.saxparser.AttNode;
import org.eclipse.wst.dtd.core.internal.saxparser.Attlist;
import org.eclipse.wst.dtd.core.internal.saxparser.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.saxparser.CMGroupNode;
import org.eclipse.wst.dtd.core.internal.saxparser.CMNode;
import org.eclipse.wst.dtd.core.internal.saxparser.CMReferenceNode;
import org.eclipse.wst.dtd.core.internal.saxparser.CMRepeatableNode;
import org.eclipse.wst.dtd.core.internal.saxparser.DTD;
import org.eclipse.wst.dtd.core.internal.saxparser.DTDSaxArtifactVisitor;
import org.eclipse.wst.dtd.core.internal.saxparser.ElementDecl;
import org.eclipse.wst.dtd.core.internal.saxparser.EntityDecl;
import org.eclipse.wst.dtd.core.internal.saxparser.ErrorMessage;
import org.eclipse.wst.dtd.core.internal.saxparser.NotationDecl;

public class DTDModelBuilder
extends DTDSaxArtifactVisitor {
    DTD dtd;
    DTDUtil dtdUtil;
    DTDFile dtdFile;
    ResourceSet resources;

    public DTDModelBuilder(ResourceSet resources, DTDUtil dtdUtil, DTD dtd, DTDFile dtdFile) {
        this.resources = resources;
        this.dtdUtil = dtdUtil;
        this.dtd = dtd;
        this.dtdFile = dtdFile;
    }

    public DTDFactoryImpl getFactory() {
        return (DTDFactoryImpl)this.dtdUtil.getFactory();
    }

    public DTDFile getDTDFile() {
        return this.dtdFile;
    }

    public void visitDTD(DTD dtd) {
        super.visitDTD(dtd);
        this.addAttlistAndContentModel(dtd, this.dtdFile);
    }

    public void visitElementDecl(ElementDecl element) {
        String declName = element.getNodeName();
        DTDElement dtdelement = (DTDElement)this.dtdUtil.getElementPool().get(declName);
        if (dtdelement == null) {
            dtdelement = this.getFactory().createDTDElement();
            dtdelement.setName(declName);
            this.dtdFile.getDTDObject().add((Object)dtdelement);
            this.dtdUtil.getElementPool().put(declName, dtdelement);
        }
        super.visitElementDecl(element);
    }

    public void visitNotationDecl(NotationDecl notation) {
        DTDNotation dtdnot = this.dtdFile.findNotation(notation.getNodeName());
        if (dtdnot == null) {
            dtdnot = this.getFactory().createDTDNotation();
            this.dtdFile.getDTDObject().add((Object)dtdnot);
        }
        dtdnot.setName(notation.getNodeName());
        if (notation.getSystemId() != null) {
            dtdnot.setSystemID(notation.getSystemId());
        }
        if (notation.getPublicId() != null) {
            dtdnot.setPublicID(notation.getPublicId());
        }
        if (notation.getComment() != null) {
            dtdnot.setComment(notation.getComment());
        }
        if (notation.getErrorMessage() != null) {
            this.addErrorMessage(notation.getErrorMessage(), dtdnot);
        }
        super.visitNotationDecl(notation);
    }

    public void visitParameterEntityReferenceDecl(EntityDecl entity) {
        DTDParameterEntityReference parmEntRef = this.getFactory().createDTDParameterEntityReference();
        this.dtdFile.getDTDObject().add((Object)parmEntRef);
        String entityName = entity.getNodeName();
        DTDEntity dtdentity = this.getDTDFile().findEntity(entityName);
        if (dtdentity != null) {
            parmEntRef.setEntity(dtdentity);
        }
        if (entity.getErrorMessage() != null) {
            this.addErrorMessage(entity.getErrorMessage(), dtdentity);
        }
        super.visitParameterEntityReferenceDecl(entity);
    }

    public void visitExternalEntityDecl(EntityDecl entity) {
        DTDEntity dtdEntity = this.createDTDEntity(entity);
        DTDExternalEntity extEntity = this.getFactory().createDTDExternalEntity();
        dtdEntity.setContent(extEntity);
        this.finishExternalEntity(extEntity, entity);
        if (dtdEntity.isParameterEntity()) {
            this.dtdUtil.getPEPool().put("%" + entity.getNodeName() + ";", dtdEntity);
        }
        super.visitExternalEntityDecl(entity);
    }

    public void visitInternalEntityDecl(EntityDecl entity) {
        DTDEntity dtdEntity = this.createDTDEntity(entity);
        DTDInternalEntity intEntity = this.getFactory().createDTDInternalEntity();
        dtdEntity.setContent(intEntity);
        intEntity.setValue(entity.getValue());
        if (dtdEntity.isParameterEntity()) {
            this.dtdUtil.getPEPool().put("%" + entity.getNodeName() + ";", dtdEntity);
        }
        super.visitInternalEntityDecl(entity);
    }

    private void addAttlistAndContentModel(DTD dtd, DTDFile dFile) {
        Enumeration en = dtd.externalElements();
        while (en.hasMoreElements()) {
            Object e = en.nextElement();
            if (e instanceof ElementDecl) {
                DTDElement dtdelement = (DTDElement)this.dtdUtil.getElementPool().get(((ElementDecl)e).getNodeName());
                if (dtdelement == null) {
                    dtdelement = this.getFactory().createDTDElement();
                    this.dtdFile.getDTDObject().add((Object)dtdelement);
                }
                this.finishElementDecl(dtdelement, (ElementDecl)e);
                continue;
            }
            if (!(e instanceof Attlist)) continue;
            this.processAttList((Attlist)e);
        }
    }

    private void processAttList(Attlist attList) {
        DTDElement e = (DTDElement)this.dtdUtil.getElementPool().get(attList.getNodeName());
        if (e != null) {
            this.createAttributes(e, attList);
        }
    }

    void finishExternalEntity(DTDExternalEntity extEntity, EntityDecl entityDecl) {
        this.updateSystemID(extEntity, entityDecl);
        extEntity.setPublicID(entityDecl.getPublicId());
        String notationName = entityDecl.getNotationName();
        if (notationName != null) {
            DTDNotation dtdNotation = this.createOrFindNotation(extEntity, notationName, true);
            extEntity.setNotation(dtdNotation);
        }
    }

    public DTDNotation createOrFindNotation(DTDExternalEntity extEntity, String name, boolean create) {
        DTDNotation aNotation = extEntity.getDTDEntity().getDTDFile().findNotation(name);
        if (aNotation != null) {
            return aNotation;
        }
        if (create) {
            aNotation = this.getFactory().createDTDNotation();
            this.dtdFile.getDTDObject().add((Object)aNotation);
            aNotation.setName(name);
        }
        return aNotation;
    }

    private void updateSystemID(DTDExternalEntity extEntity, EntityDecl entityDecl) {
        String systemId = entityDecl.getSystemId();
        String publicId = entityDecl.getPublicId();
        if (systemId != null) {
            URIResolver idResolver = URIResolverPlugin.createResolver();
            String uri = idResolver.resolve(this.dtd.getName(), publicId, systemId);
            ExternalDTDModel ed = this.dtdUtil.getExternalDTDModel(this.resources, uri);
            if (ed != null) {
                DTDFile referenceDtdFile = ed.getExternalDTDFile();
                extEntity.setEntityReferencedFromAnotherFile(referenceDtdFile);
                extEntity.setSystemID(systemId);
            } else {
                if (entityDecl.getErrorMessage() == null) {
                    ErrorMessage dtdError = new ErrorMessage();
                    dtdError.setErrorMessage(String.valueOf(DTDCoreMessages._ERROR_INCL_FILE_LOAD_FAILURE) + " '" + systemId + "'");
                    this.addErrorMessage(dtdError, extEntity.getDTDEntity());
                }
                if (systemId != null) {
                    extEntity.setSystemID(systemId);
                } else {
                    extEntity.setSystemID("");
                }
            }
        } else {
            extEntity.setSystemID("");
        }
    }

    public DTDEntity createDTDEntity(EntityDecl entity) {
        DTDEntity dtdEntity = this.getFactory().createDTDEntity();
        this.dtdFile.getDTDObject().add((Object)dtdEntity);
        dtdEntity.setName(entity.getNodeName());
        dtdEntity.setParameterEntity(entity.isParameter());
        if (entity.getComment() != null) {
            dtdEntity.setComment(entity.getComment());
        }
        if (entity.getErrorMessage() != null) {
            this.addErrorMessage(entity.getErrorMessage(), dtdEntity);
        }
        return dtdEntity;
    }

    public void finishElementDecl(DTDElement dtdElement, ElementDecl ed) {
        dtdElement.setName(ed.getNodeName());
        CMNode cmNode = ed.getContentModelNode();
        if (ed.getComment() != null) {
            dtdElement.setComment(ed.getComment());
        }
        if (ed.getErrorMessage() != null) {
            this.addErrorMessage(ed.getErrorMessage(), dtdElement);
        }
        if (cmNode instanceof CMBasicNode) {
            CMBasicNode bn = (CMBasicNode)cmNode;
            switch (bn.getType()) {
                case 1: {
                    DTDEmptyContent emptyContent = this.getFactory().createDTDEmptyContent();
                    dtdElement.setContent(emptyContent);
                    break;
                }
                case 2: {
                    DTDAnyContent anyContent = this.getFactory().createDTDAnyContent();
                    dtdElement.setContent(anyContent);
                    break;
                }
                case 3: {
                    DTDPCDataContent pcData = this.getFactory().createDTDPCDataContent();
                    dtdElement.setContent(pcData);
                }
            }
        } else if (cmNode instanceof CMReferenceNode) {
            CMReferenceNode rn = (CMReferenceNode)cmNode;
            if (rn.getType() == 5) {
                String entityName = rn.getName().trim();
                DTDEntity anEntity = (DTDEntity)this.dtdUtil.getPEPool().get(entityName);
                if (anEntity != null) {
                    DTDEntityReferenceContent enRef = this.getFactory().createDTDEntityReferenceContent();
                    enRef.setElementReferencedEntity(anEntity);
                    DTDOccurrenceType occurrenceType = DTDOccurrenceType.get(this.computeMofOccurrence(rn));
                    enRef.setOccurrence(occurrenceType);
                    dtdElement.setContent(enRef);
                } else {
                    DTDEmptyContent emptyContent = this.getFactory().createDTDEmptyContent();
                    dtdElement.setContent(emptyContent);
                }
            } else {
                DTDElement anElement = this.createOrFindElement(rn.getName(), dtdElement);
                DTDElementReferenceContent elemRef = this.getFactory().createDTDElementReferenceContent();
                elemRef.setReferencedElement(anElement);
                DTDOccurrenceType occurrenceType = DTDOccurrenceType.get(this.computeMofOccurrence(rn));
                elemRef.setOccurrence(occurrenceType);
                dtdElement.setContent(elemRef);
            }
        } else if (cmNode instanceof CMGroupNode) {
            CMGroupNode grpNode = (CMGroupNode)cmNode;
            DTDGroupContent groupContent = this.getFactory().createDTDGroupContent();
            DTDGroupKind groupKind = DTDGroupKind.get(this.computeMofGroupKind(grpNode.getGroupKind()));
            groupContent.setGroupKind(groupKind);
            DTDOccurrenceType occurrenceType = DTDOccurrenceType.get(this.computeMofOccurrence(grpNode));
            groupContent.setOccurrence(occurrenceType);
            this.processGroupContent(groupContent, grpNode);
            dtdElement.setContent(groupContent);
        } else if (cmNode == null) {
            DTDEmptyContent emptyContent = this.getFactory().createDTDEmptyContent();
            dtdElement.setContent(emptyContent);
        }
    }

    void processGroupContent(DTDGroupContent parent, CMGroupNode grpNode) {
        Enumeration children = grpNode.getChildren().elements();
        DTDFactoryImpl factory = this.getFactory();
        while (children.hasMoreElements()) {
            DTDOccurrenceType occurrenceType;
            CMNode cnode = (CMNode)children.nextElement();
            if (cnode instanceof CMGroupNode) {
                CMGroupNode gNode = (CMGroupNode)cnode;
                DTDGroupContent groupContent = factory.createDTDGroupContent();
                DTDGroupKind groupKind = DTDGroupKind.get(this.computeMofGroupKind(gNode.getGroupKind()));
                groupContent.setGroupKind(groupKind);
                occurrenceType = DTDOccurrenceType.get(this.computeMofOccurrence(gNode));
                groupContent.setOccurrence(occurrenceType);
                parent.getContent().add((Object)groupContent);
                this.processGroupContent(groupContent, gNode);
                continue;
            }
            if (cnode instanceof CMBasicNode) {
                CMBasicNode n = (CMBasicNode)cnode;
                if (n.getType() != 3) continue;
                DTDPCDataContent pcData = factory.createDTDPCDataContent();
                parent.getContent().add((Object)pcData);
                continue;
            }
            if (!(cnode instanceof CMReferenceNode)) continue;
            CMReferenceNode rn = (CMReferenceNode)cnode;
            if (rn.getType() == 4) {
                DTDElementReferenceContent elemRef = factory.createDTDElementReferenceContent();
                DTDElement anElement = this.createOrFindElement(rn.getName(), elemRef);
                elemRef.setReferencedElement(anElement);
                occurrenceType = DTDOccurrenceType.get(this.computeMofOccurrence(rn));
                elemRef.setOccurrence(occurrenceType);
                parent.getContent().add((Object)elemRef);
                continue;
            }
            String entityName = rn.getName().trim();
            DTDEntity anEntity = (DTDEntity)this.dtdUtil.getPEPool().get(entityName);
            if (anEntity == null) continue;
            DTDEntityReferenceContent enRef = factory.createDTDEntityReferenceContent();
            enRef.setElementReferencedEntity(anEntity);
            DTDOccurrenceType occurrenceType2 = DTDOccurrenceType.get(this.computeMofOccurrence(rn));
            enRef.setOccurrence(occurrenceType2);
            parent.getContent().add((Object)enRef);
        }
    }

    private DTDElement createOrFindElement(String name, Object obj) {
        DTDElement aElement = (DTDElement)this.dtdUtil.getElementPool().get(name);
        if (aElement != null) {
            return aElement;
        }
        String errorMsg = DTDCoreMessages._ERROR_UNDECLARED_ELEMENT_1;
        errorMsg = String.valueOf(errorMsg) + "\"" + name + "\"";
        errorMsg = String.valueOf(errorMsg) + DTDCoreMessages._UI_ERRORPART_UNDECLARED_ELEMENT_2;
        ErrorMessage dtdError = new ErrorMessage();
        dtdError.setErrorMessage(errorMsg);
        this.addErrorMessage(dtdError, obj);
        this.getDTDFile().setParseError(true);
        DTDFactoryImpl factory = this.getFactory();
        DTDElement dtdelement = factory.createDTDElement();
        dtdelement.setName(name);
        DTDEmptyContent emptyContent = factory.createDTDEmptyContent();
        dtdelement.setContent(emptyContent);
        this.getDTDFile().getDTDObject().add((Object)dtdelement);
        this.dtdUtil.getElementPool().put(name, dtdelement);
        return dtdelement;
    }

    private int computeMofOccurrence(CMRepeatableNode rnode) {
        int occurrence = rnode.getOccurrence();
        int mofoccur = 49;
        if (occurrence == 10) {
            mofoccur = 42;
        } else if (occurrence == 9) {
            mofoccur = 43;
        } else if (occurrence == 8) {
            mofoccur = 63;
        }
        return mofoccur;
    }

    private int computeMofGroupKind(int type) {
        if (type == 11) {
            return 2;
        }
        return 1;
    }

    public void createAttributes(DTDElement element, Attlist attList) {
        if (attList.getErrorMessage() != null) {
            this.addErrorMessage(attList.getErrorMessage(), element);
        }
        int i = 0;
        while (i < attList.size()) {
            AttNode ad = attList.elementAt(i);
            this.addAttribute(element, ad);
            ++i;
        }
    }

    public void addAttribute(DTDElement dtdelement, AttNode ad) {
        DTDAttribute dtdattr = this.getFactory().createDTDAttribute();
        dtdelement.getDTDAttribute().add((Object)dtdattr);
        this.finishAttribute(dtdattr, ad);
    }

    public void finishAttribute(DTDAttribute dtdattr, AttNode attdef) {
        boolean parseError = false;
        if (attdef.name.startsWith("%")) {
            String peName = attdef.name.trim();
            DTDEntity en = (DTDEntity)this.dtdUtil.getPEPool().get(peName);
            if (en != null) {
                dtdattr.setAttributeNameReferencedEntity(en);
            }
        }
        dtdattr.setName(attdef.name);
        int attrType = attdef.getDeclaredType();
        if (attrType == 10 && attdef.type != null) {
            String peName = attdef.type.trim();
            DTDEntity en = (DTDEntity)this.dtdUtil.getPEPool().get(peName);
            if (en != null) {
                dtdattr.setAttributeTypeReferencedEntity(en);
                this.setAttrDTDType(dtdattr, this.getFactory().getDTDBasicType_CDATA());
            } else {
                this.setAttrDTDType(dtdattr, this.getFactory().getDTDBasicType_CDATA());
            }
        } else {
            switch (attrType) {
                case 0: {
                    this.setAttrDTDType(dtdattr, this.getFactory().getDTDBasicType_CDATA());
                    break;
                }
                case 5: {
                    this.setAttrDTDType(dtdattr, this.getFactory().getDTDBasicType_ENTITIES());
                    break;
                }
                case 4: {
                    this.setAttrDTDType(dtdattr, this.getFactory().getDTDBasicType_ENTITY());
                    break;
                }
                case 1: {
                    if (this.hasIDAttribute(dtdattr)) {
                        parseError = true;
                    }
                    this.setAttrDTDType(dtdattr, this.getFactory().getDTDBasicType_ID());
                    break;
                }
                case 2: {
                    this.setAttrDTDType(dtdattr, this.getFactory().getDTDBasicType_IDREF());
                    break;
                }
                case 3: {
                    this.setAttrDTDType(dtdattr, this.getFactory().getDTDBasicType_IDREFS());
                    break;
                }
                case 9: {
                    this.setAttrDTDType(dtdattr, this.createDTDEnumeration(dtdattr, attdef, 1));
                    break;
                }
                case 8: {
                    this.setAttrDTDType(dtdattr, this.createDTDEnumeration(dtdattr, attdef, 2));
                    break;
                }
                case 6: {
                    this.setAttrDTDType(dtdattr, this.getFactory().getDTDBasicType_NMTOKEN());
                    break;
                }
                case 7: {
                    this.setAttrDTDType(dtdattr, this.getFactory().getDTDBasicType_NMTOKENS());
                }
            }
        }
        int attrDefault = attdef.getDefaultType();
        int defaultKind = 1;
        switch (attrDefault) {
            case 4: {
                defaultKind = 3;
                break;
            }
            case 3: {
                defaultKind = 1;
                break;
            }
            case 2: {
                defaultKind = 2;
                break;
            }
            case 1: {
                defaultKind = 4;
            }
        }
        DTDDefaultKind defaultKindObj = DTDDefaultKind.get(defaultKind);
        dtdattr.setDefaultKind(defaultKindObj);
        if (parseError) {
            return;
        }
        String defaultValue = attdef.defaultValue;
        if (defaultValue != null) {
            if (!(attrType != 9 && attrType != 8 || this.isDefaultEnumValueValid(attdef, defaultValue))) {
                return;
            }
            dtdattr.setDefaultValueString(defaultValue);
        }
    }

    public boolean hasIDAttribute(DTDAttribute dtdattr) {
        boolean hasID = false;
        DTDElement element = dtdattr.getDTDElement();
        EList attrs = element.getDTDAttribute();
        Iterator i = attrs.iterator();
        while (i.hasNext()) {
            DTDAttribute attr = (DTDAttribute)i.next();
            DTDType dType = attr.getDTDType();
            if (!(dType instanceof DTDBasicType) || ((DTDBasicType)dType).getKind().getValue() != 2) continue;
            hasID = true;
            break;
        }
        return hasID;
    }

    public DTDEnumerationType createDTDEnumeration(DTDAttribute dtdattr, String[] enumValues, int enumKind) {
        DTDEnumerationType enumeration = this.getFactory().createDTDEnumerationType();
        DTDEnumGroupKind groupKind = DTDEnumGroupKind.get(enumKind);
        enumeration.setKind(groupKind);
        if (enumValues != null) {
            int i = 0;
            while (i < enumValues.length) {
                EEnumLiteral enumLiteral = this.createEEnumLiteral();
                enumLiteral.setName(enumValues[i]);
                enumeration.getEnumLiterals().add((Object)enumLiteral);
                ++i;
            }
        }
        dtdattr.getDTDElement().getDTDFile().getDTDEnumerationType().add((Object)enumeration);
        return enumeration;
    }

    private EEnumLiteral createEEnumLiteral() {
        EcorePackage ePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
        return ePackage.getEcoreFactory().createEEnumLiteral();
    }

    private DTDEnumerationType createDTDEnumeration(DTDAttribute dtdattr, AttNode attdef, int enumKind) {
        DTDEnumerationType enumeration = this.getFactory().createDTDEnumerationType();
        DTDEnumGroupKind groupKind = DTDEnumGroupKind.get(enumKind);
        enumeration.setKind(groupKind);
        dtdattr.getDTDElement().getDTDFile().getDTDEnumerationType().add((Object)enumeration);
        Enumeration tokenIter = attdef.elements();
        if (tokenIter != null) {
            while (tokenIter.hasMoreElements()) {
                String val = (String)tokenIter.nextElement();
                EEnumLiteral enumLiteral = this.createEEnumLiteral();
                enumLiteral.setName(val);
                enumeration.getEnumLiterals().add((Object)enumLiteral);
            }
        }
        return enumeration;
    }

    private boolean isDefaultEnumValueValid(AttNode attdef, String defaultValue) {
        boolean valid = false;
        boolean containsPercent = false;
        Enumeration enumValues = attdef.elements();
        while (enumValues.hasMoreElements()) {
            String val = (String)enumValues.nextElement();
            if (val.equals(defaultValue)) {
                valid = true;
                break;
            }
            if (val.indexOf(37) < 0) continue;
            containsPercent = true;
        }
        return valid || containsPercent;
    }

    public void setAttrDTDType(DTDAttribute dtdattr, DTDType type) {
        dtdattr.setDTDType(type);
    }

    protected void addErrorMessage(ErrorMessage errMsg, Object obj) {
        errMsg.setObject(obj);
        this.dtdUtil.addErrorMessage(errMsg);
    }
}

