/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.grunt.internal.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.js.grunt.GruntPlugin;

public class ImageResource {
    private static ImageRegistry imageRegistry;
    private static Map<String, ImageDescriptor> imageDescriptors;
    private static URL ICON_BASE_URL;
    public static final String IMG_GRUNTFILE = "grunt_16.png";

    static {
        try {
            String pathSuffix = "icons/";
            ICON_BASE_URL = GruntPlugin.getDefault().getBundle().getEntry(pathSuffix);
        }
        catch (Exception e) {
            GruntPlugin.logError(e, "Images error: " + e.getMessage());
        }
    }

    public static Image getImage(String key) {
        return ImageResource.getImage(key, null);
    }

    public static Image getImage(String key, String keyIfImageNull) {
        Image image;
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        if ((image = imageRegistry.get(key)) == null) {
            if (keyIfImageNull != null) {
                return ImageResource.getImage(keyIfImageNull, null);
            }
            imageRegistry.put(key, ImageDescriptor.getMissingImageDescriptor());
            image = imageRegistry.get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor id;
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        if ((id = imageDescriptors.get(key)) != null) {
            return id;
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    protected static void initializeImageRegistry() {
        imageRegistry = GruntPlugin.getDefault().getImageRegistry();
        imageDescriptors = new HashMap<String, ImageDescriptor>();
        ImageResource.registerImage(IMG_GRUNTFILE, IMG_GRUNTFILE);
    }

    public static void registerImage(String key, String partialURL) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            ImageResource.registerImageDescriptor(key, id);
        }
        catch (Exception e) {
            GruntPlugin.logError(e, "Error registering image" + e.getMessage());
        }
    }

    public static void registerImageDescriptor(String key, ImageDescriptor id) {
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        imageRegistry.put(key, id);
        imageDescriptors.put(key, id);
    }
}

