/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.action;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.IDE;

public class OpenWorkingFileAction
extends SelectionListenerAction {
    private IWorkbenchPage workbenchPage;

    public OpenWorkingFileAction(IWorkbenchPage page) {
        super(null);
        this.setText(UIText.OpenWorkingFileAction_text);
        this.setToolTipText(UIText.OpenWorkingFileAction_tooltip);
        this.workbenchPage = page;
    }

    protected IWorkbenchPage getWorkbenchPage() {
        return this.workbenchPage;
    }

    protected void openWorkspaceFile(IFile file) {
        try {
            boolean activate = OpenStrategy.activateOnOpen();
            IDE.openEditor((IWorkbenchPage)this.getWorkbenchPage(), (IFile)file, (boolean)activate);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getWorkbenchPage().getWorkbenchWindow().getShell(), (String)UIText.OpenWorkingFileAction_openWorkingFileShellTitle, (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    protected void openExternalFile(File file) {
        try {
            boolean activate = OpenStrategy.activateOnOpen();
            IEditorDescriptor desc = IDE.getEditorDescriptor((String)file.getName());
            IDE.openEditor((IWorkbenchPage)this.getWorkbenchPage(), (URI)file.toURI(), (String)desc.getId(), (boolean)activate);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getWorkbenchPage().getWorkbenchWindow().getShell(), (String)UIText.OpenWorkingFileAction_openWorkingFileShellTitle, (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        IResource resource = this.getExistingResource(selection);
        if (resource instanceof IFile) {
            this.openWorkspaceFile((IFile)resource);
        } else {
            IPath location;
            Object element = selection.getFirstElement();
            if (element instanceof GitModelObject && (location = ((GitModelObject)((Object)element)).getLocation()) != null && location.toFile().exists()) {
                this.openExternalFile(location.toFile());
            }
        }
    }

    @Nullable
    private IResource getExistingResource(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        IResource resource = (IResource)AdapterUtils.adapt((Object)element, IResource.class);
        if (resource != null && resource.exists()) {
            return resource;
        }
        return null;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.selectionIsOfType(1);
    }
}

