/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene53;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.IOUtils;

class Lucene53NormsProducer
extends NormsProducer {
    private final Map<Integer, NormsEntry> norms;
    private final IndexInput data;
    private final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene53NormsProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        block20: {
            this.norms = new HashMap<Integer, NormsEntry>();
            this.maxDoc = state.segmentInfo.maxDoc();
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            version = -1;
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName, state.context);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkIndexHeader(in, metaCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(in, priorE);
                    }
                }
                CodecUtil.checkFooter(in, priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader(this.data, dataCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ",data=" + version2, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            if (!info.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + info.name, meta);
            }
            NormsEntry entry = new NormsEntry();
            entry.bytesPerValue = meta.readByte();
            switch (entry.bytesPerValue) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new CorruptIndexException("Invalid bytesPerValue: " + entry.bytesPerValue + ", field: " + info.name, meta);
                }
            }
            entry.offset = meta.readLong();
            this.norms.put(info.number, entry);
            fieldNumber = meta.readVInt();
        }
    }

    @Override
    public NumericDocValues getNorms(FieldInfo field) throws IOException {
        NormsEntry entry = this.norms.get(field.number);
        if (entry.bytesPerValue == 0) {
            final long value = entry.offset;
            return new NumericDocValues(){

                @Override
                public long get(int docID) {
                    return value;
                }
            };
        }
        IndexInput indexInput = this.data;
        synchronized (indexInput) {
            switch (entry.bytesPerValue) {
                case 1: {
                    final RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, this.maxDoc);
                    return new NumericDocValues(){

                        @Override
                        public long get(int docID) {
                            try {
                                return slice.readByte(docID);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                case 2: {
                    final RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, (long)this.maxDoc * 2L);
                    return new NumericDocValues(){

                        @Override
                        public long get(int docID) {
                            try {
                                return slice.readShort((long)docID << 1);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                case 4: {
                    final RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, (long)this.maxDoc * 4L);
                    return new NumericDocValues(){

                        @Override
                        public long get(int docID) {
                            try {
                                return slice.readInt((long)docID << 2);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                case 8: {
                    final RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, (long)this.maxDoc * 8L);
                    return new NumericDocValues(){

                        @Override
                        public long get(int docID) {
                            try {
                                return slice.readLong((long)docID << 3);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
            }
            throw new AssertionError();
        }
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    @Override
    public long ramBytesUsed() {
        return 64L * (long)this.norms.size();
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.norms.size() + ")";
    }

    static class NormsEntry {
        byte bytesPerValue;
        long offset;

        NormsEntry() {
        }
    }
}

