/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.ssh.terminal;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.Session;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.RemoteFileException;
import org.eclipse.rse.services.terminals.AbstractTerminalShell;

public class SshTerminalShell
extends AbstractTerminalShell {
    private ISshSessionProvider fSessionProvider;
    private Channel fChannel;
    private String fEncoding;
    private InputStream fInputStream;
    private OutputStream fOutputStream;
    private Writer fOutputStreamWriter;
    private int fWidth = 0;
    private int fHeight = 0;
    private static String defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SshTerminalShell(ISshSessionProvider sessionProvider, String ptyType, String encoding, String[] environment, String initialWorkingDirectory, String commandToRun) throws SystemMessageException {
        try {
            try {
                this.fSessionProvider = sessionProvider;
                this.fEncoding = encoding;
                this.fChannel = this.fSessionProvider.getSession().openChannel("shell");
                if (ptyType != null && this.fChannel instanceof ChannelShell) {
                    ((ChannelShell)this.fChannel).setPtyType(ptyType);
                }
                if (environment != null && environment.length > 0 && this.fChannel instanceof ChannelShell) {
                    Hashtable<String, String> envTable = new Hashtable<String, String>();
                    int i = 0;
                    while (true) {
                        if (i >= environment.length) {
                            ((ChannelShell)this.fChannel).setEnv(envTable);
                            break;
                        }
                        String curStr = environment[i];
                        int curLen = environment[i].length();
                        int idx = curStr.indexOf(61);
                        if (idx > 0 && idx < curLen - 1) {
                            String key = environment[i].substring(0, idx);
                            String value = environment[i].substring(idx + 1, curLen);
                            if (this.fEncoding != null) {
                                key = this.recode(key, this.fEncoding);
                                value = this.recode(value, this.fEncoding);
                            }
                            envTable.put(key, value);
                        }
                        ++i;
                    }
                }
                this.fOutputStream = this.fChannel.getOutputStream();
                this.fInputStream = this.fChannel.getInputStream();
                this.fChannel.connect();
                this.fOutputStreamWriter = this.fEncoding != null ? new BufferedWriter(new OutputStreamWriter(this.fOutputStream, encoding)) : new BufferedWriter(new OutputStreamWriter(this.fOutputStream));
                if (initialWorkingDirectory != null && initialWorkingDirectory.length() > 0 && !initialWorkingDirectory.equals(".") && !initialWorkingDirectory.equals("Command Shell")) {
                    this.writeToShell("cd " + PathUtility.enQuoteUnix((String)initialWorkingDirectory));
                }
                if (commandToRun != null && commandToRun.length() > 0) {
                    this.writeToShell(commandToRun);
                }
            }
            catch (Exception e) {
                throw new RemoteFileException("Error creating Terminal", e);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.isActive();
            throw throwable;
        }
        {
            Object var14_17 = null;
            this.isActive();
        }
    }

    public String getDefaultEncoding() {
        return this.fEncoding;
    }

    protected String recode(String s, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            return s;
        }
        if (encoding.equals(defaultEncoding)) {
            return s;
        }
        byte[] bytes = s.getBytes(encoding);
        return new String(bytes, defaultEncoding);
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    public void writeToShell(String command) throws IOException {
        if (this.isActive()) {
            command = "#break".equals(command) ? "\u0003" : String.valueOf(command) + "\r\n";
            this.fOutputStreamWriter.write(command);
            this.fOutputStreamWriter.flush();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exit() {
        if (this.fChannel == null) return;
        try {
            try {
                this.getInputStream().close();
            }
            catch (IOException iOException) {}
            try {
                this.getOutputStream().close();
            }
            catch (IOException iOException) {}
            this.fChannel.disconnect();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fChannel = null;
            this.isActive();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fChannel = null;
            this.isActive();
        }
    }

    public boolean isActive() {
        boolean hasInput = false;
        try {
            hasInput = this.getInputStream().available() > 0;
        }
        catch (IOException iOException) {}
        if (this.fChannel != null && (!this.fChannel.isEOF() || hasInput)) {
            return true;
        }
        Session session = this.fSessionProvider.getSession();
        if (session != null && !session.isConnected()) {
            this.fSessionProvider.handleSessionLost();
        }
        return false;
    }

    public boolean isLocalEcho() {
        return false;
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fChannel != null && this.fChannel instanceof ChannelShell && (newWidth != this.fWidth || newHeight != this.fHeight)) {
            ChannelShell channelShell = (ChannelShell)this.fChannel;
            channelShell.setPtySize(newWidth, newHeight, 8 * newWidth, 8 * newHeight);
            this.fWidth = newWidth;
            this.fHeight = newHeight;
        }
    }
}

